/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.nfesefaz.versao400;

import com.touchcomp.basementor.constants.enums.cte.EnumConstTipoAmbienteCTe;
import com.touchcomp.basementor.model.vo.ConfConexaoNFeUF;
import com.touchcomp.basementor.model.vo.TipoEmissaoNFe;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorlogger.TLogger;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.service.impl.nfesefaz.versao400.AuxProcessaDados_V400;
import mentorcore.tools.ClearUtil;
import nfe.constants.NFeConstTipoAmbiente;
import nfe.exception.NFeException;
import nfe.versao400.model.TConsCad;
import nfe.versao400.model.TUfCons;
import nfe.versao400.services.NFeConsultaCadastro;

public class UtilSefazNFeConsultaCadastro_V400 {
    private static final TLogger logger = TLogger.get(UtilSefazNFeConsultaCadastro_V400.class);

    NFeConsultaCadastro.EncapsuledMessageRec consultaCadastro(NFeConstTipoAmbiente tmAmb, int codUf, String versaoNfe, String cpfCnpj, String inscEst, UnidadeFederativa uf, TipoEmissaoNFe tp) throws NFeException {
        try {
            List<ConfConexaoNFeUF> confConexaoNFeUf = UtilSefazNFeConsultaCadastro_V400.getConfConexaoNFe(uf, versaoNfe);
            TConsCad t = this.getTConsultaCadastro(uf, inscEst, cpfCnpj);
            NFeConsultaCadastro.EncapsuledMessageRec e = new NFeConsultaCadastro().prepareMessage(t, this.getURL(confConexaoNFeUf, tmAmb, tp), new Integer(uf.getCodIbge()).intValue());
            new NFeConsultaCadastro().consultaCadastro(e);
            Object ret = new String();
            ret = (String)ret + "Resultado da Consulta:";
            ret = (String)ret + "\nStatus: " + e.getToReceive().getInfCons().getCStat();
            ret = (String)ret + "\nSUF: " + e.getToReceive().getInfCons().getCUF();
            ret = (String)ret + "\nMotivo: " + e.getToReceive().getInfCons().getXMotivo();
            e.setMsgProcessada((String)ret);
            return e;
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            new AuxProcessaDados_V400().trataExcecoesNFe(ex);
            return null;
        }
    }

    private static List<ConfConexaoNFeUF> getConfConexaoNFe(UnidadeFederativa unidadeFederativa, String versao) throws NFeException {
        try {
            List l = (List)CoreServiceFactory.getServiceConfConexaoNFeUF().execute(CoreRequestContext.newInstance().setAttribute("uf", unidadeFederativa).setAttribute("versaoNFe", versao), "getConfConexaoNFeUFTPAmb");
            if (l == null || l.isEmpty()) {
                throw new NFeException("Nenhum URL de conex\u00e3o cadastrada para a UF " + unidadeFederativa.getDescricao() + ". Entre em contato com o suporte t\u00e9cnico.");
            }
            return l;
        }
        catch (ExceptionService ex) {
            ex.printStackTrace();
            logger.error(ex.getClass(), (Throwable)ex);
            throw new NFeException("Erro ao pesquisar as URL's de conex\u00e3o.");
        }
    }

    private String getURL(List<ConfConexaoNFeUF> confConexaoNfeUf, NFeConstTipoAmbiente tmAmb, TipoEmissaoNFe p) throws NFeException {
        String url = null;
        short codEmissaoNFe = p.getCodigo();
        if (codEmissaoNFe == 2 || codEmissaoNFe == 5 || codEmissaoNFe == 4) {
            codEmissaoNFe = 1;
        }
        for (ConfConexaoNFeUF c : confConexaoNfeUf) {
            if (c.getTipoEmissaoNFe().getCodigo() != codEmissaoNFe) continue;
            if (tmAmb.shortValue().shortValue() == EnumConstTipoAmbienteCTe.IDENT_AMBIENTE_HOMOLOGACAO.getValue()) {
                url = c.getUrlNFeConsCadHom();
                break;
            }
            url = c.getUrlNFeConsCadProd();
            break;
        }
        if (url != null && url.trim().length() > 0) {
            return url;
        }
        throw new NFeException("Nenhuma URL encontrada para envio das informa\u00e7\u00f5es. Consulte suporte t\u00e9cnico.");
    }

    private TConsCad getTConsultaCadastro(UnidadeFederativa uf, String inscEst, String cpfCnpj) {
        TConsCad t = new TConsCad();
        TConsCad.InfCons inf = new TConsCad.InfCons();
        if (inscEst != null && inscEst.trim().length() > 0) {
            inf.setIE(this.refina(inscEst));
        }
        inf.setUF(TUfCons.valueOf((String)uf.getSigla()));
        String aux = this.refina(cpfCnpj);
        if (aux != null && aux.trim().length() > 0) {
            if (aux.length() > 11) {
                inf.setCNPJ(aux);
            } else {
                inf.setCPF(aux);
            }
        }
        inf.setXServ("CONS-CAD");
        t.setInfCons(inf);
        t.setVersao(NFeConsultaCadastro.VERSAO);
        return t;
    }

    private String refina(String to) {
        return ClearUtil.refina(to);
    }
}

