/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.nfesefaz.versao400;

import com.touchcomp.basementor.constants.enums.cte.EnumConstTipoAmbienteCTe;
import com.touchcomp.basementor.model.vo.ConfConexaoNFeUF;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.LoteFaturamentoNFe;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.TipoEmissaoNFe;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorlogger.TLogger;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.nfesefaz.versao400.AuxProcessaDados_V400;
import nfe.constants.NFeConstTipoAmbiente;
import nfe.exception.NFeException;
import nfe.versao400.model.TConsReciNFe;
import nfe.versao400.model.TProtNFe;
import nfe.versao400.model.TRetConsReciNFe;
import nfe.versao400.services.NFeConsRetRecepcaoLote;

class UtilSefazNFeConsultaLoteNFe_V400 {
    private static final TLogger logger = TLogger.get(UtilSefazNFeConsultaLoteNFe_V400.class);

    NFeConsRetRecepcaoLote.EncapsuledMessageRec consultaLoteFaturamento(List<ConfConexaoNFeUF> confConexaoNFeUf, NFeConstTipoAmbiente tmAmb, int codUf, String versao, LoteFaturamentoNFe lote, Usuario usuario, Grupo grupoUsuarios, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento opcoesRelacionamento, OpcoesFinanceiras of) throws NFeException {
        if (lote.getNumeroReciboLote() == null || lote.getNumeroReciboLote().trim().length() == 0) {
            throw new NFeException("Lote ainda n\u00e3o enviado Sefaz.");
        }
        try {
            NFeConsRetRecepcaoLote.EncapsuledMessageRec e;
            lote = (LoteFaturamentoNFe)CoreDAOFactory.getInstance().getDAOLoteFaturamentoNFe().findByPrimaryKey(lote.getIdentificador());
            int counter = 1;
            do {
                if (counter > 1) {
                    Thread.sleep(15000L);
                }
                TConsReciNFe t = this.getTConsStatServ(lote.getNumeroReciboLote(), versao, tmAmb.shortValue());
                e = new NFeConsRetRecepcaoLote().prepareMessage(t, this.getURL(confConexaoNFeUf, tmAmb, lote.getPeriodoEmissaoNfe().getTipoEmissaoNfe()), codUf);
                new NFeConsRetRecepcaoLote().consultaRecepcaoLote(e);
            } while (e.getToReceive().getCStat().equalsIgnoreCase("105") && ++counter < 5);
            String msg = "Resultado do envio do lote " + lote.getIdentificador();
            if (counter < 5) {
                msg = msg + "\nStatus: " + e.getToReceive().getCStat();
                msg = msg + "\nTipo de Ambiente(1- Produ\u00e7\u00e3o, 2- Homologa\u00e7\u00e3o): " + e.getToReceive().getTpAmb();
                msg = msg + "\nNr. recibo: " + e.getToReceive().getNRec();
                msg = msg + "\nMotivo: " + e.getToReceive().getXMotivo();
                for (TProtNFe tr : e.getToReceive().getProtNFe()) {
                    msg = msg + "\n";
                    msg = msg + "\n\tChave: " + tr.getInfProt().getChNFe();
                    msg = msg + "\n\tStatus: " + tr.getInfProt().getCStat();
                    msg = msg + "\n\tNr. Recibo: " + tr.getInfProt().getNProt();
                    msg = msg + "\n\tMotivo: " + tr.getInfProt().getXMotivo();
                }
            } else {
                msg = msg + ". N\u00e3o foi poss\u00edvel consultar o lote, pois o retorno est\u00e1 lento. Tente novamente mais tarde.";
            }
            e.setAuxliar((Object)lote);
            this.afterConsultLoteNFe(e, usuario, grupoUsuarios, opcoesFaturamento, opcoesRelacionamento, of);
            e.setMsgProcessada(msg);
            lote = (LoteFaturamentoNFe)CoreDAOFactory.getInstance().getDAOLoteFaturamentoNFe().saveOrUpdate(lote);
            e.setAuxliar((Object)lote);
            return e;
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            new AuxProcessaDados_V400().trataExcecoesNFe(ex);
            return null;
        }
    }

    private TConsReciNFe getTConsStatServ(String nrRec, String versao, Short tpAmb) {
        TConsReciNFe t = new TConsReciNFe();
        t.setTpAmb(String.valueOf(tpAmb));
        t.setVersao(versao);
        t.setNRec(nrRec);
        return t;
    }

    private void atualizarLoteFaturamento(LoteFaturamentoNFe lote, TRetConsReciNFe loteCTeRes) throws ExceptionService {
        lote.setMotivo(loteCTeRes.getXMotivo());
        lote.setStatusLote(Short.valueOf(Short.parseShort(loteCTeRes.getCStat())));
        lote.setEnviadoReceita(Short.valueOf((short)1));
    }

    public void afterConsultLoteNFe(NFeConsRetRecepcaoLote.EncapsuledMessageRec e, Usuario usuario, Grupo grupoUsuarios, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento opcoesRelacionamento, OpcoesFinanceiras of) throws ExceptionService, NFeException {
        LoteFaturamentoNFe lote = (LoteFaturamentoNFe)e.getAuxiliar();
        this.atualizarLoteFaturamento(lote, e.getToReceive());
        this.atualizarConhecimentosEnviados(lote, e.getToReceive(), usuario, grupoUsuarios, opcoesFaturamento, opcoesRelacionamento, of);
    }

    private void atualizarConhecimentosEnviados(LoteFaturamentoNFe lote, TRetConsReciNFe loteCTeRes, Usuario usuario, Grupo grupoUsuarios, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento opcoesRelacionamento, OpcoesFinanceiras of) throws ExceptionService, NFeException {
        if (loteCTeRes.getProtNFe() == null) {
            return;
        }
        for (TProtNFe n : loteCTeRes.getProtNFe()) {
            for (NotaFiscalPropria nf : lote.getNotasFiscais()) {
                if (n.getInfProt() == null || !nf.getChaveNFE().equalsIgnoreCase(n.getInfProt().getChNFe())) continue;
                new AuxProcessaDados_V400().atualizarConteudoAprovacao(n, nf, usuario, grupoUsuarios, opcoesFaturamento, opcoesRelacionamento, of);
            }
        }
    }

    private String getURL(List<ConfConexaoNFeUF> confConexaoNFeUf, NFeConstTipoAmbiente tmAmb, TipoEmissaoNFe p) throws NFeException {
        String url = null;
        short codEmissaoNFe = p.getCodigo();
        if (codEmissaoNFe == 2 || codEmissaoNFe == 5 || codEmissaoNFe == 4) {
            codEmissaoNFe = 1;
        }
        for (ConfConexaoNFeUF c : confConexaoNFeUf) {
            if (c.getTipoEmissaoNFe().getCodigo() != codEmissaoNFe) continue;
            if (tmAmb.shortValue().shortValue() == EnumConstTipoAmbienteCTe.IDENT_AMBIENTE_HOMOLOGACAO.getValue()) {
                url = c.getUrlNFeRetRecepcaoHom();
                break;
            }
            url = c.getUrlNFeRetRecepcaoProd();
            break;
        }
        if (url != null && url.trim().length() > 0) {
            return url;
        }
        throw new NFeException("Nenhuma URL encontrada para envio das informa\u00e7\u00f5es. Consulte suporte t\u00e9cnico.");
    }
}

