/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.nfesefaz.versao400;

import com.touchcomp.basementor.constants.enums.cte.EnumConstTipoAmbienteCTe;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.ConfConexaoNFeUF;
import com.touchcomp.basementor.model.vo.EventoNFe;
import com.touchcomp.basementor.model.vo.EvtNFeCancelamento;
import com.touchcomp.basementor.model.vo.EvtNFeCartaCorrecao;
import com.touchcomp.basementor.model.vo.EvtNFeEpec;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.TipoEmissaoNFe;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorlogger.TLogger;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.impl.nfesefaz.versao400.AuxProcessaDados_V400;
import nfe.constants.NFeConstTipoAmbiente;
import nfe.exception.NFeException;
import nfe.versao400.model.TConsSitNFe;
import nfe.versao400.model.TEvento;
import nfe.versao400.model.TProcEvento;
import nfe.versao400.model.TRetCancNFe;
import nfe.versao400.services.NFeConsultaNFe;

class UtilSefazNFeConsultaNFe_V400 {
    private static final TLogger logger = TLogger.get(UtilSefazNFeConsultaNFe_V400.class);

    UtilSefazNFeConsultaNFe_V400() {
    }

    NFeConsultaNFe.EncapsuledMessageRec consultaSituacaoNFe(List<ConfConexaoNFeUF> confConexaoNFeUf, NFeConstTipoAmbiente tmAmb, int codUf, String versao, NotaFiscalPropria nfe, Usuario usuario, Grupo grupoUsuarios, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento opcoesRelacionamento, OpcoesFinanceiras of) throws NFeException {
        try {
            if (!CoreBdUtil.getInstance().getSession().contains((Object)nfe)) {
                nfe = (NotaFiscalPropria)CoreDAOFactory.getInstance().getDAONotaFiscalPropria().findByPrimaryKey(nfe.getIdentificador());
            }
            TConsSitNFe t = this.getTConsultaCte(nfe.getChaveNFE(), versao, tmAmb);
            NFeConsultaNFe.EncapsuledMessageRec e = new NFeConsultaNFe().prepareMessage(t, this.getURL(confConexaoNFeUf, tmAmb, nfe.getPeriodoEmissaoNFe().getTipoEmissaoNfe()), codUf);
            new NFeConsultaNFe().consultaSituacaoNFe(e);
            this.atualizarNFe(nfe, e, usuario, grupoUsuarios, opcoesFaturamento, opcoesRelacionamento, of);
            Object ret = new String();
            ret = (String)ret + "Resultado da Consulta do NFe " + nfe.getNumeroNota() + ":";
            ret = (String)ret + "\nStatus: " + e.getToReceive().getCStat();
            ret = (String)ret + "\nSUF: " + e.getToReceive().getCUF();
            ret = (String)ret + "\nMotivo: " + e.getToReceive().getXMotivo();
            e.setMsgProcessada((String)ret);
            e.setAuxiliar((Object)nfe);
            return e;
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            new AuxProcessaDados_V400().trataExcecoesNFe(ex);
            return null;
        }
    }

    private TConsSitNFe getTConsultaCte(String chave, String versao, NFeConstTipoAmbiente tmAmb) {
        TConsSitNFe t = new TConsSitNFe();
        t.setTpAmb(String.valueOf(tmAmb.shortValue()));
        t.setVersao(NFeConsultaNFe.VERSAO);
        t.setXServ("CONSULTAR");
        t.setChNFe(chave);
        return t;
    }

    private void atualizarNFe(NotaFiscalPropria nfe, NFeConsultaNFe.EncapsuledMessageRec toReceive, Usuario usuario, Grupo grupoUsuarios, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento opcoesRelacionamento, OpcoesFinanceiras of) throws NFeException {
        if (toReceive.getToReceive().getProtNFe() != null && this.nfeNaoCancelada(toReceive.getToReceive().getCStat())) {
            new AuxProcessaDados_V400().atualizarConteudoAprovacao(toReceive.getToReceive().getProtNFe(), nfe, usuario, grupoUsuarios, opcoesFaturamento, opcoesRelacionamento, of);
        }
        if (toReceive.getToReceive().getProcEventoNFe() != null && toReceive.getToReceive().getProcEventoNFe().size() > 0) {
            this.atualizarDadosEvento(toReceive.getToReceive().getProcEventoNFe(), nfe, opcoesFaturamento, opcoesRelacionamento, usuario);
        } else if (toReceive.getToReceive().getRetCancNFe() != null) {
            this.atualizarDadosCancelamentoSemRetornoDeEvento(toReceive.getToReceive().getRetCancNFe(), nfe, opcoesFaturamento, opcoesRelacionamento, usuario);
        }
    }

    private String getURL(List<ConfConexaoNFeUF> confConexaoNfeUf, NFeConstTipoAmbiente tmAmb, TipoEmissaoNFe p) throws NFeException {
        String url = null;
        short codEmissaoNFe = p.getCodigo();
        if (codEmissaoNFe == 2 || codEmissaoNFe == 5 || codEmissaoNFe == 4) {
            codEmissaoNFe = 1;
        }
        for (ConfConexaoNFeUF c : confConexaoNfeUf) {
            if (c.getTipoEmissaoNFe().getCodigo() != codEmissaoNFe) continue;
            if (tmAmb.shortValue().shortValue() == EnumConstTipoAmbienteCTe.IDENT_AMBIENTE_HOMOLOGACAO.getValue()) {
                url = c.getUrlNFeConsultaHom();
                break;
            }
            url = c.getUrlNFeConsultaProd();
            break;
        }
        if (url != null && url.trim().length() > 0) {
            return url;
        }
        throw new NFeException("Nenhuma URL encontrada para envio das informa\u00e7\u00f5es. Consulte suporte t\u00e9cnico.");
    }

    private void atualizarDadosEvento(List<TProcEvento> procEventoNFe, NotaFiscalPropria nfe, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento op, Usuario usuario) throws NFeException {
        try {
            for (TProcEvento t : procEventoNFe) {
                EventoNFe ev = this.getEventoNFe(t.getEvento(), nfe);
                if (ev == null) continue;
                new AuxProcessaDados_V400().atualizarDadosEventoNFe(t.getRetEvento(), ev, opcoesFaturamento, op, usuario);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new NFeException(ex.getMessage(), (Throwable)ex);
        }
    }

    private EventoNFe getEventoNFe(TEvento evento, NotaFiscalPropria nf) throws NFeException, ExceptionDatabase {
        String chaveNfe = evento.getInfEvento().getChNFe();
        String tipoEvento = evento.getInfEvento().getTpEvento();
        String nrSeqEvento = evento.getInfEvento().getNSeqEvento();
        if (new Integer(tipoEvento) == 110111) {
            EvtNFeCancelamento e = CoreDAOFactory.getInstance().getDAOEventoNFe().findEventoNFeCancelamento(chaveNfe, nrSeqEvento);
            if (e != null) {
                return e;
            }
            EvtNFeCancelamento temp = new EvtNFeCancelamento();
            temp.setNotaFiscalPropria(nf);
            temp.setEmpresa(nf.getEmpresa());
            temp.setChave(nf.getChaveNFE());
            temp.setNumSeqEvento(Long.valueOf(evento.getInfEvento().getNSeqEvento()));
            return (EventoNFe)CoreDAOFactory.getInstance().getDAOEventoNFe().saveOrUpdate(temp);
        }
        if (new Integer(tipoEvento) == 110110) {
            EvtNFeCartaCorrecao e = CoreDAOFactory.getInstance().getDAOEventoNFe().findEventoNFeCartaCorrecao(chaveNfe, nrSeqEvento);
            if (e != null) {
                return e;
            }
            EvtNFeCartaCorrecao temp = new EvtNFeCartaCorrecao();
            temp.setNotaFiscalPropria(nf);
            temp.setChave(nf.getChaveNFE());
            temp.setEmpresa(nf.getEmpresa());
            temp.setNumSeqEvento(Long.valueOf(evento.getInfEvento().getNSeqEvento()));
            return (EventoNFe)CoreDAOFactory.getInstance().getDAOEventoNFe().saveOrUpdate(temp);
        }
        if (new Integer(tipoEvento) == 110140) {
            EvtNFeEpec e = CoreDAOFactory.getInstance().getDAOEventoNFe().findEventoNFeEpec(chaveNfe, nrSeqEvento);
            if (e != null) {
                return e;
            }
            EvtNFeEpec temp = new EvtNFeEpec();
            temp.setNotaFiscalPropria(nf);
            temp.setEmpresa(nf.getEmpresa());
            temp.setChave(nf.getChaveNFE());
            temp.setNumSeqEvento(Long.valueOf(evento.getInfEvento().getNSeqEvento()));
            return (EventoNFe)CoreDAOFactory.getInstance().getDAOEventoNFe().saveOrUpdate(temp);
        }
        return null;
    }

    private String getURLDpec(NFeConstTipoAmbiente tpAmb) {
        if (tpAmb.shortValue() == 2) {
            return "https://hom.nfe.fazenda.gov.br/SCEConsultaRFB/SCEConsultaRFB.asmx";
        }
        return "https://www.nfe.fazenda.gov.br/SCEConsultaRFB/SCEConsultaRFB.asmx";
    }

    private boolean nfeNaoCancelada(String status) {
        return status == null || !EnumConstNFeStatus.isStatusCancelada((Integer)Integer.valueOf(status));
    }

    private void atualizarDadosCancelamentoSemRetornoDeEvento(TRetCancNFe retCancNFe, NotaFiscalPropria nfe, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento opcoesRelacionamento, Usuario usuario) throws NFeException {
        try {
            if (retCancNFe.getInfCanc() != null) {
                new AuxProcessaDados_V400().atualizarDadosCancelamentoNFeSemRetornoEvento(retCancNFe, nfe, opcoesFaturamento, opcoesRelacionamento, usuario);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new NFeException(ex.getMessage(), (Throwable)ex);
        }
    }
}

