/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.nfesefaz.versao400;

import com.touchcomp.basementor.model.vo.ConfConexaoNFeUF;
import com.touchcomp.basementor.model.vo.ConsultaNFeDest;
import com.touchcomp.basementor.model.vo.ConsultaNFeDestNFe;
import com.touchcomp.basementor.model.vo.ConsultaNFeDestNFeAut;
import com.touchcomp.basementor.model.vo.ConsultaNFeDestNFeEventos;
import com.touchcomp.basementor.model.vo.ConsultaNFeDestTransportes;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorxml.model.XMLNFeCTe;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFeCTe;
import contatocore.util.ZipUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBException;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.service.impl.nfesefaz.versao400.AuxProcessaDados_V400;
import mentorcore.tools.ClearUtil;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;
import nfe.constants.NFeConstTipoAmbiente;
import nfe.exception.NFeException;
import nfe.exception.NFeValidateException;
import nfe.versao400.model.DistDFeInt;
import nfe.versao400.model.ResEvento;
import nfe.versao400.model.ResNFe;
import nfe.versao400.model.RetDistDFeInt;
import nfe.versao400.services.NFeDistribuicaoDFe;
import org.apache.commons.codec.DecoderException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import utilities.MarshallerUtil;

public class UtilSefazNFeDistribuicaoDFeDestNFe_V400 {
    private static final TLogger logger = TLogger.get(UtilSefazNFeDistribuicaoDFeDestNFe_V400.class);

    public NFeDistribuicaoDFe.EncapsuledMessageRec consultaNFeDest(List<ConfConexaoNFeUF> confConexaoCTeUf, NFeConstTipoAmbiente tmAmb, int uf, String versao, ConsultaNFeDest vo) throws NFeException {
        try {
            this.setUltimoNSU(vo);
            vo = (ConsultaNFeDest)CoreDAOFactory.getInstance().getDAOConsultaNFeDest().saveOrUpdate(vo);
            DistDFeInt d = this.getTConsultaDest(vo, versao, tmAmb.shortValue(), uf);
            NFeDistribuicaoDFe.EncapsuledMessageRec e = new NFeDistribuicaoDFe().prepareMessage(d, this.getURL(tmAmb, confConexaoCTeUf), uf);
            e.setVersao("1.01");
            new NFeDistribuicaoDFe().recepcaoConsultaDest(e);
            e.setAuxiliar((Object)vo);
            this.processConsulta(e);
            e.setAuxiliar(CoreDAOFactory.getInstance().getDAOConsultaNFeDest().saveOrUpdate(vo));
            Object msg = "Resultado do Processamento:\n";
            msg = (String)msg + "\nStatus: " + e.getToReceive().getCStat();
            msg = (String)msg + "\nTipo de Ambiente(1-Producao, 2-Homologacao): " + e.getToReceive().getTpAmb();
            msg = (String)msg + "\nMotivo: " + e.getToReceive().getXMotivo();
            e.setMsgProcesada((String)msg);
            return e;
        }
        catch (MalformedURLException | JAXBException | ExceptionDatabase | ExceptionService | NFeException | NFeValidateException ex) {
            logger.error(ex.getClass(), ex);
            new AuxProcessaDados_V400().trataExcecoesNFe(ex);
            return null;
        }
    }

    private String getURL(NFeConstTipoAmbiente tmAmb, List<ConfConexaoNFeUF> confConexaoNFeUf) throws NFeException {
        String url = null;
        short codEmissaoNFe = 4;
        for (ConfConexaoNFeUF c : confConexaoNFeUf) {
            if (c.getTipoEmissaoNFe().getCodigo() != codEmissaoNFe) continue;
            if (tmAmb.shortValue() == 2) {
                url = c.getUrlNFeDistribuicaoHom();
                break;
            }
            url = c.getUrlNFeDistribuicaoProd();
            break;
        }
        if (url != null && url.trim().length() > 0) {
            return url;
        }
        throw new NFeException("Nenhuma URL encontrada para envio das informa\u00e7\u00f5es. Consulte suporte t\u00e9cnico.");
    }

    private DistDFeInt getTConsultaDest(ConsultaNFeDest vo, String versao, Short tpAmb, Integer uf) {
        String cnpjCpf = this.refina(vo.getEmpresa().getPessoa().getComplemento().getCnpj());
        DistDFeInt t = new DistDFeInt();
        t.setVersao("1.01");
        t.setTpAmb(String.valueOf(tpAmb.shortValue()));
        t.setCUFAutor(uf.toString());
        if (cnpjCpf != null && cnpjCpf.trim().length() == 14) {
            t.setCNPJ(cnpjCpf);
        } else if (cnpjCpf != null && cnpjCpf.trim().length() == 11) {
            t.setCPF(cnpjCpf);
        }
        DistDFeInt.DistNSU d = new DistDFeInt.DistNSU();
        if (vo.getUltNSUConsulta() != null && vo.getUltNSUConsulta().trim().length() > 0) {
            d.setUltNSU(vo.getUltNSUConsulta());
        } else {
            d.setUltNSU("000000000000000");
        }
        t.setDistNSU(d);
        return t;
    }

    private String refina(String to) {
        return ClearUtil.refina(to);
    }

    private void processConsulta(NFeDistribuicaoDFe.EncapsuledMessageRec e) throws ExceptionDatabase, ExceptionService {
        RetDistDFeInt.LoteDistDFeInt lote;
        ConsultaNFeDest c = (ConsultaNFeDest)e.getAuxiliar();
        if (c != null) {
            c.setDataConsulta(e.getToReceive().getDhResp().toGregorianCalendar().getTime());
            c.setStatus(new Short(e.getToReceive().getCStat()));
            c.setMotivo(e.getToReceive().getXMotivo());
            if (e.getToReceive().getUltNSU() != null && !e.getToReceive().getUltNSU().isEmpty()) {
                c.setNumeroNSU(e.getToReceive().getUltNSU());
            } else {
                c.setNumeroNSU(c.getUltNSUConsulta());
            }
            e.setAuxiliar(CoreDAOFactory.getInstance().getDAOConsultaNFeDest().saveOrUpdate(c));
        }
        if ((lote = e.getToReceive().getLoteDistDFeInt()) != null) {
            for (RetDistDFeInt.LoteDistDFeInt.DocZip docZip : lote.getDocZip()) {
                try {
                    ResNFe r;
                    String result = ZipUtils.decompress((byte[])docZip.getValue());
                    if (docZip.getSchema().equals("resNFe_v1.01.xsd")) {
                        r = (ResNFe)MarshallerUtil.umarshall((String)result, ResNFe.class);
                        c.getNfeAutorizadas().add(this.getNFeAutorizada(r, c, docZip.getNSU()));
                        continue;
                    }
                    if (docZip.getSchema().equals("resEvento_v1.01.xsd")) {
                        r = (ResEvento)MarshallerUtil.umarshall((String)result, ResEvento.class);
                        c.getNfeEventos().add(this.getNFeEventos((ResEvento)r, c, docZip.getNSU()));
                        continue;
                    }
                    if (docZip.getSchema().equals("procNFe_v3.10.xsd")) {
                        c.getNfeTransportes().add(this.getNFeTransportadores(result, c));
                        continue;
                    }
                    throw new ExceptionService("Erro ainda n\u00e3o tratado. Entre em contato com o suporte t\u00e9cnico!");
                }
                catch (DecoderException ex) {
                    logger.error(ex.getMessage());
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage());
                }
            }
        }
    }

    private ConsultaNFeDestNFe createSave(ResNFe nfe, String nsu) throws ExceptionDatabase, ExceptionService {
        ConsultaNFeDestNFe aut = new ConsultaNFeDestNFe();
        if (nfe.getCNPJ() != null) {
            aut.setCNPJCpf(nfe.getCNPJ());
        } else {
            aut.setCNPJCpf(nfe.getCPF());
        }
        aut.setChNFe(nfe.getChNFe());
        aut.setNrNota(CoreUtilityFactory.getUtilityNFe().getNumeroNFeChave(aut.getChNFe()));
        String data = nfe.getDhEmi().substring(0, 10);
        aut.setDataEmissao(data);
        aut.setDigVal(new String(nfe.getDigVal()));
        aut.setInscEst(nfe.getIE());
        aut.setNomeEmitente(nfe.getXNome());
        aut.setNsuDocFiscal(nsu);
        if (nfe.getCSitNFe().equalsIgnoreCase("1")) {
            aut.setSituacaoNFe(this.getSitAutorizada());
        } else if (nfe.getCSitNFe().equalsIgnoreCase("2")) {
            aut.setSituacaoNFe(this.getSitDenegada());
        }
        aut.setTipoOperacao(new Short(nfe.getTpNF()));
        aut.setValorNF(new Double(nfe.getVNF()));
        aut = (ConsultaNFeDestNFe)CoreDAOFactory.getInstance().getDAOConsultaNFeDestNFe().saveOrUpdate(aut);
        return aut;
    }

    private ConsultaNFeDestNFeAut getNFeAutorizada(ResNFe nfe, ConsultaNFeDest c, String nsu) throws ExceptionDatabase, ExceptionService {
        ConsultaNFeDestNFeAut a;
        ConsultaNFeDestNFe aut = this.findConsultaNFe(nfe.getChNFe());
        if (aut == null) {
            aut = this.createSave(nfe, nsu);
        }
        if ((a = this.findConsultaNFeAut(aut)) == null) {
            a = new ConsultaNFeDestNFeAut();
        }
        a.setConsultaNFeDest(c);
        a.setConsultaNfeDestNFe(aut);
        String dataAut = nfe.getDhRecbto();
        a.setDataAutorizacao(DateUtil.strToDate(dataAut.substring(0, 10) + " " + dataAut.substring(11, 19), "yyyy-MM-dd HH:mm:ss"));
        return a;
    }

    private SituacaoDocumento getSitAutorizada() throws ExceptionDatabase, ExceptionService {
        return this.getSitDoc("00");
    }

    private SituacaoDocumento getSitDenegada() throws ExceptionDatabase, ExceptionService {
        return this.getSitDoc("04");
    }

    private SituacaoDocumento getSitDoc(String codigo) throws ExceptionDatabase, ExceptionService {
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("codigo", codigo);
        return CoreServiceFactory.getServiceSituacaoDocumento().getSituacaoDocumento(cq);
    }

    private void setUltimoNSU(ConsultaNFeDest vo) {
        if (!ToolMethods.isStrWithData((String)vo.getUltNSUConsulta())) {
            vo.setUltNSUConsulta(CoreDAOFactory.getInstance().getDAOConsultaNFeDest().getUltNSU(vo.getEmpresa()));
        }
    }

    private ConsultaNFeDestNFeEventos getNFeEventos(ResEvento r, ConsultaNFeDest c, String nsu) {
        ConsultaNFeDestNFeEventos a = null;
        if (a == null) {
            a = new ConsultaNFeDestNFeEventos();
        }
        a.setConsultaNFeDest(c);
        a.setCpfCnpj(r.getCNPJ());
        String data = r.getDhEvento();
        a.setDataHoraEvento(DateUtil.strToDate(data.substring(0, 10) + " " + data.substring(11, 19), "yyyy-MM-dd HH:mm:ss"));
        data = r.getDhRecbto();
        a.setDataHoraRecebimento(DateUtil.strToDate(data.substring(0, 10) + " " + data.substring(11, 19), "yyyy-MM-dd HH:mm:ss"));
        a.setDescEvento(r.getXEvento());
        a.setChaveNFe(r.getChNFe());
        a.setNrProtocolo(r.getNProt());
        a.setNrSequencialEvento(Short.valueOf(r.getNSeqEvento()));
        a.setTipoEvento(r.getTpEvento());
        a.setNumeroNsu(nsu);
        return a;
    }

    private ConsultaNFeDestTransportes getNFeTransportadores(String xml, ConsultaNFeDest vo) throws JDOMException, IOException {
        String dataEmissao;
        Namespace n = Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe");
        SAXBuilder sb = new SAXBuilder();
        Document d = null;
        d = sb.build((InputStream)new ByteArrayInputStream(xml.getBytes()));
        Element inf = d.getRootElement().getChild("NFe", n).getChild("infNFe", n);
        String ide = inf.getChild("ide", n).getChild("nNF", n).getText();
        String valor = inf.getChild("total", n).getChild("ICMSTot", n).getChild("vNF", n).getText();
        Integer numNota = Integer.parseInt(ide);
        String serie = inf.getChild("ide", n).getChild("serie", n).getText();
        if (inf.getChild("ide", n).getChild("dEmi", n) != null) {
            dataEmissao = inf.getChild("ide", n).getChild("dEmi", n).getText();
        } else {
            dataEmissao = inf.getChild("ide", n).getChild("dhEmi", n).getText();
            dataEmissao = dataEmissao.substring(0, 10);
        }
        String chave = inf.getAttributeValue("Id").substring(3, 47);
        String nomeEmitente = inf.getChild("emit", n).getChild("xNome", n).getText();
        String nomeDestinatario = inf.getChild("dest", n).getChild("xNome", n).getText();
        ConsultaNFeDestTransportes c = new ConsultaNFeDestTransportes();
        c.setChaveNFe(chave);
        c.setNomeDestinatario(nomeDestinatario);
        c.setNomeEmitente(nomeEmitente);
        c.setNumeroNota(numNota);
        c.setSerie(serie);
        c.setValorTotal(Double.valueOf(Double.parseDouble(valor)));
        c.setDataEmissao(DateUtil.strToDate(dataEmissao, "yyyy-MM-dd"));
        c.setConsultaNFeDest(vo);
        XMLNFeCTe x = new XMLNFeCTe();
        x.setConteudoXML(xml);
        x.setChaveNFe(chave);
        x.setDataChegada(new Date());
        x.setDataAtualizacao(new Timestamp(new Date().getTime()));
        x.setFlag(Integer.valueOf(0));
        ServiceXMLNFeCTe service = (ServiceXMLNFeCTe)ConfApplicationContext.getBean(ServiceXMLNFeCTe.class);
        if (!service.existXMLNFeCte(x.getChaveNFe())) {
            service.saveOrUpdate((Object)x);
        }
        return c;
    }

    public ConsultaNFeDestNFe findConsultaNFe(String chave) throws ExceptionService {
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("chaveNFe", chave);
        return (ConsultaNFeDestNFe)CoreServiceFactory.getServiceConsultaNFeDest().execute(r, "findConsultaNFeDestNFePorChaveNFe");
    }

    public ConsultaNFeDestNFeAut findConsultaNFeAut(ConsultaNFeDestNFe aut) throws ExceptionService {
        return (ConsultaNFeDestNFeAut)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOConsultaNFeDestNFeAut(), "consultaNfeDestNFe", aut, 0);
    }

    public NFeDistribuicaoDFe.EncapsuledMessageRec downloadXMLNFe(List<ConfConexaoNFeUF> confConexaoCTeUf, NFeConstTipoAmbiente tmAmb, int uf, String versao, String cnpj, String chaveNFe) throws NFeException {
        try {
            DistDFeInt d = this.getTConsultaChaveNFe(tmAmb.shortValue(), uf, cnpj, chaveNFe);
            NFeDistribuicaoDFe.EncapsuledMessageRec e = new NFeDistribuicaoDFe().prepareMessage(d, this.getURL(tmAmb, confConexaoCTeUf), uf);
            e.setVersao("1.01");
            new NFeDistribuicaoDFe().recepcaoConsultaDest(e);
            this.processConsultaDownloadNFe(e);
            Object msg = "Resultado do Processamento:\n";
            msg = (String)msg + "\nStatus: " + e.getToReceive().getCStat();
            msg = (String)msg + "\nTipo de Ambiente(1-Producao, 2-Homologacao): " + e.getToReceive().getTpAmb();
            msg = (String)msg + "\nMotivo: " + e.getToReceive().getXMotivo();
            e.setMsgProcesada((String)msg);
            return e;
        }
        catch (MalformedURLException | JAXBException | ExceptionDatabase | ExceptionService | NFeException | NFeValidateException ex) {
            logger.error(ex.getClass(), ex);
            new AuxProcessaDados_V400().trataExcecoesNFe(ex);
            return null;
        }
    }

    private DistDFeInt getTConsultaChaveNFe(Short tpAmb, Integer uf, String cnpj, String chaveNFe) {
        String cnpjCpf = this.refina(cnpj);
        DistDFeInt t = new DistDFeInt();
        t.setVersao("1.01");
        t.setTpAmb(String.valueOf(tpAmb.shortValue()));
        t.setCUFAutor(uf.toString());
        if (cnpjCpf != null && cnpjCpf.trim().length() == 14) {
            t.setCNPJ(cnpjCpf);
        } else if (cnpjCpf != null && cnpjCpf.trim().length() == 11) {
            t.setCPF(cnpjCpf);
        }
        DistDFeInt.ConsChNFe dd = new DistDFeInt.ConsChNFe();
        dd.setChNFe(chaveNFe);
        t.setConsChNFe(dd);
        return t;
    }

    private void processConsultaDownloadNFe(NFeDistribuicaoDFe.EncapsuledMessageRec e) throws ExceptionDatabase, ExceptionService {
        RetDistDFeInt.LoteDistDFeInt lote = e.getToReceive().getLoteDistDFeInt();
        if (lote != null) {
            for (RetDistDFeInt.LoteDistDFeInt.DocZip docZip : lote.getDocZip()) {
                try {
                    String result = ZipUtils.decompress((byte[])docZip.getValue());
                    if (docZip.getSchema().equals("procNFe_v4.00.xsd")) {
                        e.setAuxiliar((Object)result);
                        continue;
                    }
                    throw new ExceptionService("Erro ainda n\u00e3o tratado. Entre em contato com o suporte t\u00e9cnico!");
                }
                catch (DecoderException ex) {
                    logger.error(ex.getMessage());
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage());
                }
            }
        }
    }
}

