/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.nfesefaz.versao400;

import com.touchcomp.basementor.constants.enums.cte.EnumConstTipoAmbienteCTe;
import com.touchcomp.basementor.constants.enums.eventonfe.NFeConstTipoManifestoDestNFe;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.ConfConexaoNFeUF;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.EventoNFe;
import com.touchcomp.basementor.model.vo.EvtNFeCancelamento;
import com.touchcomp.basementor.model.vo.EvtNFeCartaCorrecao;
import com.touchcomp.basementor.model.vo.EvtNFeEpec;
import com.touchcomp.basementor.model.vo.EvtNFeManifestoDest;
import com.touchcomp.basementor.model.vo.FusoHorario;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.LoteEventosNFe;
import com.touchcomp.basementor.model.vo.LoteFaturamentoNFe;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.TipoEmissaoNFe;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorxml.model.XMLEventoNFe;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLEventoNFe;
import contatocore.util.ContatoDateUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.bind.JAXBException;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.properties.LocalProperties;
import mentorcore.service.impl.nfesefaz.versao400.AuxProcessaDados_V400;
import mentorcore.service.impl.nfesefaz.versao400.UtilSefazNFeLoteFatNFe_V400;
import mentorcore.tools.ClearUtil;
import mentorcore.tools.DateUtil;
import nfe.constants.NFeConstTipoAmbiente;
import nfe.exception.NFeException;
import nfe.exception.NFeValidateException;
import nfe.versao400.model.TEnvEvento;
import nfe.versao400.model.TEnviNFe;
import nfe.versao400.model.TEvento;
import nfe.versao400.model.TRetEvento;
import nfe.versao400.model.TUf;
import nfe.versao400.services.NFeRecepcao;
import nfe.versao400.services.NFeRecepcaoEventos;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

class UtilSefazNFeEventosNFe_V400 {
    private static final TLogger logger = TLogger.get(UtilSefazNFeEventosNFe_V400.class);

    UtilSefazNFeEventosNFe_V400() {
    }

    public NFeRecepcaoEventos.EncapsuledMessageRec eventosNFe(List<ConfConexaoNFeUF> confConexaoCTeUf, NFeConstTipoAmbiente tmAmb, int uf, String versao, LoteEventosNFe vo, LoteFaturamentoNFe loteFaturamento, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento opcoesRelacionamento, Usuario usuario, Grupo grupoUsuarios, OpcoesFinanceiras opcoesFinanceiras) throws NFeException {
        try {
            NFeRecepcaoEventos.EncapsuledMessageRec e = new NFeRecepcaoEventos().prepareMessage(this.getTLoteEventos(vo, versao, tmAmb.shortValue()), this.getURL(confConexaoCTeUf, tmAmb, vo.getTipoEmissaoNFe(), vo.getTipoLote(), vo.getTipoUrl()), uf);
            this.validarNotasEventoNFe(vo);
            this.gerarXmlNotasEpec(loteFaturamento, tmAmb, uf, versao, confConexaoCTeUf, vo.getTipoUrl(), opcoesFaturamento, opcoesRelacionamento, usuario, grupoUsuarios, opcoesFinanceiras);
            this.atualizarAntesDadosEnvio(vo, e);
            new NFeRecepcaoEventos().recepcaoLoteEventos(e);
            vo = this.atualizarDadoEventos(e, vo, opcoesFaturamento, opcoesRelacionamento, usuario);
            e.setAuxiliar((Object)vo);
            Object msg = "Resultado do Processamento:\n";
            msg = (String)msg + "\nStatus: " + e.getToReceive().getCStat();
            msg = (String)msg + "\nChave: " + e.getToReceive().getIdLote();
            msg = (String)msg + "\nTipo de Ambiente(1-Producao, 2-Homologacao): " + e.getToReceive().getTpAmb();
            msg = (String)msg + "\nMotivo: " + e.getToReceive().getXMotivo();
            msg = (String)msg + "\nLote de Eventos: " + vo.getIdentificador().toString();
            for (TRetEvento t : e.getToReceive().getRetEvento()) {
                msg = (String)msg + "\n\n";
                msg = (String)msg + "\nChave: " + t.getInfEvento().getChNFe();
                msg = (String)msg + "\nStatus: " + t.getInfEvento().getCStat();
                msg = (String)msg + "\nEvento: " + t.getInfEvento().getXEvento();
                msg = (String)msg + "\nMotivo: " + t.getInfEvento().getXMotivo();
            }
            e.setMsgProcesada((String)msg);
            return e;
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            new AuxProcessaDados_V400().trataExcecoesNFe(ex);
            return null;
        }
    }

    private String getURL(List<ConfConexaoNFeUF> confConexaoNfeUf, NFeConstTipoAmbiente tmAmb, TipoEmissaoNFe p, Short tpEvento, Short tipoUrl) throws NFeException {
        String url = null;
        short codEmissaoNFe = p.getCodigo();
        if (tpEvento != null && (tpEvento.equals((short)0) || tpEvento.equals((short)1)) && (codEmissaoNFe == 2 || codEmissaoNFe == 5 || codEmissaoNFe == 4 || codEmissaoNFe == 3 || codEmissaoNFe == 7 || codEmissaoNFe == 6) && tipoUrl != null && tipoUrl.equals((short)1)) {
            codEmissaoNFe = 1;
        }
        for (ConfConexaoNFeUF c : confConexaoNfeUf) {
            if (c.getTipoEmissaoNFe().getCodigo() != codEmissaoNFe) continue;
            if (tmAmb.shortValue().shortValue() == EnumConstTipoAmbienteCTe.IDENT_AMBIENTE_HOMOLOGACAO.getValue()) {
                url = c.getUrlNFeRepEvtHom();
                break;
            }
            url = c.getUrlNFeRepEvtProd();
            break;
        }
        if (tpEvento != null && (tpEvento == 2 || tpEvento == 3)) {
            url = tmAmb.shortValue().shortValue() == EnumConstTipoAmbienteCTe.IDENT_AMBIENTE_HOMOLOGACAO.getValue() ? "https://hom.nfe.fazenda.gov.br/NFeRecepcaoEvento4/NFeRecepcaoEvento4.asmx" : "https://www.nfe.fazenda.gov.br/NFeRecepcaoEvento4/NFeRecepcaoEvento4.asmx";
        }
        if (url != null && url.trim().length() > 0) {
            return url;
        }
        throw new NFeException("Nenhuma URL encontrada para envio das informa\u00e7\u00f5es. Consulte suporte t\u00e9cnico.");
    }

    private TEnvEvento getTLoteEventos(LoteEventosNFe vo, String versao, Short tpAmb) throws NFeException {
        TEnvEvento t = new TEnvEvento();
        t.setVersao("1.00");
        t.setIdLote(this.refina(vo.getIdentificador().toString()));
        String codOrgaoRec = vo.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge();
        if (vo.getTipoLote() == 2) {
            codOrgaoRec = "91";
        }
        for (EventoNFe e : vo.getEventosNFe()) {
            TEvento te = new TEvento();
            t.getEvento().add(te);
            TEvento.InfEvento i = new TEvento.InfEvento();
            te.setInfEvento(i);
            te.setVersao("1.00");
            String doc = this.refina(vo.getEmpresa().getPessoa().getComplemento().getCnpj());
            if (doc.length() > 11) {
                i.setCNPJ(doc);
            } else {
                i.setCPF(doc);
            }
            if (e instanceof EvtNFeCartaCorrecao) {
                this.setDadosCartaCorrecao(i, e, vo.getEmpresa(), tpAmb, codOrgaoRec);
                continue;
            }
            if (e instanceof EvtNFeCancelamento) {
                this.setDadosCancelamento(i, e, vo.getEmpresa(), tpAmb, codOrgaoRec);
                continue;
            }
            if (e instanceof EvtNFeManifestoDest) {
                this.setDadosManifestoDest(i, e, vo.getEmpresa(), tpAmb, codOrgaoRec);
                continue;
            }
            if (!(e instanceof EvtNFeEpec)) continue;
            this.setDadosEpec(i, e, vo.getEmpresa(), tpAmb, codOrgaoRec, vo.getVersaoNFe());
        }
        return t;
    }

    private String refina(String to) {
        return ClearUtil.refina(to);
    }

    private String refinaXML(String to) {
        return ToolString.clearSpecialCharacXML((String)to);
    }

    public String formatarDataEventoCartaCorrecao(Date dataEvento, Short tipoFusoHorario, FusoHorario fusoHorario) {
        String data = DateUtil.dateToStr(dataEvento, "yyyy-MM-dd");
        String hora = DateUtil.dateToStr(dataEvento, "HH:mm:ss");
        String formatado = data + "T" + hora;
        formatado = tipoFusoHorario.equals(Short.valueOf("0")) ? (TimeZone.getDefault().getID().equalsIgnoreCase("America/Manaus") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Rio_Branco") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Eirunepe") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Boa_Vista") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Porto_Velho") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Santarem") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Cuiaba") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Campo_Grande") ? (ContatoDateUtil.isHorarioVerao() ? formatado + "-03:00" : formatado + "-04:00") : (TimeZone.getDefault().getID().equalsIgnoreCase("America/Noronha") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Belem") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Fortaleza") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Recife") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Araguaina") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Maceio") ? (ContatoDateUtil.isHorarioVerao() ? formatado + "-01:00" : formatado + "-02:00") : (ContatoDateUtil.isHorarioVerao() ? formatado + "-02:00" : formatado + "-03:00"))) : formatado + fusoHorario.getCodigo();
        return formatado;
    }

    private LoteEventosNFe atualizarDadoEventos(NFeRecepcaoEventos.EncapsuledMessageRec e, LoteEventosNFe vo, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento op, Usuario usuario) throws NFeException, JAXBException, ExceptionDatabase, ExceptionService, Exception {
        vo.setMotivoRetorno(e.getToReceive().getXMotivo());
        vo.setStatus(new Short(e.getToReceive().getCStat()));
        for (TRetEvento t : e.getToReceive().getRetEvento()) {
            EventoNFe found = this.findEventoNFe(t.getInfEvento().getTpEvento(), t.getInfEvento().getChNFe(), t.getInfEvento().getNSeqEvento(), vo);
            new AuxProcessaDados_V400().atualizarDadosEventoNFe(t, found, opcoesFaturamento, op, usuario);
        }
        vo = (LoteEventosNFe)CoreDAOFactory.getInstance().getDAOLoteEventosNFe().saveOrUpdate(vo);
        return vo;
    }

    private EventoNFe findEventoNFe(String tpEvento, String chave, String nrSeqInf, LoteEventosNFe vo) throws NFeException {
        for (EventoNFe e : vo.getEventosNFe()) {
            Long nrSeqAux = 0L;
            String tpEvntAux = null;
            String chaveAux = null;
            if (e instanceof EvtNFeCancelamento) {
                evt = (EvtNFeCancelamento)e;
                nrSeqAux = evt.getNumSeqEvento();
                tpEvntAux = String.valueOf(110111);
                chaveAux = evt.getChave();
            } else if (e instanceof EvtNFeCartaCorrecao) {
                evt = (EvtNFeCartaCorrecao)e;
                nrSeqAux = evt.getNumSeqEvento();
                tpEvntAux = String.valueOf(110110);
                chaveAux = evt.getChave();
            } else if (e instanceof EvtNFeEpec) {
                evt = (EvtNFeEpec)e;
                nrSeqAux = evt.getNumSeqEvento();
                tpEvntAux = String.valueOf(110140);
                chaveAux = evt.getChave();
            } else if (e instanceof EvtNFeManifestoDest) {
                evt = (EvtNFeManifestoDest)e;
                nrSeqAux = evt.getNumSeqEvento();
                tpEvntAux = evt.getTipoEvento().getCodEvento();
                chaveAux = evt.getChave();
            }
            if (!(tpEvento + chave + ToolString.completaZeros((String)String.valueOf(nrSeqInf), (int)2, (boolean)true)).equals(tpEvntAux + chaveAux + ToolString.completaZeros((String)String.valueOf(nrSeqAux), (int)2, (boolean)true))) continue;
            return e;
        }
        throw new NFeException("Erro ao atualizar os dados do Evento da NFe.");
    }

    private EventoNFe findEventoNFe(String id, LoteEventosNFe vo) throws NFeException {
        for (EventoNFe e : vo.getEventosNFe()) {
            Long nrSeq = 0L;
            String tpEvnt = null;
            String chave = null;
            if (e instanceof EvtNFeCancelamento) {
                evt = (EvtNFeCancelamento)e;
                nrSeq = evt.getNumSeqEvento();
                tpEvnt = String.valueOf(110111);
                chave = evt.getChave();
            } else if (e instanceof EvtNFeCartaCorrecao) {
                evt = (EvtNFeCartaCorrecao)e;
                nrSeq = evt.getNumSeqEvento();
                tpEvnt = String.valueOf(110110);
                chave = evt.getChave();
            } else if (e instanceof EvtNFeManifestoDest) {
                evt = (EvtNFeManifestoDest)e;
                nrSeq = evt.getNumSeqEvento();
                tpEvnt = evt.getTipoEvento().getCodEvento();
                chave = evt.getChave();
            } else if (e instanceof EvtNFeEpec) {
                evt = (EvtNFeEpec)e;
                nrSeq = evt.getNumSeqEvento();
                tpEvnt = String.valueOf(110140);
                chave = evt.getChave();
            }
            if (!id.substring(2).equals(tpEvnt + chave + ToolString.completaZeros((String)String.valueOf(nrSeq), (int)2, (boolean)true))) continue;
            return e;
        }
        throw new NFeException("Erro ao atualizar os dados do Evento da NFe.");
    }

    private void atualizarAntesDadosEnvio(LoteEventosNFe lote, NFeRecepcaoEventos.EncapsuledMessageRec tRet) throws NFeException {
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        ServiceXMLEventoNFe service = (ServiceXMLEventoNFe)ConfApplicationContext.getBean(ServiceXMLEventoNFe.class);
        try {
            Namespace n = Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe");
            doc = builder.build((InputStream)new ByteArrayInputStream(tRet.getXmlSend().getBytes()));
            Element e = doc.detachRootElement();
            List l = e.getChildren("evento", n);
            ArrayList aux = new ArrayList(l);
            for (Element el : aux) {
                String chave = el.getChild("infEvento", n).getAttributeValue("Id");
                EventoNFe found = this.findEventoNFe(chave, lote);
                el = el.detach();
                StringWriter s = new StringWriter();
                XMLOutputter xout = new XMLOutputter();
                xout.output(el, (Writer)s);
                XMLEventoNFe xml = service.getOrCreateXMLEventoNFe(found.getIdentificador());
                xml.setConteudoEnviado(s.toString());
                service.saveOrUpdate((Object)xml);
            }
        }
        catch (JDOMException ex) {
            throw new NFeException("Erro ao processar o xml de retorno.", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new NFeException("Erro ao processar o xml de retorno.", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new NFeException("Erro ao salvar o xml do Nfe.", (Throwable)ex);
        }
    }

    private void validarNotasEventoNFe(LoteEventosNFe vo) throws NFeValidateException {
        for (EventoNFe e : vo.getEventosNFe()) {
            NotaFiscalPropria nf = null;
            if (!(e instanceof EvtNFeCancelamento ? (nf = ((EvtNFeCancelamento)e).getNotaFiscalPropria()).getStatus() == null || !EnumConstNFeStatus.isStatusAutorizada((Integer)nf.getStatus().intValue()) : e instanceof EvtNFeCartaCorrecao && ((nf = ((EvtNFeCartaCorrecao)e).getNotaFiscalPropria()).getStatus() == null || !EnumConstNFeStatus.isStatusAutorizada((Integer)nf.getStatus().intValue())))) continue;
            throw new NFeValidateException("Para efetivar um evento de uma NFe, a mesma deve ter sido autorizada. Verifique a nota: " + nf.getNumeroNota());
        }
    }

    String writeXMLNFESemValidade(List<ConfConexaoNFeUF> confConexaoCTeUf, NFeConstTipoAmbiente tmAmb, int codUF, String versao, LoteEventosNFe c) throws NFeException {
        try {
            c = (LoteEventosNFe)CoreDAOFactory.getInstance().getDAOLoteEventosNFe().findByPrimaryKey(c.getIdentificador());
            String e = new NFeRecepcaoEventos().gerarXMLSemValidade(this.getTLoteEventos(c, versao, tmAmb.shortValue()));
            return e;
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            new AuxProcessaDados_V400().trataExcecoesNFe(ex);
            return null;
        }
    }

    private void setDadosCartaCorrecao(TEvento.InfEvento i, EventoNFe e, Empresa emp, short tpAmb, String codOrgaoRec) throws NFeException {
        EvtNFeCartaCorrecao ev = (EvtNFeCartaCorrecao)e;
        i.setChNFe(ev.getNotaFiscalPropria().getChaveNFE());
        i.setCOrgao(codOrgaoRec);
        i.setNSeqEvento(this.refina(ev.getNumSeqEvento().toString()));
        i.setTpAmb(String.valueOf(tpAmb));
        i.setTpEvento(String.valueOf(110110));
        i.setVerEvento("1.00");
        i.setDhEvento(this.formatarDataEventoCartaCorrecao(ev.getDataEvento(), emp.getEmpresaDados().getTipoFusoHorario(), emp.getEmpresaDados().getFusoHorario()));
        i.setId("ID" + i.getTpEvento() + i.getChNFe() + ToolString.completaZeros((String)i.getNSeqEvento(), (int)2, (boolean)true));
        i.setDetEvento(this.getDetEventoCartaCorrecao(ev));
    }

    private TEvento.InfEvento.DetEvento getDetEventoCartaCorrecao(EvtNFeCartaCorrecao ev) throws NFeException {
        TEvento.InfEvento.DetEvento detEvento = new TEvento.InfEvento.DetEvento();
        detEvento.setVersaoEvento("1.00");
        detEvento.setDescEvento("Carta de Correcao");
        detEvento.setxCondUso(ev.getCondicaoUso().getConteudo());
        detEvento.setxCorrecao(this.refinaXML(ev.getJustificativaEvento()));
        if (ev.getJustificativaEvento() != null && ev.getJustificativaEvento().length() > 1000) {
            detEvento.setxCorrecao(this.refinaXML(ev.getJustificativaEvento().substring(0, 999)));
        }
        return detEvento;
    }

    private void setDadosCancelamento(TEvento.InfEvento i, EventoNFe e, Empresa empresa, Short tpAmb, String codOrgao) throws NFeException {
        EvtNFeCancelamento ev = (EvtNFeCancelamento)e;
        i.setChNFe(ev.getNotaFiscalPropria().getChaveNFE());
        i.setCOrgao(codOrgao);
        i.setNSeqEvento(this.refina(ev.getNumSeqEvento().toString()));
        i.setTpAmb(String.valueOf(tpAmb));
        i.setTpEvento(String.valueOf(110111));
        i.setVerEvento("1.00");
        i.setDhEvento(this.formatarDataEventoCartaCorrecao(ev.getDataEvento(), empresa.getEmpresaDados().getTipoFusoHorario(), empresa.getEmpresaDados().getFusoHorario()));
        i.setId("ID" + i.getTpEvento() + i.getChNFe() + ToolString.completaZeros((String)i.getNSeqEvento(), (int)2, (boolean)true));
        i.setDetEvento(this.getDetEventoCancelamento(ev));
    }

    private TEvento.InfEvento.DetEvento getDetEventoCancelamento(EvtNFeCancelamento ev) throws NFeException {
        TEvento.InfEvento.DetEvento detEvento = new TEvento.InfEvento.DetEvento();
        detEvento.setVersaoEvento("1.00");
        detEvento.setDescEvento("Cancelamento");
        detEvento.setNProt(ev.getNotaFiscalPropria().getNrProtocolo());
        detEvento.setXJust(this.refinaXML(ev.getJustificativaEvento()));
        if (ev.getJustificativaEvento() != null && ev.getJustificativaEvento().length() > 255) {
            detEvento.setXJust(this.refinaXML(ev.getJustificativaEvento().substring(0, 254)));
        }
        return detEvento;
    }

    private void setDadosManifestoDest(TEvento.InfEvento i, EventoNFe e, Empresa empresa, Short tpAmb, String codOrgao) throws NFeException {
        EvtNFeManifestoDest ev = (EvtNFeManifestoDest)e;
        i.setChNFe(ev.getChave());
        i.setCOrgao(codOrgao);
        i.setNSeqEvento(this.refina(ev.getNumSeqEvento().toString()));
        i.setTpAmb(String.valueOf(tpAmb));
        i.setTpEvento(ev.getTipoEvento().getCodEvento());
        i.setVerEvento("1.00");
        i.setDhEvento(this.formatarDataEventoCartaCorrecao(ev.getDataEvento(), empresa.getEmpresaDados().getTipoFusoHorario(), empresa.getEmpresaDados().getFusoHorario()));
        i.setChNFe(e.getChave());
        i.setId("ID" + i.getTpEvento() + i.getChNFe() + ToolString.completaZeros((String)i.getNSeqEvento(), (int)2, (boolean)true));
        i.setDetEvento(this.getDetEventoManisfesto(ev));
    }

    private TEvento.InfEvento.DetEvento getDetEventoManisfesto(EvtNFeManifestoDest ev) throws NFeException {
        TEvento.InfEvento.DetEvento detEvento = new TEvento.InfEvento.DetEvento();
        detEvento.setVersaoEvento("1.00");
        detEvento.setDescEvento(ev.getTipoEvento().getDescricao());
        if (ev.getTipoEvento().getCodEvento().equalsIgnoreCase(NFeConstTipoManifestoDestNFe.OPERACAO_NAO_REALIZADA.getCodigo())) {
            detEvento.setXJust(this.refinaXML(ev.getJustificativaEvento()));
        }
        return detEvento;
    }

    private void setDadosEpec(TEvento.InfEvento i, EventoNFe e, Empresa empresa, Short tpAmb, String codOrgaoRec, VersaoNFe versaoNFe) {
        EvtNFeEpec ev = (EvtNFeEpec)e;
        i.setChNFe(ev.getNotaFiscalPropria().getChaveNFE());
        i.setCOrgao("91");
        i.setNSeqEvento(this.refina(ev.getNumSeqEvento().toString()));
        i.setTpAmb(String.valueOf(tpAmb));
        i.setTpEvento(String.valueOf(110140));
        i.setVerEvento("1.00");
        i.setDhEvento(this.formatarData(ev.getNotaFiscalPropria().getDataEmissaoNota(), ev.getNotaFiscalPropria().getHoraEmissao(), empresa.getEmpresaDados().getTipoFusoHorario(), empresa.getEmpresaDados().getFusoHorario()));
        i.setId("ID" + i.getTpEvento() + i.getChNFe() + ToolString.completaZeros((String)i.getNSeqEvento(), (int)2, (boolean)true));
        i.setDetEvento(this.getDetEventoEpec(ev, codOrgaoRec, empresa, versaoNFe));
    }

    private TEvento.InfEvento.DetEvento getDetEventoEpec(EvtNFeEpec ev, String codOrgao, Empresa empresa, VersaoNFe versaoNFe) {
        TEvento.InfEvento.DetEvento detEvento = new TEvento.InfEvento.DetEvento();
        detEvento.setVersaoEvento("1.00");
        detEvento.setDescEvento("EPEC");
        detEvento.setcOrgaoAutor(codOrgao);
        detEvento.setTpAutor("1");
        detEvento.setVerAplic(LocalProperties.getInstance().getCodigoVersaoFormatado());
        detEvento.setDhEmi(this.formatarData(ev.getNotaFiscalPropria().getDataEmissaoNota(), ev.getNotaFiscalPropria().getHoraEmissao(), empresa.getEmpresaDados().getTipoFusoHorario(), empresa.getEmpresaDados().getFusoHorario()));
        detEvento.setTpNF("1");
        detEvento.setIE(this.refina(ev.getNotaFiscalPropria().getEmpresa().getPessoa().getComplemento().getInscEst()));
        UnidadeFatCliente unidFatCliente = ev.getNotaFiscalPropria().getUnidadeFatCliente();
        Endereco end = unidFatCliente.getPessoa().getEndereco();
        TEvento.InfEvento.DetEvento.Dest dest = new TEvento.InfEvento.DetEvento.Dest();
        dest.setUF(TUf.valueOf((String)unidFatCliente.getPessoa().getEndereco().getCidade().getUf().getSigla()));
        String cpfCnpj = this.refina(unidFatCliente.getCliente().getPessoa().getComplemento().getCnpj());
        if (cpfCnpj.trim().length() > 11) {
            dest.setCNPJ(cpfCnpj);
        } else if (cpfCnpj.trim().length() == 11) {
            dest.setCPF(cpfCnpj);
        }
        if (end.getCidade().getUf().getSigla().equals("EX")) {
            if (unidFatCliente.getCliente().getPessoa().getComplemento().getPassaporte() != null && unidFatCliente.getCliente().getPessoa().getComplemento().getPassaporte().trim().length() > 0) {
                dest.setIdestrangeiro(this.refina(unidFatCliente.getCliente().getPessoa().getComplemento().getPassaporte()));
            } else {
                dest.setIdestrangeiro("");
            }
        }
        if (unidFatCliente.getPessoa().getComplemento().getInscEst() != null && unidFatCliente.getPessoa().getComplemento().getInscEst().trim().length() > 0 && !unidFatCliente.getPessoa().getComplemento().getInscEst().equalsIgnoreCase("ISENTO")) {
            dest.setIe(this.refina(unidFatCliente.getPessoa().getComplemento().getInscEst()));
        }
        dest.setVICMS(this.formatarNumeros(ev.getNotaFiscalPropria().getValoresNfPropria().getValorIcms(), 2));
        dest.setVNF(this.formatarNumeros(ev.getNotaFiscalPropria().getValoresNfPropria().getValorTotal(), 2));
        dest.setVST(this.formatarNumeros(ev.getNotaFiscalPropria().getValoresNfPropria().getValorIcmsSt(), 2));
        detEvento.setDest(dest);
        return detEvento;
    }

    private String formatarNumeros(Double num, int decimalSize) {
        if (num == null) {
            num = 0.0;
        }
        DecimalFormat form = new DecimalFormat();
        form = (DecimalFormat)DecimalFormat.getInstance(Locale.ENGLISH);
        form.setMaximumIntegerDigits(15);
        form.applyPattern("###0.00");
        form.setMaximumFractionDigits(decimalSize);
        form.setMinimumFractionDigits(decimalSize);
        String aux = form.format(num);
        return aux;
    }

    private String formatarData(Date dataNota, Date horaNota, Short tipoFusoHorario, FusoHorario fusoHorario) {
        if (dataNota == null) {
            return null;
        }
        String data = DateUtil.dateToStr(dataNota, "yyyy-MM-dd");
        String hora = DateUtil.dateToStr(horaNota, "HH:mm:ss");
        String formatado = data + "T" + hora;
        formatado = tipoFusoHorario.equals(Short.valueOf("0")) ? (TimeZone.getDefault().getID().equalsIgnoreCase("America/Manaus") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Rio_Branco") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Eirunepe") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Boa_Vista") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Porto_Velho") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Santarem") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Cuiaba") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Campo_Grande") ? (ContatoDateUtil.isHorarioVerao() ? formatado + "-03:00" : formatado + "-04:00") : (TimeZone.getDefault().getID().equalsIgnoreCase("America/Noronha") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Belem") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Fortaleza") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Recife") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Araguaina") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Maceio") ? (ContatoDateUtil.isHorarioVerao() ? formatado + "-01:00" : formatado + "-02:00") : (ContatoDateUtil.isHorarioVerao() ? formatado + "-02:00" : formatado + "-03:00"))) : formatado + fusoHorario.getCodigo();
        return formatado;
    }

    private void gerarXmlNotasEpec(LoteFaturamentoNFe loteFaturamento, NFeConstTipoAmbiente tpAmb, int uf, String versao, List<ConfConexaoNFeUF> confConexaoCTeUf, Short tipoUrl, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento opcoesRelacionamento, Usuario usuario, Grupo grupoUsuarios, OpcoesFinanceiras opcoesFinanceiras) throws NFeException {
        if (loteFaturamento != null) {
            try {
                Boolean sincrono = loteFaturamento.getNotasFiscais().size() == 1;
                UtilSefazNFeLoteFatNFe_V400 u = new UtilSefazNFeLoteFatNFe_V400(tpAmb, versao, opcoesFaturamento, opcoesRelacionamento, usuario, grupoUsuarios, null, opcoesFinanceiras);
                TEnviNFe t = u.getRecepcaoLote(loteFaturamento, versao, tpAmb.shortValue(), sincrono);
                NFeRecepcao.EncapsuledMessageRec en = new NFeRecepcao().prepareMessage(t, this.getURL(confConexaoCTeUf, tpAmb, loteFaturamento.getPeriodoEmissaoNfe().getTipoEmissaoNfe(), (short)3, tipoUrl), uf);
                u.salvaGeraXMLLoteNFeAntesEnvio(loteFaturamento, en);
            }
            catch (MalformedURLException | JAXBException | NFeException | NFeValidateException ex) {
                throw new NFeException(ex.getMessage());
            }
        }
    }
}

