/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.nfesefaz.versao400;

import com.touchcomp.basementor.constants.enums.cte.EnumConstTipoAmbienteCTe;
import com.touchcomp.basementor.model.vo.ConfConexaoNFeUF;
import com.touchcomp.basementor.model.vo.InutilizacaoNumeracaoNFe;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.TipoEmissaoNFe;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.impl.nfesefaz.versao400.AuxProcessaDados_V400;
import mentorcore.tools.ClearUtil;
import mentorcore.tools.DateUtil;
import nfe.constants.NFeConstTipoAmbiente;
import nfe.exception.NFeException;
import nfe.versao400.model.TInutNFe;
import nfe.versao400.services.NFeInutilizacao;

public class UtilSefazNFeInutilizaNFe_V400 {
    private static final TLogger logger = TLogger.get(UtilSefazNFeInutilizaNFe_V400.class);
    public static final String VERSAO = "4.00";

    NFeInutilizacao.EncapsuledMessageRec inutilizaNumeracaoNFe(List<ConfConexaoNFeUF> confConexaoNFeUf, NFeConstTipoAmbiente tmAmb, int uf, String versao, InutilizacaoNumeracaoNFe vo) throws NFeException {
        try {
            vo = (InutilizacaoNumeracaoNFe)CoreDAOFactory.getInstance().getDAOInutilizacaoNumeracaoNFe().saveOrUpdate(vo);
            String url = this.getURL(confConexaoNFeUf, tmAmb, vo.getTipoEmissaoNFe(), vo.getModeloDocFiscal());
            NFeInutilizacao.EncapsuledMessageRec e = new NFeInutilizacao().prepareMessage(this.getTinuNFe(vo, tmAmb), url, uf);
            new NFeInutilizacao().inutilizacaoNFe(e);
            e.setAuxiliar(this.saveInutilizacao(e, vo));
            Object st = "Resultado da Inutiliza\u00e7\u00e3o:";
            st = (String)st + "\nStatus: " + e.getToReceive().getInfInut().getCStat();
            st = (String)st + "\nUF: " + e.getToReceive().getInfInut().getCUF();
            st = (String)st + "\nModelo: " + e.getToReceive().getInfInut().getMod();
            st = (String)st + "\nNr. Inicial: " + e.getToReceive().getInfInut().getNNFIni();
            st = (String)st + "\nNr. Final: " + e.getToReceive().getInfInut().getNNFFin();
            st = (String)st + "\nTipo de Ambiente(1- Producao,2- Homologacao): " + e.getToReceive().getInfInut().getTpAmb();
            st = (String)st + "\nMotivo: " + e.getToReceive().getInfInut().getXMotivo();
            e.setMsgProcessada((String)st);
            return e;
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            new AuxProcessaDados_V400().trataExcecoesNFe(ex);
            return null;
        }
    }

    private String getURL(List<ConfConexaoNFeUF> confConexaoNFeUf, NFeConstTipoAmbiente tmAmb, TipoEmissaoNFe p, ModeloDocFiscal modeloDocFiscal) throws NFeException {
        String url = null;
        if (modeloDocFiscal != null && modeloDocFiscal.getCodigo().equals("65")) {
            url = "https://nfce.fazenda.mg.gov.br/nfce/services/NFeInutilizacao4";
            return url;
        }
        for (ConfConexaoNFeUF c : confConexaoNFeUf) {
            if (!c.getTipoEmissaoNFe().equals((Object)p)) continue;
            if (tmAmb.shortValue().shortValue() == EnumConstTipoAmbienteCTe.IDENT_AMBIENTE_HOMOLOGACAO.getValue()) {
                url = c.getUrlNFeInutilHom();
                break;
            }
            url = c.getUrlNFeInutilProd();
            break;
        }
        if (url != null && url.trim().length() > 0) {
            return url;
        }
        throw new NFeException("Nenhuma URL encontrada para envio das informa\u00e7\u00f5es. Consulte suporte t\u00e9cnico.");
    }

    private TInutNFe getTinuNFe(InutilizacaoNumeracaoNFe vo, NFeConstTipoAmbiente tpAmb) {
        TInutNFe t = new TInutNFe();
        t.setVersao(VERSAO);
        TInutNFe.InfInut i = new TInutNFe.InfInut();
        i.setAno(DateUtil.dateToStr(vo.getPeriodo(), "yy"));
        i.setCNPJ(ClearUtil.refina(vo.getEmpresa().getPessoa().getComplemento().getCnpj()));
        i.setCUF(vo.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge());
        i.setMod(vo.getModeloDocFiscal().getCodigo());
        i.setNNFIni(ClearUtil.refina(vo.getNumeroInicial().toString()));
        i.setNNFFin(ClearUtil.refina(vo.getNumeroFinal().toString()));
        i.setSerie(Integer.valueOf(vo.getSerie()).toString());
        i.setTpAmb(String.valueOf(tpAmb.shortValue()));
        i.setXJust(vo.getJustificativa());
        i.setXServ("INUTILIZAR");
        t.setInfInut(i);
        StringBuilder sb = new StringBuilder();
        sb.append(vo.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge());
        sb.append(DateUtil.dateToStr(vo.getPeriodo(), "yy"));
        sb.append(ClearUtil.refina(vo.getEmpresa().getPessoa().getComplemento().getCnpj()));
        sb.append(vo.getModeloDocFiscal().getCodigo());
        sb.append(ToolString.completaZeros((String)ClearUtil.refina(Integer.valueOf(vo.getSerie()).toString()), (int)3, (boolean)true));
        sb.append(ToolString.completaZeros((String)ClearUtil.refina(vo.getNumeroInicial().toString()), (int)9, (boolean)true));
        sb.append(ToolString.completaZeros((String)ClearUtil.refina(vo.getNumeroFinal().toString()), (int)9, (boolean)true));
        i.setId("ID" + sb.toString());
        vo.setChaveID(i.getId());
        return t;
    }

    private Object saveInutilizacao(NFeInutilizacao.EncapsuledMessageRec e, InutilizacaoNumeracaoNFe vo) throws ExceptionDatabase {
        vo.setEnviado(Short.valueOf((short)1));
        vo.setMotivo(e.getToReceive().getInfInut().getXMotivo());
        vo.setNumProtocolo(e.getToReceive().getInfInut().getNProt());
        vo.setStatus(e.getToReceive().getInfInut().getCStat());
        vo.setConteudoInutilizacao(e.getXmlReceive().getBytes());
        vo.setConteudoEnviado(e.getXmlSend().getBytes());
        return CoreDAOFactory.getInstance().getDAOInutilizacaoNumeracaoNFe().saveOrUpdate(vo);
    }
}

