/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.nfesefaz.versao400;

import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.nfe.ConstantsNFeResponsavelTecnico;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeFinalidadeEmissao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndIntermediador;
import com.touchcomp.basementor.model.vo.AdicoesImportacao;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.CodigoBarras;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.ConfConexaoNFeUF;
import com.touchcomp.basementor.model.vo.DadosFiscaisUF;
import com.touchcomp.basementor.model.vo.DadosRecAgrNfPropria;
import com.touchcomp.basementor.model.vo.DadosTransNfPropria;
import com.touchcomp.basementor.model.vo.DetImportacaoItem;
import com.touchcomp.basementor.model.vo.DocumentosRefNFPropriaPR;
import com.touchcomp.basementor.model.vo.DocumentosRefProcessosPR;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.FusoHorario;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.GrupoDocumentosRefPR;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.ItemNotaExportacao;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemParamNomeclaturaProdutoXML;
import com.touchcomp.basementor.model.vo.LacreVolumeNFe;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.LoteFaturamentoNFe;
import com.touchcomp.basementor.model.vo.NFeAutDownloadXML;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObsItemNotaPropriaContribuinte;
import com.touchcomp.basementor.model.vo.ObsItemNotaPropriaFisco;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscalNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObservacaoNotaPropria;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoCliente;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.ParamNomeclaturaProdutoXML;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TipoEmissaoNFe;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.VolumeNFe;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.helpers.impl.unidadefatcliente.HelperUnidadeFatCliente;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorxml.model.XMLNfePropria;
import contatocore.util.ContatoDateUtil;
import contatocore.util.ContatoFormatUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.properties.LocalProperties;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.service.impl.nfesefaz.versao400.AuxProcessaDados_V400;
import mentorcore.service.impl.nfesefaz.versao400.UtilSefazNFeLoteFatNFe_V400CbsIbs;
import mentorcore.tools.ClearUtil;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.impl.xmlstore.UtilXMLStore;
import nfe.constants.NFeConstTipoAmbiente;
import nfe.exception.NFeException;
import nfe.exception.NFeValidateException;
import nfe.versao400.model.ObjectFactory;
import nfe.versao400.model.TEnderEmi;
import nfe.versao400.model.TEndereco;
import nfe.versao400.model.TEnviNFe;
import nfe.versao400.model.TInfRespTec;
import nfe.versao400.model.TIpi;
import nfe.versao400.model.TLocal;
import nfe.versao400.model.TNFe;
import nfe.versao400.model.TProtNFe;
import nfe.versao400.model.TUf;
import nfe.versao400.model.TUfEmi;
import nfe.versao400.model.TVeiculo;
import nfe.versao400.services.NFeRecepcao;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

class UtilSefazNFeLoteFatNFe_V400 {
    private static final TLogger logger = TLogger.get(UtilSefazNFeLoteFatNFe_V400.class);
    private NFeConstTipoAmbiente tpAmb;
    private final String versao;
    private final OpcoesFaturamento opcoesFaturamento;
    private final OpcoesRelacionamento opcoesRelacionamento;
    private final OpcoesFaturamentoCliente opcoesFaturamentoCliente;
    private final OpcoesFinanceiras opcoesFinanceiras;
    private final Usuario usuario;
    private final Grupo grupoUsuarios;
    private static final Short CODIGO_BARRAS_EAN = 0;
    private static final Short CODIGO_BARRAS_EAN_TRIB = 1;

    UtilSefazNFeLoteFatNFe_V400(NFeConstTipoAmbiente tmAmb, String versao, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento opcoesRelacionamento, Usuario usuario, Grupo grupoUsuarios, OpcoesFaturamentoCliente opcoesFaturamentoCliente, OpcoesFinanceiras of) {
        this.tpAmb = tmAmb;
        this.versao = versao;
        this.opcoesFaturamento = opcoesFaturamento;
        this.opcoesRelacionamento = opcoesRelacionamento;
        this.opcoesFaturamentoCliente = opcoesFaturamentoCliente;
        this.usuario = usuario;
        this.opcoesFinanceiras = of;
        this.grupoUsuarios = grupoUsuarios;
    }

    public NFeRecepcao.EncapsuledMessageRec envioContigenciaFSDA(List<ConfConexaoNFeUF> confConexaoNFeUf, int uf, LoteFaturamentoNFe l) throws NFeException {
        try {
            l = (LoteFaturamentoNFe)CoreDAOFactory.getInstance().getDAOLoteFaturamentoNFe().findByPrimaryKey(l.getIdentificador());
            Boolean sincrono = false;
            TEnviNFe t = this.getRecepcaoLote(l, this.versao, this.tpAmb.shortValue(), sincrono);
            NFeRecepcao.EncapsuledMessageRec e = new NFeRecepcao().prepareMessage(t, null, uf);
            this.salvaGeraXMLLoteNFeAntesEnvio(l, e);
            e.setAuxiliar((Object)l);
            String st = "Lote processado para impress\u00e3o em formulario de contigencia.";
            l.setMotivo(st);
            for (NotaFiscalPropria nf : l.getNotasFiscais()) {
                nf.setLiberarImpDanfe(Short.valueOf((short)1));
            }
            e.setAuxiliar(CoreDAOFactory.getInstance().getDAOLoteFaturamentoNFe().saveOrUpdate(l));
            e.setMsgProcesada(st);
            return e;
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            new AuxProcessaDados_V400().trataExcecoesNFe(ex);
            return null;
        }
    }

    String writeXMLNFeSemValidade(LoteFaturamentoNFe c, String versao) throws NFeException {
        try {
            c = (LoteFaturamentoNFe)CoreDAOFactory.getInstance().getDAOLoteFaturamentoNFe().findByPrimaryKey(c.getIdentificador());
            Boolean sincrono = c.getNotasFiscais().size() == 1;
            String e = new NFeRecepcao().gerarXMLSemValidade(this.getRecepcaoLote(c, versao, this.tpAmb.shortValue(), sincrono));
            return e;
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            new AuxProcessaDados_V400().trataExcecoesNFe(ex);
            return null;
        }
    }

    String writeXMLNFeSemValidade(NotaFiscalPropria c, String versao) throws NFeException {
        try {
            this.tpAmb = this.tpAmb == null ? NFeConstTipoAmbiente.AMBIENTE_HOMOLOGACAO : this.tpAmb;
            String e = new NFeRecepcao().gerarXMLSemValidade(this.getTNFe(c, this.tpAmb.shortValue()));
            return e;
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            new AuxProcessaDados_V400().trataExcecoesNFe(ex);
            return null;
        }
    }

    private NFeRecepcao.EncapsuledMessageRec envioNormalLoteFat(List<ConfConexaoNFeUF> confConexaoNFeUf, int uf, LoteFaturamentoNFe l) throws ExceptionDatabase, NFeValidateException, MalformedURLException, JAXBException, NFeException, ExceptionService {
        l = (LoteFaturamentoNFe)CoreDAOFactory.getInstance().getDAOLoteFaturamentoNFe().findByPrimaryKey(l.getIdentificador());
        Boolean sincrono = this.getEnvioSincrono(l, confConexaoNFeUf, uf);
        TEnviNFe t = this.getRecepcaoLote(l, this.versao, this.tpAmb.shortValue(), sincrono);
        NFeRecepcao.EncapsuledMessageRec e = new NFeRecepcao().prepareMessage(t, this.getURL(confConexaoNFeUf, this.tpAmb, l.getPeriodoEmissaoNfe().getTipoEmissaoNfe()), uf);
        this.salvaGeraXMLLoteNFeAntesEnvio(l, e);
        new NFeRecepcao().recepcaoLote(e);
        e.setAuxiliar((Object)l);
        e.setSincrono(sincrono);
        String st = "Resultado do Envio do Lote " + l.getIdentificador() + ": ";
        st = st + "\nStatus: " + e.getToReceive().getCStat();
        st = st + "\nUF: " + e.getToReceive().getCUF();
        st = st + "\nTipo Ambiente(1- Producao, 2- Homologacao): " + e.getToReceive().getTpAmb();
        st = st + "\nMotivo: " + e.getToReceive().getXMotivo();
        if (e.getToReceive().getProtNFe() != null) {
            st = st + "\n";
            st = st + "\n\tChave: " + e.getToReceive().getProtNFe().getInfProt().getChNFe();
            st = st + "\n\tStatus: " + e.getToReceive().getProtNFe().getInfProt().getCStat();
            st = st + "\n\tNr. Recibo: " + e.getToReceive().getProtNFe().getInfProt().getNProt();
            st = st + "\n\tMotivo: " + e.getToReceive().getProtNFe().getInfProt().getXMotivo();
        } else if (!ToolMethods.isEquals((Object)e.getToReceive().getCStat(), (Object)"225")) {
            e.setSincrono(Boolean.valueOf(false));
        }
        e.setMsgProcesada(st);
        this.atualizaDadosLote(e);
        this.atualizarNotasEnviadas(l, e.getToReceive().getProtNFe(), this.usuario, this.grupoUsuarios, this.opcoesFaturamento, this.opcoesRelacionamento, this.opcoesFinanceiras);
        return e;
    }

    NFeRecepcao.EncapsuledMessageRec enviaLoteFaturamento(List<ConfConexaoNFeUF> confConexaoNFeUf, int uf, LoteFaturamentoNFe l) throws NFeException {
        try {
            return this.envioNormalLoteFat(confConexaoNFeUf, uf, l);
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            new AuxProcessaDados_V400().trataExcecoesNFe(ex);
            return null;
        }
    }

    public void salvaGeraXMLLoteNFeAntesEnvio(LoteFaturamentoNFe lote, NFeRecepcao.EncapsuledMessageRec tRet) throws NFeException {
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        try {
            Namespace n = Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe");
            doc = builder.build((InputStream)new ByteArrayInputStream(tRet.getXmlSend().getBytes()));
            Element e = doc.detachRootElement();
            List l = e.getChildren("NFe", n);
            ArrayList aux = new ArrayList(l);
            block3: for (Element el : aux) {
                String chave = el.getChild("infNFe", n).getAttributeValue("Id").substring(3);
                for (Object o : lote.getNotasFiscais()) {
                    NotaFiscalPropria nf = (NotaFiscalPropria)o;
                    if (!chave.equalsIgnoreCase(nf.getChaveNFE())) continue;
                    el = el.detach();
                    StringWriter s = new StringWriter();
                    XMLOutputter xout = new XMLOutputter();
                    xout.output(el, (Writer)s);
                    XMLNfePropria x = UtilXMLStore.findCreateXMLNfePropria(nf);
                    x.setIdNotaPropria(nf.getIdentificador());
                    StringBuilder sb = new StringBuilder();
                    sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                    sb.append(s.toString());
                    x.setConteudoXML(sb.toString());
                    UtilXMLStore.saveOrUpdateXMLNotaPropria(x);
                    continue block3;
                }
            }
        }
        catch (JDOMException ex) {
            throw new NFeException("Erro ao processar o xml de retorno.", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new NFeException("Erro ao processar o xml de retorno.", (Throwable)ex);
        }
    }

    private void atualizaDadosLote(NFeRecepcao.EncapsuledMessageRec e) throws ExceptionDatabase {
        LoteFaturamentoNFe l = (LoteFaturamentoNFe)e.getAuxiliar();
        l.setDataEnvio(new Date());
        l.setEnviadoReceita(Short.valueOf((short)1));
        l.setMotivo("Lote enviado.");
        if (e.getToReceive().getInfRec() != null) {
            l.setNumeroReciboLote(e.getToReceive().getInfRec().getNRec());
            for (NotaFiscalPropria n : l.getNotasFiscais()) {
                new AuxProcessaDados_V400().atualizarSituacaoPedido(n, this.opcoesFaturamento.getSituacaoPedidosEnv());
            }
        }
        l.setMotivo(l.getMotivo() + "\n" + e.getToReceive().getXMotivo());
        e.setAuxiliar(CoreDAOFactory.getInstance().getDAOLoteFaturamentoNFe().update(l));
    }

    private String getURL(List<ConfConexaoNFeUF> confConexaoCTeUf, NFeConstTipoAmbiente tmAmb, TipoEmissaoNFe tipoEmissao) throws NFeException {
        String url = null;
        short codEmissaoNFe = tipoEmissao.getCodigo();
        if (codEmissaoNFe == 2 || codEmissaoNFe == 5 || codEmissaoNFe == 4) {
            codEmissaoNFe = 1;
        }
        for (ConfConexaoNFeUF c : confConexaoCTeUf) {
            if (c.getTipoEmissaoNFe().getCodigo() != codEmissaoNFe) continue;
            if (tmAmb.shortValue() == 2) {
                url = c.getUrlNFeRecepcaoHom();
                break;
            }
            url = c.getUrlNFeRecepcaoProd();
            break;
        }
        if (url != null && url.trim().length() > 0) {
            return url;
        }
        throw new NFeException("Nenhuma URL encontrada para envio das informa\u00e7\u00f5es. Consulte suporte t\u00e9cnico.");
    }

    private String refina(String to) {
        return ClearUtil.refina(to);
    }

    private String refinaNull(String to) {
        String str = ClearUtil.refina(to);
        str = str != null && str.trim().length() > 0 ? str : null;
        return str;
    }

    private String refina(Object to) {
        if (to == null) {
            return null;
        }
        return ClearUtil.refina(to.toString());
    }

    private String refinaXML(String to) {
        return ToolString.clearSpecialCharacXML((String)to);
    }

    private String refinaXMLNull(String to) {
        String str = ToolString.clearSpecialCharacXML((String)to);
        str = str != null && str.trim().length() > 0 ? str : null;
        return str;
    }

    String formatarNumeros(Double num, int decimalSize) {
        if (num == null) {
            num = 0.0;
        }
        DecimalFormat form = new DecimalFormat();
        form = (DecimalFormat)DecimalFormat.getInstance(Locale.ENGLISH);
        form.setMaximumIntegerDigits(15);
        form.applyPattern("###0.00");
        form.setMaximumFractionDigits(decimalSize);
        form.setMinimumFractionDigits(decimalSize);
        String aux = form.format(num);
        return aux;
    }

    String formatarNumerosNullCaso0(Double num, int decimalSize) {
        if (num == null) {
            num = 0.0;
        }
        if (num == 0.0) {
            return null;
        }
        return this.formatarNumeros(num, decimalSize);
    }

    String formatarNumeros(Integer num) {
        if (num == null) {
            num = 0;
        }
        return this.refina(num.toString());
    }

    String formatarNumerosNullCaso0(Integer num) {
        if (num == null) {
            num = 0;
        }
        if (num == 0) {
            return null;
        }
        return this.refina(num.toString());
    }

    private String formatarNumeros(Long num) {
        if (num == null) {
            num = 0L;
        }
        return this.refina(num.toString());
    }

    private String formatarNumerosNullCaso0(Long num) {
        if (num == null) {
            num = 0L;
        }
        if (num == 0L) {
            return null;
        }
        return this.refina(num.toString());
    }

    private String formatarNumeros(Short num) {
        if (num == null) {
            num = 0;
        }
        return this.refina(num.toString());
    }

    private String formatarData(Date data) {
        if (data == null) {
            return null;
        }
        return DateUtil.dateToStr(data, "yyyy-MM-dd");
    }

    private String formatarDataNull(Date data) {
        if (data == null) {
            return null;
        }
        return this.formatarData(data);
    }

    private String formatarData(Date data, String mask) {
        if (data == null) {
            return null;
        }
        return DateUtil.dateToStr(data, mask);
    }

    private String formatarHora(Date data) {
        if (data == null) {
            return null;
        }
        return DateUtil.dateToStr(data, "hh:mm:ss");
    }

    private String formatarData(Date dataNota, Date horaNota, Short tipoFusoHorario, FusoHorario fusoHorario) {
        if (dataNota == null) {
            return null;
        }
        String data = DateUtil.dateToStr(dataNota, "yyyy-MM-dd");
        String hora = DateUtil.dateToStr(horaNota, "HH:mm:ss");
        String formatado = data + "T" + hora;
        if (tipoFusoHorario.equals(Short.valueOf("0"))) {
            formatado = TimeZone.getDefault().getID().equalsIgnoreCase("America/Manaus") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Rio_Branco") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Eirunepe") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Boa_Vista") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Porto_Velho") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Santarem") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Cuiaba") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Campo_Grande") ? (ContatoDateUtil.isHorarioVerao() ? formatado + "-03:00" : formatado + "-04:00") : (TimeZone.getDefault().getID().equalsIgnoreCase("America/Noronha") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Belem") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Fortaleza") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Recife") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Araguaina") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Maceio") ? (ContatoDateUtil.isHorarioVerao() ? formatado + "-01:00" : formatado + "-02:00") : (ContatoDateUtil.isHorarioVerao() ? formatado + "-02:00" : formatado + "-03:00"));
        } else {
            String codigo = fusoHorario.getCodigo();
            formatado = formatado + codigo;
        }
        return formatado;
    }

    public TEnviNFe getRecepcaoLote(LoteFaturamentoNFe l, String versao, short tpAmb, Boolean sincrono) throws NFeValidateException {
        TEnviNFe t = new TEnviNFe();
        t.setIdLote(this.refina(l.getIdentificador().toString()));
        if (sincrono.booleanValue()) {
            t.setIndSinc("1");
        } else {
            t.setIndSinc("0");
        }
        t.setVersao(versao);
        for (NotaFiscalPropria nf : l.getNotasFiscais()) {
            t.getNFe().add(this.getTNFe(nf, tpAmb));
        }
        return t;
    }

    private TNFe getTNFe(NotaFiscalPropria nf, short tpAmb) throws NFeValidateException {
        TNFe t = new TNFe();
        TNFe.InfNFe i = new TNFe.InfNFe();
        t.setInfNFe(i);
        i.setVersao(this.versao);
        i.setId("NFe" + nf.getChaveNFE());
        EnumConstNFeFinalidadeEmissao finalidadeEmissao = EnumConstNFeFinalidadeEmissao.get((Object)nf.getFinalidadeEmNFe().getCodigo());
        i.setIde(this.getIde(nf, tpAmb, finalidadeEmissao));
        i.setEmit(this.getEmitente(nf));
        i.setAvulsa(null);
        i.setDest(this.getDestinatario(nf));
        i.setRetirada(this.getLocalRetirada(nf));
        i.setEntrega(this.getLocalEntrega(nf));
        i.getAutXML().addAll(this.getAutXML(nf));
        i.getDet().addAll(this.getDet(nf, finalidadeEmissao));
        i.setTotal(this.getTotal(nf));
        i.setTransp(this.getTransp(nf));
        i.setCobr(this.getCobranca(nf));
        i.setInfIntermed(this.getInfIntermed(nf));
        i.setPag(this.getPag(nf));
        i.setInfAdic(this.getInfAdic(nf));
        i.setExporta(this.getExporta(nf));
        i.setCompra(this.getCompraOrgaoPublico(nf));
        i.setCana(null);
        if (this.opcoesFaturamento.getInformarDadosRespTecnico().equals((short)1)) {
            i.setInfRespTec(this.getInfRespTec(nf));
        }
        if (this.opcoesFaturamento.getInformarDadosReceituario().equals((short)1)) {
            i.setAgropecuario(this.getAgropecuario(nf));
        }
        return t;
    }

    private TNFe.InfNFe.Emit getEmitente(NotaFiscalPropria nf) throws NFeValidateException {
        TNFe.InfNFe.Emit e = new TNFe.InfNFe.Emit();
        Empresa emp = nf.getEmpresa();
        Endereco end = emp.getPessoa().getEndereco();
        String cpfCnpj = this.refina(emp.getPessoa().getComplemento().getCnpj());
        if (cpfCnpj.length() > 11) {
            e.setCNPJ(cpfCnpj);
        } else {
            e.setCPF(cpfCnpj);
        }
        e.setXNome(this.refinaXML(emp.getPessoa().getNome()));
        String aux = this.refinaXML(emp.getPessoa().getNomeFantasia());
        e.setXFant(aux != null && aux.trim().length() > 0 ? aux : null);
        TEnderEmi te = new TEnderEmi();
        e.setEnderEmit(te);
        te.setXLgr(this.refinaXML(end.getLogradouro()));
        te.setNro(this.refinaXML(end.getNumero()));
        te.setXCpl(this.refinaXMLNull(end.getComplemento()));
        te.setXBairro(this.refinaXML(end.getBairro()));
        te.setCMun(end.getCidade().getUf().getCodIbge() + end.getCidade().getCodIbge());
        te.setXMun(this.refinaXML(end.getCidade().getDescricao()));
        te.setUF(TUfEmi.valueOf((String)end.getCidade().getUf().getSigla()));
        te.setCEP(this.refina(end.getCep()));
        te.setCPais(this.refinaNull(end.getCidade().getUf().getPais().getCodIbge()));
        te.setXPais(this.refinaXMLNull(end.getCidade().getUf().getPais().getDescricao()));
        te.setFone(this.refinaNull(this.getFone(emp.getPessoa().getComplemento())));
        e.setIE(this.refina(emp.getPessoa().getComplemento().getInscEst()));
        DadosFiscaisUF d = this.findDadosFiscaisUF(emp, nf.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf());
        if (d != null && d.getInscritoEstado() != null && d.getInscritoEstado() == 1) {
            e.setIEST(this.refinaNull(d.getInscricaoEstadual()));
        }
        e.setCRT(emp.getEmpresaDados().getRegimeTributario().getCodigo().toString());
        e.setIM(this.refinaNull(emp.getPessoa().getComplemento().getInscricaoMunicipal()));
        if (emp.getEmpresaDados().getCnae() != null) {
            e.setCNAE(this.refinaNull(emp.getEmpresaDados().getCnae().getCodigo()));
        }
        if (e.getIM() != null && e.getIM().trim().length() > 0 && (e.getCNAE() == null || e.getCNAE().trim().length() == 0)) {
            e.setIM(null);
            e.setCNAE(null);
        }
        if (e.getCNAE() != null && e.getCNAE().trim().length() > 0 && (e.getIM() == null || e.getIM().trim().length() == 0)) {
            e.setIM(null);
            e.setCNAE(null);
        }
        return e;
    }

    private TNFe.InfNFe.Dest getDestinatario(NotaFiscalPropria nf) throws NFeValidateException {
        TNFe.InfNFe.Dest e = new TNFe.InfNFe.Dest();
        HelperUnidadeFatCliente helper = ((HelperUnidadeFatCliente)Context.get(HelperUnidadeFatCliente.class)).build(nf.getUnidadeFatCliente());
        Endereco end = helper.get().getPessoa().getEndereco();
        String cpfCnpj = this.refina(helper.get().getCliente().getPessoa().getComplemento().getCnpj());
        if (!end.getCidade().getUf().getSigla().equals("EX")) {
            if (cpfCnpj.length() > 11) {
                e.setCNPJ(cpfCnpj);
            } else if (cpfCnpj.length() == 11) {
                e.setCPF(cpfCnpj);
            }
        }
        if (end.getCidade().getUf().getSigla().equals("EX") || cpfCnpj == null || cpfCnpj.trim().isEmpty()) {
            if (helper.get().getCliente().getPessoa().getComplemento().getPassaporte() != null && helper.get().getCliente().getPessoa().getComplemento().getPassaporte().trim().length() > 0) {
                e.setIdEstrangeiro(this.refina(helper.get().getCliente().getPessoa().getComplemento().getPassaporte()));
            } else {
                e.setIdEstrangeiro("");
            }
        }
        e.setXNome(this.refinaXML(helper.get().getPessoa().getNome()));
        e.setEnderDest(this.getTEndereco(end, this.getFone(helper.get().getCliente().getPessoa().getComplemento())));
        Date data = DateUtil.strToDate("01/01/2016");
        if (nf.getDataEmissaoNota().before(data)) {
            if (helper.get().getPessoa().getComplemento().getInscEst() == null || helper.get().getPessoa().getComplemento().getInscEst().trim().length() == 0 || end.getCidade().getUf().getSigla().equals("EX")) {
                e.setIndIEDest("9");
            } else if (helper.get().getPessoa().getComplemento().getInscEst().equalsIgnoreCase("ISENTO")) {
                e.setIndIEDest("2");
            } else {
                e.setIndIEDest("1");
            }
        } else if (nf.getContribuinteEstado().equals(EnumConstContrEstadoIcms.CONTRIBUINTE.getEnumId())) {
            e.setIndIEDest("1");
        } else if (nf.getContribuinteEstado().equals(EnumConstContrEstadoIcms.ISENTO.getEnumId())) {
            e.setIndIEDest("2");
        } else {
            e.setIndIEDest("9");
        }
        if ((e.getIndIEDest().equals("1") || e.getIndIEDest().equals("9")) && helper.get().getPessoa().getComplemento().getInscEst() != null && helper.get().getPessoa().getComplemento().getInscEst().trim().length() > 0) {
            e.setIE(this.refina(helper.get().getPessoa().getComplemento().getInscEst()));
        }
        e.setISUF(this.refinaNull(helper.get().getCliente().getPessoa().getComplemento().getSuframa()));
        if (helper.get().getCliente().getPessoa().getComplemento().getInscricaoMunicipal() != null && helper.get().getCliente().getPessoa().getComplemento().getInscricaoMunicipal().trim().length() > 0) {
            e.setIM(this.refina(helper.get().getCliente().getPessoa().getComplemento().getInscricaoMunicipal()));
        }
        e.setEmail(this.refinaXMLNull(this.getEmail(helper.get().getCliente().getPessoa().getComplemento())));
        return e;
    }

    private TNFe.InfNFe.Ide getIde(NotaFiscalPropria nf, short tpAmb, EnumConstNFeFinalidadeEmissao finalidadeEmissao) throws NFeValidateException {
        TNFe.InfNFe.Ide i = new TNFe.InfNFe.Ide();
        i.setCUF(nf.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge());
        i.setCNF(ToolString.completaZeros((String)this.formatarNumeros(nf.getCodChaveAcesso()), (int)8, (boolean)true));
        i.setNatOp(this.refinaXML(nf.getNaturezaOperacao().getDescricao()));
        short tp = (short)(nf.getCondicaoPagamento().getNumeroParcelas() != 1 || nf.getCondicaoPagamento().getEntrada() != 1 ? 1 : 0);
        i.setMod(nf.getModeloDocFiscal().getCodigo());
        i.setSerie(nf.getSerie());
        i.setNNF(this.formatarNumeros(nf.getNumeroNota()));
        i.setDhEmi(this.formatarData(nf.getDataEmissaoNota(), nf.getHoraEmissao(), nf.getEmpresa().getEmpresaDados().getTipoFusoHorario(), nf.getEmpresa().getEmpresaDados().getFusoHorario()));
        i.setDhSaiEnt(this.formatarData(nf.getDataEntradaSaida(), nf.getHoraEntradaSaida(), nf.getEmpresa().getEmpresaDados().getTipoFusoHorario(), nf.getEmpresa().getEmpresaDados().getFusoHorario()));
        short tipoOp = nf.getNaturezaOperacao().getEntradaSaida() == 2 ? (short)0 : 1;
        i.setTpNF(this.formatarNumeros(tipoOp));
        i.setIdDest(this.getLocalDestinoOperacao(nf));
        i.setCMunFG(nf.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge() + nf.getEmpresa().getPessoa().getEndereco().getCidade().getCodIbge());
        i.setTpImp(this.formatarNumeros(nf.getFormatoImpressao()));
        i.setTpEmis(this.formatarNumeros(nf.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo()));
        i.setCDV(this.formatarNumeros(nf.getDigitoVerificador()));
        i.setTpAmb(this.formatarNumeros(tpAmb));
        i.setFinNFe(nf.getFinalidadeEmNFe().getCodigo());
        if (finalidadeEmissao.isDebito() && nf.getFinalidadeEmNFeTipo() != null) {
            i.setTpNFDebito(nf.getFinalidadeEmNFeTipo().getCodigo());
        } else if (finalidadeEmissao.isCredito() && nf.getFinalidadeEmNFeTipo() != null) {
            i.setTpNFCredito(nf.getFinalidadeEmNFeTipo().getCodigo());
        }
        i.setIndFinal(this.formatarNumeros(nf.getIndicadorConsumidorFinal()));
        i.setIndPres(this.formatarNumeros(nf.getIndicadorPresencaConsumidor()));
        if (EnumConstNFeIndIntermediador.valueOfCodigo((Short)nf.getTipoIntermediadorComercial()) != null && !ToolMethods.isEquals((Object)EnumConstNFeIndIntermediador.valueOfCodigo((Short)nf.getTipoIntermediadorComercial()), (Object)EnumConstNFeIndIntermediador.NAO_SE_APLICA)) {
            i.setIndIntermed(this.formatarNumeros(nf.getTipoIntermediadorComercial()));
        }
        i.setProcEmi("0");
        i.setVerProc(LocalProperties.getInstance().getCodigoVersaoFormatado());
        if (nf.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo() != 1) {
            i.setDhCont(this.formatarData(nf.getPeriodoEmissaoNFe().getDataInicial(), nf.getPeriodoEmissaoNFe().getDataInicial(), nf.getEmpresa().getEmpresaDados().getTipoFusoHorario(), nf.getEmpresa().getEmpresaDados().getFusoHorario()));
            i.setXJust(this.refinaXML(nf.getPeriodoEmissaoNFe().getDescricao()));
        }
        i.getNFref().addAll(this.getNFRef(nf));
        return i;
    }

    private Collection<? extends TNFe.InfNFe.Ide.NFref> getNFRef(NotaFiscalPropria nf) throws NFeValidateException {
        ArrayList l = new ArrayList();
        this.getNFRefDocumentos(nf, l);
        this.getNFRefCTes(nf, l);
        return l;
    }

    private TEndereco getTEndereco(Endereco end, String fone) {
        TEndereco te = new TEndereco();
        te.setXLgr(this.refinaXML(end.getLogradouro()));
        te.setNro(this.refinaXML(end.getNumero()));
        te.setXCpl(this.refinaXMLNull(end.getComplemento()));
        te.setXBairro(this.refinaXML(end.getBairro()));
        if (end.getCidade().getUf().getSigla().equalsIgnoreCase("EX")) {
            te.setCMun("9999999");
            te.setUF(TUf.valueOf((String)"EX"));
            te.setXMun("EXTERIOR");
        } else {
            te.setCMun(end.getCidade().getUf().getCodIbge() + end.getCidade().getCodIbge());
            te.setUF(TUf.valueOf((String)end.getCidade().getUf().getSigla()));
            te.setXMun(this.refinaXML(end.getCidade().getDescricao()));
            te.setCEP(this.refinaNull(end.getCep()));
        }
        te.setCPais(this.refinaXMLNull(end.getCidade().getUf().getPais().getCodIbge()));
        te.setXPais(this.refinaXMLNull(end.getCidade().getUf().getPais().getDescricao()));
        te.setFone(this.refinaNull(fone));
        return te;
    }

    private String getFone(Complemento complemento) {
        String fone = null;
        if (complemento.getFone1() != null && complemento.getFone1().trim().length() > 0) {
            fone = complemento.getFone1();
        }
        if (complemento.getFone2() != null && complemento.getFone2().trim().length() > 0) {
            fone = complemento.getFone2();
        }
        if (complemento.getCel1() != null && complemento.getCel1().trim().length() > 0) {
            fone = complemento.getFone1();
        }
        if (complemento.getCel2() != null && complemento.getCel2().trim().length() > 0) {
            fone = complemento.getCel2();
        }
        return fone;
    }

    private String getEmail(Complemento complemento) {
        String email = null;
        for (EmailPessoa e : complemento.getEmails()) {
            if (e.getEmail() == null || e.getEmail().trim().length() <= 0) continue;
            email = e.getEmail();
            break;
        }
        return email;
    }

    private TNFe.InfNFe.Cobr getCobranca(NotaFiscalPropria nf) {
        if (!this.existeTitulosNF(nf)) {
            return null;
        }
        TNFe.InfNFe.Cobr c = new TNFe.InfNFe.Cobr();
        Double valor = 0.0;
        Integer cont = 1;
        List<Titulo> titulosOrdenados = new ArrayList<Titulo>();
        for (InfPagamentoNfPropria i : nf.getInfPagamentoNfPropria()) {
            if (!i.getTipoPagamentoNFe().getExibirTitulos().equals((short)1)) continue;
            titulosOrdenados.addAll(i.getTitulos());
        }
        titulosOrdenados = this.getOrdenarTitulosPorDataVencimento(titulosOrdenados);
        for (Titulo t : titulosOrdenados) {
            TNFe.InfNFe.Cobr.Dup f = new TNFe.InfNFe.Cobr.Dup();
            f.setDVenc(this.formatarData(t.getDataVencimento()));
            f.setVDup(this.formatarNumeros(t.getValor(), 2));
            f.setNDup(ToolString.completaZeros((String)cont.toString(), (int)3, (boolean)true));
            c.getDup().add(f);
            valor = valor + t.getValor();
            Integer n = cont;
            cont = cont + 1;
        }
        if (valor > 0.0) {
            TNFe.InfNFe.Cobr.Fat f = new TNFe.InfNFe.Cobr.Fat();
            f.setNFat(this.refina(nf.getNumeroNota()));
            f.setVLiq(this.formatarNumeros(valor, 2));
            f.setVOrig(this.formatarNumeros(valor, 2));
            f.setVDesc(this.formatarNumeros(0.0, 2));
            c.setFat(f);
        }
        return c;
    }

    private TNFe.InfNFe.InfAdic getInfAdic(NotaFiscalPropria nf) {
        String conteudo;
        TNFe.InfNFe.InfAdic.ObsCont ob;
        TNFe.InfNFe.InfAdic inf = new TNFe.InfNFe.InfAdic();
        Object obsCont = "";
        Object obsFisco = "";
        if (nf.getGrupoDocumentosRefPR() != null) {
            for (DocumentosRefProcessosPR p : nf.getGrupoDocumentosRefPR().getProcessosReferenciados()) {
                TNFe.InfNFe.InfAdic.ProcRef proc = new TNFe.InfNFe.InfAdic.ProcRef();
                proc.setNProc(p.getProcessoFiscal().getNrProcesso());
                proc.setIndProc(p.getProcessoFiscal().getTipoProcesso().getCodigo().toString());
                inf.getProcRef().add(proc);
            }
        }
        for (ObservacaoNotaPropria obs : nf.getObservacaoNota()) {
            if (ToolMethods.isStrWithData((String)obs.getObsFaturamento().getChave())) {
                ob = new TNFe.InfNFe.InfAdic.ObsCont();
                ob.setXCampo(obs.getObsFaturamento().getChave());
                conteudo = this.refinaXML(obs.getConteudo());
                if (conteudo.trim().length() > 60) {
                    conteudo = conteudo.substring(0, 60);
                }
                ob.setXTexto(conteudo);
                inf.getObsCont().add(ob);
                continue;
            }
            obsCont = (String)obsCont + this.refinaXML(obs.getConteudo());
        }
        for (ObservacaoIntFiscalNotaFiscalPropria fisco : nf.getObservacaoIntFiscalNotaFiscalPropria()) {
            if (ToolMethods.isStrWithData((String)fisco.getObsFaturamento().getChave())) {
                ob = new TNFe.InfNFe.InfAdic.ObsFisco();
                ob.setXCampo(fisco.getObsFaturamento().getChave());
                conteudo = this.refinaXML(fisco.getConteudo());
                if (conteudo.trim().length() > 60) {
                    conteudo = conteudo.substring(0, 60);
                }
                ob.setXTexto(conteudo);
                inf.getObsFisco().add(ob);
                continue;
            }
            obsFisco = (String)obsFisco + this.refinaXML(fisco.getConteudo());
        }
        if ((obsFisco = (String)obsFisco + this.getValoresFCP(nf)) != null && ((String)obsFisco).trim().length() > 0) {
            inf.setInfAdFisco((String)obsFisco);
        }
        if (obsCont != null && ((String)obsCont).trim().length() > 0) {
            inf.setInfCpl((String)obsCont);
        }
        if (inf.getInfAdFisco() != null && inf.getInfAdFisco().trim().length() > 0) {
            return inf;
        }
        if (inf.getInfCpl() != null && inf.getInfCpl().trim().length() > 0) {
            return inf;
        }
        if (ToolMethods.isWithData((Collection)inf.getObsCont())) {
            return inf;
        }
        if (ToolMethods.isWithData((Collection)inf.getObsFisco())) {
            return inf;
        }
        return null;
    }

    private TNFe.InfNFe.Transp getTransp(NotaFiscalPropria nf) {
        String idDest;
        TNFe.InfNFe.Transp t = new TNFe.InfNFe.Transp();
        DadosTransNfPropria d = nf.getDadosTransNfPropria();
        Short tpFrete = d.getTipoFrete().getFretePorConta();
        Short tpFreteNf = tpFrete != null && tpFrete == 0 ? Short.valueOf((short)0) : (tpFrete != null && tpFrete == 1 ? Short.valueOf((short)1) : (tpFrete != null && tpFrete == 2 ? Short.valueOf((short)2) : (tpFrete != null && tpFrete == 3 ? Short.valueOf((short)3) : (tpFrete != null && tpFrete == 4 ? Short.valueOf((short)4) : Short.valueOf((short)9)))));
        t.setModFrete(this.refina(tpFreteNf));
        if (tpFrete != 9) {
            t.setTransporta(this.getTransportador(d.getTransportador()));
        }
        if (!(idDest = this.getLocalDestinoOperacao(nf)).equals("2")) {
            t.setVeicTransp(this.getVeiculo(d));
            t.getReboque().addAll(this.getReboques(d));
        }
        t.getVol().addAll(this.getVolumes(nf));
        return t;
    }

    private TNFe.InfNFe.Transp.Transporta getTransportador(Transportador transportador) {
        if (transportador == null) {
            return null;
        }
        TNFe.InfNFe.Transp.Transporta tr = new TNFe.InfNFe.Transp.Transporta();
        String cpfCnpj = this.refinaNull(transportador.getPessoa().getComplemento().getCnpj());
        if (cpfCnpj != null && cpfCnpj.trim().length() > 0) {
            if (cpfCnpj.length() > 11) {
                tr.setCNPJ(cpfCnpj);
            } else {
                tr.setCPF(cpfCnpj);
            }
        }
        tr.setXNome(this.refinaXMLNull(transportador.getPessoa().getNome()));
        tr.setIE(this.refinaNull(transportador.getPessoa().getComplemento().getInscEst()));
        StringBuilder sb = new StringBuilder();
        sb.append(transportador.getPessoa().getEndereco().getLogradouro());
        if (transportador.getPessoa().getEndereco().getNumero() != null) {
            sb.append(",").append(transportador.getPessoa().getEndereco().getNumero());
        }
        if (transportador.getPessoa().getEndereco().getBairro() != null) {
            sb.append(",").append(transportador.getPessoa().getEndereco().getBairro());
        }
        if (sb.length() > 60) {
            sb = new StringBuilder(sb.substring(0, 60));
        }
        tr.setXEnder(this.refinaXMLNull(sb.toString()));
        tr.setXMun(this.refinaXML(transportador.getPessoa().getEndereco().getCidade().getDescricao()));
        tr.setUF(TUf.valueOf((String)transportador.getPessoa().getEndereco().getCidade().getUf().getSigla()));
        return tr;
    }

    private TVeiculo getVeiculo(DadosTransNfPropria d) {
        String insc = this.refinaXMLNull(d.getInscricaoAntt());
        String placa = this.refinaXMLNull(d.getPlacaVeiculo());
        String uf = this.refinaXMLNull(d.getUfPlacaVeiculo());
        if (insc != null || placa != null) {
            TVeiculo v = new TVeiculo();
            v.setPlaca(placa);
            v.setRNTC(insc);
            v.setUF(TUf.valueOf((String)uf));
            return v;
        }
        return null;
    }

    private Collection<? extends TVeiculo> getReboques(DadosTransNfPropria d) {
        ArrayList<TVeiculo> reb = new ArrayList<TVeiculo>();
        String insc = this.refinaXMLNull(d.getInscricaoAnttReboque1());
        String placa = this.refinaXMLNull(d.getPlacaReboque1());
        String uf = this.refinaXMLNull(d.getUfPlacaReboque1());
        if (insc != null || placa != null) {
            TVeiculo v = new TVeiculo();
            v.setPlaca(placa);
            v.setRNTC(this.refinaXML(insc));
            v.setUF(TUf.valueOf((String)uf));
            reb.add(v);
        }
        String insc2 = this.refinaXMLNull(d.getInscricaoAnttReboque2());
        String placa2 = this.refinaXMLNull(d.getPlacaReboque2());
        String uf2 = this.refinaXMLNull(d.getUfPlacaReboque2());
        if (insc2 != null || placa2 != null) {
            TVeiculo v = new TVeiculo();
            v.setPlaca(placa2);
            v.setRNTC(insc2);
            v.setUF(TUf.valueOf((String)uf2));
            reb.add(v);
        }
        return reb;
    }

    private Collection<? extends TNFe.InfNFe.Transp.Vol> getVolumes(NotaFiscalPropria nf) {
        ArrayList<TNFe.InfNFe.Transp.Vol> vol = new ArrayList<TNFe.InfNFe.Transp.Vol>();
        List volumes = nf.getVolumes();
        if (volumes != null && volumes.size() > 0) {
            for (VolumeNFe vf : volumes) {
                TNFe.InfNFe.Transp.Vol v = new TNFe.InfNFe.Transp.Vol();
                v.setQVol(this.formatarNumerosNullCaso0(vf.getQuantidade()));
                if (vf.getEmbalagem() != null) {
                    v.setEsp(this.refinaXML(vf.getEmbalagem().getNome()));
                }
                if (this.opcoesFaturamento.getNaoImpMarcaDanfe() != 1) {
                    if (vf.getMarca() != null && vf.getMarca().trim().length() > 0) {
                        v.setMarca(this.refinaXMLNull(vf.getMarca()));
                    } else {
                        v.setMarca(this.refina(nf.getNumeroNota()));
                    }
                }
                v.setNVol(this.formatarNumerosNullCaso0(vf.getNumeroVolume()));
                v.setPesoL(this.formatarNumerosNullCaso0(vf.getPesoLiquido(), 3));
                v.setPesoB(this.formatarNumerosNullCaso0(vf.getPesoBruto(), 3));
                v.getLacres().addAll(this.getLacresVolumesNFe(vf.getLacres()));
                if (v.getEsp() == null && v.getQVol() == null && v.getMarca() == null && v.getNVol() == null && v.getPesoB() == null && v.getPesoL() == null && (v.getLacres() == null || v.getLacres().isEmpty())) continue;
                vol.add(v);
            }
        }
        return vol;
    }

    private TNFe.InfNFe.Total getTotal(NotaFiscalPropria nfPropria) {
        double valorProduto = 0.0;
        double valorServico = 0.0;
        double valorTotalServico = 0.0;
        double valorFrete = 0.0;
        double valorSeguro = 0.0;
        double valorDesconto = 0.0;
        double valorDespAcessoria = 0.0;
        double bcICMS = 0.0;
        double valorIss = 0.0;
        double valorIcms = 0.0;
        double valorIcmsST = 0.0;
        double valorIcmsDesonerado = 0.0;
        double bcICMST = 0.0;
        double valorIPI = 0.0;
        double valorTotal = 0.0;
        double valorPis = 0.0;
        double valorCofins = 0.0;
        double valorPisST = 0.0;
        double valorCofinsST = 0.0;
        double valorContSocial = 0.0;
        double valorIRRF = 0.0;
        double valorInss = 0.0;
        double bcInss = 0.0;
        double bcIrrf = 0.0;
        double valorPisServ = 0.0;
        double valorCofinsServ = 0.0;
        double valorImpostoImportacao = 0.0;
        double valorImpEst = 0.0;
        double valorIcmsFundoPobreza = 0.0;
        double valorIcmsUFRem = 0.0;
        double valorIcmsUFDest = 0.0;
        double valorFCP = 0.0;
        double valorFCPSt = 0.0;
        double valorFCPStRetido = 0.0;
        double valorIpiDevolucao = 0.0;
        for (Object o : nfPropria.getItensNotaPropria()) {
            ItemNotaFiscalPropria vo = (ItemNotaFiscalPropria)o;
            String codigo = vo.getIncidenciaIcms().getCodigo().substring(1);
            if (vo.getVrServico() > 0.0 && vo.getItemNotaLivroFiscal().getVrIss() > 0.0) {
                valorServico += vo.getVrServico().doubleValue();
                valorTotalServico += vo.getItemNotaLivroFiscal().getValorTotal().doubleValue();
                if (vo.getItemNotaLivroFiscal().getVrIss() > 0.0) {
                    valorIss += vo.getItemNotaLivroFiscal().getVrIss().doubleValue();
                    valorPisServ += vo.getItemNotaLivroFiscal().getVrPis().doubleValue();
                    valorCofinsServ += vo.getItemNotaLivroFiscal().getVrCofins().doubleValue();
                } else {
                    valorPis += vo.getItemNotaLivroFiscal().getVrPis().doubleValue();
                    valorCofins += vo.getItemNotaLivroFiscal().getVrCofins().doubleValue();
                }
            } else {
                valorProduto += vo.getVrProduto().doubleValue();
                valorServico += vo.getVrServico().doubleValue();
                if (vo.getItemNotaLivroFiscal().getVrIcms() > 0.0 && vo.getItemNotaLivroFiscal().getVrIcmsTributado() <= 0.0) {
                    bcICMS += vo.getItemNotaLivroFiscal().getVrBcCalculoIcms().doubleValue();
                }
                bcICMS += vo.getItemNotaLivroFiscal().getVrIcmsTributado().doubleValue();
                if (ToolMethods.isEquals((Object)codigo, (Object)"51") && vo.getItemNotaLivroFiscal().getValorIcmsDiferimento() > 0.0) {
                    bcICMS += vo.getItemNotaLivroFiscal().getVrIcmsOutros().doubleValue();
                }
                bcICMST += vo.getItemNotaLivroFiscal().getVrBcCalculoIcmsSt().doubleValue();
                valorIPI += vo.getItemNotaLivroFiscal().getVrIpiIndustria().doubleValue();
                valorTotal += vo.getItemNotaLivroFiscal().getValorTotal().doubleValue();
                valorIcms += vo.getItemNotaLivroFiscal().getVrIcms().doubleValue();
                valorIcmsST += vo.getItemNotaLivroFiscal().getVrIcmsSt().doubleValue();
                valorIcmsDesonerado += vo.getItemNotaLivroFiscal().getVrIcmsDesonerado().doubleValue();
                valorPis += vo.getItemNotaLivroFiscal().getVrPis().doubleValue();
                valorCofins += vo.getItemNotaLivroFiscal().getVrCofins().doubleValue();
                valorImpostoImportacao += vo.getItemNotaLivroFiscal().getVrImpostoImportacao().doubleValue();
                if (vo.getIssRetido() != null && vo.getIssRetido() != 2) {
                    valorIss += vo.getItemNotaLivroFiscal().getVrIss().doubleValue();
                }
            }
            valorFrete += vo.getValorFrete().doubleValue();
            valorSeguro += vo.getVrSeguro().doubleValue();
            valorDesconto += vo.getValorDesconto().doubleValue();
            valorDespAcessoria += vo.getValorDespAcessoria().doubleValue();
            valorPisST += vo.getItemNotaLivroFiscal().getVrPisSt().doubleValue();
            valorCofinsST += vo.getItemNotaLivroFiscal().getVrCofinsSt().doubleValue();
            valorContSocial += vo.getItemNotaLivroFiscal().getVrContSoc().doubleValue();
            valorIRRF += vo.getItemNotaLivroFiscal().getVrIrrf().doubleValue();
            if (vo.getItemNotaLivroFiscal().getVrIrrf() > 0.0) {
                bcIrrf += vo.getItemNotaLivroFiscal().getValorTotal().doubleValue();
            }
            valorInss += vo.getItemNotaLivroFiscal().getVrInss().doubleValue();
            if (vo.getItemNotaLivroFiscal().getVrInss() > 0.0) {
                bcInss += vo.getItemNotaLivroFiscal().getValorTotal().doubleValue();
            }
            if (vo.getItemNotaLivroFiscal().getValorIcmsPartilhaRem() != null && vo.getItemNotaLivroFiscal().getValorIcmsPartilhaRem() >= 0.0) {
                valorIcmsUFRem += vo.getItemNotaLivroFiscal().getValorIcmsPartilhaRem().doubleValue();
            }
            if (vo.getItemNotaLivroFiscal().getValorIcmsPartilhaDest() != null && vo.getItemNotaLivroFiscal().getValorIcmsPartilhaDest() >= 0.0) {
                valorIcmsUFDest += vo.getItemNotaLivroFiscal().getValorIcmsPartilhaDest().doubleValue();
            }
            if (vo.getItemNotaLivroFiscal().getValorFundoPobreza() != null) {
                valorIcmsFundoPobreza += vo.getItemNotaLivroFiscal().getValorFundoPobreza().doubleValue();
            }
            if (vo.getItemNotaLivroFiscal().getValorFCP() != null) {
                valorFCP += vo.getItemNotaLivroFiscal().getValorFCP().doubleValue();
            }
            if (vo.getItemNotaLivroFiscal().getValorFCPSt() != null) {
                valorFCPSt += vo.getItemNotaLivroFiscal().getValorFCPSt().doubleValue();
            }
            if (vo.getItemNotaLivroFiscal().getValorFCPStRetido() != null) {
                valorFCPStRetido += vo.getItemNotaLivroFiscal().getValorFCPStRetido().doubleValue();
            }
            if (vo.getItemNotaLivroFiscal().getValorIpiDevolucao() != null) {
                valorIpiDevolucao += vo.getItemNotaLivroFiscal().getValorIpiDevolucao().doubleValue();
            }
            valorImpEst += vo.getItemNotaLivroFiscal().getVlrImpostosEstimado().doubleValue();
        }
        TNFe.InfNFe.Total t = new TNFe.InfNFe.Total();
        TNFe.InfNFe.Total.ICMSTot icms = new TNFe.InfNFe.Total.ICMSTot();
        icms.setVBC(this.formatarNumeros(bcICMS, 2));
        icms.setVICMS(this.formatarNumeros(valorIcms, 2));
        icms.setVICMSDeson(this.formatarNumeros(valorIcmsDesonerado, 2));
        icms.setVBCST(this.formatarNumeros(bcICMST, 2));
        icms.setVST(this.formatarNumeros(valorIcmsST, 2));
        icms.setVProd(this.formatarNumeros(valorProduto + valorServico, 2));
        icms.setVFrete(this.formatarNumeros(valorFrete, 2));
        icms.setVSeg(this.formatarNumeros(valorSeguro, 2));
        icms.setVDesc(this.formatarNumeros(valorDesconto, 2));
        icms.setVII(this.formatarNumeros(valorImpostoImportacao, 2));
        icms.setVIPI(this.formatarNumeros(valorIPI, 2));
        icms.setVPIS(this.formatarNumeros(valorPis, 2));
        icms.setVCOFINS(this.formatarNumeros(valorCofins, 2));
        icms.setVOutro(this.formatarNumeros(valorDespAcessoria, 2));
        icms.setVNF(this.formatarNumeros(valorTotal + valorTotalServico, 2));
        icms.setVTotTrib(this.formatarNumeros(valorImpEst, 2));
        icms.setVFCPUFDest(this.formatarNumeros(valorIcmsFundoPobreza, 2));
        icms.setVICMSUFDest(this.formatarNumeros(valorIcmsUFDest, 2));
        icms.setVICMSUFRemet(this.formatarNumeros(valorIcmsUFRem, 2));
        icms.setVFCP(this.formatarNumeros(valorFCP, 2));
        icms.setVFCPST(this.formatarNumeros(valorFCPSt, 2));
        icms.setVFCPSTRet(this.formatarNumeros(valorFCPStRetido, 2));
        icms.setVIPIDevol(this.formatarNumeros(0.0, 2));
        if (valorIpiDevolucao > 0.0) {
            icms.setVIPIDevol(this.formatarNumerosNullCaso0(valorIpiDevolucao, 2));
        }
        t.setICMSTot(icms);
        if (valorTotalServico > 0.0 && valorIss > 0.0) {
            TNFe.InfNFe.Total.ISSQNtot iss = new TNFe.InfNFe.Total.ISSQNtot();
            iss.setVServ(this.formatarNumerosNullCaso0(valorServico, 2));
            iss.setVBC(this.formatarNumerosNullCaso0(valorTotalServico, 2));
            iss.setVISS(this.formatarNumerosNullCaso0(valorIss, 2));
            iss.setVPIS(this.formatarNumerosNullCaso0(valorPisServ, 2));
            iss.setVCOFINS(this.formatarNumerosNullCaso0(valorCofinsServ, 2));
            iss.setDCompet(this.formatarData(nfPropria.getDataEmissaoNota()));
            t.setISSQNtot(iss);
        }
        if (valorPisST > 0.0 || valorCofinsST > 0.0 || valorContSocial > 0.0 || valorIRRF > 0.0 || valorInss > 0.0) {
            TNFe.InfNFe.Total.RetTrib ret = new TNFe.InfNFe.Total.RetTrib();
            ret.setVRetPIS(this.formatarNumerosNullCaso0(valorPis, 2));
            ret.setVRetCOFINS(this.formatarNumerosNullCaso0(valorCofinsST, 2));
            ret.setVRetCSLL(this.formatarNumerosNullCaso0(valorContSocial, 2));
            ret.setVBCIRRF(this.formatarNumerosNullCaso0(bcIrrf, 2));
            ret.setVIRRF(this.formatarNumerosNullCaso0(valorIRRF, 2));
            ret.setVBCRetPrev(this.formatarNumerosNullCaso0(bcInss, 2));
            ret.setVRetPrev(this.formatarNumerosNullCaso0(valorInss, 2));
            t.setRetTrib(ret);
        }
        new UtilSefazNFeLoteFatNFe_V400CbsIbs(this, this.opcoesFaturamento).setInfoTotalCbsIbs(nfPropria, t, valorTotal, valorTotalServico);
        return t;
    }

    private TNFe.InfNFe.Exporta getExporta(NotaFiscalPropria nf) {
        if (nf.getUfEmbarque() != null && nf.getLocalEmbarque() != null) {
            TNFe.InfNFe.Exporta e = new TNFe.InfNFe.Exporta();
            e.setUFSaidaPais(TUfEmi.valueOf((String)nf.getUfEmbarque().getSigla()));
            e.setXLocExporta(nf.getLocalEmbarque());
            return e;
        }
        return null;
    }

    private String getCombinacaoString(String st1, String st2, String st3) {
        Object strFinal;
        if (st1 != null) {
            strFinal = st1;
            if (st2 != null) {
                strFinal = (String)strFinal + " " + st2;
            }
        } else {
            strFinal = st2;
        }
        if (ToolMethods.isStrWithData((String)st3)) {
            strFinal = strFinal == null ? st3 : (String)strFinal + " " + st3;
        }
        if (strFinal == null) {
            return null;
        }
        strFinal = strFinal != null && ((String)strFinal).trim().length() > 0 ? ((String)strFinal).trim() : null;
        return strFinal;
    }

    private Collection<? extends TNFe.InfNFe.Det> getDet(NotaFiscalPropria nf, EnumConstNFeFinalidadeEmissao finalidade) throws NFeValidateException {
        ArrayList<TNFe.InfNFe.Det> toRet = new ArrayList<TNFe.InfNFe.Det>();
        Cliente c = nf.getUnidadeFatCliente().getCliente();
        List<ItemNotaFiscalPropria> itens = this.ordenarItensPorNrSequencial(nf.getItensNotaPropria());
        for (ItemNotaFiscalPropria i : itens) {
            TNFe.InfNFe.Det d = new TNFe.InfNFe.Det();
            d.setNItem(this.formatarNumeros(i.getNumeroItem()));
            d.setProd(this.getProduto(i, nf.getUnidadeFatCliente().getCliente()));
            d.setImposto(this.getImposto(i, finalidade));
            d.setInfAdProd(this.getCombinacaoString(i.getInfAdicionalItemSistema(), i.getInfAdicionalItem(), this.getInfAdicionalProdutoParametrizacaoNomeXML(c, i.getProduto())));
            d.setImpostoDevol(this.getImpostoDevol(i));
            d.setObsItem(this.getObsItem(i));
            new UtilSefazNFeLoteFatNFe_V400CbsIbs(this, this.opcoesFaturamento).setTotalItem(d, i);
            toRet.add(d);
        }
        return toRet;
    }

    private TNFe.InfNFe.Det.Prod getProduto(ItemNotaFiscalPropria i, Cliente cliente) {
        TNFe.InfNFe.Det.Prod p = new TNFe.InfNFe.Det.Prod();
        if (this.opcoesFaturamento.getUsarCodAuxNfe() != null && this.opcoesFaturamento.getUsarCodAuxNfe() == 1 && i.getProduto().getCodigoAuxiliar() != null && i.getProduto().getCodigoAuxiliar().trim().length() > 0) {
            p.setCProd(this.refinaXML(i.getProduto().getCodigoAuxiliar()));
        } else {
            p.setCProd(this.refina(i.getProduto().getIdentificador().toString()));
        }
        String cEAN = "";
        String cEANTrib = "";
        if (this.opcoesFaturamentoCliente != null) {
            cEAN = this.getCodigoBarrasParametrizacaoNomeXML(cliente, i.getProduto(), CODIGO_BARRAS_EAN);
            cEANTrib = this.getCodigoBarrasParametrizacaoNomeXML(cliente, i.getProduto(), CODIGO_BARRAS_EAN_TRIB);
        }
        for (CodigoBarras c : i.getProduto().getCodigoBarras()) {
            if (!ToolMethods.isStrWithData((String)cEAN) && c.getUsarComoCodigoPrinc() != null && c.getUsarComoCodigoPrinc() == 1) {
                cEAN = ToolString.clearSpecialCharacXML((String)c.getCodigoBarras());
            }
            if (ToolMethods.isStrWithData((String)cEANTrib) || c.getUsarComoCodPrincTrib() == null || c.getUsarComoCodPrincTrib() != 1) continue;
            cEANTrib = ToolString.clearSpecialCharacXML((String)c.getCodigoBarras());
        }
        if (!cEAN.isEmpty() && !cEANTrib.isEmpty()) {
            p.setCEAN(cEAN);
            p.setCEANTrib(cEANTrib);
        }
        if (!(p.getCEAN() != null && p.getCEAN().trim().length() != 0 || p.getCEANTrib() != null && p.getCEANTrib().trim().length() != 0)) {
            p.setCEAN("SEM GTIN");
            p.setCEANTrib("SEM GTIN");
        }
        Object nome = i.getProduto().getNome().trim();
        if (this.opcoesFaturamento.getConcCodBarrasItensNfDanfe() == 1 && i.getProduto().getCodigoBarras() != null && !i.getProduto().getCodigoBarras().isEmpty()) {
            nome = (String)nome + " - " + String.valueOf(i.getProduto().getCodigoBarras().get(0));
        }
        if (((String)nome).length() > 120) {
            nome = ((String)nome).substring(0, 120);
        }
        if (this.opcoesFaturamentoCliente != null) {
            p.setXProd(this.refinaXML(this.getNomeProdutoParametrizacaoNomeXML(cliente, i.getProduto(), (String)nome)));
        } else {
            p.setXProd(this.refinaXML((String)nome));
        }
        if (i.getProduto().getNcm() != null) {
            p.setNCM(this.refina(i.getProduto().getNcm().getCodigo()));
        } else if (i.getProduto().getGenero() != null) {
            p.setNCM(this.refina(i.getProduto().getGenero().getCodigo()));
        }
        if (i.getProduto().getRegraExcecaoNCM() != null && i.getProduto().getTipoProduto() != 1) {
            p.setEXTIPI(this.refina(i.getProduto().getRegraExcecaoNCM().getCodigo()));
        }
        p.setCFOP(this.refina(i.getItemNotaLivroFiscal().getCfop().getCodigo()));
        EnumConstNFeFinalidadeEmissao finalidade = EnumConstNFeFinalidadeEmissao.get((Object)i.getNotaFiscalPropria().getFinalidadeEmNFe().getCodigo());
        if (i.getUnidadeMedidaCom() != null && i.getQuantidadeTotalCom() != null && (i.getQuantidadeTotalCom() > 0.0 || finalidade.isComplementar()) && i.getValorUnitarioCom() != null && i.getValorUnitarioCom() > 0.0) {
            p.setUCom(i.getUnidadeMedidaCom().getSigla());
            p.setQCom(this.formatarNumeros(i.getQuantidadeTotalCom(), 4));
            p.setVUnCom(this.formatarNumeros(i.getValorUnitarioCom(), 6));
        } else {
            p.setUCom(i.getProduto().getUnidadeMedida().getSigla());
            p.setQCom(this.formatarNumeros(i.getQuantidadeTotal(), 4));
            p.setVUnCom(this.formatarNumeros(i.getValorUnitario(), 6));
        }
        if (i.getUnidadeMedidaTrib() != null && i.getQuantidadeTotalTrib() != null && (i.getQuantidadeTotalTrib() > 0.0 || finalidade.isComplementar()) && i.getValorUnitarioTrib() != null && i.getValorUnitarioTrib() > 0.0) {
            p.setUTrib(i.getUnidadeMedidaTrib().getSigla());
            p.setQTrib(this.formatarNumeros(i.getQuantidadeTotalTrib(), 4));
            p.setVUnTrib(this.formatarNumeros(i.getValorUnitarioTrib(), 6));
        } else {
            p.setUTrib(i.getProduto().getUnidadeMedida().getSigla());
            p.setQTrib(this.formatarNumeros(i.getQuantidadeTotal(), 4));
            p.setVUnTrib(this.formatarNumeros(i.getValorUnitario(), 6));
        }
        p.setVProd(this.formatarNumeros(i.getVrProduto() + i.getVrServico(), 2));
        p.setVFrete(this.formatarNumerosNullCaso0(i.getValorFrete(), 2));
        p.setVSeg(this.formatarNumerosNullCaso0(i.getVrSeguro(), 2));
        p.setVDesc(this.formatarNumerosNullCaso0(i.getValorDesconto(), 2));
        p.setVOutro(this.formatarNumerosNullCaso0(i.getValorDespAcessoria(), 2));
        p.setIndTot(this.formatarNumeros(i.getIndicadorTotal()));
        p.getDI().addAll(this.getDI(i));
        p.getDetExport().addAll(this.getDetExport(i));
        if (i.getNrPedido() != null && i.getNrPedido().trim().length() > 0) {
            p.setXPed(this.refinaXML(i.getNrPedido()));
        } else {
            p.setXPed(this.getNrPedidoCliente(i.getNotaFiscalPropria()));
        }
        if (ToolMethods.isStrWithData((String)i.getNrItemPedido())) {
            p.setNItemPed(this.refinaXML(i.getNrItemPedido().toString()));
        }
        p.setVeicProd(null);
        p.setComb(this.getComb(i));
        p.setCEST(this.getCest(i));
        if (i.getProduto().getCodBeneficioFiscal() != null && i.getProduto().getCodBeneficioFiscal().trim().length() > 0) {
            p.setCBenef(i.getProduto().getCodBeneficioFiscal());
        }
        p.getRastro().addAll(this.getRastro(i.getGradesNotaFiscalPropria()));
        p.setMed(this.getMed(i.getProduto()));
        if (i.getModeloFiscal().getUtilizaCodigoFCI() != null && i.getModeloFiscal().getUtilizaCodigoFCI().equals((short)1) && i.getProduto().getCodigoFCI() != null && !i.getProduto().getCodigoFCI().isEmpty()) {
            p.setNFCI(i.getProduto().getCodigoFCI());
        }
        return p;
    }

    private Collection<? extends TNFe.InfNFe.Det.Prod.DI> getDI(ItemNotaFiscalPropria i) {
        ArrayList<TNFe.InfNFe.Det.Prod.DI> di = new ArrayList<TNFe.InfNFe.Det.Prod.DI>();
        if (i.getItemNotaImportacao() != null) {
            for (DetImportacaoItem det : i.getItemNotaImportacao().getDetimportacaoItem()) {
                TNFe.InfNFe.Det.Prod.DI d = new TNFe.InfNFe.Det.Prod.DI();
                d.setNDI(det.getNumDocImportacao());
                d.setDDI(this.formatarData(det.getDataRegDocImp()));
                d.setXLocDesemb(det.getLocalDesembaraco());
                if (det.getUfDesembaraco() != null) {
                    d.setUFDesemb(TUfEmi.valueOf((String)det.getUfDesembaraco().getSigla()));
                }
                d.setDDesemb(this.formatarData(det.getDataDesembaraco()));
                d.setTpViaTransp(det.getViaTransporteDetImportacaoItem().getCodigo());
                if (d.getTpViaTransp().equals("1")) {
                    d.setVAFRMM(this.formatarNumeros(det.getValorAFRMM(), 2));
                }
                d.setTpIntermedio(this.formatarNumeros(det.getTipoIntermedio()));
                if (det.getAdquirenteEncomendante() != null) {
                    d.setCNPJ(this.refina(det.getAdquirenteEncomendante().getComplemento().getCnpj()));
                    d.setUFTerceiro(TUfEmi.valueOf((String)det.getAdquirenteEncomendante().getEndereco().getCidade().getUf().getSigla()));
                }
                if (det.getExportador() != null) {
                    d.setCExportador(this.formatarNumeros(det.getExportador().getIdentificador()));
                }
                for (AdicoesImportacao a : det.getAdicoesImportacao()) {
                    TNFe.InfNFe.Det.Prod.DI.Adi aa = new TNFe.InfNFe.Det.Prod.DI.Adi();
                    aa.setNAdicao(this.formatarNumeros(a.getNrDaAdicao()));
                    aa.setNSeqAdic(this.formatarNumeros(a.getNrSeqDaAdicao()));
                    if (a.getFabricante() != null) {
                        aa.setCFabricante(this.formatarNumeros(a.getFabricante().getIdentificador()));
                    }
                    if (ToolMethods.isStrWithData((String)a.getNrAtoConcessiorioDrawback())) {
                        aa.setNDraw(a.getNrAtoConcessiorioDrawback());
                    }
                    aa.setVDescDI(this.formatarNumerosNullCaso0(a.getValorDesconto(), 2));
                    d.getAdi().add(aa);
                }
                di.add(d);
            }
        }
        return di;
    }

    private TNFe.InfNFe.Det.Prod.Comb getComb(ItemNotaFiscalPropria i) {
        if (i.getProduto().getClassificacaoProdutoANP() != null && i.getItemNotaLivroFiscal().getUfConsumoComb() != null) {
            TNFe.InfNFe.Det.Prod.Comb c = new TNFe.InfNFe.Det.Prod.Comb();
            if (i.getProduto().getClassificacaoProdutoANP() != null) {
                c.setCProdANP(i.getProduto().getClassificacaoProdutoANP().getCodigo());
                c.setDescANP(i.getProduto().getClassificacaoProdutoANP().getDescricao());
                c.setPGLP(this.formatarNumerosNullCaso0(i.getProduto().getPercGLP(), 4));
                c.setPGNn(this.formatarNumerosNullCaso0(i.getProduto().getPercGNN(), 4));
                c.setPGNi(this.formatarNumerosNullCaso0(i.getProduto().getPercGNI(), 4));
                c.setVPart(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getValorPartida(), 2));
            }
            c.setQTemp(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getQtdCombTempAmb(), 4));
            c.setUFCons(TUf.valueOf((String)i.getItemNotaLivroFiscal().getUfConsumoComb().getSigla()));
            TNFe.InfNFe.Det.Prod.Comb.CIDE ci = new TNFe.InfNFe.Det.Prod.Comb.CIDE();
            c.setCIDE(ci);
            ci.setQBCProd(this.formatarNumeros(i.getItemNotaLivroFiscal().getQuantidadeBCCIDE(), 4));
            ci.setVAliqProd(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaCIDE(), 4));
            ci.setVCIDE(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorCIDE(), 2));
            if (i.getProduto().getPercIndiceMisturaBioDiesel() != null && i.getProduto().getPercIndiceMisturaBioDiesel() > 0.0) {
                c.setPBio(this.formatarNumerosNullCaso0(i.getProduto().getPercIndiceMisturaBioDiesel(), 4));
            }
            return c;
        }
        return null;
    }

    private String getNrPedidoCliente(NotaFiscalPropria nf) {
        String st;
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("nota", nf);
        HashMap h = (HashMap)CoreDAOFactory.getInstance().getDAOPedido().findDadosPedidosObs(nf);
        String string = st = h.get("NR_PED_CLIENTE") != null ? h.get("NR_PED_CLIENTE").toString() : null;
        if (st != null && st.trim().length() == 0) {
            st = null;
        }
        return st;
    }

    private TNFe.InfNFe.Det.Imposto getImposto(ItemNotaFiscalPropria i, EnumConstNFeFinalidadeEmissao finalidade) throws NFeValidateException {
        TNFe.InfNFe.Det.Imposto imp = new TNFe.InfNFe.Det.Imposto();
        imp.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoVTotTrib(this.formatarNumeros(i.getItemNotaLivroFiscal().getVlrImpostosEstimado(), 2)));
        if (!finalidade.isCredito() && !finalidade.isDebito()) {
            JAXBElement j;
            if (i.getProduto().getTipoProduto() == 1 && i.getItemNotaLivroFiscal().getVrIss() > 0.0) {
                imp.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoISSQN(this.getISSQN(i)));
                imp.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoPIS(this.getPIS(i)));
                TNFe.InfNFe.Det.Imposto.PISST pisSt = this.getPisST(i);
                if (pisSt != null) {
                    imp.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoPISST(pisSt));
                }
                imp.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoCOFINS(this.getCofins(i)));
                TNFe.InfNFe.Det.Imposto.COFINSST cofinsSt = this.getCofinsST(i);
                if (cofinsSt != null) {
                    imp.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoCOFINSST(cofinsSt));
                }
            } else {
                imp.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoICMS(this.getICMS(i)));
                imp.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoIPI(this.getIPI(i)));
                TNFe.InfNFe.Det.Imposto.II ii = this.getII(i);
                if (ii != null) {
                    imp.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoII(ii));
                }
                imp.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoPIS(this.getPIS(i)));
                TNFe.InfNFe.Det.Imposto.PISST pisSt = this.getPisST(i);
                if (pisSt != null) {
                    imp.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoPISST(pisSt));
                }
                imp.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoCOFINS(this.getCofins(i)));
                TNFe.InfNFe.Det.Imposto.COFINSST cofinsSt = this.getCofinsST(i);
                if (cofinsSt != null) {
                    imp.getContent().add(new ObjectFactory().createTNFeInfNFeDetImpostoCOFINSST(cofinsSt));
                }
            }
            if (this.validarOperacoesInterestaduais(i.getNotaFiscalPropria()) && (j = this.getIcmsUFDest(i)) != null) {
                imp.getContent().add(j);
            }
        }
        new UtilSefazNFeLoteFatNFe_V400CbsIbs(this, this.opcoesFaturamento).setInfoItem(imp, i);
        return imp;
    }

    private TNFe.InfNFe.Det.Imposto.COFINS getCofins(ItemNotaFiscalPropria i) throws NFeValidateException {
        TNFe.InfNFe.Det.Imposto.COFINS c = new TNFe.InfNFe.Det.Imposto.COFINS();
        String codigo = i.getIncidenciaPisCofins().getCodigo();
        if (codigo.equalsIgnoreCase("01") || codigo.equalsIgnoreCase("02")) {
            TNFe.InfNFe.Det.Imposto.COFINS.COFINSAliq a = new TNFe.InfNFe.Det.Imposto.COFINS.COFINSAliq();
            a.setCST(codigo);
            a.setVBC(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBCCofins(), 2));
            a.setPCOFINS(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaCofins(), 4));
            a.setVCOFINS(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrCofins(), 2));
            c.setCOFINSAliq(a);
        } else if (codigo.equalsIgnoreCase("03")) {
            if (i.getProduto().getPisCofinsTributadoQuantidade() == 0) {
                throw new RuntimeException("Para incid\u00eancia Pis/Cofins 03, no cadastro do produto: " + i.getProduto().getIdentificador() + "-" + i.getProduto().getNome() + " deve est\u00e1 marcado a op\u00e7\u00e3o Tributado por Quantidade!");
            }
            TNFe.InfNFe.Det.Imposto.COFINS.COFINSQtde q = new TNFe.InfNFe.Det.Imposto.COFINS.COFINSQtde();
            q.setCST(codigo);
            q.setVAliqProd(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaCofinsQtde(), 4));
            q.setVCOFINS(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrCofins(), 2));
            q.setQBCProd(this.formatarNumeros(i.getQuantidadeTotal(), 4));
            c.setCOFINSQtde(q);
        } else if (codigo.equalsIgnoreCase("04") || codigo.equalsIgnoreCase("05") || codigo.equalsIgnoreCase("06") || codigo.equalsIgnoreCase("07") || codigo.equalsIgnoreCase("08") || codigo.equalsIgnoreCase("09")) {
            TNFe.InfNFe.Det.Imposto.COFINS.COFINSNT nt = new TNFe.InfNFe.Det.Imposto.COFINS.COFINSNT();
            nt.setCST(codigo);
            c.setCOFINSNT(nt);
        } else if (codigo.equalsIgnoreCase("49") || codigo.equalsIgnoreCase("50") || codigo.equalsIgnoreCase("51") || codigo.equalsIgnoreCase("52") || codigo.equalsIgnoreCase("53") || codigo.equalsIgnoreCase("54") || codigo.equalsIgnoreCase("55") || codigo.equalsIgnoreCase("56") || codigo.equalsIgnoreCase("60") || codigo.equalsIgnoreCase("61") || codigo.equalsIgnoreCase("62") || codigo.equalsIgnoreCase("63") || codigo.equalsIgnoreCase("64") || codigo.equalsIgnoreCase("65") || codigo.equalsIgnoreCase("66") || codigo.equalsIgnoreCase("67") || codigo.equalsIgnoreCase("70") || codigo.equalsIgnoreCase("71") || codigo.equalsIgnoreCase("72") || codigo.equalsIgnoreCase("73") || codigo.equalsIgnoreCase("74") || codigo.equalsIgnoreCase("75") || codigo.equalsIgnoreCase("98") || codigo.equalsIgnoreCase("99")) {
            TNFe.InfNFe.Det.Imposto.COFINS.COFINSOutr outr = new TNFe.InfNFe.Det.Imposto.COFINS.COFINSOutr();
            outr.setCST(codigo);
            outr.setVBC(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBCCofins(), 2));
            outr.setPCOFINS(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaCofins(), 4));
            outr.setVCOFINS(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrCofins(), 2));
            c.setCOFINSOutr(outr);
        } else {
            throw new NFeValidateException("Incidencida de Pis nao contemplada pela NFe:" + codigo);
        }
        return c;
    }

    private TNFe.InfNFe.Det.Imposto.PIS getPIS(ItemNotaFiscalPropria i) throws NFeValidateException {
        TNFe.InfNFe.Det.Imposto.PIS c = new TNFe.InfNFe.Det.Imposto.PIS();
        String codigo = i.getIncidenciaPisCofins().getCodigo();
        if (codigo.equalsIgnoreCase("01") || codigo.equalsIgnoreCase("02")) {
            TNFe.InfNFe.Det.Imposto.PIS.PISAliq a = new TNFe.InfNFe.Det.Imposto.PIS.PISAliq();
            a.setCST(codigo);
            a.setVBC(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBCPis(), 2));
            a.setPPIS(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaPis(), 4));
            a.setVPIS(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrPis(), 2));
            c.setPISAliq(a);
        } else if (codigo.equalsIgnoreCase("03")) {
            if (i.getProduto().getPisCofinsTributadoQuantidade() == 0) {
                throw new RuntimeException("Para incid\u00eancia Pis/Cofins 03, no cadastro do produto: " + i.getProduto().getIdentificador() + "-" + i.getProduto().getNome() + " deve est\u00e1 marcado a op\u00e7\u00e3o Tributado por Quantidade!");
            }
            TNFe.InfNFe.Det.Imposto.PIS.PISQtde q = new TNFe.InfNFe.Det.Imposto.PIS.PISQtde();
            q.setCST(codigo);
            q.setVAliqProd(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaPisQtde(), 4));
            q.setVPIS(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrPis(), 2));
            q.setQBCProd(this.formatarNumeros(i.getQuantidadeTotal(), 4));
            c.setPISQtde(q);
        } else if (codigo.equalsIgnoreCase("04") || codigo.equalsIgnoreCase("05") || codigo.equalsIgnoreCase("06") || codigo.equalsIgnoreCase("07") || codigo.equalsIgnoreCase("08") || codigo.equalsIgnoreCase("09")) {
            TNFe.InfNFe.Det.Imposto.PIS.PISNT nt = new TNFe.InfNFe.Det.Imposto.PIS.PISNT();
            nt.setCST(codigo);
            c.setPISNT(nt);
        } else if (codigo.equalsIgnoreCase("49") || codigo.equalsIgnoreCase("50") || codigo.equalsIgnoreCase("51") || codigo.equalsIgnoreCase("52") || codigo.equalsIgnoreCase("53") || codigo.equalsIgnoreCase("54") || codigo.equalsIgnoreCase("55") || codigo.equalsIgnoreCase("56") || codigo.equalsIgnoreCase("60") || codigo.equalsIgnoreCase("61") || codigo.equalsIgnoreCase("62") || codigo.equalsIgnoreCase("63") || codigo.equalsIgnoreCase("64") || codigo.equalsIgnoreCase("65") || codigo.equalsIgnoreCase("66") || codigo.equalsIgnoreCase("67") || codigo.equalsIgnoreCase("70") || codigo.equalsIgnoreCase("71") || codigo.equalsIgnoreCase("72") || codigo.equalsIgnoreCase("73") || codigo.equalsIgnoreCase("74") || codigo.equalsIgnoreCase("75") || codigo.equalsIgnoreCase("98") || codigo.equalsIgnoreCase("99")) {
            TNFe.InfNFe.Det.Imposto.PIS.PISOutr outr = new TNFe.InfNFe.Det.Imposto.PIS.PISOutr();
            outr.setCST(codigo);
            outr.setVBC(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBCPis(), 2));
            outr.setPPIS(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaPis(), 4));
            outr.setVPIS(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrPis(), 2));
            c.setPISOutr(outr);
        } else {
            throw new NFeValidateException("CST de PIS n\u00e3o contemplado pela NFe: " + codigo);
        }
        return c;
    }

    private TNFe.InfNFe.Det.Imposto.COFINSST getCofinsST(ItemNotaFiscalPropria i) {
        TNFe.InfNFe.Det.Imposto.COFINSST outr = null;
        if (i.getItemNotaLivroFiscal().getVrCofinsSt() > 0.0) {
            outr = new TNFe.InfNFe.Det.Imposto.COFINSST();
            outr.setVBC(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBCCofinsSt(), 2));
            outr.setPCOFINS(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaCofinsSt(), 4));
            outr.setVCOFINS(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrCofinsSt(), 2));
            return outr;
        }
        return outr;
    }

    private TNFe.InfNFe.Det.Imposto.PISST getPisST(ItemNotaFiscalPropria i) {
        TNFe.InfNFe.Det.Imposto.PISST outr = null;
        if (i.getItemNotaLivroFiscal().getVrPisSt() > 0.0) {
            outr = new TNFe.InfNFe.Det.Imposto.PISST();
            outr.setVBC(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBCPisSt(), 2));
            outr.setPPIS(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaPisSt(), 4));
            outr.setVPIS(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrPisSt(), 2));
            return outr;
        }
        return outr;
    }

    private TNFe.InfNFe.Det.Imposto.II getII(ItemNotaFiscalPropria i) {
        if (i.getItemNotaLivroFiscal().getCfop() != null && i.getItemNotaLivroFiscal().getCfop().getCodigo().startsWith("3")) {
            TNFe.InfNFe.Det.Imposto.II ii = new TNFe.InfNFe.Det.Imposto.II();
            ii.setVBC(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBCImpostoImp(), 2));
            ii.setVDespAdu(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrDespAduaneira(), 2));
            ii.setVII(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrImpostoImportacao(), 2));
            ii.setVIOF(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIof(), 2));
            return ii;
        }
        return null;
    }

    private TIpi getIPI(ItemNotaFiscalPropria i) throws NFeValidateException {
        TIpi ip = new TIpi();
        if (i.getClasseEnquadramentoIpi() == null && i.getProduto().getClasseEnqIpi() == null) {
            throw new NFeValidateException("Informe o Enquadramento de IPI do Item: " + i.getProduto().toString());
        }
        if (i.getClasseEnquadramentoIpi() != null) {
            ip.setCEnq(i.getClasseEnquadramentoIpi().getCodigo());
        } else {
            ip.setCEnq(i.getProduto().getClasseEnqIpi().getCodigo());
        }
        String cod = i.getIncidenciaIpi().getCodigo();
        if (cod.equalsIgnoreCase("00") || cod.equalsIgnoreCase("49") || cod.equalsIgnoreCase("50") || cod.equalsIgnoreCase("99")) {
            TIpi.IPITrib tr = new TIpi.IPITrib();
            tr.setCST(cod);
            if (i.getProduto().getIpiTributadoQuantidade() == 0) {
                tr.setVBC(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIpiTributado(), 2));
                tr.setPIPI(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIpi(), 4));
            } else {
                tr.setQUnid(this.formatarNumeros(i.getQuantidadeTotal(), 4));
                tr.setVUnid(this.formatarNumeros(i.getValorUnitario(), 4));
            }
            tr.setVIPI(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIpiIndustria(), 2));
            ip.setIPITrib(tr);
        } else if (cod.equalsIgnoreCase("01") || cod.equalsIgnoreCase("02") || cod.equalsIgnoreCase("03") || cod.equalsIgnoreCase("04") || cod.equalsIgnoreCase("05") || cod.equalsIgnoreCase("51") || cod.equalsIgnoreCase("52") || cod.equalsIgnoreCase("53") || cod.equalsIgnoreCase("54") || cod.equalsIgnoreCase("55")) {
            TIpi.IPINT nt = new TIpi.IPINT();
            nt.setCST(cod);
            ip.setIPINT(nt);
        } else {
            throw new NFeValidateException("Incidencia IPI nao contemplada pela nota fiscal eletronica.");
        }
        return ip;
    }

    private TNFe.InfNFe.Det.Imposto.ICMS getICMS(ItemNotaFiscalPropria i) throws NFeValidateException {
        TNFe.InfNFe.Det.Imposto.ICMS ic = new TNFe.InfNFe.Det.Imposto.ICMS();
        String procedencia = i.getIncidenciaIcms().getCodigo().substring(0, 1);
        String codigo = i.getIncidenciaIcms().getCodigo().substring(1);
        String motDesoneracaoIcms = null;
        if (i.getMotivoDesoneracaoIcms() != null) {
            motDesoneracaoIcms = i.getMotivoDesoneracaoIcms().getCodigo();
        }
        if (codigo.equalsIgnoreCase("00")) {
            TNFe.InfNFe.Det.Imposto.ICMS.ICMS00 ii = new TNFe.InfNFe.Det.Imposto.ICMS.ICMS00();
            ii.setOrig(procedencia);
            ii.setCST(codigo);
            ii.setModBC(i.getModalidadeIcms().getCodigo());
            ii.setVBC(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsTributado(), 2));
            ii.setPICMS(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIcms(), 4));
            ii.setVICMS(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcms(), 2));
            if (i.getItemNotaLivroFiscal().getValorFCP() > 0.0) {
                ii.setPFCP(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaFCP(), 4));
                ii.setVFCP(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorFCP(), 2));
            }
            ic.setICMS00(ii);
        } else if (codigo.equalsIgnoreCase("10")) {
            TNFe.InfNFe.Det.Imposto.ICMS.ICMS10 ii = new TNFe.InfNFe.Det.Imposto.ICMS.ICMS10();
            ii.setOrig(procedencia);
            ii.setCST(codigo);
            if (i.getModalidadeIcms() != null) {
                ii.setModBC(i.getModalidadeIcms().getCodigo());
            }
            ii.setVBC(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsTributado(), 2));
            ii.setPICMS(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIcms(), 4));
            ii.setVICMS(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcms(), 2));
            if (i.getItemNotaLivroFiscal().getValorFCP() > 0.0) {
                ii.setVBCFCP(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorBCFCP(), 2));
                ii.setPFCP(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaFCP(), 4));
                ii.setVFCP(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorFCP(), 2));
            }
            if (i.getModalidadeIcmsSt() != null) {
                ii.setModBCST(i.getModalidadeIcmsSt().getCodigo());
            }
            ii.setPMVAST(this.formatarNumerosNullCaso0(this.getIndiceAlteracao(i.getItemNotaLivroFiscal().getIndiceAlteracaoIcmsST()), 4));
            ii.setPRedBCST(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getDescontoPadraoIcmsST(), 4));
            ii.setVBCST(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBcCalculoIcmsSt(), 2));
            ii.setPICMSST(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIcmsST(), 4));
            ii.setVICMSST(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsSt(), 2));
            if (i.getItemNotaLivroFiscal().getValorFCPSt() > 0.0) {
                ii.setVBCFCPST(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorBCFCPSt(), 2));
                ii.setPFCPST(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaFCPSt(), 4));
                ii.setVFCPST(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorFCPSt(), 2));
            }
            ic.setICMS10(ii);
        } else if (codigo.equalsIgnoreCase("20")) {
            TNFe.InfNFe.Det.Imposto.ICMS.ICMS20 ii = new TNFe.InfNFe.Det.Imposto.ICMS.ICMS20();
            ii.setOrig(procedencia);
            ii.setCST(codigo);
            ii.setModBC(i.getModalidadeIcms().getCodigo());
            ii.setPRedBC(this.formatarNumeros(i.getItemNotaLivroFiscal().getPercReducaoBCIcms(), 4));
            ii.setVBC(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsTributado(), 2));
            ii.setPICMS(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIcms(), 4));
            ii.setVICMS(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcms(), 2));
            if (i.getMotivoDesoneracaoIcms() != null && i.getItemNotaLivroFiscal().getVrIcmsDesonerado() > 0.0) {
                ii.setVICMSDeson(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsDesonerado(), 2));
                ii.setMotDesICMS(motDesoneracaoIcms);
                if (ToolMethods.isEquals((Object)motDesoneracaoIcms, (Object)"7")) {
                    ii.setIndDeduzDeson("1");
                }
            }
            ic.setICMS20(ii);
        } else if (codigo.equalsIgnoreCase("30")) {
            TNFe.InfNFe.Det.Imposto.ICMS.ICMS30 ii = new TNFe.InfNFe.Det.Imposto.ICMS.ICMS30();
            ii.setOrig(procedencia);
            ii.setCST(codigo);
            if (i.getModalidadeIcmsSt() == null) {
                throw new NFeValidateException("Informe a Modalidade ICMSST no Modelo Fiscal " + i.getModeloFiscal().toString());
            }
            ii.setModBCST(i.getModalidadeIcmsSt().getCodigo());
            ii.setPMVAST(this.formatarNumerosNullCaso0(this.getIndiceAlteracao(i.getItemNotaLivroFiscal().getIndiceAlteracaoIcmsST()), 4));
            ii.setPRedBCST(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getDescontoPadraoIcmsST(), 4));
            ii.setVBCST(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBcCalculoIcmsSt(), 2));
            ii.setPICMSST(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIcmsST(), 4));
            ii.setVICMSST(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsSt(), 2));
            if (i.getMotivoDesoneracaoIcms() != null && i.getItemNotaLivroFiscal().getVrIcmsDesonerado() > 0.0) {
                ii.setVICMSDeson(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsDesonerado(), 2));
                ii.setMotDesICMS(motDesoneracaoIcms);
                if (ToolMethods.isEquals((Object)motDesoneracaoIcms, (Object)"7")) {
                    ii.setIndDeduzDeson("1");
                }
            }
            ic.setICMS30(ii);
        } else if (codigo.equalsIgnoreCase("40") || codigo.equalsIgnoreCase("41") || codigo.equalsIgnoreCase("50")) {
            TNFe.InfNFe.Det.Imposto.ICMS.ICMS40 ii = new TNFe.InfNFe.Det.Imposto.ICMS.ICMS40();
            ii.setOrig(procedencia);
            ii.setCST(codigo);
            if (i.getMotivoDesoneracaoIcms() != null && i.getItemNotaLivroFiscal().getVrIcmsDesonerado() > 0.0) {
                ii.setVICMSDeson(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsDesonerado(), 2));
                ii.setMotDesICMS(motDesoneracaoIcms);
                if (ToolMethods.isEquals((Object)motDesoneracaoIcms, (Object)"7")) {
                    ii.setIndDeduzDeson("1");
                }
            }
            ic.setICMS40(ii);
        } else if (codigo.equalsIgnoreCase("51")) {
            TNFe.InfNFe.Det.Imposto.ICMS.ICMS51 ii = new TNFe.InfNFe.Det.Imposto.ICMS.ICMS51();
            ii.setOrig(procedencia);
            ii.setCST(codigo);
            if (i.getModalidadeIcms() != null) {
                ii.setModBC(i.getModalidadeIcms().getCodigo());
            }
            ii.setPRedBC(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getPercReducaoBCIcms(), 4));
            if (i.getItemNotaLivroFiscal().getValorIcmsDiferimento() > 0.0) {
                ii.setVBC(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getVrIcmsTributado() + i.getItemNotaLivroFiscal().getVrIcmsOutros(), 2));
            } else {
                ii.setVBC(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getVrIcmsTributado(), 2));
            }
            ii.setPICMS(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getAliquotaIcms(), 4));
            ii.setVICMS(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getVrIcms(), 2));
            ii.setVICMSDif(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getValorIcmsDiferimento(), 2));
            ii.setVICMSOp(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getValorIcmsDiferimento() + i.getItemNotaLivroFiscal().getVrIcms(), 2));
            ii.setPDif(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getPercentualDiferimento(), 4));
            ic.setICMS51(ii);
        } else if (codigo.equalsIgnoreCase("60")) {
            if (i.getProduto().getClassificacaoProdutoANP() != null) {
                TNFe.InfNFe.Det.Imposto.ICMS.ICMSST ii = new TNFe.InfNFe.Det.Imposto.ICMS.ICMSST();
                ii.setCST(codigo);
                ii.setOrig(procedencia);
                ii.setVBCSTRet(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBCICMSSTRet(), 2));
                ii.setVICMSSTRet(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrICMSSTRet(), 2));
                ii.setVBCSTDest(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBCICMSSTDest(), 2));
                ii.setVICMSSTDest(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrICMSSTDest(), 2));
                ii.setPST(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIcmsST(), 2));
                ii.setVICMSSubstituto(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsSubstituto(), 2));
                ii.setVICMSSTRet(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrICMSSTRet(), 2));
                ic.setICMSST(ii);
            } else {
                TNFe.InfNFe.Det.Imposto.ICMS.ICMS60 ii = new TNFe.InfNFe.Det.Imposto.ICMS.ICMS60();
                ii.setOrig(procedencia);
                ii.setCST(codigo);
                ii.setVBCSTRet(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBCICMSSTRet(), 2));
                ii.setPST(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIcmsST(), 2));
                ii.setVICMSSubstituto(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsSubstituto(), 2));
                ii.setVICMSSTRet(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrICMSSTRet(), 2));
                ic.setICMS60(ii);
            }
        } else if (codigo.equalsIgnoreCase("61")) {
            TNFe.InfNFe.Det.Imposto.ICMS.ICMS61 ii = new TNFe.InfNFe.Det.Imposto.ICMS.ICMS61();
            ii.setOrig(procedencia);
            ii.setCST(codigo);
            ii.setQBCMonoRet(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsOutros(), 2));
            ii.setAdRemICMSRet(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIcms(), 2));
            ii.setVICMSMonoRet(this.formatarNumeros(0.0, 2));
            ic.setICMS61(ii);
        } else if (codigo.equalsIgnoreCase("70")) {
            TNFe.InfNFe.Det.Imposto.ICMS.ICMS70 ii = new TNFe.InfNFe.Det.Imposto.ICMS.ICMS70();
            ii.setOrig(procedencia);
            ii.setCST(codigo);
            if (i.getModalidadeIcms() == null) {
                throw new NFeValidateException("Informe a Modalidade ICMS no Modelo Fiscal " + i.getModeloFiscal().getDescricao());
            }
            ii.setModBC(i.getModalidadeIcms().getCodigo());
            ii.setPRedBC(this.formatarNumeros(i.getItemNotaLivroFiscal().getPercReducaoBCIcms(), 4));
            ii.setVBC(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsTributado(), 2));
            ii.setPICMS(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIcms(), 4));
            ii.setVICMS(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcms(), 2));
            if (i.getModalidadeIcmsSt() != null) {
                ii.setModBCST(i.getModalidadeIcmsSt().getCodigo());
            }
            ii.setPMVAST(this.formatarNumerosNullCaso0(this.getIndiceAlteracao(i.getItemNotaLivroFiscal().getIndiceAlteracaoIcmsST()), 4));
            ii.setPRedBCST(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getDescontoPadraoIcmsST(), 4));
            ii.setVBCST(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBcCalculoIcmsSt(), 2));
            ii.setPICMSST(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIcmsST(), 4));
            ii.setVICMSST(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsSt(), 2));
            if (i.getMotivoDesoneracaoIcms() != null && i.getItemNotaLivroFiscal().getVrIcmsDesonerado() > 0.0) {
                ii.setVICMSDeson(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsDesonerado(), 2));
                ii.setMotDesICMS(motDesoneracaoIcms);
                if (ToolMethods.isEquals((Object)motDesoneracaoIcms, (Object)"7")) {
                    ii.setIndDeduzDeson("1");
                }
            }
            if (i.getItemNotaLivroFiscal().getAliquotaFCPSt() > 0.0 && i.getItemNotaLivroFiscal().getValorBCFCPSt() > 0.0 && i.getItemNotaLivroFiscal().getValorFCPSt() > 0.0) {
                ii.setPFCPST(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaFCPSt(), 4));
                ii.setVBCFCPST(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorBCFCPSt(), 2));
                ii.setVFCPST(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorFCPSt(), 2));
            }
            ic.setICMS70(ii);
        } else if (codigo.equalsIgnoreCase("90")) {
            TNFe.InfNFe.Det.Imposto.ICMS.ICMS90 ii = new TNFe.InfNFe.Det.Imposto.ICMS.ICMS90();
            if (i.getModalidadeIcmsSt() == null) {
                throw new NFeValidateException("Informe a Modalidade ICMSST no Modelo Fiscal " + i.getModeloFiscal().getDescricao());
            }
            if (i.getModalidadeIcms() == null) {
                throw new NFeValidateException("Informe a Modalidade ICMS no Modelo Fiscal " + i.getModeloFiscal().getDescricao());
            }
            ii.setOrig(procedencia);
            ii.setCST(codigo);
            if (i.getItemNotaLivroFiscal().getVrIcms() > 0.0) {
                ii.setModBC(i.getModalidadeIcms().getCodigo());
                ii.setVBC(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsTributado(), 2));
                ii.setPRedBC(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getPercReducaoBCIcms(), 4));
                ii.setPICMS(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIcms(), 4));
                ii.setVICMS(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcms(), 2));
            }
            if (i.getItemNotaLivroFiscal().getVrIcmsSt() > 0.0) {
                ii.setModBCST(i.getModalidadeIcmsSt().getCodigo());
                ii.setPMVAST(this.formatarNumerosNullCaso0(this.getIndiceAlteracao(i.getItemNotaLivroFiscal().getIndiceAlteracaoIcmsST()), 4));
                ii.setPRedBCST(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getDescontoPadraoIcmsST(), 4));
                ii.setVBCST(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBcCalculoIcmsSt(), 2));
                ii.setPICMSST(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIcmsST(), 4));
                ii.setVICMSST(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsSt(), 2));
            }
            if (i.getMotivoDesoneracaoIcms() != null && i.getItemNotaLivroFiscal().getVrIcmsDesonerado() > 0.0) {
                ii.setVICMSDeson(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsDesonerado(), 2));
                ii.setMotDesICMS(motDesoneracaoIcms);
                if (ToolMethods.isEquals((Object)motDesoneracaoIcms, (Object)"7")) {
                    ii.setIndDeduzDeson("1");
                }
            }
            ic.setICMS90(ii);
        } else if (codigo.equalsIgnoreCase("101")) {
            TNFe.InfNFe.Det.Imposto.ICMS.ICMSSN101 ii = new TNFe.InfNFe.Det.Imposto.ICMS.ICMSSN101();
            ii.setOrig(procedencia);
            ii.setCSOSN(codigo);
            ii.setPCredSN(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaICMSSimples(), 4));
            ii.setVCredICMSSN(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorICMSSimples(), 2));
            ic.setICMSSN101(ii);
        } else if (codigo.equalsIgnoreCase("102") || codigo.equalsIgnoreCase("103") || codigo.equalsIgnoreCase("300") || codigo.equalsIgnoreCase("400")) {
            TNFe.InfNFe.Det.Imposto.ICMS.ICMSSN102 ii = new TNFe.InfNFe.Det.Imposto.ICMS.ICMSSN102();
            ii.setOrig(procedencia);
            ii.setCSOSN(codigo);
            ic.setICMSSN102(ii);
        } else if (codigo.equalsIgnoreCase("201")) {
            TNFe.InfNFe.Det.Imposto.ICMS.ICMSSN201 ii = new TNFe.InfNFe.Det.Imposto.ICMS.ICMSSN201();
            if (i.getModalidadeIcmsSt() == null) {
                throw new NFeValidateException("Informe a Modalidade ICMSST no Modelo Fiscal " + i.getModeloFiscal().getDescricao());
            }
            ii.setOrig(procedencia);
            ii.setCSOSN(codigo);
            ii.setModBCST(i.getModalidadeIcmsSt().getCodigo());
            ii.setPMVAST(this.formatarNumerosNullCaso0(this.getIndiceAlteracao(i.getItemNotaLivroFiscal().getIndiceAlteracaoIcmsST()), 4));
            ii.setPRedBCST(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getDescontoPadraoIcmsST(), 4));
            ii.setVBCST(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBcCalculoIcmsSt(), 2));
            ii.setPICMSST(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIcmsST(), 4));
            ii.setVICMSST(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsSt(), 2));
            ii.setPCredSN(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaICMSSimples(), 4));
            ii.setVCredICMSSN(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorICMSSimples(), 2));
            ic.setICMSSN201(ii);
        } else if (codigo.equalsIgnoreCase("202")) {
            TNFe.InfNFe.Det.Imposto.ICMS.ICMSSN202 ii = new TNFe.InfNFe.Det.Imposto.ICMS.ICMSSN202();
            if (i.getModalidadeIcmsSt() == null) {
                throw new NFeValidateException("Informe a Modalidade ICMSST no Modelo Fiscal " + i.getModeloFiscal().getDescricao());
            }
            ii.setOrig(procedencia);
            ii.setCSOSN(codigo);
            ii.setModBCST(i.getModalidadeIcmsSt().getCodigo());
            ii.setPMVAST(this.formatarNumerosNullCaso0(this.getIndiceAlteracao(i.getItemNotaLivroFiscal().getIndiceAlteracaoIcmsST()), 4));
            ii.setPRedBCST(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getDescontoPadraoIcmsST(), 4));
            ii.setVBCST(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBcCalculoIcmsSt(), 2));
            ii.setPICMSST(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIcmsST(), 4));
            ii.setVICMSST(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsSt(), 2));
            if (i.getItemNotaLivroFiscal().getAliquotaFCPSt() > 0.0) {
                ii.setVBCFCPST(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorBCFCPSt(), 2));
                ii.setVFCPST(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorFCPSt(), 2));
                ii.setPFCPST(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaFCPSt(), 4));
            }
            ic.setICMSSN202(ii);
        } else if (codigo.equalsIgnoreCase("500")) {
            TNFe.InfNFe.Det.Imposto.ICMS.ICMSSN500 ii = new TNFe.InfNFe.Det.Imposto.ICMS.ICMSSN500();
            ii.setOrig(procedencia);
            ii.setCSOSN(codigo);
            ii.setVBCSTRet(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBCICMSSTRet(), 2));
            ii.setPST(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIcmsST(), 2));
            ii.setVICMSSubstituto(this.formatarNumeros(0.0, 2));
            ii.setVICMSSTRet(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrICMSSTRet(), 2));
            ic.setICMSSN500(ii);
        } else if (codigo.equalsIgnoreCase("900")) {
            TNFe.InfNFe.Det.Imposto.ICMS.ICMSSN900 ii = new TNFe.InfNFe.Det.Imposto.ICMS.ICMSSN900();
            ii.setOrig(procedencia);
            ii.setCSOSN(codigo);
            if (i.getItemNotaLivroFiscal().getVrIcms() > 0.0) {
                if (i.getModalidadeIcms() != null) {
                    ii.setModBC(i.getModalidadeIcms().getCodigo());
                }
                if (i.getItemNotaLivroFiscal().getPercReducaoBCIcms() > 0.0) {
                    ii.setPRedBC(this.formatarNumeros(i.getItemNotaLivroFiscal().getPercReducaoBCIcms(), 4));
                }
                ii.setPICMS(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIcms(), 4));
                ii.setVICMS(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcms(), 2));
                if (i.getItemNotaLivroFiscal().getVrIcms() > 0.0) {
                    ii.setVBC(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBcCalculoIcms(), 2));
                } else {
                    ii.setVBC(this.formatarNumeros(0.0, 2));
                }
            }
            if (i.getItemNotaLivroFiscal().getVrIcmsSt() > 0.0) {
                if (i.getModalidadeIcmsSt() != null) {
                    ii.setModBCST(i.getModalidadeIcmsSt().getCodigo());
                }
                ii.setPMVAST(this.formatarNumerosNullCaso0(this.getIndiceAlteracao(i.getItemNotaLivroFiscal().getIndiceAlteracaoIcmsST()), 4));
                ii.setPRedBCST(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getDescontoPadraoIcmsST(), 4));
                ii.setVBCST(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrBcCalculoIcmsSt(), 2));
                ii.setPICMSST(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIcmsST(), 4));
                ii.setVICMSST(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIcmsSt(), 2));
            }
            ii.setPCredSN(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaICMSSimples(), 4));
            ii.setVCredICMSSN(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorICMSSimples(), 2));
            ic.setICMSSN900(ii);
        } else {
            throw new NFeValidateException("Incidencia ICMS n\u00e3o comtemplanda pela NFe.");
        }
        return ic;
    }

    private TNFe.InfNFe.Det.Imposto.ISSQN getISSQN(ItemNotaFiscalPropria i) {
        TNFe.InfNFe.Det.Imposto.ISSQN ii = new TNFe.InfNFe.Det.Imposto.ISSQN();
        ii.setVBC(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorTotal(), 2));
        ii.setVISSQN(this.formatarNumeros(i.getItemNotaLivroFiscal().getVrIss(), 2));
        ii.setVAliq(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaIss(), 4));
        ii.setCMunFG(i.getNotaFiscalPropria().getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge() + i.getNotaFiscalPropria().getEmpresa().getPessoa().getEndereco().getCidade().getCodIbge());
        ii.setCListServ(this.refina(i.getProduto().getCodigoServico()));
        ii.setIndIncentivo("0");
        return ii;
    }

    private void getNFRefDocumentos(NotaFiscalPropria nf, List l) {
        TNFe.InfNFe.Ide.NFref.RefNF ref;
        TNFe.InfNFe.Ide.NFref n;
        if (nf.getGrupoDocumentosRefPR() == null) {
            return;
        }
        GrupoDocumentosRefPR gr = nf.getGrupoDocumentosRefPR();
        for (DocumentosRefNFPropriaPR nfRef : gr.getNotasProprias()) {
            n = new TNFe.InfNFe.Ide.NFref();
            n.setRefNFe(nfRef.getChaveNFe());
            l.add(n);
        }
        for (DocumentosRefNFPropriaPR nfRef : gr.getNotasMod1A()) {
            n = new TNFe.InfNFe.Ide.NFref();
            ref = new TNFe.InfNFe.Ide.NFref.RefNF();
            ref.setCUF(nfRef.getEmissor().getEndereco().getCidade().getUf().getCodIbge());
            ref.setAAMM(this.formatarData(nfRef.getDataEmissao(), "yyMM"));
            ref.setCNPJ(this.refina(nfRef.getEmissor().getComplemento().getCnpj()));
            ref.setMod(nfRef.getModeloDocFiscal().getCodigo());
            ref.setSerie(nfRef.getSerie());
            ref.setNNF(this.formatarNumeros(nfRef.getNumero()));
            n.setRefNF(ref);
            l.add(n);
        }
        for (DocumentosRefNFPropriaPR nfRef : gr.getNotasProdutor()) {
            n = new TNFe.InfNFe.Ide.NFref();
            ref = new TNFe.InfNFe.Ide.NFref.RefNFP();
            ref.setCUF(nfRef.getEmissor().getEndereco().getCidade().getUf().getCodIbge());
            ref.setAAMM(this.formatarData(nfRef.getDataEmissao(), "yyMM"));
            String cpfCNPJ = this.refina(nfRef.getEmissor().getComplemento().getCnpj());
            if (cpfCNPJ.trim().length() == 14) {
                ref.setCNPJ(cpfCNPJ);
            } else {
                ref.setCPF(cpfCNPJ);
            }
            String inscEst = this.refina(nfRef.getEmissor().getComplemento().getInscEst());
            if (inscEst.trim().length() > 0) {
                ref.setIE(inscEst);
            } else {
                ref.setIE("ISENTO");
            }
            ref.setMod(nfRef.getModeloDocFiscal().getCodigo());
            ref.setSerie(nfRef.getSerie());
            ref.setNNF(this.formatarNumeros(nfRef.getNumero()));
            n.setRefNFP((TNFe.InfNFe.Ide.NFref.RefNFP)ref);
            l.add(n);
        }
        for (DocumentosRefNFPropriaPR nfRef : gr.getNotasTerceiros()) {
            n = new TNFe.InfNFe.Ide.NFref();
            n.setRefNFe(nfRef.getChaveNFe());
            l.add(n);
        }
        for (DocumentosRefNFPropriaPR nfRef : nf.getGrupoDocumentosRefPR().getNfces()) {
            n = new TNFe.InfNFe.Ide.NFref();
            n.setRefNFe(nfRef.getChaveNFe());
            l.add(n);
        }
    }

    private void getNFRefCTes(NotaFiscalPropria nf, List l) {
    }

    private TLocal getLocalEntrega(NotaFiscalPropria nf) {
        if (nf.getLocalEntregaNFPropria() != null) {
            TLocal t = new TLocal();
            String cpfCnpj = this.refina(nf.getLocalEntregaNFPropria().getCnpjEnderecoEntrega());
            if (cpfCnpj.trim().length() == 11) {
                t.setCPF(cpfCnpj);
            } else {
                t.setCNPJ(cpfCnpj);
            }
            Endereco end = nf.getLocalEntregaNFPropria().getEnderecoEntrega();
            t.setXLgr(this.refinaXML(end.getLogradouro()));
            t.setNro(this.refinaXML(end.getNumero()));
            t.setXCpl(this.refinaXMLNull(end.getComplemento()));
            t.setXBairro(this.refinaXML(end.getBairro()));
            t.setCMun(end.getCidade().getUf().getCodIbge() + end.getCidade().getCodIbge());
            t.setXMun(this.refinaXML(end.getCidade().getDescricao()));
            t.setUF(TUf.valueOf((String)end.getCidade().getUf().getSigla()));
            t.setCEP(this.refinaXML(end.getCep()));
            t.setCPais(end.getCidade().getUf().getPais().getCodIbge());
            t.setXPais(end.getCidade().getUf().getPais().getDescricao());
            t.setIE(this.refinaXMLNull(nf.getLocalEntregaNFPropria().getInscEstEnderecoEntrega()));
            t.setEmail(this.refinaXMLNull(nf.getLocalEntregaNFPropria().getEmailEnderecoEntrega()));
            t.setXNome(this.refinaXMLNull(nf.getLocalEntregaNFPropria().getNomeEnderecoEntrega()));
            t.setFone(this.refinaXMLNull(nf.getLocalEntregaNFPropria().getTelefone()));
            return t;
        }
        return null;
    }

    private TLocal getLocalRetirada(NotaFiscalPropria nf) {
        if (nf.getLocalRetiradaNFPropria() != null) {
            TLocal t = new TLocal();
            String cpfCnpj = this.refina(nf.getLocalRetiradaNFPropria().getCnpjEnderecoRetirada());
            if (cpfCnpj.trim().length() == 11) {
                t.setCPF(cpfCnpj);
            } else {
                t.setCNPJ(cpfCnpj);
            }
            Endereco end = nf.getLocalRetiradaNFPropria().getEnderecoRetirada();
            t.setXLgr(this.refinaXML(end.getLogradouro()));
            t.setNro(this.refinaXML(end.getNumero()));
            t.setXCpl(this.refinaXMLNull(end.getComplemento()));
            t.setXBairro(this.refinaXML(end.getBairro()));
            t.setCMun(end.getCidade().getUf().getCodIbge() + end.getCidade().getCodIbge());
            t.setXMun(this.refinaXML(end.getCidade().getDescricao()));
            t.setUF(TUf.valueOf((String)end.getCidade().getUf().getSigla()));
            t.setCEP(this.refinaXML(end.getCep()));
            t.setCPais(end.getCidade().getUf().getPais().getCodIbge());
            t.setXPais(end.getCidade().getUf().getPais().getDescricao());
            t.setIE(this.refinaXMLNull(nf.getLocalRetiradaNFPropria().getInscEstEnderecoRetirada()));
            t.setEmail(this.refinaXMLNull(nf.getLocalRetiradaNFPropria().getEmailEnderecoRetirada()));
            t.setXNome(this.refinaXMLNull(nf.getLocalRetiradaNFPropria().getNomeEnderecoRetirada()));
            t.setFone(this.refinaXMLNull(nf.getLocalRetiradaNFPropria().getTelefone()));
            return t;
        }
        return null;
    }

    private TNFe.InfNFe.Compra getCompraOrgaoPublico(NotaFiscalPropria nf) {
        TNFe.InfNFe.Compra c = new TNFe.InfNFe.Compra();
        if (nf.getNotaEmpenho() != null && nf.getNotaEmpenho().trim().length() > 0) {
            c.setXNEmp(this.refinaXML(nf.getNotaEmpenho()));
        }
        if (nf.getNrContrato() != null && nf.getNrContrato().trim().length() > 0) {
            c.setXCont(this.refinaXML(nf.getNrContrato()));
        }
        if (nf.getNrPedidoCompra() != null && nf.getNrPedidoCompra().trim().length() > 0) {
            c.setXPed(this.refinaXML(nf.getNrPedidoCompra()));
        }
        if (c.getXNEmp() != null || c.getXCont() != null || c.getXPed() != null) {
            return c;
        }
        return null;
    }

    private Collection<? extends TNFe.InfNFe.Transp.Vol.Lacres> getLacresVolumesNFe(List<LacreVolumeNFe> lacres) {
        ArrayList<TNFe.InfNFe.Transp.Vol.Lacres> lista = new ArrayList<TNFe.InfNFe.Transp.Vol.Lacres>();
        for (LacreVolumeNFe l : lacres) {
            TNFe.InfNFe.Transp.Vol.Lacres lacre = new TNFe.InfNFe.Transp.Vol.Lacres();
            lacre.setNLacre(l.getLacre());
            lista.add(lacre);
        }
        return lista;
    }

    private String getLocalDestinoOperacao(NotaFiscalPropria nf) {
        ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)nf.getItensNotaPropria().get(0);
        Cfop c = i.getItemNotaLivroFiscal().getCfop();
        if (c.getCodigo().startsWith("3") || c.getCodigo().startsWith("7")) {
            return "3";
        }
        if (c.getCodigo().startsWith("1") || c.getCodigo().startsWith("5")) {
            return "1";
        }
        return "2";
    }

    private Collection<? extends TNFe.InfNFe.AutXML> getAutXML(NotaFiscalPropria nf) {
        ArrayList<TNFe.InfNFe.AutXML> toRet = new ArrayList<TNFe.InfNFe.AutXML>();
        for (NFeAutDownloadXML p : nf.getNfeAutDownloadXML()) {
            TNFe.InfNFe.AutXML d = new TNFe.InfNFe.AutXML();
            String cnpjCpf = p.getCnpjCPF();
            if (cnpjCpf.trim().length() == 11) {
                d.setCPF(cnpjCpf);
            } else {
                d.setCNPJ(cnpjCpf);
            }
            toRet.add(d);
        }
        return toRet;
    }

    private String getCest(ItemNotaFiscalPropria i) {
        if (i.getProduto().getCest() != null) {
            return this.refina(i.getProduto().getCest().getCodigo());
        }
        return null;
    }

    private JAXBElement getIcmsUFDest(ItemNotaFiscalPropria i) throws NFeValidateException {
        if ((i.getItemNotaLivroFiscal().getValorIcmsPartilhaRem() >= 0.0 || i.getItemNotaLivroFiscal().getValorIcmsPartilhaDest() >= 0.0 || i.getItemNotaLivroFiscal().getAliquotaInterestadual() > 0.0) && !i.getNotaFiscalPropria().getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf().getSigla().equals("EX") && (i.getItemNotaLivroFiscal().getVrIcms() > 0.0 || i.getIncidenciaIcms().getCodigo().equals("0101") || i.getIncidenciaIcms().getCodigo().equals("0102") || i.getIncidenciaIcms().getCodigo().equals("0103") || i.getIncidenciaIcms().getCodigo().equals("0300") || i.getIncidenciaIcms().getCodigo().equals("0400") || i.getIncidenciaIcms().getCodigo().equals("0500") || i.getIncidenciaIcms().getCodigo().equals("060"))) {
            TNFe.InfNFe.Det.Imposto.ICMSUFDest ii = new TNFe.InfNFe.Det.Imposto.ICMSUFDest();
            ii.setVBCUFDest(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorBcIcmsUfDest(), 2));
            ii.setPICMSUFDest(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaInternaUFDest(), 2));
            ii.setPICMSInter(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaInterestadual(), 2));
            ii.setPICMSInterPart(this.formatarNumeros(i.getItemNotaLivroFiscal().getPercPartilhaIcms(), 2));
            ii.setVICMSUFDest(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorIcmsPartilhaDest(), 2));
            ii.setVICMSUFRemet(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorIcmsPartilhaRem(), 2));
            ii.setPFCPUFDest(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaFundoPobreza(), 2));
            ii.setVFCPUFDest(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorFundoPobreza(), 2));
            ii.setVBCFCPUFDest(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorBcIcmsUfDest(), 2));
            return new ObjectFactory().createTNFeInfNFeDetImpostoICMSUFDest(ii);
        }
        return null;
    }

    private boolean validarOperacoesInterestaduais(NotaFiscalPropria vo) {
        if (DateUtil.yearFromDate(vo.getDataEmissaoNota()) < 2015) {
            return false;
        }
        if (vo.getIndicadorConsumidorFinal() == 0) {
            return false;
        }
        if (vo.getEmpresa().getPessoa().getEndereco().getCidade().getUf().equals((Object)vo.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf())) {
            return false;
        }
        return vo.getContribuinteEstado() == EnumConstContrEstadoIcms.NAO_CONTRIBUINTE.getEnumId();
    }

    private DadosFiscaisUF findDadosFiscaisUF(Empresa empresa, UnidadeFederativa unidadeFederativa) {
        try {
            CoreRequestContext r = new CoreRequestContext();
            r.setAttribute("empresa", empresa);
            r.setAttribute("uf", unidadeFederativa);
            DadosFiscaisUF d = (DadosFiscaisUF)CoreServiceFactory.getServiceDadosFiscaisUF().execute(r, "findDadosFiscaisUFPorEmpresaAndUF");
            return d;
        }
        catch (ExceptionService ex) {
            logger.error(ex.getMessage());
            return null;
        }
    }

    private TNFe.InfNFe.Pag getPag(NotaFiscalPropria nf) {
        TNFe.InfNFe.Pag p = new TNFe.InfNFe.Pag();
        p.getDetPag().addAll(this.getDetPag(nf));
        return p;
    }

    private Collection<? extends TNFe.InfNFe.Pag.DetPag> getDetPag(NotaFiscalPropria nf) {
        ArrayList<TNFe.InfNFe.Pag.DetPag> pagamentos = new ArrayList<TNFe.InfNFe.Pag.DetPag>();
        for (InfPagamentoNfPropria i : nf.getInfPagamentoNfPropria()) {
            if (!ToolMethods.isEquals((Object)i.getTipoPagRetido(), (Object)0) || !ToolMethods.isEquals((Object)i.getTipoPagDifal(), (Object)0)) continue;
            TNFe.InfNFe.Pag.DetPag d = new TNFe.InfNFe.Pag.DetPag();
            d.setTPag(i.getTipoPagamentoNFe().getCodigo());
            if (!ToolMethods.isEquals((Object)i.getTipoPagamentoNFe().getCodigo(), (Object)"90")) {
                d.setVPag(this.formatarNumeros(i.getValor(), 2));
            } else {
                d.setVPag(this.formatarNumeros(0.0, 2));
            }
            if (ToolMethods.isEquals((Object)i.getTipoPagamentoNFe().getCodigo(), (Object)"99")) {
                d.setXPag("Outros");
            }
            if (i.getTipoPagamentoNFe().getExibirIndPag() != null && i.getTipoPagamentoNFe().getExibirIndPag().equals((short)1)) {
                short s = (short)(nf.getCondicaoPagamento().getNumeroParcelas() != 1 || nf.getCondicaoPagamento().getEntrada() != 1 ? 1 : 0);
            }
            if (i.getTipoPagamentoNFe().getCartaoDebCred().equals((short)1)) {
                TNFe.InfNFe.Pag.DetPag.Card c = new TNFe.InfNFe.Pag.DetPag.Card();
                if (i.getBandeiraCartaoNFe() != null) {
                    c.setTBand(i.getBandeiraCartaoNFe().getCodigo());
                }
                if (i.getTipoIntegracao() != null && i.getTipoIntegracao() != 0) {
                    c.setTpIntegra(i.getTipoIntegracao().toString());
                } else {
                    c.setTpIntegra("1");
                }
                if (i.getNrAutorizacao() != null && !i.getNrAutorizacao().isEmpty()) {
                    c.setCAut(i.getNrAutorizacao());
                }
                if (i.getCredenciadoraCreditoDebito() != null) {
                    c.setCNPJ(i.getCredenciadoraCreditoDebito().getComplemento().getCnpj());
                }
                d.setCard(c);
            }
            pagamentos.add(d);
        }
        return pagamentos;
    }

    private boolean existeTitulosNF(NotaFiscalPropria vo) {
        for (InfPagamentoNfPropria i : vo.getInfPagamentoNfPropria()) {
            Date dataVenc;
            if (i.getTitulos() == null || i.getTitulos().size() <= 0) continue;
            if (i.getTitulos().size() > 1) {
                return true;
            }
            if (i.getTitulos().size() != 1) continue;
            Titulo t = (Titulo)i.getTitulos().get(0);
            Date dataEmissaoNF = ToolDate.dataSemHora((Date)vo.getDataEmissaoNota());
            if (ToolMethods.isEquals((Object)dataEmissaoNF, (Object)(dataVenc = ToolDate.dataSemHora((Date)t.getDataVencimento())))) continue;
            return true;
        }
        return false;
    }

    private String getValoresFCP(NotaFiscalPropria nf) {
        String str;
        Double valorFCP = 0.0;
        Double valorFCPSt = 0.0;
        Double valorFCPStRetido = 0.0;
        for (ItemNotaFiscalPropria i : nf.getItensNotaPropria()) {
            valorFCP = valorFCP + i.getItemNotaLivroFiscal().getValorFCP();
            valorFCPSt = valorFCPSt + i.getItemNotaLivroFiscal().getValorFCPSt();
            valorFCPStRetido = valorFCPStRetido + i.getItemNotaLivroFiscal().getValorFCPStRetido();
        }
        StringBuilder sb = new StringBuilder();
        if (valorFCP > 0.0) {
            sb.append("Vr FCP: ");
            sb.append(ContatoFormatUtil.formataNumero((Number)valorFCP, (int)2));
            sb.append(";");
        }
        if (valorFCPSt > 0.0) {
            sb.append("Vr FCP ST: ");
            sb.append(ContatoFormatUtil.formataNumero((Number)valorFCPSt, (int)2));
            sb.append(";");
        }
        if (valorFCPStRetido > 0.0) {
            sb.append("Vr FCP ST Retido: ");
            sb.append(ContatoFormatUtil.formataNumero((Number)valorFCPStRetido, (int)2));
            sb.append(";");
        }
        str = (str = sb.toString()) != null && str.trim().length() > 0 ? str.trim() : "";
        return str;
    }

    private Collection<? extends TNFe.InfNFe.Det.Prod.Rastro> getRastro(List<GradeItemNotaFiscalPropria> grades) {
        ItemNotaFiscalPropria i;
        ArrayList<TNFe.InfNFe.Det.Prod.Rastro> lista = new ArrayList<TNFe.InfNFe.Det.Prod.Rastro>();
        for (GradeItemNotaFiscalPropria g : grades) {
            if (g.getLoteFabricacao() == null || !g.getLoteFabricacao().getUnico().equals((short)0) || g.getLoteFabricacao().getDataFabricacao() == null || g.getLoteFabricacao().getDataValidade() == null) continue;
            LoteFabricacao lote = g.getLoteFabricacao();
            TNFe.InfNFe.Det.Prod.Rastro r = new TNFe.InfNFe.Det.Prod.Rastro();
            r.setNLote(lote.getLoteFabricacao());
            if (r.getNLote().trim().length() > 20) {
                r.setNLote(r.getNLote().substring(0, 19).trim());
            }
            r.setDFab(this.formatarData(lote.getDataFabricacao(), "yyyy-MM-dd"));
            r.setDVal(this.formatarData(lote.getDataValidade(), "yyyy-MM-dd"));
            r.setQLote(this.formatarNumeros(g.getQuantidade(), 3));
            if (lote.getCodigoAgregacao() != null && lote.getCodigoAgregacao().trim().length() > 0) {
                r.setCAgreg(lote.getCodigoAgregacao());
            }
            lista.add(r);
        }
        if (!ToolMethods.isWithData(lista) && ToolMethods.isWithData(grades) && ToolMethods.isStrWithData((String)(i = grades.get(0).getItemNotaFiscalPropria()).getNrLoteFabricacao()) && i.getDataFabricacao() != null && i.getDataValidade() != null) {
            TNFe.InfNFe.Det.Prod.Rastro r = new TNFe.InfNFe.Det.Prod.Rastro();
            r.setNLote(i.getNrLoteFabricacao());
            if (r.getNLote().trim().length() > 20) {
                r.setNLote(r.getNLote().substring(0, 19));
            }
            r.setDFab(this.formatarData(i.getDataFabricacao(), "yyyy-MM-dd"));
            r.setDVal(this.formatarData(i.getDataValidade(), "yyyy-MM-dd"));
            r.setQLote(this.formatarNumeros(i.getQuantidadeTotal(), 3));
            lista.add(r);
        }
        return lista;
    }

    private TNFe.InfNFe.Det.Prod.Med getMed(Produto produto) {
        if (produto.getTipoMedicamento() != null) {
            TNFe.InfNFe.Det.Prod.Med p = new TNFe.InfNFe.Det.Prod.Med();
            p.setCProdANVISA(produto.getCodAnvisa());
            p.setVPMC(this.formatarNumeros(produto.getValorMaximoConsumo(), 2));
            if (produto.getCodAnvisa().equalsIgnoreCase("ISENTO")) {
                // empty if block
            }
            return p;
        }
        return null;
    }

    private TNFe.InfNFe.Det.ImpostoDevol getImpostoDevol(ItemNotaFiscalPropria i) {
        if (i.getItemNotaLivroFiscal().getValorIpiDevolucao() > 0.0) {
            TNFe.InfNFe.Det.ImpostoDevol id = new TNFe.InfNFe.Det.ImpostoDevol();
            id.setPDevol(this.formatarNumeros(i.getItemNotaLivroFiscal().getPercIpiDevolucao(), 2));
            TNFe.InfNFe.Det.ImpostoDevol.IPI ipi = new TNFe.InfNFe.Det.ImpostoDevol.IPI();
            ipi.setVIPIDevol(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorIpiDevolucao(), 2));
            id.setIPI(ipi);
            return id;
        }
        return null;
    }

    private String getNomeProdutoParametrizacaoNomeXML(Cliente cliente, Produto produto, String nome) {
        if (this.opcoesFaturamentoCliente == null) {
            return nome;
        }
        if (ToolMethods.isEquals((Object)this.opcoesFaturamentoCliente.getAplicarTodoCliente(), (Object)1)) {
            for (ParamNomeclaturaProdutoXML p : this.opcoesFaturamentoCliente.getProdutos()) {
                for (ItemParamNomeclaturaProdutoXML item : p.getItens()) {
                    if (!ToolMethods.isEquals((Object)item.getProduto(), (Object)produto) || ToolMethods.isEquals((Object)item.getConcatInfAddProduto(), (Object)1)) continue;
                    return item.getDescricao();
                }
            }
        }
        if (ToolMethods.isEquals((Object)this.opcoesFaturamentoCliente.getAplicarTodoCliente(), (Object)0)) {
            for (ParamNomeclaturaProdutoXML p : this.opcoesFaturamentoCliente.getProdutos()) {
                if (!ToolMethods.isEquals((Object)p.getCliente(), (Object)cliente)) continue;
                for (ItemParamNomeclaturaProdutoXML item : p.getItens()) {
                    if (!ToolMethods.isEquals((Object)item.getProduto(), (Object)produto) || ToolMethods.isEquals((Object)item.getConcatInfAddProduto(), (Object)1)) continue;
                    return item.getDescricao();
                }
            }
        }
        return nome;
    }

    private Double getIndiceAlteracao(Double indiceAlteracaoIcmsST) {
        if (indiceAlteracaoIcmsST != null && indiceAlteracaoIcmsST >= 1.0) {
            indiceAlteracaoIcmsST = indiceAlteracaoIcmsST * 100.0;
            indiceAlteracaoIcmsST = indiceAlteracaoIcmsST - 100.0;
        } else if (indiceAlteracaoIcmsST != null && indiceAlteracaoIcmsST > 0.0 && indiceAlteracaoIcmsST < 1.0) {
            indiceAlteracaoIcmsST = indiceAlteracaoIcmsST * 100.0;
        }
        return indiceAlteracaoIcmsST;
    }

    private TInfRespTec getInfRespTec(NotaFiscalPropria nf) {
        TInfRespTec t = new TInfRespTec();
        t.setCNPJ(ConstantsNFeResponsavelTecnico.CNPJ);
        t.setXContato(ConstantsNFeResponsavelTecnico.CONTATO);
        t.setEmail(ConstantsNFeResponsavelTecnico.EMAIL);
        t.setFone(ConstantsNFeResponsavelTecnico.TELEFONE);
        return t;
    }

    private void atualizarNotasEnviadas(LoteFaturamentoNFe lote, TProtNFe tProtNFe, Usuario usuario, Grupo grupoUsuarios, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento opcoesRelacionamento, OpcoesFinanceiras of) throws ExceptionService, NFeException {
        if (tProtNFe == null) {
            return;
        }
        for (NotaFiscalPropria nf : lote.getNotasFiscais()) {
            if (tProtNFe == null || tProtNFe.getInfProt() == null || !nf.getChaveNFE().equalsIgnoreCase(tProtNFe.getInfProt().getChNFe())) continue;
            new AuxProcessaDados_V400().atualizarConteudoAprovacao(tProtNFe, nf, usuario, grupoUsuarios, opcoesFaturamento, opcoesRelacionamento, of);
        }
    }

    private List<ItemNotaFiscalPropria> ordenarItensPorNrSequencial(List<ItemNotaFiscalPropria> itensNotaPropria) {
        if (itensNotaPropria != null) {
            Collections.sort(itensNotaPropria, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    ItemNotaFiscalPropria item1 = (ItemNotaFiscalPropria)o1;
                    ItemNotaFiscalPropria item2 = (ItemNotaFiscalPropria)o2;
                    return item1.getNumeroItem().compareTo(item2.getNumeroItem());
                }
            });
            return itensNotaPropria;
        }
        return new ArrayList<ItemNotaFiscalPropria>();
    }

    private List<Titulo> getOrdenarTitulosPorDataVencimento(List<Titulo> titulosOrdenados) {
        if (titulosOrdenados != null) {
            Collections.sort(titulosOrdenados, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    Titulo item1 = (Titulo)o1;
                    Titulo item2 = (Titulo)o2;
                    return item1.getDataVencimento().compareTo(item2.getDataVencimento());
                }
            });
            return titulosOrdenados;
        }
        return new ArrayList<Titulo>();
    }

    private TNFe.InfNFe.InfIntermed getInfIntermed(NotaFiscalPropria nf) {
        if (!ToolMethods.isEquals((Object)EnumConstNFeIndIntermediador.valueOfCodigo((Short)nf.getTipoIntermediadorComercial()), (Object)EnumConstNFeIndIntermediador.PLATAFORMA_TERCEIROS)) {
            return null;
        }
        TNFe.InfNFe.InfIntermed inf = new TNFe.InfNFe.InfIntermed();
        inf.setCNPJ(ToolString.onlyNumbers((String)nf.getIntermediadorComercial().getPessoa().getComplemento().getCnpj()));
        inf.setIdCadIntTran(nf.getIntermediadorComercial().getIdentificacaoIntermediador());
        return inf;
    }

    private String getCodigoBarrasParametrizacaoNomeXML(Cliente cliente, Produto produto, Short tipoCodigoBarras) {
        if (this.opcoesFaturamentoCliente == null) {
            return "";
        }
        if (ToolMethods.isEquals((Object)this.opcoesFaturamentoCliente.getAplicarTodoCliente(), (Object)1)) {
            for (ParamNomeclaturaProdutoXML p : this.opcoesFaturamentoCliente.getProdutos()) {
                for (ItemParamNomeclaturaProdutoXML item : p.getItens()) {
                    if (!ToolMethods.isEquals((Object)item.getProduto(), (Object)produto)) continue;
                    if (ToolMethods.isEquals((Object)tipoCodigoBarras, (Object)CODIGO_BARRAS_EAN) && ToolMethods.isStrWithData((String)item.getCodigoBarrasEan())) {
                        return item.getCodigoBarrasEan();
                    }
                    if (!ToolMethods.isEquals((Object)tipoCodigoBarras, (Object)CODIGO_BARRAS_EAN_TRIB) || !ToolMethods.isStrWithData((String)item.getCodigoBarrasEanTrib())) continue;
                    return item.getCodigoBarrasEanTrib();
                }
            }
        }
        if (ToolMethods.isEquals((Object)this.opcoesFaturamentoCliente.getAplicarTodoCliente(), (Object)0)) {
            for (ParamNomeclaturaProdutoXML p : this.opcoesFaturamentoCliente.getProdutos()) {
                if (!ToolMethods.isEquals((Object)p.getCliente(), (Object)cliente)) continue;
                for (ItemParamNomeclaturaProdutoXML item : p.getItens()) {
                    if (!ToolMethods.isEquals((Object)item.getProduto(), (Object)produto)) continue;
                    if (ToolMethods.isEquals((Object)tipoCodigoBarras, (Object)CODIGO_BARRAS_EAN) && ToolMethods.isStrWithData((String)item.getCodigoBarrasEan())) {
                        return item.getCodigoBarrasEan();
                    }
                    if (!ToolMethods.isEquals((Object)tipoCodigoBarras, (Object)CODIGO_BARRAS_EAN_TRIB) || !ToolMethods.isStrWithData((String)item.getCodigoBarrasEanTrib())) continue;
                    return item.getCodigoBarrasEanTrib();
                }
            }
        }
        return "";
    }

    private String getInfAdicionalProdutoParametrizacaoNomeXML(Cliente cliente, Produto produto) {
        if (this.opcoesFaturamentoCliente == null) {
            return "";
        }
        if (ToolMethods.isEquals((Object)this.opcoesFaturamentoCliente.getAplicarTodoCliente(), (Object)1)) {
            for (ParamNomeclaturaProdutoXML p : this.opcoesFaturamentoCliente.getProdutos()) {
                for (ItemParamNomeclaturaProdutoXML item : p.getItens()) {
                    if (!ToolMethods.isEquals((Object)item.getProduto(), (Object)produto) || !ToolMethods.isEquals((Object)item.getConcatInfAddProduto(), (Object)1)) continue;
                    return item.getDescricao();
                }
            }
        }
        if (ToolMethods.isEquals((Object)this.opcoesFaturamentoCliente.getAplicarTodoCliente(), (Object)0)) {
            for (ParamNomeclaturaProdutoXML p : this.opcoesFaturamentoCliente.getProdutos()) {
                if (!ToolMethods.isEquals((Object)p.getCliente(), (Object)cliente)) continue;
                for (ItemParamNomeclaturaProdutoXML item : p.getItens()) {
                    if (!ToolMethods.isEquals((Object)item.getProduto(), (Object)produto) || !ToolMethods.isEquals((Object)item.getConcatInfAddProduto(), (Object)1)) continue;
                    return item.getDescricao();
                }
            }
        }
        return "";
    }

    private TNFe.InfNFe.Det.ObsItem getObsItem(ItemNotaFiscalPropria i) {
        String conteudo;
        TNFe.InfNFe.Det.ObsItem.ObsCont ob;
        if (!ToolMethods.isWithData((Collection)i.getObsItemNotaPropriaContribuinte()) && !ToolMethods.isWithData((Collection)i.getObsItemNotaPropriaFisco())) {
            return null;
        }
        TNFe.InfNFe.Det.ObsItem obs = new TNFe.InfNFe.Det.ObsItem();
        for (ObsItemNotaPropriaContribuinte contrib : i.getObsItemNotaPropriaContribuinte()) {
            if (!ToolMethods.isStrWithData((String)contrib.getObsFaturamento().getChave())) continue;
            ob = new TNFe.InfNFe.Det.ObsItem.ObsCont();
            ob.setXCampo(contrib.getObsFaturamento().getChave());
            conteudo = this.refinaXML(contrib.getConteudo());
            if (conteudo.trim().length() > 60) {
                conteudo = conteudo.substring(0, 60);
            }
            ob.setXTexto(conteudo);
            obs.setObsCont(ob);
            break;
        }
        for (ObsItemNotaPropriaFisco fisco : i.getObsItemNotaPropriaFisco()) {
            if (!ToolMethods.isStrWithData((String)fisco.getObsFaturamento().getChave())) continue;
            ob = new TNFe.InfNFe.Det.ObsItem.ObsFisco();
            ob.setXCampo(fisco.getObsFaturamento().getChave());
            conteudo = this.refinaXML(fisco.getConteudo());
            if (conteudo.trim().length() > 60) {
                conteudo = conteudo.substring(0, 60);
            }
            ob.setXTexto(conteudo);
            obs.setObsFisco((TNFe.InfNFe.Det.ObsItem.ObsFisco)ob);
            break;
        }
        if (obs.getObsCont() == null && obs.getObsFisco() == null) {
            return null;
        }
        return obs;
    }

    private Boolean getEnvioSincrono(LoteFaturamentoNFe l, List<ConfConexaoNFeUF> confConexaoNFeUf, int uf) {
        if (l.getNotasFiscais().size() > 1) {
            return false;
        }
        short codEmissaoNFe = l.getPeriodoEmissaoNfe().getTipoEmissaoNfe().getCodigo();
        if (codEmissaoNFe == 2 || codEmissaoNFe == 5 || codEmissaoNFe == 4) {
            codEmissaoNFe = 1;
        }
        for (ConfConexaoNFeUF c : confConexaoNFeUf) {
            if (c.getTipoEmissaoNFe().getCodigo() != codEmissaoNFe) continue;
            return ToolMethods.isEquals((Object)c.getSincrono(), (Object)1);
        }
        return true;
    }

    private Collection<? extends TNFe.InfNFe.Det.Prod.DetExport> getDetExport(ItemNotaFiscalPropria i) {
        ArrayList<TNFe.InfNFe.Det.Prod.DetExport> lista = new ArrayList<TNFe.InfNFe.Det.Prod.DetExport>();
        for (ItemNotaExportacao itemExp : i.getItensExportacao()) {
            TNFe.InfNFe.Det.Prod.DetExport p = new TNFe.InfNFe.Det.Prod.DetExport();
            p.setNDraw(itemExp.getNrAtoConcessorioDrawback());
            TNFe.InfNFe.Det.Prod.DetExport.ExportInd ex = new TNFe.InfNFe.Det.Prod.DetExport.ExportInd();
            ex.setChNFe(itemExp.getChaveNFeRecExportacao());
            ex.setNRE(itemExp.getNrRegistroExportacao());
            ex.setQExport(this.formatarNumeros(i.getQuantidadeTotal(), 4));
            p.setExportInd(ex);
            lista.add(p);
        }
        return lista;
    }

    private TNFe.InfNFe.Agropecuario getAgropecuario(NotaFiscalPropria nf) {
        if (ToolMethods.isWithData((Collection)nf.getReceitasAgronomicas())) {
            TNFe.InfNFe.Agropecuario agrop = new TNFe.InfNFe.Agropecuario();
            for (DadosRecAgrNfPropria r : nf.getReceitasAgronomicas()) {
                if (r.getNrReceitaAgro() <= 0L || !ToolMethods.isStrWithData((String)r.getCpfTecnicoReceita())) continue;
                TNFe.InfNFe.Agropecuario.Defensivo d = new TNFe.InfNFe.Agropecuario.Defensivo();
                d.setCPFRespTec(r.getCpfTecnicoReceita());
                d.setNReceituario(r.getNrReceitaAgro().toString());
                agrop.getDefensivo().add(d);
            }
            if (ToolMethods.isWithData((Collection)agrop.getDefensivo())) {
                return agrop;
            }
        }
        return null;
    }
}

