/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.nfesefaz.versao400;

import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaPropriaCbs;
import com.touchcomp.basementor.model.vo.ItemNotaPropriaIbs;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import javax.xml.bind.JAXBElement;
import mentorcore.service.impl.nfesefaz.versao400.UtilSefazNFeLoteFatNFe_V400;
import nfe.versao400.model.ObjectFactory;
import nfe.versao400.model.TCIBS;
import nfe.versao400.model.TCredPres;
import nfe.versao400.model.TEstornoCred;
import nfe.versao400.model.TIBSCBSMonoTot;
import nfe.versao400.model.TISTot;
import nfe.versao400.model.TNFe;
import nfe.versao400.model.TRed;
import nfe.versao400.model.TTribNFe;
import nfe.versao400.model.TTribRegular;

public class UtilSefazNFeLoteFatNFe_V400CbsIbs {
    UtilSefazNFeLoteFatNFe_V400 instance;
    OpcoesFaturamento opcoesFaturamento;

    public UtilSefazNFeLoteFatNFe_V400CbsIbs(UtilSefazNFeLoteFatNFe_V400 instance, OpcoesFaturamento opcoesFaturamento) {
        this.instance = instance;
        this.opcoesFaturamento = opcoesFaturamento;
    }

    void setInfoTotalCbsIbs(NotaFiscalPropria nfPropria, TNFe.InfNFe.Total t, Double valorTotal, Double valorTotalServico) {
        TISTot tt;
        if (!ToolMethods.isAffirmative((Number)nfPropria.getInformarDadosReformaTributaria())) {
            return;
        }
        double valorTotalCbs = 0.0;
        double valorTotalIbsMun = 0.0;
        double valorTotalIbsUF = 0.0;
        double valorTotalIs = 0.0;
        double valorTotalBC = 0.0;
        double valorTotalCredPresCBS = 0.0;
        for (ItemNotaFiscalPropria vo : nfPropria.getItensNotaPropria()) {
            if (vo.getImpostoCBS() != null) {
                valorTotalCbs += vo.getImpostoCBS().getValorCBS().doubleValue();
                valorTotalCredPresCBS += vo.getImpostoCBS().getValorCredPresCBS().doubleValue();
            }
            if (vo.getImpostoIBS() != null) {
                valorTotalIbsMun += vo.getImpostoIBS().getValorIBSMun().doubleValue();
                valorTotalIbsUF += vo.getImpostoIBS().getValorIBSUF().doubleValue();
                valorTotalBC += vo.getImpostoIBS().getValorBaseCalcIBS().doubleValue();
            }
            if (vo.getImpostoSeletivo() == null) continue;
            valorTotalIs += vo.getImpostoSeletivo().getValorIS().doubleValue();
        }
        if (valorTotalIs > 0.0) {
            tt = new TISTot();
            tt.setVIS(this.instance.formatarNumeros(valorTotalIs, 2));
            t.setISTot(tt);
        }
        tt = new TIBSCBSMonoTot();
        tt.setVBCIBSCBS(this.instance.formatarNumeros(valorTotalBC, 2));
        TIBSCBSMonoTot.GIBS gibs = new TIBSCBSMonoTot.GIBS();
        gibs.setVIBS(this.instance.formatarNumeros(valorTotalIbsMun + valorTotalIbsUF, 2));
        gibs.setVCredPres(this.instance.formatarNumeros(0.0, 2));
        gibs.setVCredPresCondSus(this.instance.formatarNumeros(0.0, 2));
        TIBSCBSMonoTot.GIBS.GIBSUF gibsUF = new TIBSCBSMonoTot.GIBS.GIBSUF();
        gibsUF.setVIBSUF(this.instance.formatarNumeros(valorTotalIbsUF, 2));
        gibsUF.setVDif(this.instance.formatarNumeros(0.0, 2));
        gibsUF.setVDevTrib(this.instance.formatarNumeros(0.0, 2));
        gibs.setGIBSUF(gibsUF);
        TIBSCBSMonoTot.GIBS.GIBSMun gibsMun = new TIBSCBSMonoTot.GIBS.GIBSMun();
        gibsMun.setVIBSMun(this.instance.formatarNumeros(valorTotalIbsMun, 2));
        gibsMun.setVDif(this.instance.formatarNumeros(0.0, 2));
        gibsMun.setVDevTrib(this.instance.formatarNumeros(0.0, 2));
        gibs.setGIBSMun(gibsMun);
        tt.setGIBS(gibs);
        TIBSCBSMonoTot.GCBS cbs = new TIBSCBSMonoTot.GCBS();
        cbs.setVCBS(this.instance.formatarNumeros(valorTotalCbs, 2));
        cbs.setVCredPres(this.instance.formatarNumeros(valorTotalCredPresCBS, 2));
        cbs.setVCredPresCondSus(this.instance.formatarNumeros(0.0, 2));
        cbs.setVDif(this.instance.formatarNumeros(0.0, 2));
        cbs.setVDevTrib(this.instance.formatarNumeros(0.0, 2));
        tt.setGCBS(cbs);
        t.setIBSCBSTot((TIBSCBSMonoTot)tt);
        t.setVNFTot(this.instance.formatarNumeros(nfPropria.getValoresNfPropria().getValorTotalDoc(), 2));
    }

    void setTotalItem(TNFe.InfNFe.Det d, ItemNotaFiscalPropria i) {
        if (!ToolMethods.isAffirmative((Number)i.getNotaFiscalPropria().getInformarDadosReformaTributaria())) {
            return;
        }
        if (i.getImpostoCBS() == null || i.getImpostoIBS() == null) {
            return;
        }
        d.setVItem(this.instance.formatarNumeros(i.getItemNotaLivroFiscal().getValorTotalItemDoc(), 2));
    }

    void setInfoItem(TNFe.InfNFe.Det.Imposto imp, ItemNotaFiscalPropria i) {
        if (!ToolMethods.isAffirmative((Number)i.getNotaFiscalPropria().getInformarDadosReformaTributaria())) {
            return;
        }
        if (i.getImpostoCBS() == null || i.getImpostoIBS() == null) {
            return;
        }
        TTribNFe t = new TTribNFe();
        t.setCST(i.getImpostoCBS().getIncidenciaTributaria().getCodigo());
        t.setCClassTrib(i.getImpostoCBS().getIncidenciaTributariaClass().getCodigo());
        JAXBElement j = new ObjectFactory().createTNFeInfNFeDetImpostoIBSCBS(t);
        if (ToolMethods.isAffirmative((Number)i.getImpostoCBS().getIncidenciaTributariaClass().getCalcularCbsIbs())) {
            t.setGIBSCBS(this.getGIBSCBS(i.getImpostoIBS(), i.getImpostoCBS()));
        }
        if (ToolMethods.isAffirmative((Number)i.getImpostoCBS().getIncidenciaTributariaClass().getIndGrupoTribEstCredito())) {
            t.setGEstornoCred(this.getGEstornoCredCBSIBS(i.getImpostoIBS(), i.getImpostoCBS()));
        }
        imp.getContent().add(j);
    }

    private TCIBS getGIBSCBS(ItemNotaPropriaIbs impostoIBS, ItemNotaPropriaCbs impostoCBS) {
        TCIBS t = new TCIBS();
        t.setVBC(this.instance.formatarNumeros(impostoIBS.getValorBaseCalcIBS(), 2));
        if (impostoCBS != null) {
            t.setGCBS(this.getGCBS(impostoCBS));
        }
        t.setGIBSMun(this.getGIBSMun(impostoIBS));
        t.setGIBSUF(this.getGIBSUF(impostoIBS));
        if (ToolMethods.isAffirmative((Number)impostoCBS.getIncidenciaTributariaClass().getIndGrupoTribReg())) {
            t.setGTribRegular(this.getGTribRegular(impostoCBS, impostoIBS));
        }
        if (ToolMethods.isAffirmative((Number)impostoCBS.getIncidenciaTributariaClass().getIndGrupoTribCredPresumido())) {
            t.setGCBSCredPres(this.getGCBSCredPresmido(impostoCBS));
            t.setGIBSCredPres(this.getGIBSCredPresmido(impostoIBS));
        }
        t.setVIBS(this.instance.formatarNumeros(impostoIBS.getValorIBSMun() + impostoIBS.getValorIBSUF(), 2));
        return t;
    }

    private TCIBS.GCBS getGCBS(ItemNotaPropriaCbs impostoCBS) {
        TCIBS.GCBS g = new TCIBS.GCBS();
        g.setVCBS(this.instance.formatarNumeros(impostoCBS.getValorCBS(), 2));
        g.setPCBS(this.instance.formatarNumeros(impostoCBS.getAliquotaCBS(), 4));
        if (impostoCBS.getPercRedAliquotaCBS() > 0.0) {
            g.setGRed(this.getGRed(impostoCBS.getPercRedAliquotaCBS(), impostoCBS.getAliquotaEfetivaCBS()));
        }
        return g;
    }

    private TCIBS.GIBSMun getGIBSMun(ItemNotaPropriaIbs impostoIBS) {
        TCIBS.GIBSMun g = new TCIBS.GIBSMun();
        g.setVIBSMun(this.instance.formatarNumeros(impostoIBS.getValorIBSMun(), 2));
        g.setPIBSMun(this.instance.formatarNumeros(impostoIBS.getAliquotaIBSMun(), 4));
        if (impostoIBS.getPercRedAliquotaIBSMun() > 0.0) {
            g.setGRed(this.getGRed(impostoIBS.getPercRedAliquotaIBSMun(), impostoIBS.getAliquotaEfetivaIBSMun()));
        }
        return g;
    }

    private TCIBS.GIBSUF getGIBSUF(ItemNotaPropriaIbs impostoIBS) {
        TCIBS.GIBSUF g = new TCIBS.GIBSUF();
        g.setVIBSUF(this.instance.formatarNumeros(impostoIBS.getValorIBSUF(), 2));
        g.setPIBSUF(this.instance.formatarNumeros(impostoIBS.getAliquotaIBSUF(), 4));
        if (impostoIBS.getPercRedAliquotaIBSUF() > 0.0) {
            g.setGRed(this.getGRed(impostoIBS.getPercRedAliquotaIBSUF(), impostoIBS.getAliquotaEfetivaIBSUF()));
        }
        return g;
    }

    private TTribRegular getGTribRegular(ItemNotaPropriaCbs impostoCBS, ItemNotaPropriaIbs impostoIBS) {
        TTribRegular t = new TTribRegular();
        t.setCClassTribReg(impostoCBS.getIncidenciaTributariaClassReg().getCodigo());
        t.setCSTReg(impostoCBS.getIncidenciaTributariaReg().getCodigo());
        t.setPAliqEfetRegCBS(this.instance.formatarNumeros(impostoCBS.getAliquotaEfetivaCBSReg(), 4));
        t.setVTribRegCBS(this.instance.formatarNumeros(impostoCBS.getValorCBSReg(), 2));
        t.setPAliqEfetRegIBSMun(this.instance.formatarNumeros(impostoIBS.getAliquotaEfetivaIBSMunReg(), 4));
        t.setVTribRegIBSMun(this.instance.formatarNumeros(impostoIBS.getValorIBSMunReg(), 2));
        t.setPAliqEfetRegIBSUF(this.instance.formatarNumeros(impostoIBS.getAliquotaEfetivaIBSUFReg(), 4));
        t.setVTribRegIBSUF(this.instance.formatarNumeros(impostoIBS.getValorIBSUFReg(), 2));
        return t;
    }

    private TRed getGRed(Double percRedAliquota, Double aliquotaEfetiva) {
        TRed t = new TRed();
        t.setPRedAliq(this.instance.formatarNumeros(percRedAliquota, 4));
        t.setPAliqEfet(this.instance.formatarNumeros(aliquotaEfetiva, 4));
        return t;
    }

    private TCredPres getGCBSCredPresmido(ItemNotaPropriaCbs impostoCBS) {
        TCredPres t = new TCredPres();
        t.setPCredPres(this.instance.formatarNumeros(impostoCBS.getAliquotaCredPresumidoCBS(), 4));
        t.setVCredPres(this.instance.formatarNumeros(impostoCBS.getValorCredPresCBS(), 2));
        return t;
    }

    private TCredPres getGIBSCredPresmido(ItemNotaPropriaIbs impostoIBS) {
        TCredPres t = new TCredPres();
        t.setPCredPres(this.instance.formatarNumeros(0.0, 4));
        t.setVCredPres(this.instance.formatarNumeros(0.0, 2));
        return t;
    }

    private TEstornoCred getGEstornoCredCBSIBS(ItemNotaPropriaIbs impostoIBS, ItemNotaPropriaCbs impostoCBS) {
        TEstornoCred t = new TEstornoCred();
        t.setvCBSEstCred(this.instance.formatarNumeros(impostoCBS.getValorEstornoCreditoCbs(), 2));
        t.setvIBSEstCred(this.instance.formatarNumeros(impostoIBS.getValorEstornoCreditoIbsMun() + impostoIBS.getValorEstornoCreditoIbsUF(), 2));
        return t;
    }
}

