/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.nfse.util;

import com.touchcomp.basementor.model.vo.LoteRps;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionFileManipulation;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.nfse.UtilNFSeBuildText;

public class UtilEmailNFSe {
    private static TLogger logger = TLogger.get(UtilEmailNFSe.class);

    public void sendEmailNFSe(LoteRps loteRps, OpcoesRelacionamento opRel) {
        for (Rps r : loteRps.getRps()) {
            if (r.getNumeroNFse() == null || r.getNumeroNFse() <= 0L) continue;
            try {
                Email email = UtilEmailNFSe.criarEmail(r, opRel);
                ToolSendEmail.sendEmailWithException((Email)email);
            }
            catch (Exception ex) {
                logger.error(ex.getClass(), (Throwable)ex);
            }
        }
    }

    public static Email criarEmail(Rps r, OpcoesRelacionamento opcoesRel) throws IOException {
        Email email = null;
        OpcoesRelacionamento op = opcoesRel;
        if (op != null && op.getServidorEmailNFSe() != null && op.getModeloEmailNFSe() != null) {
            try {
                if (UtilEmailNFSe.validarEnvioEmail(r)) {
                    ServidorEmail servidorEmail = op.getServidorEmailNFSe();
                    email = new Email(true);
                    email.setRemetente(servidorEmail.getEmail());
                    email.addDestinatarios(new String[]{r.getEmail()});
                    String aux = op.getEmailCopiaNFSe();
                    if (op.getEnviarCopiaNFSe() != null && op.getEnviarCopiaNFSe() == 1 && aux != null && aux.trim().length() > 0) {
                        email.addDestinatarios(new String[]{aux});
                    }
                    email.setAssunto(op.getModeloEmailNFSe().getTituloEmail());
                    String texto = UtilEmailNFSe.getTextoEmail(new String(op.getModeloEmailNFSe().getModelo()), r);
                    texto = texto.replace("\n", "<BR>");
                    email.setCorpoMensagem(texto);
                    email.setServidor(new Email.ServidorEmail(servidorEmail.getServidor(), servidorEmail.getServidorImap(), servidorEmail.getServidorPop(), servidorEmail.getEmail(), servidorEmail.getSenha(), servidorEmail.getPortaEmail(), servidorEmail.getNaoAutenticarEmail(), servidorEmail.getLogin(), servidorEmail.getServerProperties(), servidorEmail.getGerarArquivoExtensaoEml(), servidorEmail.getDebugServer()));
                    email.addAnexos(UtilEmailNFSe.getAnexos(r));
                    email.setZiparAnexos(servidorEmail.getZiparEmails() != null && servidorEmail.getZiparEmails() == 1);
                }
            }
            catch (ExceptionFileManipulation | ExceptionService ex) {
                logger.error(ex.getMessage());
                return null;
            }
        }
        return email;
    }

    private static boolean validarEnvioEmail(Rps r) throws ExceptionService {
        if (r.getEmail() == null) {
            return false;
        }
        return !r.getEmail().isEmpty();
    }

    private static String getTextoEmail(String modelo, Rps r) {
        List tokens = ToolString.getReplaceTokens((String)modelo);
        HashMap<String, String> values = new HashMap<String, String>();
        for (Object o : tokens) {
            StringToken tk = (StringToken)o;
            String value = UtilNFSeBuildText.getInstance().getValueEmail(tk.getChave(), r);
            values.put(tk.getChave(), value);
        }
        return ToolString.build((String)modelo, values);
    }

    private static List getAnexos(Rps r) throws IOException, ExceptionService, ExceptionFileManipulation {
        ArrayList<File> anexos = new ArrayList<File>();
        File f = UtilEmailNFSe.getNFSeXMLFile(r);
        if (f != null) {
            anexos.add(f);
        }
        return anexos;
    }

    public static File getNFSeXMLFile(Rps r) throws ExceptionFileManipulation {
        return CoreUtilityFactory.getUtilityNFe().recordToFileNFSe(r, System.getProperty("java.io.tmpdir"));
    }
}

