/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.notafiscalpropria.importarnfexml;

import com.touchcomp.basementor.constants.ConstantsNotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ModalidadeIcms;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class AuxImportarNotaPropriaICMS {
    private Namespace n = ConstantsNotaFiscalTerceiros.NAMESPACE_XML_NFE_X1;

    private Element getIcms(Element icms) {
        String[] compICMS;
        for (String cp : compICMS = new String[]{"00", "10", "20", "30", "40", "51", "60", "70", "90"}) {
            Element icmsInt = icms.getChild("ICMS" + cp, this.n);
            if (icmsInt == null) continue;
            return icmsInt;
        }
        return null;
    }

    public void valoresImpostosICMS(Element icms, ItemNotaFiscalPropria vo) throws ExceptionService {
        ModalidadeIcms modalidadeIcms;
        String modBC;
        if (icms == null) {
            return;
        }
        Element icmsInt = this.getIcms(icms);
        if (icmsInt == null) {
            return;
        }
        Double bcIcms = 0.0;
        Double aliqIcms = 0.0;
        Double percRedBC = 0.0;
        Double vrIcms = 0.0;
        if (icmsInt.getChildText("orig", this.n) != null && icmsInt.getChildText("CST", this.n) != null) {
            String origem = icmsInt.getChildText("orig", this.n);
            String cst = icmsInt.getChildText("CST", this.n);
            if (origem.trim().length() > 0 && cst.trim().length() > 0) {
                String inc = origem + cst;
                IncidenciaIcms incidenciaIcms = (IncidenciaIcms)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOIncidenciaIcms(), "codigo", inc, 0);
                if (incidenciaIcms != null) {
                    vo.setIncidenciaIcms(incidenciaIcms);
                }
            }
        }
        if (icmsInt.getChildText("modBC", this.n) != null && (modBC = icmsInt.getChildText("modBC", this.n)).trim().length() > 0 && (modalidadeIcms = (ModalidadeIcms)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOModalidadeIcms(), "codigo", modBC, 0)) != null) {
            vo.setModalidadeIcms(modalidadeIcms);
        }
        if (icmsInt.getChildText("vBC", this.n) != null) {
            bcIcms = new Double(icmsInt.getChildText("vBC", this.n));
        }
        if (icmsInt.getChildText("pICMS", this.n) != null) {
            aliqIcms = new Double(icmsInt.getChildText("pICMS", this.n));
        }
        if (icmsInt.getChildText("pRedBC", this.n) != null) {
            percRedBC = new Double(icmsInt.getChildText("pRedBC", this.n));
        }
        if (icmsInt.getChildText("vICMS", this.n) != null) {
            vrIcms = new Double(icmsInt.getChildText("vICMS", this.n));
        }
        vo.getItemNotaLivroFiscal().setVrIcms(Double.valueOf(0.0));
        vo.getItemNotaLivroFiscal().setAliquotaIcms(Double.valueOf(0.0));
        vo.getItemNotaLivroFiscal().setVrIcmsTributado(Double.valueOf(0.0));
        vo.getItemNotaLivroFiscal().setVrIcmsIsento(Double.valueOf(0.0));
        vo.getItemNotaLivroFiscal().setVrIcmsOutros(Double.valueOf(0.0));
        vo.getItemNotaLivroFiscal().setVrBcCalculoIcms(Double.valueOf(0.0));
        if (icmsInt.getName().equals("ICMS00") || icmsInt.getText().equals("ICMS10")) {
            vo.getItemNotaLivroFiscal().setVrIcms(vrIcms);
            vo.getItemNotaLivroFiscal().setAliquotaIcms(aliqIcms);
            vo.getItemNotaLivroFiscal().setVrIcmsTributado(bcIcms);
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcms(bcIcms);
        } else if (icmsInt.getName().equals("ICMS30") || icmsInt.getName().equals("ICMS40") || icmsInt.getName().equals("ICMS41")) {
            if (bcIcms > 0.0) {
                vo.getItemNotaLivroFiscal().setAliquotaIcms(aliqIcms);
                vo.getItemNotaLivroFiscal().setVrIcmsOutros(bcIcms);
                vo.getItemNotaLivroFiscal().setVrBcCalculoIcms(bcIcms);
                vo.getItemNotaLivroFiscal().setVrIcms(Double.valueOf(0.0));
            } else {
                vo.getItemNotaLivroFiscal().setAliquotaIcms(Double.valueOf(0.0));
                vo.getItemNotaLivroFiscal().setVrIcmsOutros(vo.getVrProduto());
                vo.getItemNotaLivroFiscal().setVrBcCalculoIcms(vo.getVrProduto());
                vo.getItemNotaLivroFiscal().setVrIcms(Double.valueOf(0.0));
            }
        } else if (icmsInt.getName().equals("ICMS50") || icmsInt.getName().equals("ICMS51") || icmsInt.getName().equals("ICMS60")) {
            if (bcIcms > 0.0) {
                vo.getItemNotaLivroFiscal().setAliquotaIcms(aliqIcms);
                vo.getItemNotaLivroFiscal().setVrIcmsOutros(bcIcms);
                vo.getItemNotaLivroFiscal().setVrBcCalculoIcms(bcIcms);
                vo.getItemNotaLivroFiscal().setVrIcms(Double.valueOf(0.0));
            } else {
                vo.getItemNotaLivroFiscal().setAliquotaIcms(Double.valueOf(0.0));
                vo.getItemNotaLivroFiscal().setVrIcmsOutros(vo.getVrProduto());
                vo.getItemNotaLivroFiscal().setVrBcCalculoIcms(vo.getVrProduto());
                vo.getItemNotaLivroFiscal().setVrIcms(Double.valueOf(0.0));
            }
        } else if (icmsInt.getName().equals("ICMS20") || icmsInt.getName().equals("ICMS70") || icmsInt.getName().equals("ICMS90")) {
            double vrReduz = 0.0;
            if (bcIcms > 0.0 && percRedBC > 0.0) {
                vrReduz = bcIcms * (percRedBC / 100.0);
            }
            vo.getItemNotaLivroFiscal().setVrIcmsTributado(Double.valueOf(bcIcms - vrReduz));
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcms(bcIcms);
            vo.getItemNotaLivroFiscal().setAliquotaIcms(aliqIcms);
            vo.getItemNotaLivroFiscal().setVrIcms(vrIcms);
            vo.getItemNotaLivroFiscal().setVrIcmsIsento(Double.valueOf(vrReduz));
        }
        this.setIcmsST(icmsInt, vo);
        if (!ToolMethods.isEquals((Object)vo.getModeloFiscal().getModeloFiscalIcms().getIncluiDespAcess(), (Object)1)) {
            vo.getItemNotaLivroFiscal().setVrIcmsOutros(Double.valueOf(vo.getItemNotaLivroFiscal().getVrIcmsOutros() + vo.getValorDespAcessoria()));
        }
        if (!ToolMethods.isEquals((Object)vo.getModeloFiscal().getModeloFiscalIcms().getIncluiDesconto(), (Object)1) && vo.getItemNotaLivroFiscal().getVrIcmsOutros() > 0.0) {
            vo.getItemNotaLivroFiscal().setVrIcmsOutros(Double.valueOf(vo.getItemNotaLivroFiscal().getVrIcmsOutros() - vo.getValorDesconto()));
        }
        if (!ToolMethods.isEquals((Object)vo.getModeloFiscal().getModeloFiscalIcms().getIncluiFrete(), (Object)1)) {
            vo.getItemNotaLivroFiscal().setVrIcmsOutros(Double.valueOf(vo.getItemNotaLivroFiscal().getVrIcmsOutros() + vo.getValorFrete()));
        }
        if (!ToolMethods.isEquals((Object)vo.getModeloFiscal().getModeloFiscalIcms().getIncluiSeguro(), (Object)1)) {
            vo.getItemNotaLivroFiscal().setVrIcmsOutros(Double.valueOf(vo.getItemNotaLivroFiscal().getVrIcmsOutros() + vo.getVrSeguro()));
        }
        double totIcms = vo.getItemNotaLivroFiscal().getVrIcmsOutros() + vo.getItemNotaLivroFiscal().getVrIcmsTributado() + vo.getItemNotaLivroFiscal().getVrIcmsIsento();
        double dif = vo.getItemNotaLivroFiscal().getValorTotal() - totIcms;
        if (dif > 0.0) {
            vo.getItemNotaLivroFiscal().setVrIcmsOutros(Double.valueOf(vo.getItemNotaLivroFiscal().getVrIcmsOutros() + dif));
        }
    }

    private void setIcmsST(Element icmsInt, ItemNotaFiscalPropria vo) {
        if (icmsInt.getChildText("vBCST", this.n) != null) {
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcmsSt(new Double(icmsInt.getChildText("vBCST", this.n)));
        }
        if (icmsInt.getChildText("pICMSST", this.n) != null) {
            vo.getItemNotaLivroFiscal().setAliquotaIcmsST(new Double(icmsInt.getChildText("pICMSST", this.n)));
        }
        if (icmsInt.getChildText("vICMSST", this.n) != null) {
            vo.getItemNotaLivroFiscal().setVrIcmsSt(new Double(icmsInt.getChildText("vICMSST", this.n)));
        }
        if (icmsInt.getChildText("vICMSSTRet", this.n) != null) {
            vo.getItemNotaLivroFiscal().setVrIcmsSt(new Double(icmsInt.getChildText("vICMSSTRet", this.n)));
        }
        if (icmsInt.getChildText("pMVAST", this.n) != null) {
            vo.getItemNotaLivroFiscal().setDescontoPadraoIcmsST(new Double(icmsInt.getChildText("pMVAST", this.n)));
        }
        if (icmsInt.getChildText("vBCSTRet", this.n) != null) {
            vo.getItemNotaLivroFiscal().setVrBcCalculoIcmsSt(new Double(icmsInt.getChildText("vBCSTRet", this.n)));
        }
    }
}

