/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.notafiscalpropria.importarnfexml;

import com.touchcomp.basementor.model.vo.ApuracaoValoresCooperados;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.TipoCooperado;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.notafiscalpropria.importarnfexml.UtilityApuracaoValoresCooperados;
import mentorcore.service.impl.notafiscalpropria.importarnfexml.UtilityGeracaoArquivoX8;
import mentorcore.service.impl.notafiscalpropria.importarnfexml.UtilityGerarBaixasApuracaoValores;

public class CoreServiceApuracaoValoresCooperado
extends CoreService {
    public static final String APURAR_VALORES_COOPERADO = "apurarValoresCooperado";
    public static final String GERACAO_ARQUIVO_X8 = "geracaoArquivoX8";
    public static final String SALVAR_AND_GERAR_BAIXA = "salvarAndGerarBaixas";
    public static final String PESQUISAR_ULTIMA_APURACAO_POR_EMPRESA = "pesquisarUltimaApuracaoPorEmpresa";

    public List apurarValoresCooperado(CoreRequestContext request) throws ExceptionService {
        Date periodoVencimentoInicial = (Date)request.getAttribute("periodoInicial");
        Date periodoVencimentoFinal = (Date)request.getAttribute("periodoFinal");
        Date periodoEmissaoInicial = (Date)request.getAttribute("periodoEmissaoInicial");
        Date periodoEmissaoFinal = (Date)request.getAttribute("periodoEmissaoFinal");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        OpcoesFinanceiras opcoesFinanceiras = (OpcoesFinanceiras)request.getAttribute("opcoesFinanceiras");
        TipoCooperado tipoCooperado = (TipoCooperado)request.getAttribute("tipoCooperado");
        ClassificacaoClientes classificacaoClientes = (ClassificacaoClientes)request.getAttribute("classificacaoClientes");
        CategoriaPessoa categoriaPessoa = (CategoriaPessoa)request.getAttribute("categoriaPessoa");
        Short tipoApuracao = (Short)request.getAttribute("tipoApuracao");
        List meiosPagamentos = (List)request.getAttribute("meiosPagamentos");
        UnidadeFatCliente unidadeFatCliente = (UnidadeFatCliente)request.getAttribute("unidadeFatCliente");
        Short naoApurarTituloPeriodoAnterior = (Short)request.getAttribute("naoApurarTituloPeriodoAnterior");
        Short tipoCliente = (Short)request.getAttribute("tipoCliente");
        Short utilizarClassificacaoTitulo = (Short)request.getAttribute("utilizarClassificacaoTitulo");
        return new UtilityApuracaoValoresCooperados().apuracarValoresCooperadoPorPeriodo(periodoVencimentoInicial, periodoVencimentoFinal, empresa, tipoCooperado, opcoesFinanceiras, classificacaoClientes, categoriaPessoa, tipoApuracao, periodoEmissaoInicial, periodoEmissaoFinal, meiosPagamentos, unidadeFatCliente, naoApurarTituloPeriodoAnterior, tipoCliente, utilizarClassificacaoTitulo);
    }

    public void geracaoArquivoX8(CoreRequestContext request) throws IOException, ExceptionService {
        ApuracaoValoresCooperados vo = (ApuracaoValoresCooperados)request.getAttribute("apuracaoValoresCooperados");
        File file = (File)request.getAttribute("file");
        Boolean arquivoComContaBancaria = (Boolean)request.getAttribute("arquivoContaBancaria");
        new UtilityGeracaoArquivoX8().gerarArquivoX8(file, vo, arquivoComContaBancaria);
    }

    public Object salvarAndGerarBaixas(CoreRequestContext request) throws ExceptionDatabase, Exception {
        ApuracaoValoresCooperados vo = (ApuracaoValoresCooperados)request.getAttribute("vo");
        OpcoesFinanceiras opcoesFinanceiras = (OpcoesFinanceiras)request.getAttribute("opcoesFinanceiras");
        EmpresaFinanceiro empresaFinanceira = (EmpresaFinanceiro)request.getAttribute("empresaFinanceira");
        OpcoesContabeis opcoesContabeis = (OpcoesContabeis)request.getAttribute("opcoesContabeis");
        OpcoesGerenciais opcoesGerenciais = (OpcoesGerenciais)request.getAttribute("opcoesGerenciais");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        EmpresaContabilidade empresaContabil = (EmpresaContabilidade)request.getAttribute("empresaContabil");
        HashMap hash = new UtilityGerarBaixasApuracaoValores().gerarBaixaRecebimentoAndPagamento(vo, opcoesFinanceiras, empresaFinanceira, opcoesContabeis, empresa, opcoesGerenciais, empresaContabil);
        GrupoDeBaixa pagamento = (GrupoDeBaixa)hash.get("BAIXA_PAGAMENTO");
        GrupoDeBaixa recebimento = (GrupoDeBaixa)hash.get("BAIXA_RECEBIMENTO");
        if (ToolMethods.isNotNull((Object)pagamento).booleanValue() && !pagamento.getGrupoDeBaixaFormas().isEmpty()) {
            pagamento = (GrupoDeBaixa)CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().saveOrUpdate(pagamento);
            vo.setGrupoBaixaPagamento(pagamento);
        }
        if (ToolMethods.isNotNull((Object)recebimento).booleanValue() && !recebimento.getGrupoDeBaixaFormas().isEmpty()) {
            recebimento = (GrupoDeBaixa)CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().saveOrUpdate(recebimento);
            vo.setGrupoBaixaRecebimento(recebimento);
        }
        vo = (ApuracaoValoresCooperados)CoreDAOFactory.getInstance().getDAOApuracaoValoresCooperados().saveOrUpdate(vo);
        return vo;
    }

    public Object pesquisarUltimaApuracaoPorEmpresa(CoreRequestContext request) throws ExceptionDatabase {
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        return (ApuracaoValoresCooperados)CoreDAOFactory.getInstance().getDAOApuracaoValoresCooperados().pesquisarUltimaApuracaoPorEmpresa(empresa);
    }
}

