/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.notafiscalpropria.importarnfexml;

import com.touchcomp.basementor.model.impl.TagImpostosCooperado;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.DeParaItensNotaPropria;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorxml.model.XMLNfePropria;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFePropria;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionCFOPNotFound;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionCategoriaSTNotFound;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionParametrizacaoCtbModFiscalNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.notafiscalpropria.importarnfexml.UtilityImportarNotaPropria;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class CoreServiceImportarNotaPropria
extends CoreService {
    public static final String BUSCAR_DADOS_XML = "buscarDadosXml";
    public static final String SALVAR_NFE = "salvarNfe";
    public static final String SALVAR_XML_NFE = "salvarXmlNfe";

    public HashMap buscarDadosXml(CoreRequestContext request) throws JDOMException, IOException, ExceptionService {
        File xml = (File)request.getAttribute("xml");
        NaturezaOperacao nat = (NaturezaOperacao)request.getAttribute("nat");
        Empresa emp = (Empresa)request.getAttribute("emp");
        return new UtilityImportarNotaPropria().readXml(xml, nat, emp);
    }

    public List salvarNfe(CoreRequestContext request) throws ExceptionDatabase, JDOMException, IOException, ExceptionService, ExceptionParametrizacaoCtbModFiscalNotFound, ExceptionCFOPNotFound, ExceptionCategoriaSTNotFound, ExceptionCalculoICMS, ExceptionCalculoIPI, ExceptionCalculoPisCofins, ExceptionGeracaoTitulos, ExceptionAvaliadorExpressoes, ExceptionValidacaoDados, ExceptionInvalidData {
        List list = (List)request.getAttribute("list");
        List files = (List)request.getAttribute("files");
        OpcoesFaturamento opcoesFaturamento = (OpcoesFaturamento)request.getAttribute("opcoesFaturamento");
        CondicoesPagamento condicaoPagamento = (CondicoesPagamento)request.getAttribute("condicaoPagamento");
        OpcoesFinanceiras opcoesFinanceira = (OpcoesFinanceiras)request.getAttribute("opcoesFinanceira");
        OpcoesContabeis opcoesContabeis = (OpcoesContabeis)request.getAttribute("opcoesContabeis");
        OpcoesImpostos opcoesImposto = (OpcoesImpostos)request.getAttribute("opcoesImpostos");
        EmpresaContabilidade empresaContabil = (EmpresaContabilidade)request.getAttribute("empresaContabilidade");
        String parcelas = (String)request.getAttribute("parcelas");
        Short respeitarImpostosIcms = (Short)request.getAttribute("respeitarValoresImpostosIcms");
        Short respeitarImpostosIpi = (Short)request.getAttribute("respeitarValoresImpostosIpi");
        Short respeitarImpostosPisCofins = (Short)request.getAttribute("respeitarValoresImpostosPisCofins");
        Short considerarVlrOutrosDespAcess = (Short)request.getAttribute("considerarVlrOutrosDespAcess");
        Short respeitarOutrosImpostos = (Short)request.getAttribute("respeitarValoresOutrosImpostos");
        TagImpostosCooperado tagImpostosCooperado = (TagImpostosCooperado)request.getAttribute("tagImpostosCooperados");
        MeioPagamento meioPagamento = (MeioPagamento)request.getAttribute("meioPagamento");
        for (DeParaItensNotaPropria dePara : list) {
            CoreDAOFactory.getInstance().getDAODeParaItensNotaPropria().saveOrUpdate(dePara);
        }
        List notas = new UtilityImportarNotaPropria().createNotaPropria(files, list, opcoesFaturamento, condicaoPagamento, opcoesFinanceira, empresaContabil, parcelas, respeitarImpostosIcms, respeitarImpostosPisCofins, respeitarImpostosIpi, respeitarOutrosImpostos, opcoesContabeis, tagImpostosCooperado, meioPagamento, considerarVlrOutrosDespAcess, opcoesImposto);
        return notas;
    }

    public void salvarXmlNfe(CoreRequestContext request) throws JDOMException, IOException {
        List hash = (List)request.getAttribute("listHash");
        for (HashMap hashMap : hash) {
            NotaFiscalPropria nota = (NotaFiscalPropria)hashMap.get("NFE");
            File file = (File)hashMap.get("FILE");
            this.saveXml(nota, file);
        }
    }

    private void saveXml(NotaFiscalPropria nota, File xml) throws JDOMException, IOException {
        if (nota != null && xml != null) {
            this.processarArquivoXML(nota, xml);
        }
    }

    private void processarArquivoXML(NotaFiscalPropria vo, File xml) throws JDOMException, IOException {
        Namespace n = Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe");
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(xml), "UTF-8");
        SAXBuilder sb = new SAXBuilder();
        Document d = null;
        d = sb.build((Reader)reader);
        Element inf = d.getRootElement().getChild("NFe", n);
        Element infProt = d.getRootElement().getChild("protNFe", n);
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        new XMLOutputter().output(inf, (OutputStream)b);
        b.flush();
        String contNota = new String(b.toByteArray());
        b = new ByteArrayOutputStream();
        new XMLOutputter().output(infProt, (OutputStream)b);
        b.flush();
        String protocoloRec = new String(b.toByteArray());
        XMLNfePropria x = CoreServiceImportarNotaPropria.createXmlNotaPropria(vo);
        x.setIdNotaPropria(vo.getIdentificador());
        x.setConteudoXML(contNota);
        x.setConteudoAprovacao(protocoloRec);
        CoreServiceImportarNotaPropria.saveOrUpdateXMLNotaPropria(x);
    }

    public static XMLNfePropria createXmlNotaPropria(NotaFiscalPropria notaFiscalPropria) {
        ServiceXMLNFePropria service = (ServiceXMLNFePropria)ConfApplicationContext.getBean(ServiceXMLNFePropria.class);
        return service.getOrCreateXMLNfePropria(notaFiscalPropria.getIdentificador());
    }

    public static void saveOrUpdateXMLNotaPropria(XMLNfePropria x) {
        ServiceXMLNFePropria service = (ServiceXMLNFePropria)ConfApplicationContext.getBean(ServiceXMLNFePropria.class);
        service.saveOrUpdate((Object)x);
    }
}

