/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.notafiscalpropria.importarnfexml;

import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemApuracaoValoresCooperados;
import com.touchcomp.basementor.model.vo.ItemTituloApuracCooperado;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TipoCooperado;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorservice.service.interfaces.ServiceCliente;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class UtilityApuracaoValoresCooperados {
    private final ServiceCliente serviceCliente = (ServiceCliente)Context.get(ServiceCliente.class);

    public List apuracarValoresCooperadoPorPeriodo(Date dataVencimentoInicial, Date dataVencimentoFinal, Empresa empresa, TipoCooperado tipoCooperado, OpcoesFinanceiras opcoesFinanceiras, ClassificacaoClientes classificacaoClientes, CategoriaPessoa categoriaPessoa, Short tipoApuracao, Date dataEmissaoInicial, Date dataEmissaoFinal, List<MeioPagamento> meiosPagamentos, UnidadeFatCliente unidadeFatCliente, Short naoApurarTitulosPeriodoAnterior, Short tipoCliente, Short utilizarClassificacaoTitulo) throws ExceptionService {
        List titulos = new ArrayList();
        ArrayList<ItemApuracaoValoresCooperados> apuracoes = new ArrayList<ItemApuracaoValoresCooperados>();
        if (tipoApuracao.equals((short)0)) {
            titulos = this.findTitulosCooperado(dataVencimentoInicial, dataVencimentoFinal, tipoCooperado, dataEmissaoInicial, dataEmissaoFinal, meiosPagamentos, classificacaoClientes, utilizarClassificacaoTitulo);
            this.processarLancamentos(titulos, apuracoes, tipoApuracao, tipoCliente, classificacaoClientes, categoriaPessoa);
            if (naoApurarTitulosPeriodoAnterior == null || naoApurarTitulosPeriodoAnterior.equals((short)0)) {
                this.processarLancamentosAtrasados(this.titulosAbertoMesesAnterioresCooperado(tipoCooperado, dataVencimentoInicial, dataEmissaoInicial, dataEmissaoFinal, meiosPagamentos, classificacaoClientes, utilizarClassificacaoTitulo), apuracoes, opcoesFinanceiras);
            }
        } else {
            titulos = this.findTitulosCliente(dataVencimentoInicial, dataVencimentoFinal, classificacaoClientes, dataEmissaoInicial, dataEmissaoFinal, meiosPagamentos, unidadeFatCliente, categoriaPessoa, tipoCliente, utilizarClassificacaoTitulo);
            this.processarLancamentos(titulos, apuracoes, tipoApuracao, tipoCliente, classificacaoClientes, categoriaPessoa);
            if (naoApurarTitulosPeriodoAnterior == null || naoApurarTitulosPeriodoAnterior.equals((short)0)) {
                this.processarLancamentosAtrasados(this.titulosAbertoMesesAnterioresCliente(classificacaoClientes, dataVencimentoInicial, dataEmissaoInicial, dataEmissaoFinal, meiosPagamentos, categoriaPessoa, tipoCliente, utilizarClassificacaoTitulo), apuracoes, opcoesFinanceiras);
            }
        }
        return apuracoes;
    }

    private List findTitulosCooperado(Date periodoInicial, Date periodoFinal, TipoCooperado tipoCooperado, Date periodoEmissaoInicial, Date periodoEmissaoFinal, List<MeioPagamento> meiosPagamentos, ClassificacaoClientes classificacaoClientes, Short utilizarClassificacaoTitulo) {
        Object hql = " select distinct titulo  from Titulo titulo  left join titulo.classificacaoPessoa classif where  titulo.provisao = :realizado  and  titulo.dataVencimento between :dataInicial and :dataFinal  and  titulo.valorSaldo > 0";
        if (ToolMethods.isEquals((Object)utilizarClassificacaoTitulo, (Object)1)) {
            hql = (String)hql + " and classif.identificador = :idClassificacao";
        }
        hql = (String)hql + " and  exists (from Cooperado cooperado          where          cooperado.cliente.pessoa.identificador = titulo.pessoa.identificador         and          cooperado.tipoCooperado.identificador = :tipoCooperado)";
        if (periodoEmissaoInicial != null && periodoEmissaoFinal != null) {
            hql = (String)hql + " and titulo.dataEmissao between :dataEmissaoInicial and :dataEmissaoFinal";
        }
        if (meiosPagamentos != null && !meiosPagamentos.isEmpty()) {
            int count = 1;
            int qtdeMeios = meiosPagamentos.size();
            hql = (String)hql + " and (";
            for (MeioPagamento m : meiosPagamentos) {
                hql = count == qtdeMeios ? (String)hql + " titulo.meioPagamento.identificador = " + m.getIdentificador() : (String)hql + " titulo.meioPagamento.identificador = " + m.getIdentificador() + " or ";
                ++count;
            }
            hql = (String)hql + ")";
        }
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery((String)hql);
        q.setLong("tipoCooperado", tipoCooperado.getIdentificador().longValue());
        q.setParameter("realizado", (Object)1);
        q.setDate("dataInicial", periodoInicial);
        q.setDate("dataFinal", periodoFinal);
        if (periodoEmissaoInicial != null && periodoEmissaoFinal != null) {
            q.setDate("dataEmissaoInicial", periodoEmissaoInicial);
            q.setDate("dataEmissaoFinal", periodoEmissaoFinal);
        }
        if (ToolMethods.isEquals((Object)utilizarClassificacaoTitulo, (Object)1)) {
            q.setLong("idClassificacao", classificacaoClientes.getIdentificador().longValue());
        }
        return q.list();
    }

    private void processarLancamentos(List titulos, List<ItemApuracaoValoresCooperados> apuracoes, Short tipoApuracao, Short tipoCliente, ClassificacaoClientes classificacaoClientes, CategoriaPessoa categoriaPessoa) throws ExceptionService {
        for (Object obj : titulos) {
            boolean achou = false;
            Titulo titulo = (Titulo)obj;
            for (ItemApuracaoValoresCooperados apuracao : apuracoes) {
                ItemTituloApuracCooperado itemTitulo;
                Double saldoTitulo;
                Double valor;
                ItemApuracaoValoresCooperados itemApuracao = apuracao;
                if (!itemApuracao.getPessoa().getIdentificador().equals(titulo.getPessoa().getIdentificador())) continue;
                achou = true;
                if (titulo.getPagRec().equals((short)1)) {
                    valor = itemApuracao.getValor();
                    saldoTitulo = titulo.getValorSaldo();
                    valor = valor - saldoTitulo;
                    itemApuracao.setValor(valor);
                    itemTitulo = new ItemTituloApuracCooperado(titulo, saldoTitulo);
                    itemTitulo.setItemApuracaoCooperado(itemApuracao);
                    itemApuracao.getTitulos().add(itemTitulo);
                    continue;
                }
                valor = itemApuracao.getValor();
                saldoTitulo = titulo.getValorSaldo();
                valor = valor + saldoTitulo;
                itemApuracao.setValor(valor);
                itemTitulo = new ItemTituloApuracCooperado(titulo, saldoTitulo);
                itemTitulo.setItemApuracaoCooperado(itemApuracao);
                itemApuracao.getTitulos().add(itemTitulo);
            }
            if (achou) continue;
            ItemApuracaoValoresCooperados item = new ItemApuracaoValoresCooperados();
            item.setPessoa(titulo.getPessoa());
            Double saldoTitulo = titulo.getValorSaldo();
            if (titulo.getPagRec().equals((short)1)) {
                valor = item.getValor();
                valor = valor - saldoTitulo;
                item.setValor(valor);
            } else {
                valor = item.getValor();
                valor = valor + saldoTitulo;
                item.setValor(valor);
            }
            ItemTituloApuracCooperado itemTitulo = new ItemTituloApuracCooperado(titulo, saldoTitulo);
            itemTitulo.setItemApuracaoCooperado(item);
            item.getTitulos().add(itemTitulo);
            apuracoes.add(item);
        }
        if (ToolMethods.isWithData(apuracoes)) {
            List<Object> clientes = new ArrayList();
            if (apuracoes.size() > 50) {
                clientes = ToolMethods.isEquals((Object)tipoApuracao, (Object)0) ? this.getClienteFromCooperado() : (ToolMethods.isEquals((Object)tipoCliente, (Object)1) ? this.getClienteFromCategoriaPessoa(categoriaPessoa) : this.getClienteFromClassificacao(classificacaoClientes));
            }
            for (ItemApuracaoValoresCooperados itemApuracao : apuracoes) {
                Cliente cliente = this.getCliente(clientes, itemApuracao.getPessoa());
                itemApuracao.setCliente(cliente);
                if (itemApuracao.getValor() <= 0.0) {
                    itemApuracao.setTipoCobrancaApuracao(cliente.getFinanceiro().getTipoCobrancaApuracao());
                    continue;
                }
                itemApuracao.setTipoCobrancaApuracao(cliente.getFinanceiro().getTipoCobrancaApuracaoCredor());
            }
        }
    }

    private List titulosAbertoMesesAnterioresCooperado(TipoCooperado tipoCooperado, Date periodoInicial, Date periodoEmissaoInicial, Date periodoEmissaoFinal, List<MeioPagamento> meiosPagamentos, ClassificacaoClientes classificacaoClientes, Short utilizarClassificacaoTitulo) {
        Object hql = " select distinct titulo  from Titulo titulo  left join titulo.classificacaoPessoa classif where  titulo.dataVencimento < :dataInicial   and titulo.provisao = :realizado ";
        if (ToolMethods.isEquals((Object)utilizarClassificacaoTitulo, (Object)1)) {
            hql = (String)hql + " and classif.identificador = :idClassificacao";
        }
        hql = (String)hql + " and  exists (from Cooperado cooperado          where          cooperado.cliente.pessoa.identificador = titulo.pessoa.identificador         and          cooperado.tipoCooperado.identificador = :tipoCooperado)  and  titulo.valorSaldo > 0 ";
        if (periodoEmissaoInicial != null && periodoEmissaoFinal != null) {
            hql = (String)hql + " and titulo.dataEmissao between :dataEmissaoInicial and :dataEmissaoFinal";
        }
        if (meiosPagamentos != null && !meiosPagamentos.isEmpty()) {
            int count = 1;
            int qtdeMeios = meiosPagamentos.size();
            hql = (String)hql + " and (";
            for (MeioPagamento m : meiosPagamentos) {
                hql = count == qtdeMeios ? (String)hql + " titulo.meioPagamento.identificador = " + m.getIdentificador() : (String)hql + " titulo.meioPagamento.identificador = " + m.getIdentificador() + " or ";
                ++count;
            }
            hql = (String)hql + ")";
        }
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery((String)hql);
        q.setLong("tipoCooperado", tipoCooperado.getIdentificador().longValue());
        q.setParameter("realizado", (Object)1);
        q.setDate("dataInicial", periodoInicial);
        if (periodoEmissaoInicial != null && periodoEmissaoFinal != null) {
            q.setDate("dataEmissaoInicial", periodoEmissaoInicial);
            q.setDate("dataEmissaoFinal", periodoEmissaoFinal);
        }
        if (ToolMethods.isEquals((Object)utilizarClassificacaoTitulo, (Object)1)) {
            q.setLong("idClassificacao", classificacaoClientes.getIdentificador().longValue());
        }
        return q.list();
    }

    private void processarLancamentosAtrasados(List lancsCooperado, List apuracoes, OpcoesFinanceiras opcoesFinanceiras) throws ExceptionService {
        for (Object obj : lancsCooperado) {
            boolean achou = false;
            Titulo titulo = (Titulo)obj;
            for (Object apuracao : apuracoes) {
                ItemTituloApuracCooperado itemTitulo;
                Double saldoTitulo;
                Double valor;
                ItemApuracaoValoresCooperados itemApuracao = (ItemApuracaoValoresCooperados)apuracao;
                if (!itemApuracao.getPessoa().getIdentificador().equals(titulo.getPessoa().getIdentificador())) continue;
                achou = true;
                if (titulo.getPagRec().equals((short)1)) {
                    valor = itemApuracao.getValor();
                    saldoTitulo = titulo.getValorSaldo();
                    valor = valor - saldoTitulo;
                    itemApuracao.setValor(valor);
                    titulo.setValorMultaEmbutida(Double.valueOf(saldoTitulo * opcoesFinanceiras.getPercMulta() / 100.0));
                    itemTitulo = new ItemTituloApuracCooperado(titulo, saldoTitulo);
                    itemTitulo.setItemApuracaoCooperado(itemApuracao);
                    itemApuracao.getTitulos().add(itemTitulo);
                    continue;
                }
                valor = itemApuracao.getValor();
                saldoTitulo = titulo.getValorSaldo();
                valor = valor + saldoTitulo;
                itemApuracao.setValor(valor);
                itemTitulo = new ItemTituloApuracCooperado(titulo, saldoTitulo);
                itemTitulo.setItemApuracaoCooperado(itemApuracao);
                itemApuracao.getTitulos().add(itemTitulo);
            }
            if (achou) continue;
            ItemApuracaoValoresCooperados item = new ItemApuracaoValoresCooperados();
            item.setPessoa(titulo.getPessoa());
            Double saldoTitulo = titulo.getValorSaldo();
            if (titulo.getPagRec().equals((short)1)) {
                valor = item.getValor();
                valor = valor - saldoTitulo;
                item.setValor(valor);
            } else {
                valor = item.getValor();
                valor = valor + saldoTitulo;
                item.setValor(valor);
            }
            ItemTituloApuracCooperado itemTitulo = new ItemTituloApuracCooperado(titulo, saldoTitulo);
            itemTitulo.setItemApuracaoCooperado(item);
            item.getTitulos().add(itemTitulo);
            apuracoes.add(item);
        }
    }

    private List findTitulosCliente(Date periodoInicial, Date periodoFinal, ClassificacaoClientes classificacaoClientes, Date periodoEmissaoInicial, Date periodoEmissaoFinal, List<MeioPagamento> meiosPagamentos, UnidadeFatCliente unidadeFatCliente, CategoriaPessoa categoriaPessoa, Short tipoCliente, Short utilizarClassificacaoTitulo) {
        Object hql = " select distinct titulo  from Titulo titulo  left join titulo.classificacaoPessoa classif where  titulo.provisao = :realizado  and  titulo.dataVencimento between :dataInicial and :dataFinal  and  titulo.valorSaldo > 0 ";
        if (ToolMethods.isEquals((Object)utilizarClassificacaoTitulo, (Object)1)) {
            hql = (String)hql + " and classif.identificador = :idClassificacao";
        }
        hql = (String)hql + " and exists (from Cliente cliente          where          cliente.pessoa.identificador = titulo.pessoa.identificador ";
        hql = ToolMethods.isEquals((Object)tipoCliente, (Object)1) ? (String)hql + " and cliente.faturamento.categoriaPessoa.identificador = :idCategoria)" : (!ToolMethods.isEquals((Object)utilizarClassificacaoTitulo, (Object)1) ? (String)hql + " and cliente.classificacaoClientes.identificador = :idClassificacao)" : (String)hql + ")");
        if (!ToolMethods.isEquals((Object)utilizarClassificacaoTitulo, (Object)1)) {
            hql = (String)hql + " and not exists(from Cooperado cooperado                where                 cooperado.cliente.pessoa.identificador = titulo.pessoa.identificador                 and cooperado.ativo = :ativo                 and cooperado.cliente.ativo = :ativo) ";
        }
        if (periodoEmissaoInicial != null && periodoEmissaoFinal != null) {
            hql = (String)hql + " and titulo.dataEmissao between :dataEmissaoInicial and :dataEmissaoFinal";
        }
        if (meiosPagamentos != null && !meiosPagamentos.isEmpty()) {
            int count = 1;
            int qtdeMeios = meiosPagamentos.size();
            hql = (String)hql + " and (";
            for (MeioPagamento m : meiosPagamentos) {
                hql = count == qtdeMeios ? (String)hql + " titulo.meioPagamento.identificador = " + m.getIdentificador() : (String)hql + " titulo.meioPagamento.identificador = " + m.getIdentificador() + " or ";
                ++count;
            }
            hql = (String)hql + ")";
        }
        if (unidadeFatCliente != null) {
            hql = (String)hql + " and titulo.pessoa.identificador = :idPessoa";
        }
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery((String)hql);
        if (ToolMethods.isEquals((Object)tipoCliente, (Object)1)) {
            q.setLong("idCategoria", categoriaPessoa.getIdentificador().longValue());
        } else {
            q.setLong("idClassificacao", classificacaoClientes.getIdentificador().longValue());
        }
        q.setParameter("realizado", (Object)1);
        q.setDate("dataInicial", periodoInicial);
        q.setDate("dataFinal", periodoFinal);
        if (periodoEmissaoInicial != null && periodoEmissaoFinal != null) {
            q.setDate("dataEmissaoInicial", periodoEmissaoInicial);
            q.setDate("dataEmissaoFinal", periodoEmissaoFinal);
        }
        if (unidadeFatCliente != null) {
            q.setLong("idPessoa", unidadeFatCliente.getPessoa().getIdentificador().longValue());
        }
        if (!ToolMethods.isEquals((Object)utilizarClassificacaoTitulo, (Object)1)) {
            q.setShort("ativo", (short)1);
        }
        return q.list();
    }

    private List titulosAbertoMesesAnterioresCliente(ClassificacaoClientes classificacaoClientes, Date periodoInicial, Date periodoEmissaoInicial, Date periodoEmissaoFinal, List<MeioPagamento> meiosPagamentos, CategoriaPessoa categoriaPessoa, Short tipoCliente, Short utilizarClassificacaoTitulo) {
        Object hql = " select distinct titulo  from Titulo titulo left join titulo.classificacaoPessoa classif  where  titulo.dataVencimento < :dataInicial   and titulo.provisao = :realizado ";
        if (ToolMethods.isEquals((Object)utilizarClassificacaoTitulo, (Object)1)) {
            hql = (String)hql + " and classif.identificador = :idClassificacao";
        }
        hql = (String)hql + " and  exists (from Cliente cliente          where          cliente.pessoa.identificador = titulo.pessoa.identificador ";
        hql = ToolMethods.isEquals((Object)tipoCliente, (Object)1) ? (String)hql + " and  cliente.faturamento.categoriaPessoa.identificador = :idCategoria)" : (!ToolMethods.isEquals((Object)utilizarClassificacaoTitulo, (Object)1) ? (String)hql + " and cliente.classificacaoClientes.identificador = :idClassificacao)" : (String)hql + ")");
        hql = (String)hql + " and  titulo.valorSaldo > 0 ";
        if (periodoEmissaoInicial != null && periodoEmissaoFinal != null) {
            hql = (String)hql + " and titulo.dataEmissao between :dataEmissaoInicial and :dataEmissaoFinal";
        }
        if (meiosPagamentos != null && !meiosPagamentos.isEmpty()) {
            int count = 1;
            int qtdeMeios = meiosPagamentos.size();
            hql = (String)hql + " and (";
            for (MeioPagamento m : meiosPagamentos) {
                hql = count == qtdeMeios ? (String)hql + " titulo.meioPagamento.identificador = " + m.getIdentificador() : (String)hql + " titulo.meioPagamento.identificador = " + m.getIdentificador() + " or ";
                ++count;
            }
            hql = (String)hql + ")";
        }
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery((String)hql);
        if (ToolMethods.isEquals((Object)tipoCliente, (Object)1)) {
            q.setLong("idCategoria", categoriaPessoa.getIdentificador().longValue());
        } else {
            q.setLong("idClassificacao", classificacaoClientes.getIdentificador().longValue());
        }
        q.setParameter("realizado", (Object)1);
        q.setDate("dataInicial", periodoInicial);
        if (periodoEmissaoInicial != null && periodoEmissaoFinal != null) {
            q.setDate("dataEmissaoInicial", periodoEmissaoInicial);
            q.setDate("dataEmissaoFinal", periodoEmissaoFinal);
        }
        return q.list();
    }

    private Cliente getCliente(List<Cliente> clientes, Pessoa pessoa) throws ExceptionService {
        for (Cliente cliente : clientes) {
            if (!ToolMethods.isAffirmative((Number)cliente.getAtivo()) || !cliente.getPessoa().equals((Object)pessoa)) continue;
            return cliente;
        }
        Cliente cliente = this.getClienteAtivoFromPessoa(pessoa);
        if (cliente != null) {
            return cliente;
        }
        cliente = this.getClienteFromPessoa(pessoa);
        if (cliente != null) {
            return cliente;
        }
        throw new ExceptionService("Cliente nao encontrado para a pessoa: " + pessoa.toString());
    }

    private List<Cliente> getClienteFromCooperado() {
        String hql = " select distinct c.cliente from Cooperado c where c.cliente.ativo = :sim";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setShort("sim", (short)1);
        return q.list();
    }

    private List<Cliente> getClienteFromClassificacao(ClassificacaoClientes classificacao) {
        String hql = " select distinct c from Cliente c  where c.classificacaoClientes = :classificacaoClientes and c.ativo = :sim";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setEntity("classificacaoClientes", (Object)classificacao);
        q.setShort("sim", (short)1);
        return q.list();
    }

    private List<Cliente> getClienteFromCategoriaPessoa(CategoriaPessoa categoriaPessoa) {
        String hql = " select distinct c from Cliente c  where c.faturamento.categoriaPessoa = :categoriaPessoa and c.ativo = :sim";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setEntity("categoriaPessoa", (Object)categoriaPessoa);
        q.setShort("sim", (short)1);
        return q.list();
    }

    private Cliente getClienteFromPessoa(Pessoa pessoa) {
        String hql = " select distinct c from Cliente c  where c.pessoa = :pessoa";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setMaxResults(1);
        q.setEntity("pessoa", (Object)pessoa);
        return (Cliente)q.uniqueResult();
    }

    private Cliente getClienteAtivoFromPessoa(Pessoa pessoa) {
        String hql = " select distinct c from Cliente c  where c.pessoa = :pessoa and c.ativo = :sim";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        q.setEntity("pessoa", (Object)pessoa);
        return (Cliente)q.uniqueResult();
    }
}

