/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.notafiscalpropria.importarnfexml;

import com.touchcomp.basementor.constants.ConstantsTipoCobrancaApuracao;
import com.touchcomp.basementor.model.vo.ApuracaoValoresCooperados;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.ContaSalarioColaborador;
import com.touchcomp.basementor.model.vo.Cooperado;
import com.touchcomp.basementor.model.vo.ItemApuracaoValoresCooperados;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.tools.DateUtil;

public class UtilityGeracaoArquivoX8 {
    Double valorTotal = 0.0;
    Integer totalRegistros = 0;

    public void gerarArquivoX8(File arquivo, ApuracaoValoresCooperados vo, Boolean arquivoComContaBancaria) throws IOException, ExceptionService {
        this.valorTotal = 0.0;
        this.totalRegistros = 0;
        if (arquivo.exists()) {
            arquivo.delete();
        }
        arquivo.createNewFile();
        for (ItemApuracaoValoresCooperados item : vo.getValoresCooperados()) {
            if (!(item.getValor() > 0.0) || !ToolMethods.isEquals((Object)item.getTipoCobrancaApuracao(), (Object)ConstantsTipoCobrancaApuracao.GERAR_ARQUIVO_X8)) continue;
            if (arquivoComContaBancaria.booleanValue()) {
                this.escreverLinhaX8(item, arquivo, vo.getEmpresa().getEmpresaDados().getCodigoEmpresa());
            } else {
                this.escreverLinhaX8Zerado(item, arquivo, vo.getEmpresa().getEmpresaDados().getCodigoEmpresa());
            }
            this.totalRegistros = this.totalRegistros + 1;
        }
        this.escreverLinhaX9(arquivo, vo, vo.getEmpresa().getEmpresaDados().getCodigoEmpresa());
    }

    private void escreverLinhaX8Zerado(ItemApuracaoValoresCooperados item, File arquivo, String codigoCooperativa) throws IOException, ExceptionService {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        String aux = null;
        p.append("X8");
        p.append(codigoCooperativa);
        Cliente cliente = (Cliente)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOCliente(), "pessoa", item.getPessoa(), 0);
        Cooperado cooperado = (Cooperado)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOCooperado(), "cliente", cliente, 0);
        if (cooperado.getCodigoCooperado() == null || cooperado.getCodigoCooperado().isEmpty()) {
            throw new ExceptionService("Primeiro, informe a Matricula do Cooperado: " + cliente.getPessoa().getNome());
        }
        if (cooperado.getCodigoCooperado().length() > 5) {
            throw new ExceptionService("Numero da Matricula est\u00e1 acima de 5 digitos: " + cliente.getPessoa().getNome());
        }
        aux = cooperado.getCodigoCooperado();
        aux = ToolString.completaZeros((String)aux, (int)5, (boolean)true);
        p.append(aux);
        aux = cliente.getPessoa().getNome();
        aux = ToolString.completaEspacos((String)aux, (int)28);
        p.append(aux);
        p.append("00000000000000");
        p.append("000");
        p.append("0000");
        p.append("0");
        p.append(ToolString.completaZeros((String)"", (int)9, (boolean)true));
        p.append("0");
        p.append("000");
        p.append(ToolString.completaZeros((String)this.formatarValor(item.getValor()), (int)14, (boolean)true));
        p.println();
        p.flush();
        p.close();
    }

    private void escreverLinhaX8(ItemApuracaoValoresCooperados item, File arquivo, String codigoCooperativa) throws IOException, ExceptionService {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        String aux = null;
        p.append("X8");
        p.append(codigoCooperativa);
        Pessoa pessoa = item.getPessoa();
        Cliente cliente = item.getCliente();
        Cooperado cooperado = (Cooperado)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOCooperado(), "cliente", cliente, 0);
        if (cooperado.getCodigoCooperado() == null || cooperado.getCodigoCooperado().isEmpty()) {
            throw new ExceptionService("Primeiro, informe a Matricula do Cooperado: " + cliente.getPessoa().getNome());
        }
        if (cooperado.getCodigoCooperado().length() > 5) {
            throw new ExceptionService("Numero da Matricula est\u00e1 acima de 5 digitos: " + cliente.getPessoa().getNome());
        }
        aux = cooperado.getCodigoCooperado();
        aux = ToolString.completaZeros((String)aux, (int)5, (boolean)true);
        p.append(aux);
        aux = cliente.getPessoa().getNome();
        aux = ToolString.completaEspacos((String)aux, (int)28);
        p.append(aux);
        String cpf = pessoa.getComplemento().getCnpj();
        String cpf1 = cpf.substring(0, 9);
        p.append(cpf1);
        Object cpf2 = "";
        if (cpf.trim().length() == 11) {
            cpf2 = cpf.substring(9, 11);
            cpf2 = "000" + (String)cpf2;
        } else {
            cpf2 = cpf.substring(9, 14);
        }
        p.append((CharSequence)cpf2);
        ContaSalarioColaborador conta = null;
        if (pessoa.getContaSalarioColaborador().size() == 1) {
            conta = (ContaSalarioColaborador)pessoa.getContaSalarioColaborador().get(0);
        } else {
            for (ContaSalarioColaborador c : pessoa.getContaSalarioColaborador()) {
                if (!ToolMethods.isEquals((Object)c.getAtivo(), (Object)1) || !ToolMethods.isEquals((Object)c.getPreferencial(), (Object)1)) continue;
                conta = c;
                break;
            }
        }
        if (conta != null) {
            String codBanco = conta.getInstituicaoValor().getNrBanco();
            codBanco = ToolString.completaZeros((String)codBanco, (int)3);
            p.append(codBanco);
            String codAgencia = conta.getAgencia();
            codAgencia = ToolString.completaZeros((String)codAgencia, (int)4);
            p.append(codAgencia);
            String digitoAgencia = conta.getDvAgencia();
            digitoAgencia = ToolString.completaZeros((String)digitoAgencia, (int)1);
            p.append(digitoAgencia);
            String codConta = conta.getContaCorrente();
            codConta = ToolString.completaZeros((String)codConta, (int)9);
            p.append(codConta);
            String digitoConta = conta.getDvContaCorrente();
            digitoConta = ToolString.completaZeros((String)digitoConta, (int)1);
            p.append(digitoConta);
            p.append("000");
        } else {
            p.append("000");
            p.append("0000");
            p.append("0");
            p.append(ToolString.completaZeros((String)"", (int)9, (boolean)true));
            p.append("0");
            p.append("000");
        }
        p.append(ToolString.completaZeros((String)this.formatarValor(item.getValor()), (int)14, (boolean)true));
        p.println();
        p.flush();
        p.close();
    }

    private String formatarValor(Double valorInformado) {
        Double valor = ContatoFormatUtil.arrredondarNumero((Double)valorInformado, (int)2);
        this.valorTotal = this.valorTotal + valor;
        Integer inteira = valor.intValue();
        String numero = null;
        Integer decimal = (int)Math.round((valor - (double)valor.intValue()) * 100.0);
        numero = decimal.toString().length() == 1 ? inteira.toString() + "0" + decimal.toString() : inteira.toString() + decimal.toString();
        return numero;
    }

    private void escreverLinhaX9(File arquivo, ApuracaoValoresCooperados apuracao, String codigoCooperativa) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        Object aux = null;
        p.append("X9");
        p.append(codigoCooperativa);
        Integer mes = DateUtil.monthFromDate(apuracao.getDataInicial());
        aux = mes.toString();
        if (((String)aux).length() == 1) {
            aux = "0" + (String)aux;
        }
        p.append((CharSequence)aux);
        Integer ano = DateUtil.yearFromDate(apuracao.getDataFinal());
        p.append(ano.toString());
        this.totalRegistros = this.totalRegistros + 1;
        p.append(ToolString.completaZeros((String)this.totalRegistros.toString(), (int)5, (boolean)true));
        p.append(ToolString.completaZeros((String)this.formatarValor(this.valorTotal), (int)15, (boolean)true));
        p.println();
        p.flush();
        p.close();
    }
}

