/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.notafiscalpropria.importarnfexml;

import com.touchcomp.basementor.constants.ConstantsTipoCobrancaApuracao;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.baixatitulo.EnumConstTipoBaixaTitulos;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.ApuracaoValoresCooperados;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.ItemApuracaoValoresCooperados;
import com.touchcomp.basementor.model.vo.ItemTituloApuracCooperado;
import com.touchcomp.basementor.model.vo.LancComissaoApuracaoValoresCooperados;
import com.touchcomp.basementor.model.vo.LancamentoComissaoRepresentante;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.helpers.impl.baixatitulos.HelperBaixaTitulos;
import com.touchcomp.basementorservice.helpers.impl.grupodebaixa.HelperGrupoDeBaixa;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.service.impl.fornecedor.ServiceFornecedorImpl;
import com.touchcomp.basementorservice.service.impl.opcoescontabeisbaixatitulos.ServiceOpcoesContabeisBaixaTitulosImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorservice.service.interfaces.ServiceCliente;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.financeiro.utility.UtilityFinanceiro;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.titulos.AuxTitulosFolhaLeite;

public class UtilityGerarBaixasApuracaoValores {
    private final ServiceCliente serviceCliente = (ServiceCliente)Context.get(ServiceCliente.class);
    private final SCompPlanoConta scPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);
    private final ServiceOpcoesContabeisBaixaTitulosImpl serviceOpcoesContabeisBaixaTitulosImpl = (ServiceOpcoesContabeisBaixaTitulosImpl)ConfApplicationContext.getBean(ServiceOpcoesContabeisBaixaTitulosImpl.class);

    public HashMap gerarBaixaRecebimentoAndPagamento(ApuracaoValoresCooperados vo, OpcoesFinanceiras opcoesFinanceiras, EmpresaFinanceiro empresaFinanceira, OpcoesContabeis opcoesContabeis, Empresa empresa, OpcoesGerenciais opcoesGerenciais, EmpresaContabilidade empresaContabil) throws Exception {
        ArrayList<ItemTituloApuracCooperado> titulosBaixaPagamento = new ArrayList<ItemTituloApuracCooperado>();
        ArrayList<ItemTituloApuracCooperado> titulosBaixaRecebimento = new ArrayList<ItemTituloApuracCooperado>();
        for (ItemApuracaoValoresCooperados item : vo.getValoresCooperados()) {
            if (!(item.getValor() >= 0.0)) continue;
            for (ItemTituloApuracCooperado itemTitulo : item.getTitulos()) {
                if (!(itemTitulo.getSaldoTitulo() > 0.0)) continue;
                if (itemTitulo.getTitulo().getPagRec().equals((short)0)) {
                    titulosBaixaPagamento.add(itemTitulo);
                    continue;
                }
                titulosBaixaRecebimento.add(itemTitulo);
            }
        }
        GrupoDeBaixa grupoBaixaPag = this.createGrupoPagamento(vo, opcoesFinanceiras, (short)0, titulosBaixaPagamento, empresaFinanceira, empresa, opcoesGerenciais);
        GrupoDeBaixa grupoBaixaRec = this.createGrupoPagamento(vo, opcoesFinanceiras, (short)1, titulosBaixaRecebimento, empresaFinanceira, empresa, opcoesGerenciais);
        this.verificarBaixasSaldoNegativo(vo, grupoBaixaPag, grupoBaixaRec, opcoesFinanceiras, empresaFinanceira, opcoesContabeis, empresa, opcoesGerenciais);
        this.verificarBaixasSaldoPositivo(vo, opcoesFinanceiras, opcoesContabeis);
        this.setarLancamentosGerenciaisAndMovimentosBancarios(grupoBaixaPag, empresa, opcoesFinanceiras, empresaContabil, opcoesGerenciais);
        this.setarLancamentosGerenciaisAndMovimentosBancarios(grupoBaixaRec, empresa, opcoesFinanceiras, empresaContabil, opcoesGerenciais);
        HashMap<String, GrupoDeBaixa> hashMap = new HashMap<String, GrupoDeBaixa>();
        if (grupoBaixaPag != null && ToolMethods.isWithData((Collection)grupoBaixaPag.getGrupoDeBaixaFormas()) && ToolMethods.isWithData((Collection)((GrupoDeBaixaFormas)grupoBaixaPag.getGrupoDeBaixaFormas().getFirst()).getBaixaTitulo())) {
            hashMap.put("BAIXA_PAGAMENTO", grupoBaixaPag);
        } else {
            hashMap.put("BAIXA_PAGAMENTO", null);
        }
        if (grupoBaixaRec != null && ToolMethods.isWithData((Collection)grupoBaixaRec.getGrupoDeBaixaFormas()) && ToolMethods.isWithData((Collection)((GrupoDeBaixaFormas)grupoBaixaRec.getGrupoDeBaixaFormas().getFirst()).getBaixaTitulo())) {
            hashMap.put("BAIXA_RECEBIMENTO", grupoBaixaRec);
        } else {
            hashMap.put("BAIXA_RECEBIMENTO", null);
        }
        return hashMap;
    }

    private GrupoDeBaixa createGrupoPagamento(ApuracaoValoresCooperados ap, OpcoesFinanceiras opcoesFinanceiras, Short tipoBaixa, List<ItemTituloApuracCooperado> titulosPagamento, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer) throws Exception {
        GrupoDeBaixa vo = new GrupoDeBaixa();
        vo.setEmpresa(ap.getEmpresa());
        if (ap.getDataBaixa() != null) {
            vo.setDataLiquidacao(ap.getDataBaixa());
        } else {
            vo.setDataLiquidacao(ap.getDataFinal());
        }
        vo.setDataAtualizacao(ap.getDataAtualizacao());
        vo.setDataCadastro(new Date());
        vo.setPagRec(tipoBaixa);
        GrupoDeBaixaFormas gbf = new GrupoDeBaixaFormas();
        vo.setGrupoDeBaixaFormas(Arrays.asList(gbf));
        gbf.setGrupoDeBaixa(vo);
        if (ap.getFormaPagamento().equals((short)1)) {
            gbf.setFormaPagamento(Short.valueOf((short)1));
            gbf.setContaValor(ap.getContaBaixas());
        } else {
            gbf.setFormaPagamento(Short.valueOf((short)11));
        }
        gbf.setAgrupamento(Short.valueOf((short)0));
        gbf.setBaixaTitulo(this.getBaixasTitulo(gbf, titulosPagamento, empresaFinanceiro, empresa, opGer));
        CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencialLiquidacao(gbf);
        new HelperGrupoDeBaixa(vo).setLancamentoPisCofins();
        return vo;
    }

    private List<BaixaTitulo> getBaixasTitulo(GrupoDeBaixaFormas vo, List<ItemTituloApuracCooperado> titulosPagamento, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer) throws Exception {
        ArrayList<BaixaTitulo> aux = new ArrayList<BaixaTitulo>();
        HelperBaixaTitulos helper = (HelperBaixaTitulos)Context.get(HelperBaixaTitulos.class);
        for (ItemTituloApuracCooperado itemT : titulosPagamento) {
            Titulo t = itemT.getTitulo();
            BaixaTitulo b = helper.novaBaixaTitulosCalcValores(t, vo.getGrupoDeBaixa().getDataLiquidacao(), EnumConstTipoBaixaTitulos.BAIXA_TITULOS_ORIG_PADRAO, itemT.getSaldoTitulo(), empresaFinanceiro, empresa, opGer);
            b.setGrupoDeBaixaFormas(vo);
            aux.add(b);
        }
        return aux;
    }

    private void verificarBaixasSaldoNegativo(ApuracaoValoresCooperados vo, GrupoDeBaixa grupoBaixaPag, GrupoDeBaixa grupoBaixaRec, OpcoesFinanceiras opcoesFinanceiras, EmpresaFinanceiro empresaFinanceira, OpcoesContabeis opcoesContabeis, Empresa empresa, OpcoesGerenciais opGer) throws Exception {
        for (ItemApuracaoValoresCooperados item : vo.getValoresCooperados()) {
            if (!(item.getValor() < 0.0)) continue;
            Cliente cliente = item.getCliente();
            if (cliente == null) {
                cliente = this.serviceCliente.getClienteCpfCpnj(item.getPessoa().getComplemento().getCnpj());
            }
            if (cliente.getFinanceiro().getTipoCobrancaApuracao().equals(ConstantsTipoCobrancaApuracao.NAO_GERAR_TITULO)) {
                this.gerarBaixasTipoCobrancaNaoGerarTitulo(vo, grupoBaixaPag, grupoBaixaRec, opcoesFinanceiras, item, empresaFinanceira, empresa, opGer);
                continue;
            }
            if (cliente.getFinanceiro().getTipoCobrancaApuracao().equals(ConstantsTipoCobrancaApuracao.GERAR_TITULO_BOLETO)) {
                this.gerarBaixasTipoCobrancaGerarTituloBoleto(vo, grupoBaixaPag, grupoBaixaRec, opcoesFinanceiras, opcoesContabeis, item, cliente, empresaFinanceira, empresa, opGer);
                continue;
            }
            if (cliente.getFinanceiro().getTipoCobrancaApuracao().equals(ConstantsTipoCobrancaApuracao.GERAR_TITULO_DEBITO_CONTA)) {
                this.gerarBaixasTipoCobrancaGerarTituloDebitoConta(vo, grupoBaixaPag, grupoBaixaRec, opcoesFinanceiras, opcoesContabeis, item, cliente, empresaFinanceira, empresa, opGer);
                continue;
            }
            if (!cliente.getFinanceiro().getTipoCobrancaApuracao().equals(ConstantsTipoCobrancaApuracao.GERAR_SOMENTE_TITULO)) continue;
            this.gerarBaixasTipoCobrancaGerarSomenteTitulo(vo, grupoBaixaPag, grupoBaixaRec, opcoesFinanceiras, opcoesContabeis, item, cliente, empresaFinanceira, empresa, opGer);
        }
    }

    public List getEventosOrdenados(List lista) {
        if (lista != null) {
            Collections.sort(lista, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    ItemTituloApuracCooperado item1 = (ItemTituloApuracCooperado)o1;
                    ItemTituloApuracCooperado item2 = (ItemTituloApuracCooperado)o2;
                    Double vlr1 = item1.getSaldoTitulo();
                    Double vlr2 = item2.getSaldoTitulo();
                    return vlr1.compareTo(vlr2);
                }
            });
            return lista;
        }
        return null;
    }

    private void createBaixaRecebimentoPagamento(ItemTituloApuracCooperado itemT, GrupoDeBaixa vo, Double valorBaixa, Double valorSaldoBaixa, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer) throws Exception {
        HelperBaixaTitulos helper = (HelperBaixaTitulos)Context.get(HelperBaixaTitulos.class);
        for (GrupoDeBaixaFormas gbf : vo.getGrupoDeBaixaFormas()) {
            Titulo t = itemT.getTitulo();
            BaixaTitulo b = helper.novaBaixaTitulosCalcValores(t, vo.getDataLiquidacao(), EnumConstTipoBaixaTitulos.BAIXA_TITULOS_ORIG_PADRAO, valorBaixa, empresaFinanceiro, empresa, opGer);
            b.setSaldoBaixa(valorSaldoBaixa);
            b.setGrupoDeBaixaFormas(gbf);
            gbf.getBaixaTitulo().add(b);
        }
    }

    private void gerarBaixasTipoCobrancaNaoGerarTitulo(ApuracaoValoresCooperados vo, GrupoDeBaixa grupoBaixaPag, GrupoDeBaixa grupoBaixaRec, OpcoesFinanceiras opcoesFinanceiras, ItemApuracaoValoresCooperados item, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer) throws Exception {
        Double valorRecebimento = 0.0;
        Double valorPagamento = 0.0;
        List<ItemTituloApuracCooperado> aux = new ArrayList();
        for (ItemTituloApuracCooperado itemTitulo : item.getTitulos()) {
            if (itemTitulo.getTitulo().getPagRec().equals((short)1)) {
                valorRecebimento = valorRecebimento + itemTitulo.getSaldoTitulo();
                if (!(itemTitulo.getSaldoTitulo() > 0.0)) continue;
                aux.add(itemTitulo);
                continue;
            }
            if (!(itemTitulo.getSaldoTitulo() > 0.0)) continue;
            valorPagamento = valorPagamento + itemTitulo.getSaldoTitulo();
            if (grupoBaixaPag == null) continue;
            this.createBaixaRecebimentoPagamento(itemTitulo, grupoBaixaPag, itemTitulo.getSaldoTitulo(), 0.0, empresaFinanceiro, empresa, opGer);
        }
        aux = this.getEventosOrdenados(aux);
        valorRecebimento = ContatoFormatUtil.arrredondarNumero((Double)valorRecebimento, (int)2);
        if (valorPagamento == 0.0) {
            return;
        }
        Double valorSaldoApuracao = ContatoFormatUtil.arrredondarNumero((Double)valorPagamento, (int)2);
        for (Object e : aux) {
            ItemTituloApuracCooperado itemT = (ItemTituloApuracCooperado)e;
            if (valorSaldoApuracao >= itemT.getSaldoTitulo()) {
                valorSaldoApuracao = valorSaldoApuracao - itemT.getSaldoTitulo();
                valorSaldoApuracao = ContatoFormatUtil.arrredondarNumero((Double)valorSaldoApuracao, (int)2);
                if (grupoBaixaRec == null) continue;
                this.createBaixaRecebimentoPagamento(itemT, grupoBaixaRec, itemT.getSaldoTitulo(), itemT.getSaldoTitulo(), empresaFinanceiro, empresa, opGer);
                continue;
            }
            Double saldo = ContatoFormatUtil.arrredondarNumero((Double)(itemT.getSaldoTitulo() - valorSaldoApuracao), (int)2);
            if (grupoBaixaRec != null) {
                this.createBaixaRecebimentoPagamento(itemT, grupoBaixaRec, valorSaldoApuracao, itemT.getSaldoTitulo(), empresaFinanceiro, empresa, opGer);
            }
            return;
        }
    }

    private void gerarBaixasTipoCobrancaGerarTituloBoleto(ApuracaoValoresCooperados vo, GrupoDeBaixa grupoBaixaPag, GrupoDeBaixa grupoBaixaRec, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis, ItemApuracaoValoresCooperados item, Cliente cliente, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer) throws Exception {
        Double valorRecebimento = 0.0;
        Double valorPagamento = 0.0;
        for (ItemTituloApuracCooperado itemTitulo : item.getTitulos()) {
            if (itemTitulo.getTitulo().getPagRec().equals((short)1) && itemTitulo.getSaldoTitulo() > 0.0) {
                valorRecebimento = valorRecebimento + itemTitulo.getSaldoTitulo();
                this.createBaixaRecebimentoPagamento(itemTitulo, grupoBaixaRec, itemTitulo.getSaldoTitulo(), 0.0, empresaFinanceiro, empresa, opGer);
                continue;
            }
            if (!(itemTitulo.getSaldoTitulo() > 0.0)) continue;
            valorPagamento = valorPagamento + itemTitulo.getSaldoTitulo();
            this.createBaixaRecebimentoPagamento(itemTitulo, grupoBaixaPag, itemTitulo.getSaldoTitulo(), 0.0, empresaFinanceiro, empresa, opGer);
        }
        if (vo.getGerarTituloDevedor().equals((short)1)) {
            PlanoConta pc = this.scPlanoConta.getPlanoConta(cliente, opcoesContabeis);
            Double valorTituloAGerar = ToolFormatter.arrredondarNumero((Double)(valorRecebimento - valorPagamento), (int)2);
            Titulo t = new AuxTitulosFolhaLeite().createTituloDevedorApuracao(valorTituloAGerar, vo.getDataVencimentoTitulo(), vo.getTipoDocTitulo(), vo.getMeioPagamentoTitulo(), vo.getCarteiraCobrancaTitulo(), opcoesFinanceiras, opcoesContabeis, vo, cliente, vo.getPlanoGerencialTitulo(), vo.getDescricao(), vo.getDataEmissaoTitGerar(), pc);
            item.setTituloMesSeguinte(t);
            this.calcularLancamentosComissao(item, valorRecebimento, valorPagamento, opcoesFinanceiras);
        }
    }

    private void gerarBaixasTipoCobrancaGerarTituloDebitoConta(ApuracaoValoresCooperados vo, GrupoDeBaixa grupoBaixaPag, GrupoDeBaixa grupoBaixaRec, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis, ItemApuracaoValoresCooperados item, Cliente cliente, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer) throws Exception {
        Double valorRecebimento = 0.0;
        Double valorPagamento = 0.0;
        for (ItemTituloApuracCooperado itemTitulo : item.getTitulos()) {
            if (itemTitulo.getTitulo().getPagRec().equals((short)1) && itemTitulo.getSaldoTitulo() > 0.0) {
                valorRecebimento = valorRecebimento + itemTitulo.getSaldoTitulo();
                this.createBaixaRecebimentoPagamento(itemTitulo, grupoBaixaRec, itemTitulo.getSaldoTitulo(), 0.0, empresaFinanceiro, empresa, opGer);
                continue;
            }
            if (!(itemTitulo.getSaldoTitulo() > 0.0)) continue;
            valorPagamento = valorPagamento + itemTitulo.getSaldoTitulo();
            this.createBaixaRecebimentoPagamento(itemTitulo, grupoBaixaPag, itemTitulo.getSaldoTitulo(), 0.0, empresaFinanceiro, empresa, opGer);
        }
        if (vo.getGerarTituloDevedor().equals((short)1)) {
            PlanoConta pc = this.scPlanoConta.getPlanoConta(cliente, opcoesContabeis);
            Double valorTituloAGerar = ToolFormatter.arrredondarNumero((Double)(valorRecebimento - valorPagamento), (int)2);
            Titulo t = new AuxTitulosFolhaLeite().createTituloDevedorApuracao(valorTituloAGerar, vo.getDataVencimentoDebitoConta(), vo.getTipoDocDebitoConta(), vo.getMeioPagamentoDebitoConta(), vo.getCarteiraCobrancaDebitoConta(), opcoesFinanceiras, opcoesContabeis, vo, cliente, vo.getPlanoGerencialDebitoConta(), vo.getDescricao(), vo.getDataEmissaoTitGerar(), pc);
            item.setTituloMesSeguinte(t);
            this.calcularLancamentosComissao(item, valorRecebimento, valorPagamento, opcoesFinanceiras);
        }
    }

    private void gerarBaixasTipoCobrancaGerarSomenteTitulo(ApuracaoValoresCooperados vo, GrupoDeBaixa grupoBaixaPag, GrupoDeBaixa grupoBaixaRec, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis, ItemApuracaoValoresCooperados item, Cliente cliente, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer) throws Exception {
        Double valorRecebimento = 0.0;
        Double valorPagamento = 0.0;
        for (ItemTituloApuracCooperado itemTitulo : item.getTitulos()) {
            if (itemTitulo.getTitulo().getPagRec().equals((short)1) && itemTitulo.getSaldoTitulo() > 0.0) {
                valorRecebimento = valorRecebimento + itemTitulo.getSaldoTitulo();
                this.createBaixaRecebimentoPagamento(itemTitulo, grupoBaixaRec, itemTitulo.getSaldoTitulo(), 0.0, empresaFinanceiro, empresa, opGer);
                continue;
            }
            if (!(itemTitulo.getSaldoTitulo() > 0.0)) continue;
            valorPagamento = valorPagamento + itemTitulo.getSaldoTitulo();
            this.createBaixaRecebimentoPagamento(itemTitulo, grupoBaixaPag, itemTitulo.getSaldoTitulo(), 0.0, empresaFinanceiro, empresa, opGer);
        }
        if (vo.getGerarTituloDevedor().equals((short)1)) {
            PlanoConta pc = this.scPlanoConta.getPlanoConta(cliente, opcoesContabeis);
            Double valorTituloAGerar = ToolFormatter.arrredondarNumero((Double)(valorRecebimento - valorPagamento), (int)2);
            Titulo t = new AuxTitulosFolhaLeite().createTituloDevedorApuracao(valorTituloAGerar, vo.getDataVencimentoSomenteTitulo(), vo.getTipoDocSomenteTitulo(), vo.getMeioPagamentoSomenteTitulo(), vo.getCarteiraCobrancaSomenteTitulo(), opcoesFinanceiras, opcoesContabeis, vo, cliente, vo.getPlanoGerencialSomenteTitulo(), vo.getDescricao(), vo.getDataEmissaoTitGerar(), pc);
            item.setTituloMesSeguinte(t);
            this.calcularLancamentosComissao(item, valorRecebimento, valorPagamento, opcoesFinanceiras);
        }
    }

    private void verificarBaixasSaldoPositivo(ApuracaoValoresCooperados vo, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        if (ToolMethods.isEquals((Object)vo.getGerarTituloCredor(), (Object)1)) {
            for (ItemApuracaoValoresCooperados item : vo.getValoresCooperados()) {
                if (!(item.getValor() > 0.0)) continue;
                Cliente cliente = item.getCliente();
                if (cliente == null) {
                    cliente = this.serviceCliente.getClienteCpfCpnj(item.getPessoa().getComplemento().getCnpj());
                }
                if (!ToolMethods.isEquals((Object)cliente.getFinanceiro().getTipoCobrancaApuracaoCredor(), (Object)ConstantsTipoCobrancaApuracao.GERAR_TITULO_CREDOR)) continue;
                Fornecedor fornecedor = ((ServiceFornecedorImpl)Context.get(ServiceFornecedorImpl.class)).get(cliente.getPessoa());
                PlanoConta pc = this.scPlanoConta.getPlanoConta(cliente, opcoesContabeis);
                if (fornecedor != null) {
                    SCompPlanoConta compPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);
                    pc = compPlanoConta.getPlanoConta(fornecedor, opcoesContabeis);
                }
                Double valorTituloAGerar = ToolFormatter.arrredondarNumero((Double)item.getValor(), (int)2);
                Titulo t = new AuxTitulosFolhaLeite().createTituloCredorApuracao(valorTituloAGerar, vo.getDataVencimentoTituloCredor(), vo.getTipoDocTituloCredor(), vo.getMeioPagamentoTituloCredor(), vo.getCarteiraCobrancaTituloCredor(), opcoesFinanceiras, opcoesContabeis, vo, cliente, vo.getPlanoGerencialTituloCredor(), vo.getDataEmissaoTitGerar(), pc);
                item.setTituloMesSeguinte(t);
                this.calcularLancamentosComissao(item, valorTituloAGerar, valorTituloAGerar, opcoesFinanceiras);
            }
        }
    }

    private void calcularLancamentosComissao(ItemApuracaoValoresCooperados item, Double valorRecebimento, Double valorPagamento, OpcoesFinanceiras opcoesFinanceiras) {
        if (ToolMethods.isAffirmative((Number)opcoesFinanceiras.getGerarEstornoComissaoApuracaoCooperado()) && valorRecebimento > valorPagamento) {
            Double percentualPago = ToolFormatter.arrredondarNumero((Double)(valorPagamento * 100.0 / valorRecebimento), (int)6);
            Double percentualAReceber = ToolFormatter.arrredondarNumero((Double)(100.0 - percentualPago), (int)6);
            List<TituloComissaoRepresentante> tempComissoes = this.getNovosPercentuaisCalculoComissao(item, percentualAReceber);
            if (item.getTituloMesSeguinte() != null) {
                item.getTituloMesSeguinte().setRepresentantes(this.getComissaoTitulosMesSeguinte(tempComissoes, item.getTituloMesSeguinte()));
            }
            item.setLancamentosComissao(this.getLancamentosEstornoComissaoRepresentante(tempComissoes, item));
        }
    }

    private List<TituloComissaoRepresentante> getNovosPercentuaisCalculoComissao(ItemApuracaoValoresCooperados item, Double percentualAReceber) {
        ArrayList<TituloComissaoRepresentante> tempComissoes = new ArrayList<TituloComissaoRepresentante>();
        for (ItemTituloApuracCooperado itemTitulo : item.getTitulos()) {
            Titulo t = itemTitulo.getTitulo();
            if (!ToolMethods.isEquals((Object)t.getPagRec(), (Object)1)) continue;
            for (TituloRepresentante tr : t.getRepresentantes()) {
                Double valorBaseCalculo = ToolFormatter.arrredondarNumero((Double)(tr.getVrBCComissao() * (percentualAReceber / 100.0)), (int)2);
                Double valorComissao = ToolFormatter.arrredondarNumero((Double)(valorBaseCalculo * (tr.getPercComissao() / 100.0)), (int)2);
                Boolean achou = false;
                for (TituloComissaoRepresentante tcr : tempComissoes) {
                    if (!ToolMethods.isEquals((Object)tr.getRepresentante(), (Object)tcr.getRepresentante())) continue;
                    tcr.setBaseCalculoComissao(tcr.getBaseCalculoComissao() + valorBaseCalculo);
                    tcr.setValorComissao(tcr.getValorComissao() + valorComissao);
                    achou = true;
                    break;
                }
                if (achou.booleanValue()) continue;
                TituloComissaoRepresentante temp = new TituloComissaoRepresentante(this);
                temp.setRepresentante(tr.getRepresentante());
                temp.setBaseCalculoComissao(valorBaseCalculo);
                temp.setValorComissao(valorComissao);
                tempComissoes.add(temp);
            }
        }
        return tempComissoes;
    }

    private List<TituloRepresentante> getComissaoTitulosMesSeguinte(List<TituloComissaoRepresentante> tempComissoes, Titulo tituloMesSeguinte) {
        ArrayList<TituloRepresentante> lista = new ArrayList<TituloRepresentante>();
        for (TituloComissaoRepresentante temp : tempComissoes) {
            TituloRepresentante tr = new TituloRepresentante();
            tr.setTitulo(tituloMesSeguinte);
            tr.setRepresentante(temp.getRepresentante());
            tr.setVrBCComissao(temp.getBaseCalculoComissao());
            tr.setPercComissao(ToolFormatter.arrredondarNumero((Double)(temp.getValorComissao() * 100.0 / temp.getBaseCalculoComissao()), (int)6));
            lista.add(tr);
        }
        return lista;
    }

    private List<LancComissaoApuracaoValoresCooperados> getLancamentosEstornoComissaoRepresentante(List<TituloComissaoRepresentante> tempComissoes, ItemApuracaoValoresCooperados item) {
        ArrayList<LancComissaoApuracaoValoresCooperados> lista = new ArrayList<LancComissaoApuracaoValoresCooperados>();
        for (TituloComissaoRepresentante temp : tempComissoes) {
            LancamentoComissaoRepresentante l = new LancamentoComissaoRepresentante();
            l.setRepresentante(temp.getRepresentante());
            l.setValor(temp.getValorComissao());
            l.setDataCadastro(new Date());
            l.setDataLancamento(item.getApuracaoValoresCooperado().getDataBaixa());
            l.setDebCred(Short.valueOf((short)0));
            l.setObservacao("Lancamento Estorno Comissao Apuracao Cooperado");
            l.setEmpresa(item.getApuracaoValoresCooperado().getEmpresa());
            LancComissaoApuracaoValoresCooperados lc = new LancComissaoApuracaoValoresCooperados();
            lc.setItemApuracaoValoresCooperados(item);
            lc.setLancamentoComissaoRepresentante(l);
            lista.add(lc);
        }
        return lista;
    }

    private void setarLancamentosGerenciaisAndMovimentosBancarios(GrupoDeBaixa vo, Empresa empresa, OpcoesFinanceiras opcoesFinanceiras, EmpresaContabilidade empresaContabil, OpcoesGerenciais opcoesGerenciais) {
        if (vo.getGrupoDeBaixaFormas() != null && !vo.getGrupoDeBaixaFormas().isEmpty()) {
            try {
                for (GrupoDeBaixaFormas gbf : vo.getGrupoDeBaixaFormas()) {
                    gbf.setGrupoDeBaixa(vo);
                    gbf.setMovimentoBancario(new ArrayList());
                    if (gbf.getFormaPagamento() != null && (gbf.getFormaPagamento() == 0 || gbf.getFormaPagamento() == 1 || gbf.getFormaPagamento() == 4)) {
                        UtilityFinanceiro.gerarMovimentosBancarios(gbf, empresa, opcoesFinanceiras.getToleranciaValorMovimentoFinanceiro());
                    }
                    if (gbf.getFormaPagamento() != null && gbf.getFormaPagamento() != 9 && gbf.getFormaPagamento() != 10 && gbf.getFormaPagamento() != 3) {
                        CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencialLiquidacao(gbf);
                    }
                    for (BaixaTitulo bt : gbf.getBaixaTitulo()) {
                        if (gbf.getFormaPagamento() == null) continue;
                        if (gbf.getFormaPagamento() == 2) {
                            this.gerarLancamentosGerenciais(bt, empresaContabil);
                        }
                        if (gbf.getFormaPagamento() == 8) {
                            this.gerarLancamentosGerenciaisRenegociacao(bt, empresaContabil);
                        }
                        if (gbf.getFormaPagamento() != 3) continue;
                        this.gerarLancamentosGerenciaisFaltaPagamento(bt, empresaContabil, opcoesGerenciais);
                    }
                }
            }
            catch (ExceptionService ex) {
                TLogger.get(ex.getClass()).error((Throwable)ex);
                throw new RuntimeException("Erro ao criar Baixa T?tulo. " + ex.getMessage());
            }
        }
    }

    private void gerarLancamentosGerenciais(BaixaTitulo baixa, EmpresaContabilidade empresaContabil) {
        PlanoContaGerencial pcGerencial;
        Short debCred;
        Object historico = "Valor Dev. NF ";
        CentroCusto centroCusto = null;
        if (ToolMethods.isEquals((Object)baixa.getGrupoDeBaixaFormas().getFormaPagamento(), (Object)2) || ToolMethods.isEquals((Object)baixa.getGrupoDeBaixaFormas().getFormaPagamento(), (Object)8) || ToolMethods.isEquals((Object)baixa.getGrupoDeBaixaFormas().getFormaPagamento(), (Object)3)) {
            OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos = this.serviceOpcoesContabeisBaixaTitulosImpl.getOpcoesContabeisByBaixa(baixa, baixa.getTitulo().getEmpresa());
            centroCusto = opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao();
        }
        if (baixa.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec() == 0) {
            debCred = EnumLancamentoCTBGerencial.CREDITO.getValue();
            historico = (String)historico + "Terceiros: ";
            pcGerencial = empresaContabil.getPlanoDevGerenPagamento();
        } else {
            debCred = EnumLancamentoCTBGerencial.DEBITO.getValue();
            historico = (String)historico + "Propria: ";
            pcGerencial = empresaContabil.getPlanoDevGerenRecebimento();
        }
        historico = (String)historico + String.valueOf(baixa.getTitulo().getPessoa());
        LancamentoCtbGerencial lancamentoCtbGerencial = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(baixa.getLancamentoCtbGerencial(), baixa.getGrupoDeBaixaFormas().getGrupoDeBaixa().getDataLiquidacao(), baixa.getGrupoDeBaixaFormas().getGrupoDeBaixa().getDataLiquidacao(), debCred, baixa.getGrupoDeBaixaFormas().getGrupoDeBaixa().getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), (String)historico, pcGerencial, baixa.getTitulo().getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue()), centroCusto, baixa.getValor(), null);
        baixa.setLancamentoCtbGerencial(lancamentoCtbGerencial);
    }

    private void gerarLancamentosGerenciaisRenegociacao(BaixaTitulo baixa, EmpresaContabilidade empresaContabil) throws ExceptionService {
        PlanoContaGerencial planoContaGerencial;
        Short debCred;
        if (baixa.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec() == 0) {
            debCred = EnumLancamentoCTBGerencial.CREDITO.getValue();
            planoContaGerencial = empresaContabil.getPcGerRenegociacaoPag();
            if (empresaContabil.getPcGerRenegociacaoPag() == null) {
                throw new ExceptionService("Informe a conta gerencial de renegocia??o no cadastro da empresa contabilidade.");
            }
        } else {
            debCred = EnumLancamentoCTBGerencial.DEBITO.getValue();
            planoContaGerencial = empresaContabil.getPcGerRenegociacaoRec();
            if (empresaContabil.getPcGerRenegociacaoRec() == null) {
                throw new ExceptionService("Informe a conta gerencial de renegocia??o no cadastro da empresa contabilidade.");
            }
        }
        LancamentoCtbGerencial lancamentoCtbGerencial = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(baixa.getLancamentoCtbGerencial(), baixa.getGrupoDeBaixaFormas().getGrupoDeBaixa().getDataLiquidacao(), baixa.getGrupoDeBaixaFormas().getGrupoDeBaixa().getDataLiquidacao(), debCred, baixa.getGrupoDeBaixaFormas().getGrupoDeBaixa().getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Valor Referente a Renegocia??o de Titulo de " + baixa.getTitulo().getPessoa().getNome(), planoContaGerencial, baixa.getTitulo().getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue()), null, baixa.getValor(), null);
        baixa.setLancamentoCtbGerencial(lancamentoCtbGerencial);
    }

    private void gerarLancamentosGerenciaisFaltaPagamento(BaixaTitulo baixa, EmpresaContabilidade empresaContabil, OpcoesGerenciais opcoesGerenciais) throws ExceptionService {
        CentroCusto centroCusto = null;
        if (baixa.getContasBaixa() != null && baixa.getContasBaixa().getCentroCustoFaltaPagamento() != null) {
            centroCusto = baixa.getContasBaixa().getCentroCustoFaltaPagamento();
        } else if (opcoesGerenciais != null && opcoesGerenciais.getLancarCentroCusto() != null && opcoesGerenciais.getLancarCentroCusto().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
            throw new ExceptionService("Informar Centro de Custo para Falta de Pagamento!");
        }
        PlanoContaGerencial planoContaGerencial = baixa.getContasBaixa() != null && baixa.getContasBaixa().getPlanoContaGerencialFaltaPagamento() != null ? baixa.getContasBaixa().getPlanoContaGerencialFaltaPagamento() : empresaContabil.getPlanoFaltaPagamentoGerencial();
        LancamentoCtbGerencial lancamentoCtbGerencial = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(baixa.getLancamentoCtbGerencial(), baixa.getGrupoDeBaixaFormas().getGrupoDeBaixa().getDataLiquidacao(), baixa.getGrupoDeBaixaFormas().getGrupoDeBaixa().getDataLiquidacao(), Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), baixa.getGrupoDeBaixaFormas().getGrupoDeBaixa().getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Titulo/Parcela: " + baixa.getTitulo().getIdentificador() + "/" + baixa.getTitulo().getNumParcTituloEstnota() + ". Pessoa: " + baixa.getTitulo().getPessoa().getNome() + ". Valor Referente a Falta de Pagamento ", planoContaGerencial, Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue()), centroCusto, baixa.getValor(), null);
        baixa.setLancamentoCtbGerencial(lancamentoCtbGerencial);
    }

    public class TituloComissaoRepresentante {
        private Representante representante;
        private Double baseCalculoComissao = 0.0;
        private Double percComissao = 0.0;
        private Double valorComissao = 0.0;

        public TituloComissaoRepresentante(UtilityGerarBaixasApuracaoValores this$0) {
        }

        public Representante getRepresentante() {
            return this.representante;
        }

        public void setRepresentante(Representante representante) {
            this.representante = representante;
        }

        public Double getBaseCalculoComissao() {
            return this.baseCalculoComissao;
        }

        public void setBaseCalculoComissao(Double baseCalculoComissao) {
            this.baseCalculoComissao = baseCalculoComissao;
        }

        public Double getPercComissao() {
            return this.percComissao;
        }

        public void setPercComissao(Double percComissao) {
            this.percComissao = percComissao;
        }

        public Double getValorComissao() {
            return this.valorComissao;
        }

        public void setValorComissao(Double valorComissao) {
            this.valorComissao = valorComissao;
        }
    }
}

