/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.notafiscalpropria.importarnfexml;

import com.touchcomp.basementor.model.impl.TagImpostosCooperado;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.DeParaItensNotaPropria;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.service.impl.deparaitensnotapropria.ServiceDeParaItensNotaPropriaImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatcliente.ServiceUnidadeFatClienteImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorxml.model.XMLNfePropria;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFePropria;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionCFOPNotFound;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionCategoriaSTNotFound;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionParametrizacaoCtbModFiscalNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.notafiscalpropria.importarnfexml.UtilityProcessarNota;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public class UtilityImportarNotaPropria {
    Namespace n = Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe");

    public HashMap readXml(File xml, NaturezaOperacao nat, Empresa emp) throws JDOMException, IOException, ExceptionService {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(xml), "UTF-8");
        SAXBuilder sb = new SAXBuilder();
        Document d = null;
        d = sb.build((Reader)reader);
        Element inf = d.getRootElement().getChild("NFe", this.n).getChild("infNFe", this.n);
        HashMap<String, Object> h = new HashMap<String, Object>();
        UnidadeFatCliente cliente = this.findDestinatario(inf);
        h.put("UNIDADE_FAT_CLIENTE", cliente);
        Empresa empresa = this.findEmitente(inf);
        h.put("EMITENTE", empresa);
        h.put("PRODUTOS", this.findProdutos(inf, cliente, nat, emp));
        return h;
    }

    private UnidadeFatCliente findDestinatario(Element inf) throws ExceptionService {
        String cnpj = "";
        String ie = "";
        cnpj = inf.getChild("dest", this.n).getChild("CNPJ", this.n) != null ? inf.getChild("dest", this.n).getChild("CNPJ", this.n).getText() : inf.getChild("dest", this.n).getChild("CPF", this.n).getText();
        if (inf.getChild("dest", this.n).getChild("IE", this.n) != null) {
            ie = inf.getChild("dest", this.n).getChild("IE", this.n).getText();
        }
        ServiceUnidadeFatClienteImpl service = (ServiceUnidadeFatClienteImpl)Context.get(ServiceUnidadeFatClienteImpl.class);
        UnidadeFatCliente unid = null;
        unid = ToolMethods.isStrWithData((String)ie) ? service.getCNPJInscEstAtivo(cnpj, ie) : service.findUnidadeFatByCpfCnpj(cnpj);
        if (unid == null) {
            throw new ExceptionService("Cliente n\u00e3o Encontrado com o CNPJ: " + cnpj);
        }
        return unid;
    }

    private Empresa findEmitente(Element inf) throws ExceptionService {
        String cnpj = "";
        cnpj = inf.getChild("emit", this.n).getChild("CNPJ", this.n) != null ? inf.getChild("emit", this.n).getChild("CNPJ", this.n).getText() : inf.getChild("emit", this.n).getChild("CPF", this.n).getText();
        String hql = " select e from Empresa e where e.pessoa.complemento.cnpj = :cnpj";
        Empresa empresa = (Empresa)CoreBdUtil.getInstance().getSession().createQuery(hql).setText("cnpj", cnpj).uniqueResult();
        if (empresa == null) {
            throw new ExceptionService("Emitente n\u00e3o Cadastrado com o CNPJ: " + cnpj);
        }
        return empresa;
    }

    private List<DeParaItensNotaPropria> findProdutos(Element inf, UnidadeFatCliente unid, NaturezaOperacao nat, Empresa empresa) {
        ArrayList<DeParaItensNotaPropria> deParaNota = new ArrayList<DeParaItensNotaPropria>();
        List lista = inf.getChildren("det", this.n);
        for (Object object : lista) {
            Element det = (Element)object;
            String codigo = det.getChild("prod", this.n).getChild("cProd", this.n).getText();
            String descricao = det.getChild("prod", this.n).getChild("xProd", this.n).getText();
            String cst = this.getCST(det);
            DeParaItensNotaPropria dePara = this.findParaNotaPropria(codigo, descricao, unid, cst, nat, empresa);
            deParaNota.add(dePara);
        }
        return deParaNota;
    }

    private DeParaItensNotaPropria findParaNotaPropria(String codigoProduto, String descricao, UnidadeFatCliente unid, String cstIcms, NaturezaOperacao nat, Empresa emp) {
        ServiceDeParaItensNotaPropriaImpl service = (ServiceDeParaItensNotaPropriaImpl)Context.get(ServiceDeParaItensNotaPropriaImpl.class);
        return service.getDePara(codigoProduto, descricao, unid, cstIcms, nat, emp);
    }

    public List createNotaPropria(List<File> files, List<DeParaItensNotaPropria> deParas, OpcoesFaturamento opcoesFaturamento, CondicoesPagamento condicaoPagamento, OpcoesFinanceiras opcoesFinanceira, EmpresaContabilidade empresaContabil, String parcelas, Short respeitarImpostosIcms, Short respeitarImpostosPisCofins, Short respeitarImpostosIpi, Short respeitarOutrosImpostos, OpcoesContabeis opcoesContabeis, TagImpostosCooperado tagsImpostosCooperado, MeioPagamento meioPagamento, Short considerarVlrOutrosDespAcess, OpcoesImpostos opImpostos) throws JDOMException, IOException, ExceptionService, ExceptionParametrizacaoCtbModFiscalNotFound, ExceptionDatabase, ExceptionCFOPNotFound, ExceptionCategoriaSTNotFound, ExceptionCalculoICMS, ExceptionCalculoIPI, ExceptionCalculoPisCofins, ExceptionGeracaoTitulos, ExceptionAvaliadorExpressoes, ExceptionValidacaoDados, ExceptionInvalidData {
        ArrayList aux = new ArrayList();
        for (File xml : files) {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(xml), "UTF-8");
            SAXBuilder sb = new SAXBuilder();
            Document d = null;
            d = sb.build((Reader)reader);
            NotaFiscalPropria nota = new UtilityProcessarNota().getProcessarNota(d, deParas, opcoesFaturamento, condicaoPagamento, opcoesFinanceira, empresaContabil, parcelas, respeitarImpostosIcms, respeitarImpostosPisCofins, respeitarImpostosIpi, respeitarOutrosImpostos, opcoesContabeis, tagsImpostosCooperado, meioPagamento, considerarVlrOutrosDespAcess, opImpostos);
            for (InfPagamentoNfPropria inf : nota.getInfPagamentoNfPropria()) {
                inf.setNotaFiscalPropria(nota);
                for (Titulo t : inf.getTitulos()) {
                    t.setInfPagamentoNfPropria(inf);
                }
            }
            nota = (NotaFiscalPropria)CoreDAOFactory.getInstance().getDAONotaFiscalPropria().saveOrUpdate(nota);
            HashMap<String, Object> hash = new HashMap<String, Object>();
            hash.put("NFE", nota);
            hash.put("FILE", xml);
            aux.add(hash);
        }
        return aux;
    }

    public static XMLNfePropria createXmlNotaPropria(NotaFiscalPropria notaFiscalPropria) {
        ServiceXMLNFePropria service = (ServiceXMLNFePropria)ConfApplicationContext.getBean(ServiceXMLNFePropria.class);
        return service.getOrCreateXMLNfePropria(notaFiscalPropria.getIdentificador());
    }

    public static void saveOrUpdateXMLNotaPropria(XMLNfePropria x) {
        ServiceXMLNFePropria service = (ServiceXMLNFePropria)ConfApplicationContext.getBean(ServiceXMLNFePropria.class);
        service.saveOrUpdate((Object)x);
    }

    public boolean verificarExistenciaParametrizacaoNfe() {
        String hql = " select p  from ParametrizacaoImportacaoNfePropria p ";
        Object obj = CoreBdUtil.getInstance().getSession().createQuery(hql).uniqueResult();
        if (obj != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String getCST(Element det) {
        Element imposto = det.getChild("imposto", this.n);
        if (imposto == null) {
            return null;
        }
        Element icms = imposto.getChild("ICMS", this.n);
        if (icms == null || icms.getChildren().isEmpty()) {
            return null;
        }
        Element detIcms = (Element)icms.getChildren().get(0);
        String proc = detIcms.getChildText("orig", this.n);
        String cst = detIcms.getChildText("CST", this.n);
        return proc + cst;
    }
}

