/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.notafiscalpropria.importarnfexml;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementor.constants.enums.piscofins.EnumConstTipoAliquotaPisCofins;
import com.touchcomp.basementor.model.vo.DadosTransNfPropria;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EstoqueTerceiros;
import com.touchcomp.basementor.model.vo.GeracaoNfeAutomatizada;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.PeriodoEmissaoNFe;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.ValoresNfPropria;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;
import com.touchcomp.basementorservice.helpers.impl.centroestoque.HelperCentroEstoque;
import com.touchcomp.basementorservice.helpers.impl.naturezaoperacao.HelperNaturezaOperacao;
import com.touchcomp.basementorservice.helpers.impl.notapropria.HelperItemNotaPropria;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionCFOPNotFound;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionCategoriaSTNotFound;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.calculoimpostos.CalculosImpFiscaisNotaPropria;
import mentorcore.utilities.impl.notafiscalpropria.UtilityNotaFiscalPropria;

public class UtilityNotaAutomatizada {
    public NotaFiscalPropria criarNfePropria(GeracaoNfeAutomatizada nfeAutomatica, OpcoesFaturamento opcoesFaturamento, OpcoesFinanceiras opcoesFinanceiras, List<HashMap> saldos, Usuario usuario, OpcoesEstoque opcoesEstoque, EmpresaContabilidade empresaContabilidade, OpcoesImpostos opcoesImposto) throws ExceptionService, ExceptionCFOPNotFound, ExceptionAvaliadorExpressoes, ExceptionCategoriaSTNotFound, ExceptionCalculoICMS, ExceptionCalculoIPI, ExceptionCalculoPisCofins, ExceptionDatabase, ExceptionInvalidData {
        NaturezaOperacao natureza = nfeAutomatica.getNaturezaOperacao();
        NotaFiscalPropria n = new NotaFiscalPropria();
        n.setInformarDadosReformaTributaria(opcoesFaturamento.getInformarDadosReformaTributaria());
        n.setDataCadastro(new Date());
        n.setDataAtualizacao(nfeAutomatica.getDataAtualizacao());
        n.setGeradaNFCe(Short.valueOf((short)0));
        n.setSituacaoDocumento(this.getSituacaoDocumento("00"));
        n.setSerie(((HelperNaturezaOperacao)Context.get(HelperNaturezaOperacao.class)).build(natureza).getSerie(nfeAutomatica.getEmpresa()));
        n.setSerieInf(n.getSerie());
        n.setEmpresa(nfeAutomatica.getEmpresa());
        n.setUnidadeFatCliente(nfeAutomatica.getUnidadeFatCliente());
        n.setClassificacaoCliente(n.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
        n.setCategoriaPessoa(n.getUnidadeFatCliente().getCategoriaPessoa());
        n.setNaturezaOperacao(natureza);
        n.setCondicaoPagamento(nfeAutomatica.getCondicoesPagamento());
        n.setCodChaveAcesso(CoreUtilityFactory.getUtilityNFe().getCodAcesso(opcoesFaturamento.getVersaoNFe()));
        n.setModeloDocFiscal(natureza.getModeloDocFiscal());
        n.setVersaoNfe(opcoesFaturamento.getVersaoNFe());
        n.setPeriodoEmissaoNFe(this.getPeriodoEmissaoAtivo(opcoesFaturamento.getEmpresa()));
        n.setTipoEmissao(n.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo());
        n.setFinalidadeEmNFe(n.getNaturezaOperacao().getFinalidadeEmNFe());
        n.setFinalidadeEmNFeTipo(n.getNaturezaOperacao().getFinalidadeEmNFeTipo());
        n.setMotivo("Nota nao Enviada");
        n.setFormatoImpressao(Short.valueOf((short)1));
        n.setStatus(Short.valueOf((short)0));
        n.setNrProtocolo("");
        n.setLiberarImpDanfe(Short.valueOf((short)0));
        n.setDataEmissaoNota(nfeAutomatica.getDataEmissao());
        n.setDataEntradaSaida(nfeAutomatica.getDataSaida());
        n.setHoraEmissao(nfeAutomatica.getHoraEmissao());
        n.setHoraEntradaSaida(nfeAutomatica.getHoraSaida());
        n.setContribuinteEstado(n.getUnidadeFatCliente().getPessoa().getComplemento().getContribuinteEstado());
        if (nfeAutomatica.getCondicoesPagamento().getMeioPagamento() != null) {
            n.setMeioPagamento(nfeAutomatica.getCondicoesPagamento().getMeioPagamento());
        } else {
            n.setMeioPagamento(opcoesFinanceiras.getMeioPagamento());
        }
        n.setItensNotaPropria(this.getItens(saldos, nfeAutomatica, n, usuario, opcoesEstoque, empresaContabilidade, opcoesImposto, opcoesFaturamento));
        HashMap h = UtilityNotaFiscalPropria.calcularTotalizadores(n.getItensNotaPropria());
        if (n.getValoresNfPropria() == null) {
            n.setValoresNfPropria(new ValoresNfPropria());
        }
        n.getValoresNfPropria().setNotaFiscalPropria(n);
        n.getValoresNfPropria().setValorCofins((Double)h.get("vlrCofins"));
        n.getValoresNfPropria().setBcIcmsSt((Double)h.get("bcIcmsSt"));
        n.getValoresNfPropria().setValorCofinsSt((Double)h.get("vlrCofinsSt"));
        n.getValoresNfPropria().setValorContSoc((Double)h.get("vlrContSoc"));
        n.getValoresNfPropria().setValorDesconto((Double)h.get("vlrDesconto"));
        n.getValoresNfPropria().setValorDespAcess((Double)h.get("vlrDespAcess"));
        n.getValoresNfPropria().setValorFrete((Double)h.get("vlrFrete"));
        n.getValoresNfPropria().setValorFunrural((Double)h.get("vlrFunrural"));
        n.getValoresNfPropria().setValorIpiComercio((Double)h.get("vlrIpiComercio"));
        n.getValoresNfPropria().setValorIcms((Double)h.get("vlrIcms"));
        n.getValoresNfPropria().setValorIcmsDesonerado((Double)h.get("valorIcmsDesonerado"));
        n.getValoresNfPropria().setValorIcmsIsento((Double)h.get("vlrIcmsIsento"));
        n.getValoresNfPropria().setValorIcmsOutros((Double)h.get("vlrIcmsOutros"));
        n.getValoresNfPropria().setValorIcmsSa((Double)h.get("vlrIcmsSA"));
        n.getValoresNfPropria().setValorIcmsSt((Double)h.get("vlrIcmsSt"));
        n.getValoresNfPropria().setBcIcmsSt((Double)h.get("bcIcmsSt"));
        n.getValoresNfPropria().setValorIcmsTributado((Double)h.get("vlrIcmsTrib"));
        n.getValoresNfPropria().setValorInss((Double)h.get("vlrInss"));
        n.getValoresNfPropria().setValorInssNaoRetido((Double)h.get("vlrInssNaoRet"));
        n.getValoresNfPropria().setValorIpiIndustria((Double)h.get("vlrIpiInd"));
        n.getValoresNfPropria().setValorIpiIsento((Double)h.get("vlrIpiIsento"));
        n.getValoresNfPropria().setValorIpiOutros((Double)h.get("vlrIpiOutros"));
        n.getValoresNfPropria().setValorIpiTributado((Double)h.get("bcIpi"));
        n.getValoresNfPropria().setValorIrrf((Double)h.get("vlrIrrf"));
        n.getValoresNfPropria().setValorIss((Double)h.get("vlrIss"));
        n.getValoresNfPropria().setValorLei10833((Double)h.get("vlrLei10833"));
        n.getValoresNfPropria().setValorOutros((Double)h.get("vlrOutros"));
        n.getValoresNfPropria().setValorPis((Double)h.get("vlrPis"));
        n.getValoresNfPropria().setValorPisSt((Double)h.get("vlrPisST"));
        n.getValoresNfPropria().setValorProduto((Double)h.get("vlrProduto"));
        n.getValoresNfPropria().setValorSeguro((Double)h.get("vlrSeguro"));
        n.getValoresNfPropria().setValorServico((Double)h.get("vlrServico"));
        n.getValoresNfPropria().setValorSestSenat((Double)h.get("vlrSestSenat"));
        n.getValoresNfPropria().setValorTotal((Double)h.get("vlrTotal"));
        n.getValoresNfPropria().setVrBcCofins((Double)h.get("valorBcCofins"));
        n.getValoresNfPropria().setVrBcPis((Double)h.get("vlrBCPis"));
        n.getValoresNfPropria().setValorImpImportacao((Double)h.get("valorImpImportacao"));
        n.getValoresNfPropria().setValorEstImpostos((Double)h.get("vlrEstimadoImp"));
        n.getValoresNfPropria().setAliquotaEstImpostos((Double)h.get("aliqEstimadaImp"));
        n.getValoresNfPropria().setValorFCP((Double)h.get("valorFCP"));
        n.getValoresNfPropria().setValorFCPSt((Double)h.get("valorFCPSt"));
        n.getValoresNfPropria().setValorFCPStRetido((Double)h.get("valorFCPStRetido"));
        n.getValoresNfPropria().setValorIcmsDiferimento((Double)h.get("valorIcmsDiferimento"));
        n.getValoresNfPropria().setValorSenar((Double)h.get("valorSenar"));
        n.getValoresNfPropria().setValorRAT((Double)h.get("valorRat"));
        n.getValoresNfPropria().setValorTaxaSanidadeAnimal((Double)h.get("valorTaxaSanidadeAnimal"));
        n.setValoresNfPropria(new ValoresNfPropria());
        n.getValoresNfPropria().setNotaFiscalPropria(n);
        n.setDadosTransNfPropria(new DadosTransNfPropria());
        n.getDadosTransNfPropria().setNotaFiscalPropria(n);
        n.getDadosTransNfPropria().setTipoFrete(n.getUnidadeFatCliente().getCliente().getFaturamento().getTipoFrete());
        n.getDadosTransNfPropria().setTransportador(n.getUnidadeFatCliente().getCliente().getFaturamento().getTransportadora());
        InfPagamentoNfPropria i = new InfPagamentoNfPropria();
        i.setValor(n.getValoresNfPropria().getValorTotal());
        i.setNotaFiscalPropria(n);
        MeioPagamento meioPagamento = nfeAutomatica.getCondicoesPagamento().getMeioPagamento();
        if (meioPagamento != null) {
            i.setMeioPagamento(meioPagamento);
            i.setTipoPagamentoNFe(meioPagamento.getTipoPagamentoNFe());
        }
        n.setInfPagamentoNfPropria(new ArrayList());
        n.getInfPagamentoNfPropria().add(i);
        new CalculosImpFiscaisNotaPropria().calcularImpostosFiscaisItNotaPropria(n, opcoesFaturamento, empresaContabilidade, opcoesImposto);
        n.setLivrosFiscais(new UtilityNotaFiscalPropria().getLivroFiscaisResumo(n.getItensNotaPropria(), new ArrayList(), n.getModeloDocFiscal(), n.getSituacaoDocumento()));
        CoreUtilityFactory.getUtilityNotaFiscalPropria().calcularTotalizadores(n);
        return n;
    }

    private SituacaoDocumento getSituacaoDocumento(String codigo) throws ExceptionService {
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("codigo", codigo);
        return (SituacaoDocumento)CoreServiceFactory.getServiceSituacaoDocumento().execute(cq, "getSituacaoDocumento");
    }

    private PeriodoEmissaoNFe getPeriodoEmissaoAtivo(Empresa empresa) throws ExceptionService {
        return (PeriodoEmissaoNFe)CoreServiceFactory.getServicePeriodoEmissaoNFe().execute(CoreRequestContext.newInstance().setAttribute("empresa", empresa), "findPeriodoEmissaoNFeAtivo");
    }

    private List<ItemNotaFiscalPropria> getItens(List<HashMap> saldosEstoqueTerceiros, GeracaoNfeAutomatizada vo, NotaFiscalPropria nota, Usuario usuario, OpcoesEstoque opcoesEstoque, EmpresaContabilidade empresaContabilidade, OpcoesImpostos opcoesImposto, OpcoesFaturamento opcoesFaturamento) throws ExceptionService, ExceptionCFOPNotFound, ExceptionCategoriaSTNotFound, ExceptionCalculoICMS, ExceptionCalculoIPI, ExceptionCalculoPisCofins, ExceptionDatabase, ExceptionInvalidData {
        Double quantidade = vo.getQuantidade();
        ArrayList<ItemNotaFiscalPropria> itens = new ArrayList<ItemNotaFiscalPropria>();
        ItemNotaFiscalPropria item = null;
        for (HashMap hash : saldosEstoqueTerceiros) {
            Object obj = hash.get("grade");
            BigDecimal saldo = (BigDecimal)hash.get("SALDO");
            if (saldo.doubleValue() >= quantidade) {
                item = this.createItemNotaPropria(quantidade, obj, nota, usuario, vo, opcoesEstoque, 1, opcoesFaturamento, empresaContabilidade, opcoesImposto);
                itens.add(item);
                return itens;
            }
            if (quantidade > 0.0) {
                quantidade = quantidade - saldo.doubleValue();
                item = this.createItemNotaPropria(saldo.doubleValue(), obj, nota, usuario, vo, opcoesEstoque, 1, opcoesFaturamento, empresaContabilidade, opcoesImposto);
                itens.add(item);
                continue;
            }
            throw new ExceptionService("N\u00e3o existe saldo suficiente para esta quantidade.");
        }
        return itens;
    }

    private ItemNotaFiscalPropria createItemNotaPropria(Double quantidade, Object obj, NotaFiscalPropria nota, Usuario usuario, GeracaoNfeAutomatizada nfe, OpcoesEstoque opcoesEstoque, Integer numeroItem, OpcoesFaturamento opcoesFaturamento, EmpresaContabilidade empresaContabilidade, OpcoesImpostos opcoesImposto) throws ExceptionService, ExceptionCFOPNotFound, ExceptionCategoriaSTNotFound, ExceptionCalculoICMS, ExceptionCalculoIPI, ExceptionCalculoPisCofins, ExceptionDatabase, ExceptionInvalidData {
        ItemNotaFiscalPropria item = new ItemNotaFiscalPropria();
        item.setNotaFiscalPropria(nota);
        GradeItemNotaFiscalPropria gr = (GradeItemNotaFiscalPropria)obj;
        item.setCentroEstoque(((HelperCentroEstoque)ConfApplicationContext.getBean(HelperCentroEstoque.class)).getCentroEstoque(opcoesEstoque, nfe.getEmpresa(), nfe.getProduto(), usuario, nfe.getNaturezaOperacao(), nfe.getUnidadeFatCliente(), nfe.getUnidadeFatCliente().getPessoa()));
        item.setQuantidadeTotal(quantidade);
        item.setValorUnitario(gr.getItemNotaFiscalPropria().getValorUnitario());
        item.setVrProduto(Double.valueOf(item.getValorUnitario() * quantidade));
        item.setValorFrete(Double.valueOf(0.0));
        item.setVrSeguro(Double.valueOf(0.0));
        item.setValorDesconto(Double.valueOf(0.0));
        item.setValorDespAcessoria(Double.valueOf(0.0));
        item.setFatorConversao(Double.valueOf(1.0));
        item.setNumeroItem(numeroItem);
        item.setProduto(nfe.getProduto());
        item.setUnidadeMedida(nfe.getProduto().getUnidadeMedida());
        item.setItemNotaLivroFiscal(new ItemNotaLivroFiscal());
        item.getItemNotaLivroFiscal().setItemNotaFiscalPropria(item);
        item.setIndicadorTotal(Short.valueOf((short)1));
        item.setModeloFiscal(nfe.getModeloFiscal());
        item.setGerarFinanceiro(item.getModeloFiscal().getGerarFinanceiro());
        item.setGradesNotaFiscalPropria(this.getGradeItemNotaFiscalPropria(item.getValorUnitario(), item.getQuantidadeTotal(), nota.getDataEntradaSaida(), item, nota.getEmpresa(), nota.getNaturezaOperacao().getEntradaSaida(), gr, nfe));
        ModeloFiscal mod = item.getModeloFiscal();
        Produto prod = item.getProduto();
        item.setIncidenciaIcms(mod.getModeloFiscalIcms().getIncidenciaIcms());
        item.setIncidenciaIpi(mod.getModeloFiscalIpi().getIncidenciaIpi());
        item.setIncidenciaPisCofins(mod.getModeloFiscalPisCofins().getIncidenciaPisCofins());
        item.setModalidadeIcms(mod.getModeloFiscalIcms().getModalidadeIcms());
        item.setModalidadeIcmsSt(mod.getModeloFiscalIcms().getModalidadeIcmsSt());
        item.setIssRetido(Short.valueOf(mod.getIssRetido().equals((short)1) ? (short)1 : 0));
        if (nota.getNaturezaOperacao().getEntradaSaida().equals((short)1)) {
            item.getItemNotaLivroFiscal().setCfop(CoreUtilityFactory.getUtilityCFOP().findCfopSaida(nota.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nota.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), mod, EnumConstNFeIndicadorPresConsumidor.valueOfCodigo((Short)nota.getIndicadorPresencaConsumidor())));
        } else {
            item.getItemNotaLivroFiscal().setCfop(CoreUtilityFactory.getUtilityCFOP().findCfopEntrada(nota.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nota.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), mod));
        }
        if (mod.getTipoIRRF() != null && mod.getTipoIRRF() == 1) {
            item.getItemNotaLivroFiscal().setAliquotaIrrf(prod.getAliquotaIrrf());
            item.getItemNotaLivroFiscal().setPercRedIrrf(prod.getPercRedIrrf());
        }
        if (mod.getTipoFunrural() != null && mod.getTipoFunrural() == 1) {
            item.getItemNotaLivroFiscal().setAliquotaFunrural(prod.getAliquotaFunrural());
            item.getItemNotaLivroFiscal().setPercRedFunrural(prod.getPercRedFunrural());
        }
        if (mod.getTipoSenar() != null && mod.getTipoSenar() == 1) {
            item.getItemNotaLivroFiscal().setAliquotaSenar(prod.getAliquotaSenar());
        }
        if (mod.getTipoRat() != null && mod.getTipoRat() == 1) {
            item.getItemNotaLivroFiscal().setAliquotaRat(prod.getAliquotaRat());
        }
        if (mod.getTipoTaxaAnimal() != null && mod.getTipoTaxaAnimal() == 1) {
            item.getItemNotaLivroFiscal().setTaxaSanidadeAnimal(prod.getTaxaSanidadeAnimal());
            item.getItemNotaLivroFiscal().setFatorTaxaSanidadeAnimal(prod.getFatorTaxaSanidadeAnimal());
        }
        if (mod.getTipoLei10833() != null && mod.getTipoLei10833() == 1) {
            item.getItemNotaLivroFiscal().setAliquotaLei10833(prod.getAliquotaLei10833());
            item.getItemNotaLivroFiscal().setPercRedLei10833(prod.getPercRedLei10833());
        }
        if (mod.getTipoOutros() != null && mod.getTipoOutros() == 1) {
            item.getItemNotaLivroFiscal().setAliquotaOutros(prod.getAliquotaOutros());
            item.getItemNotaLivroFiscal().setPercRedOutros(prod.getPercRedOutros());
        }
        if (mod.getTipoContSoc() != null && mod.getTipoContSoc() == 1) {
            item.getItemNotaLivroFiscal().setAliquotaContSoc(prod.getAliquotaContSoc());
            item.getItemNotaLivroFiscal().setPercRedContSoc(prod.getPercRedContSoc());
        }
        if (mod.getIssRetido() != null && mod.getIssRetido() != 2) {
            item.getItemNotaLivroFiscal().setAliquotaIss(prod.getAliquotaIss());
        }
        if (mod.getModeloFiscalPisCofins().getCalcularPisNormal().equals((short)1)) {
            if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                item.getItemNotaLivroFiscal().setAliquotaPis(mod.getModeloFiscalPisCofins().getAliquotaPis());
            } else {
                item.getItemNotaLivroFiscal().setAliquotaPis(item.getProduto().getAliquotaPis());
            }
        } else {
            item.getItemNotaLivroFiscal().setAliquotaPis(Double.valueOf(0.0));
        }
        if (mod.getModeloFiscalPisCofins().getCalcularPisSt().equals((short)1)) {
            if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                item.getItemNotaLivroFiscal().setAliquotaPisSt(mod.getModeloFiscalPisCofins().getAliquotaPisSt());
            } else {
                item.getItemNotaLivroFiscal().setAliquotaPisSt(item.getProduto().getAliquotaPisSt());
            }
        } else {
            item.getItemNotaLivroFiscal().setAliquotaPisSt(Double.valueOf(0.0));
        }
        if (mod.getModeloFiscalPisCofins().getCalcularCofinsNormal().equals((short)1)) {
            if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                item.getItemNotaLivroFiscal().setAliquotaCofins(mod.getModeloFiscalPisCofins().getAliquotaCofins());
            } else {
                item.getItemNotaLivroFiscal().setAliquotaCofins(item.getProduto().getAliquotaCofins());
            }
        } else {
            item.getItemNotaLivroFiscal().setAliquotaCofins(Double.valueOf(0.0));
        }
        if (mod.getModeloFiscalPisCofins().getCalcularCofinsSt().equals((short)1)) {
            if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                item.getItemNotaLivroFiscal().setAliquotaCofinsSt(mod.getModeloFiscalPisCofins().getAliquotaCofinsSt());
            } else {
                item.getItemNotaLivroFiscal().setAliquotaCofinsSt(item.getProduto().getAliquotaCofinsSt());
            }
        } else {
            item.getItemNotaLivroFiscal().setAliquotaCofinsSt(Double.valueOf(0.0));
        }
        item.getItemNotaLivroFiscal().setAliquotaIcms(new HelperItemNotaPropria().findAliquotaIcms(nota.getNaturezaOperacao(), mod, nota.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nota.getUnidadeFatCliente().getCliente().getPessoa().getEndereco().getCidade().getUf(), prod));
        if (ToolMethods.isEquals((Object)mod.getModeloFiscalIcms().getTipoPercReducaoBaseCalcIcms(), (Object)2)) {
            item.getItemNotaLivroFiscal().setPercReducaoBCIcms(mod.getModeloFiscalIcms().getReducaoBaseCalcIcms());
        } else {
            item.getItemNotaLivroFiscal().setPercReducaoBCIcms(prod.getReducaoBaseCalcIcms());
        }
        Double aliqIpi = BaseCalculoValores.getAliquotaIpi((Produto)prod, (ModeloFiscalIpi)mod.getModeloFiscalIpi());
        item.getItemNotaLivroFiscal().setAliquotaIpi(aliqIpi);
        if (mod.getTipoINSS() != null && mod.getTipoINSS() == 1) {
            item.getItemNotaLivroFiscal().setAliquotaInss(prod.getAliquotaInss());
            item.getItemNotaLivroFiscal().setPercRedBcInss(prod.getPercRedBCINSS());
        }
        item.setCest(item.getProduto().getCest());
        item.setNcm(item.getProduto().getNcm());
        if (mod.getTipoINSS() != null && (mod.getTipoINSS() == 1 || mod.getTipoINSS() == 3)) {
            item.getItemNotaLivroFiscal().setAliquotaInss(prod.getAliquotaInss());
            item.getItemNotaLivroFiscal().setPercRedBcInss(prod.getPercRedBCINSS());
        }
        new HelperItemNotaPropria().setParamTribAndParametrosCBSIBSIS(item, nfe.getEmpresa(), nfe.getDataEmissao(), nfe.getNaturezaOperacao(), nfe.getUnidadeFatCliente());
        new CalculosImpFiscaisNotaPropria().calcularImpostosFiscaisItNotaPropria(item, nota.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nota.getUnidadeFatCliente(), nota.getSituacaoDocumento(), nota.getEmpresa(), nota.getIndicadorConsumidorFinal(), opcoesFaturamento, nota.getDataEmissaoNota(), empresaContabilidade, opcoesImposto, nota.getNaturezaOperacao());
        return item;
    }

    private List<GradeItemNotaFiscalPropria> getGradeItemNotaFiscalPropria(Double valorUnitario, Double quantidade, Date dataEntradaSaida, ItemNotaFiscalPropria item, Empresa empresa, Short entradaSaida, GradeItemNotaFiscalPropria grr, GeracaoNfeAutomatizada nfe) throws ExceptionService, ExceptionDatabase {
        ArrayList<GradeItemNotaFiscalPropria> gr = new ArrayList<GradeItemNotaFiscalPropria>();
        item.setFatorConversao(Double.valueOf(1.0));
        GradeItemNotaFiscalPropria g = new GradeItemNotaFiscalPropria();
        g.setDataEntradaSaida(nfe.getDataSaida());
        g.setItemNotaFiscalPropria(item);
        g.setGradeCor(grr.getGradeCor());
        g.setFatorConversao(item.getFatorConversao());
        g.setCentroEstoque(item.getCentroEstoque());
        g.setEmpresa(empresa);
        g.setEntradaSaida(entradaSaida);
        g.setLoteFabricacao(grr.getLoteFabricacao());
        g.setQuantidade(quantidade);
        g.setValorCusto(grr.getValorCusto());
        g.setMovimentacaoFisica(item.getModeloFiscal().getMovimentacaoFisica());
        EstoqueTerceiros estoqueTerceiros = this.criaEstoqueTerceiros(nfe);
        estoqueTerceiros.setEstoqueTerceirosMae(grr.getEstoqueTerceiros());
        estoqueTerceiros.setGradeItemNotaPropria(g);
        estoqueTerceiros.setQuantidade(g.getQuantidade());
        g.setEstoqueTerceiros(estoqueTerceiros);
        gr.add(g);
        return gr;
    }

    public GradeCor findPrimeiraGradeCor(Produto pro) throws ExceptionService {
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("produto", pro);
        GradeCor gc = (GradeCor)CoreServiceFactory.getServiceGradeCor().execute(cq, "findPrimeiraGradeCor");
        if (gc == null) {
            throw new ExceptionService("Produto: " + pro.getNome() + " n\u00e3o possui Grade de Cor");
        }
        return gc;
    }

    public Object findLoteProduto(Produto produto) throws ExceptionDatabase {
        ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl = (ServiceLoteFabricacaoImpl)Context.get(ServiceLoteFabricacaoImpl.class);
        LoteFabricacao loteFab = serviceLoteFabricacaoImpl.findLoteUnico(produto);
        if (loteFab == null) {
            loteFab = new LoteFabricacao();
            loteFab.setLoteFabricacao("UNICO");
            loteFab.setDataFabricacao(new Date());
            loteFab.setProduto(produto);
            loteFab.setLoteFabricacao("UNICO");
            loteFab.setUnico(Short.valueOf((short)1));
            loteFab.setStatusLoteFabricacao(produto.getStatusLoteFabricacao());
            loteFab.setLoteBloqueado(produto.getStatusLoteFabricacao().getLoteBloqueado());
            loteFab = (LoteFabricacao)CoreDAOFactory.getInstance().getDAOLoteFabricacao().saveOrUpdate(loteFab);
        }
        return loteFab;
    }

    private EstoqueTerceiros criaEstoqueTerceiros(GeracaoNfeAutomatizada nfe) {
        EstoqueTerceiros estoqueTerceiros = new EstoqueTerceiros();
        estoqueTerceiros.setPessoaParceiro(nfe.getUnidadeFatCliente().getPessoa());
        estoqueTerceiros.setNaturezaOperacao(nfe.getNaturezaOperacao());
        estoqueTerceiros.setData(nfe.getDataSaida());
        estoqueTerceiros.setEmpresa(nfe.getEmpresa());
        return estoqueTerceiros;
    }
}

