/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.notafiscalpropria.importarnfexml;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstPadraoOutros;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementor.constants.enums.piscofins.EnumConstTipoAliquotaPisCofins;
import com.touchcomp.basementor.model.impl.TagImpostosCooperado;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Cooperado;
import com.touchcomp.basementor.model.vo.DadosTransNfPropria;
import com.touchcomp.basementor.model.vo.DeParaItensNotaPropria;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.ModeloFiscalObsContrib;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import com.touchcomp.basementor.model.vo.ObservacaoNotaPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.PeriodoEmissaoNFe;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilNF;
import com.touchcomp.basementorservice.helpers.impl.notapropria.HelperItemNotaPropria;
import com.touchcomp.basementorservice.service.impl.finalidademnfe.ServiceFinalidadeEmNFeImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionCFOPNotFound;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionCategoriaSTNotFound;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionParametrizacaoCtbModFiscalNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.service.impl.notafiscalpropria.importarnfexml.AuxImportarNotaPropriaCofins;
import mentorcore.service.impl.notafiscalpropria.importarnfexml.AuxImportarNotaPropriaICMS;
import mentorcore.service.impl.notafiscalpropria.importarnfexml.AuxImportarNotaPropriaICMSSN;
import mentorcore.service.impl.notafiscalpropria.importarnfexml.AuxImportarNotaPropriaIPI;
import mentorcore.service.impl.notafiscalpropria.importarnfexml.AuxImportarNotaPropriaPis;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.calculoimpostos.CalculosImpFiscaisNotaPropria;
import mentorcore.utilities.impl.notafiscalpropria.UtilityNotaFiscalPropria;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class UtilityProcessarNota {
    private final ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl = (ServiceLoteFabricacaoImpl)Context.get(ServiceLoteFabricacaoImpl.class);
    Namespace n = Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe");
    private static TLogger logger = TLogger.get(UtilityProcessarNota.class);

    public NotaFiscalPropria getProcessarNota(Document d, List<DeParaItensNotaPropria> deParas, OpcoesFaturamento opcoesFaturamento, CondicoesPagamento condicaoPagamento, OpcoesFinanceiras opcoesFinanceira, EmpresaContabilidade empresaContabilidade, String parcelas, Short respeitarImpostosIcms, Short respeitarImpostosPisCofins, Short respeitarImpostosIpi, Short respeitarOutrosImpostosCooperado, OpcoesContabeis opcoesContabeis, TagImpostosCooperado tagImpostosCooperado, MeioPagamento meioPagamento, Short considerarVlrOutrosDespAcess, OpcoesImpostos opImpostos) throws ExceptionService, ExceptionParametrizacaoCtbModFiscalNotFound, ExceptionDatabase, ExceptionCFOPNotFound, ExceptionCategoriaSTNotFound, ExceptionCalculoICMS, ExceptionCalculoIPI, ExceptionCalculoPisCofins, ExceptionGeracaoTitulos, ExceptionAvaliadorExpressoes, ExceptionValidacaoDados, ExceptionInvalidData {
        Element inf = d.getRootElement().getChild("NFe", this.n).getChild("infNFe", this.n);
        NotaFiscalPropria nota = new NotaFiscalPropria();
        nota.setInformarDadosReformaTributaria(opcoesFaturamento.getInformarDadosReformaTributaria());
        String campo = null;
        nota.setDataCadastro(new Date());
        campo = inf.getChild("ide", this.n).getChild("dhEmi", this.n).getText();
        nota.setDataEmissaoNota(DateUtil.strToDate(campo.substring(8, 10) + "/" + campo.substring(5, 7) + "/" + campo.substring(0, 4)));
        nota.setHoraEmissao(nota.getDataEmissaoNota());
        if (inf.getChild("ide", this.n).getChild("dhSaiEnt", this.n) != null) {
            campo = inf.getChild("ide", this.n).getChild("dhSaiEnt", this.n).getText();
            nota.setDataEntradaSaida(DateUtil.strToDate(campo.substring(8, 10) + "/" + campo.substring(5, 7) + "/" + campo.substring(0, 4)));
            nota.setHoraEntradaSaida(nota.getDataEntradaSaida());
        } else {
            nota.setDataEntradaSaida(nota.getDataEmissaoNota());
            nota.setHoraEntradaSaida(nota.getHoraEmissao());
        }
        nota.setEmpresa(opcoesFaturamento.getEmpresa());
        nota.setFaturadoSuframa(Short.valueOf((short)0));
        nota.setSituacaoDocumento(this.getSituacaoDocumento("00"));
        nota.setSerie(inf.getChild("ide", this.n).getChild("serie", this.n).getText());
        nota.setNumeroNota(new Integer(inf.getChild("ide", this.n).getChild("nNF", this.n).getText()));
        nota.setDigitoVerificador(new Integer(new Integer(inf.getChild("ide", this.n).getChild("cDV", this.n).getText())));
        nota.setCodChaveAcesso(new Integer(inf.getChild("ide", this.n).getChild("cNF", this.n).getText()));
        String obs = "";
        if (ToolMethods.isNotNull((Object)inf.getChild("infAdic", this.n)).booleanValue() && ToolMethods.isNotNull((Object)inf.getChild("infAdic", this.n).getChild("infCpl", this.n)).booleanValue()) {
            obs = inf.getChild("infAdic", this.n).getChild("infCpl", this.n).getText();
        }
        campo = d.getRootElement().getChild("NFe", this.n).getChild("infNFe", this.n).getAttributeValue("Id");
        nota.setChaveNFE(campo.substring(3, 47));
        nota.setVersaoNfe(opcoesFaturamento.getVersaoNFe());
        nota.setIndicadorPresencaConsumidor(Short.valueOf((short)9));
        nota.setFinalidadeEmNFe(((ServiceFinalidadeEmNFeImpl)Context.get(ServiceFinalidadeEmNFeImpl.class)).getByCodigo(inf.getChild("ide", this.n).getChild("finNFe", this.n).getText()));
        campo = inf.getChild("dest", this.n).getChild("CNPJ", this.n) != null ? inf.getChild("dest", this.n).getChild("CNPJ", this.n).getText() : inf.getChild("dest", this.n).getChild("CPF", this.n).getText();
        String inscEstadual = null;
        if (inf.getChild("dest", this.n).getChild("IE", this.n) != null) {
            inscEstadual = inf.getChild("dest", this.n).getChild("IE", this.n).getText();
        }
        nota.setUnidadeFatCliente(this.getUnidadeFatCliente(campo, inscEstadual, deParas));
        if (nota.getUnidadeFatCliente() != null) {
            nota.setClassificacaoCliente(nota.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
            nota.setCategoriaPessoa(nota.getUnidadeFatCliente().getCategoriaPessoa());
        }
        nota.setNaturezaOperacao(this.getNaturezaOperacao(campo, deParas));
        nota.setIndicadorEmitente(Short.valueOf((short)0));
        nota.setIndicadorConsumidorFinal(Short.valueOf((short)0));
        nota.setModeloDocFiscal(UtilityProcessarNota.getModeloPorCodigo("55"));
        nota.setEnviadoReceita(Short.valueOf((short)0));
        nota.setNumeroNotaInf(nota.getNumeroNota());
        nota.setSerieInf(nota.getSerie());
        nota.setChaveNFEInf(nota.getChaveNFE());
        nota.setStatus(Short.valueOf((short)100));
        nota.setMotivo("Autorizado o uso da NF-e");
        nota.setFormatoImpressao(opcoesFaturamento.getTipoImpressao());
        DadosTransNfPropria dadosTransNfPropria = new DadosTransNfPropria();
        dadosTransNfPropria.setTransportador(nota.getUnidadeFatCliente().getCliente().getFaturamento().getTransportadora());
        dadosTransNfPropria.setTipoFrete(nota.getUnidadeFatCliente().getCliente().getFaturamento().getTipoFrete());
        dadosTransNfPropria.setNotaFiscalPropria(nota);
        nota.setDadosTransNfPropria(dadosTransNfPropria);
        nota.setPeriodoEmissaoNFe(this.getPeriodoEmissaoAtivo(opcoesFaturamento.getEmpresa()));
        List listaItens = inf.getChildren("det", this.n);
        nota.setItensNotaPropria(this.getItensNota(nota, deParas, listaItens, opcoesFaturamento, respeitarImpostosIcms, respeitarImpostosPisCofins, respeitarImpostosIpi, empresaContabilidade, opcoesContabeis, opImpostos));
        nota.setObservacaoNota(this.getObsFaturamentoNotaPropria(nota, obs));
        if (meioPagamento != null) {
            nota.setMeioPagamento(meioPagamento);
        } else if (condicaoPagamento.getMeioPagamento() != null) {
            nota.setMeioPagamento(condicaoPagamento.getMeioPagamento());
        } else {
            nota.setMeioPagamento(opcoesFinanceira.getMeioPagamento());
        }
        this.verificarTotalizadoresOutrosImpostos(nota, inf, considerarVlrOutrosDespAcess);
        new UtilityNotaFiscalPropria().calcularTotalizadores(nota);
        nota.setLiberarImpDanfe(Short.valueOf((short)1));
        nota.setDigitoVerificador(new Integer(inf.getChild("ide", this.n).getChild("cDV", this.n).getText()));
        new CalculosImpFiscaisNotaPropria().calcularImpostosFiscaisItNotaPropria(nota, opcoesFaturamento, empresaContabilidade, opImpostos);
        nota.setLivrosFiscais(new UtilityNotaFiscalPropria().getLivroFiscaisResumo(nota.getItensNotaPropria(), new ArrayList(), nota.getModeloDocFiscal(), nota.getSituacaoDocumento()));
        CoreUtilityFactory.getUtilityNotaFiscalPropria().calcularTotalizadores(nota);
        this.setOutrosImpostosProdutorRural(inf, nota, respeitarOutrosImpostosCooperado, tagImpostosCooperado);
        this.arredondarImpostosCooperado(nota, respeitarOutrosImpostosCooperado);
        nota.setCondicaoPagamento(condicaoPagamento);
        nota.setParcelas(parcelas);
        CoreUtilityFactory.getUtilityTitulos().criarTitulos(nota, opcoesFinanceira, empresaContabilidade, opcoesContabeis);
        if (nota.getFinalidadeEmNFe() == null) {
            nota.setFinalidadeEmNFe(nota.getNaturezaOperacao().getFinalidadeEmNFe());
        }
        if (nota.getFinalidadeEmNFeTipo() == null) {
            nota.setFinalidadeEmNFeTipo(nota.getNaturezaOperacao().getFinalidadeEmNFeTipo());
        }
        return nota;
    }

    private SituacaoDocumento getSituacaoDocumento(String codigo) throws ExceptionService {
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("codigo", codigo);
        return (SituacaoDocumento)CoreServiceFactory.getServiceSituacaoDocumento().execute(cq, "getSituacaoDocumento");
    }

    private PeriodoEmissaoNFe getPeriodoEmissaoAtivo(Empresa empresa) throws ExceptionService {
        return (PeriodoEmissaoNFe)CoreServiceFactory.getServicePeriodoEmissaoNFe().execute(CoreRequestContext.newInstance().setAttribute("empresa", empresa), "findPeriodoEmissaoNFeAtivo");
    }

    public static ModeloDocFiscal getModeloPorCodigo(String string) throws ExceptionService {
        return (ModeloDocFiscal)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOModeloDocFiscal(), "codigo", string, 0);
    }

    private UnidadeFatCliente getUnidadeFatCliente(String cnpjXML, String inscEstadual, List<DeParaItensNotaPropria> deParas) throws ExceptionService {
        for (DeParaItensNotaPropria dePara : deParas) {
            if (!ToolMethods.isEquals((Object)dePara.getCliente().getPessoa().getComplemento().getCnpj(), (Object)cnpjXML)) continue;
            Optional<UnidadeFatCliente> un = dePara.getCliente().getUnidadeFatClientes().stream().filter(i -> ToolMethods.isEquals((Object)i.getPessoa().getComplemento().getInscEst(), (Object)inscEstadual)).findFirst();
            if (un.isPresent()) {
                return un.get();
            }
            if (ToolMethods.isStrWithData((String)inscEstadual)) {
                throw new ExceptionService("Nenhuma unidade de faturamento encontrada com a IE: " + inscEstadual + " no cliente: " + String.valueOf(dePara.getCliente()));
            }
            return (UnidadeFatCliente)dePara.getCliente().getUnidadeFatClientes().get(0);
        }
        throw new ExceptionService("Erro ao buscar Cliente");
    }

    private NaturezaOperacao getNaturezaOperacao(String campo, List<DeParaItensNotaPropria> deParas) throws ExceptionService {
        for (DeParaItensNotaPropria dePara : deParas) {
            if (!dePara.getCliente().getPessoa().getComplemento().getCnpj().equals(campo)) continue;
            return dePara.getNaturezaOperacao();
        }
        throw new ExceptionService("Erro ao buscar Natureza Opera\u00e7\u00e3o");
    }

    private List<ItemNotaFiscalPropria> getItensNota(NotaFiscalPropria nota, List<DeParaItensNotaPropria> deParas, List listaItens, OpcoesFaturamento opcoesFaturamento, Short respeitarImpostosIcms, Short respeitarImpostosPisCofins, Short respeitarImpostosIpi, EmpresaContabilidade empresaContabilidade, OpcoesContabeis opcoesContabeis, OpcoesImpostos opImpostos) throws ExceptionService, ExceptionDatabase, ExceptionCFOPNotFound, ExceptionCategoriaSTNotFound, ExceptionCalculoICMS, ExceptionCalculoIPI, ExceptionCalculoPisCofins, ExceptionValidacaoDados, ExceptionInvalidData {
        ArrayList<ItemNotaFiscalPropria> itensNota = new ArrayList<ItemNotaFiscalPropria>();
        int i = 1;
        block2: for (Object object : listaItens) {
            Element det = (Element)object;
            String codigo = det.getChild("prod", this.n).getChild("cProd", this.n).getText();
            Cliente cliente = nota.getUnidadeFatCliente().getCliente();
            NaturezaOperacao natureOperacao = nota.getNaturezaOperacao();
            for (DeParaItensNotaPropria dePara : deParas) {
                if (!dePara.getCliente().equals((Object)cliente) || !dePara.getNaturezaOperacao().getIdentificador().equals(natureOperacao.getIdentificador()) || !dePara.getCodigo().equals(codigo)) continue;
                ItemNotaFiscalPropria it = new ItemNotaFiscalPropria();
                it.setNotaFiscalPropria(nota);
                it.setCentroEstoque(this.findCentroEstoquePadraoEmpresa(nota.getEmpresa()));
                it.setQuantidadeTotal(new Double(det.getChild("prod", this.n).getChild("qCom", this.n).getText()));
                it.setValorUnitario(new Double(det.getChild("prod", this.n).getChild("vUnCom", this.n).getText()));
                it.setVrProduto(new Double(det.getChild("prod", this.n).getChild("vProd", this.n).getText()));
                this.validarValoresItem(it);
                it.setNotaFiscalPropria(nota);
                if (opcoesFaturamento.getClassificacaoVendasPadrao() != null) {
                    it.setClassificacaoVendas(opcoesFaturamento.getClassificacaoVendasPadrao());
                }
                it.setFatorConversao(Double.valueOf(1.0));
                it.setNumeroItem(Integer.valueOf(i));
                ++i;
                it.setProduto(dePara.getProduto());
                it.setCest(it.getProduto().getCest());
                it.setNcm(it.getProduto().getNcm());
                it.setUnidadeMedida(dePara.getProduto().getUnidadeMedida());
                it.setItemNotaLivroFiscal(new ItemNotaLivroFiscal());
                it.getItemNotaLivroFiscal().setItemNotaFiscalPropria(it);
                it.setIndicadorTotal(Short.valueOf((short)1));
                it.setModeloFiscal(dePara.getModeloFiscal());
                it.setGerarFinanceiro(it.getModeloFiscal().getGerarFinanceiro());
                it.setIssRetido(Short.valueOf(it.getModeloFiscal().getIssRetido().equals((short)1) ? (short)1 : 0));
                it.setGradesNotaFiscalPropria(this.getGradeItemNotaFiscalPropria(it.getValorUnitario(), it.getQuantidadeTotal(), nota.getDataEntradaSaida(), it, nota.getEmpresa(), natureOperacao.getEntradaSaida()));
                it.setInfAdicionalItem("Informa\u00e7\u00e3o Adicional Nota");
                ModeloFiscal mod = it.getModeloFiscal();
                Produto prod = it.getProduto();
                it.setIncidenciaIcms(mod.getModeloFiscalIcms().getIncidenciaIcms());
                it.setIncidenciaIpi(mod.getModeloFiscalIpi().getIncidenciaIpi());
                it.setIncidenciaPisCofins(mod.getModeloFiscalPisCofins().getIncidenciaPisCofins());
                new HelperItemNotaPropria(it).setNatReceitaPisCofins();
                it.setModalidadeIcms(mod.getModeloFiscalIcms().getModalidadeIcms());
                it.setModalidadeIcmsSt(mod.getModeloFiscalIcms().getModalidadeIcmsSt());
                if (nota.getNaturezaOperacao().getEntradaSaida() == 1) {
                    it.getItemNotaLivroFiscal().setCfop(CoreUtilityFactory.getUtilityCFOP().findCfopSaida(nota.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nota.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), mod, EnumConstNFeIndicadorPresConsumidor.valueOfCodigo((Short)nota.getIndicadorPresencaConsumidor())));
                } else {
                    it.getItemNotaLivroFiscal().setCfop(CoreUtilityFactory.getUtilityCFOP().findCfopEntrada(nota.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nota.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), mod));
                }
                if (mod.getTipoIRRF() != null && mod.getTipoIRRF() == 1) {
                    it.getItemNotaLivroFiscal().setAliquotaIrrf(prod.getAliquotaIrrf());
                    it.getItemNotaLivroFiscal().setPercRedIrrf(prod.getPercRedIrrf());
                }
                if (mod.getTipoFunrural() != null && mod.getTipoFunrural() == 1) {
                    it.getItemNotaLivroFiscal().setAliquotaFunrural(prod.getAliquotaFunrural());
                    it.getItemNotaLivroFiscal().setPercRedFunrural(prod.getPercRedFunrural());
                }
                if (mod.getTipoRat() != null && mod.getTipoRat() == 1) {
                    it.getItemNotaLivroFiscal().setAliquotaRat(prod.getAliquotaRat());
                }
                if (mod.getTipoSenar() != null && mod.getTipoSenar() == 1) {
                    it.getItemNotaLivroFiscal().setAliquotaSenar(prod.getAliquotaSenar());
                }
                if (mod.getTipoTaxaAnimal() != null && mod.getTipoTaxaAnimal() == 1) {
                    it.getItemNotaLivroFiscal().setTaxaSanidadeAnimal(prod.getTaxaSanidadeAnimal());
                    it.getItemNotaLivroFiscal().setFatorTaxaSanidadeAnimal(prod.getFatorTaxaSanidadeAnimal());
                }
                if (mod.getTipoLei10833() != null && mod.getTipoLei10833() == 1) {
                    it.getItemNotaLivroFiscal().setAliquotaLei10833(prod.getAliquotaLei10833());
                    it.getItemNotaLivroFiscal().setPercRedLei10833(prod.getPercRedLei10833());
                }
                if (mod.getTipoOutros() != null && mod.getTipoOutros() == 1) {
                    it.getItemNotaLivroFiscal().setAliquotaOutros(prod.getAliquotaOutros());
                    it.getItemNotaLivroFiscal().setPercRedOutros(prod.getPercRedOutros());
                }
                if (mod.getTipoContSoc() != null && mod.getTipoContSoc() == 1) {
                    it.getItemNotaLivroFiscal().setAliquotaContSoc(prod.getAliquotaContSoc());
                    it.getItemNotaLivroFiscal().setPercRedContSoc(prod.getPercRedContSoc());
                }
                if (mod.getIssRetido() != null && mod.getIssRetido() != 2) {
                    it.getItemNotaLivroFiscal().setAliquotaIss(prod.getAliquotaIss());
                }
                if (mod.getIssRetido() != null && mod.getIssRetido() != 2) {
                    it.getItemNotaLivroFiscal().setAliquotaIss(prod.getAliquotaIss());
                }
                if (mod.getModeloFiscalPisCofins().getCalcularPisNormal().equals((short)1)) {
                    if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                        it.getItemNotaLivroFiscal().setAliquotaPis(mod.getModeloFiscalPisCofins().getAliquotaPis());
                    } else {
                        it.getItemNotaLivroFiscal().setAliquotaPis(it.getProduto().getAliquotaPis());
                    }
                } else {
                    it.getItemNotaLivroFiscal().setAliquotaPis(Double.valueOf(0.0));
                }
                if (mod.getModeloFiscalPisCofins().getCalcularPisSt().equals((short)1)) {
                    if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                        it.getItemNotaLivroFiscal().setAliquotaPisSt(mod.getModeloFiscalPisCofins().getAliquotaPisSt());
                    } else {
                        it.getItemNotaLivroFiscal().setAliquotaPisSt(it.getProduto().getAliquotaPisSt());
                    }
                } else {
                    it.getItemNotaLivroFiscal().setAliquotaPisSt(Double.valueOf(0.0));
                }
                if (mod.getModeloFiscalPisCofins().getCalcularCofinsNormal().equals((short)1)) {
                    if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                        it.getItemNotaLivroFiscal().setAliquotaCofins(mod.getModeloFiscalPisCofins().getAliquotaCofins());
                    } else {
                        it.getItemNotaLivroFiscal().setAliquotaCofins(it.getProduto().getAliquotaCofins());
                    }
                } else {
                    it.getItemNotaLivroFiscal().setAliquotaCofins(Double.valueOf(0.0));
                }
                if (mod.getModeloFiscalPisCofins().getCalcularCofinsSt().equals((short)1)) {
                    if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                        it.getItemNotaLivroFiscal().setAliquotaCofinsSt(mod.getModeloFiscalPisCofins().getAliquotaCofinsSt());
                    } else {
                        it.getItemNotaLivroFiscal().setAliquotaCofinsSt(it.getProduto().getAliquotaCofinsSt());
                    }
                } else {
                    it.getItemNotaLivroFiscal().setAliquotaCofinsSt(Double.valueOf(0.0));
                }
                it.getItemNotaLivroFiscal().setAliquotaIcms(new HelperItemNotaPropria().findAliquotaIcms(nota.getNaturezaOperacao(), mod, nota.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nota.getUnidadeFatCliente().getCliente().getPessoa().getEndereco().getCidade().getUf(), prod));
                if (ToolMethods.isEquals((Object)mod.getModeloFiscalIcms().getTipoPercReducaoBaseCalcIcms(), (Object)2)) {
                    it.getItemNotaLivroFiscal().setPercReducaoBCIcms(mod.getModeloFiscalIcms().getReducaoBaseCalcIcms());
                } else {
                    it.getItemNotaLivroFiscal().setPercReducaoBCIcms(prod.getReducaoBaseCalcIcms());
                }
                Double aliquotaIpi = BaseCalculoValores.getAliquotaIpi((Produto)prod, (ModeloFiscalIpi)mod.getModeloFiscalIpi());
                it.getItemNotaLivroFiscal().setAliquotaIpi(aliquotaIpi);
                if (mod.getTipoINSS() != null && (mod.getTipoINSS() == 1 || mod.getTipoINSS() == 3)) {
                    it.getItemNotaLivroFiscal().setAliquotaInss(prod.getAliquotaInss());
                    it.getItemNotaLivroFiscal().setPercRedBcInss(prod.getPercRedBCINSS());
                }
                new HelperItemNotaPropria().setParamTribAndParametrosCBSIBSIS(it, nota.getEmpresa(), nota.getDataEmissaoNota(), nota.getNaturezaOperacao(), nota.getUnidadeFatCliente());
                this.setValoresAcessorios(it, det.getChild("prod", this.n));
                try {
                    this.setDadosContabeis(it, nota, opcoesContabeis, it.getItemNotaLivroFiscal().getCfop());
                }
                catch (ExceptionParametrizacaoCtbModFiscalNotFound ex) {
                    logger.error(ex.getMessage());
                    String message = ex.getMessage();
                    StringBuilder sb = new StringBuilder();
                    sb.append("Nr NF: " + nota.getNumeroNota());
                    sb.append("  S\u00e9rie: " + nota.getSerie());
                    sb.append("\nCliente: " + nota.getUnidadeFatCliente().toString());
                    sb.append("\n\n");
                    sb.append(message);
                    throw new ExceptionService(sb.toString());
                }
                new CalculosImpFiscaisNotaPropria().calcularImpostosFiscaisItNotaPropria(it, nota.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nota.getUnidadeFatCliente(), nota.getSituacaoDocumento(), nota.getEmpresa(), nota.getIndicadorConsumidorFinal(), opcoesFaturamento, nota.getDataEmissaoNota(), empresaContabilidade, opImpostos, nota.getNaturezaOperacao());
                Element impostos = det.getChild("imposto", this.n);
                if (ToolMethods.isEquals((Object)respeitarImpostosIcms, (Object)1)) {
                    Element icms = impostos.getChild("ICMS", this.n);
                    new AuxImportarNotaPropriaICMS().valoresImpostosICMS(icms, it);
                    new AuxImportarNotaPropriaICMSSN().valoresImpostosICMSSN(icms, it);
                    it.setNaoCalcularIcms(Short.valueOf((short)1));
                }
                if (ToolMethods.isEquals((Object)respeitarImpostosIpi, (Object)1)) {
                    Element ipi = impostos.getChild("IPI", this.n);
                    new AuxImportarNotaPropriaIPI().valoresImpostosIPI(ipi, it);
                    it.setNaoCalcularIpi(Short.valueOf((short)1));
                }
                if (ToolMethods.isEquals((Object)respeitarImpostosPisCofins, (Object)1)) {
                    Element pis = impostos.getChild("PIS", this.n);
                    Element cofins = impostos.getChild("COFINS", this.n);
                    new AuxImportarNotaPropriaPis().valoresImpostosPIS(pis, it);
                    new AuxImportarNotaPropriaCofins().valoresImpostosCofins(cofins, it);
                    it.setNaoCalcularPisCofins(Short.valueOf((short)1));
                }
                itensNota.add(it);
                continue block2;
            }
        }
        return itensNota;
    }

    private void setDadosContabeis(ItemNotaFiscalPropria i, NotaFiscalPropria nota, OpcoesContabeis opcoesContabeis, Cfop cfop) throws ExceptionService, ExceptionParametrizacaoCtbModFiscalNotFound, ExceptionValidacaoDados, ExceptionInvalidData {
        try {
            CompParametrizacaoContabilNF comp = (CompParametrizacaoContabilNF)Context.get(CompParametrizacaoContabilNF.class);
            CompParametrizacaoContabilNF.DadosContas dados = comp.getPlanoContasNfPropria(i.getModeloFiscal(), i.getProduto(), nota.getUnidadeFatCliente(), nota.getNaturezaOperacao(), nota.getEmpresa(), nota.getUnidadeFatCliente().getCategoriaPessoa(), opcoesContabeis, cfop);
            i.setPlanoContaCred(dados.getPlanoContaCred());
            i.setPlanoContaDeb(dados.getPlanoContaDeb());
            i.setPlanoContaGerencial(dados.getPcGerencial());
        }
        catch (ExceptionParametrizacao ex) {
            TLogger.get(((Object)((Object)ex)).getClass()).error((Throwable)ex);
            throw new ExceptionService(ex.getFormattedMessage());
        }
    }

    private List<GradeItemNotaFiscalPropria> getGradeItemNotaFiscalPropria(Double valorUnitario, Double quantidade, Date dataEntradaSaida, ItemNotaFiscalPropria item, Empresa empresa, Short entradaSaida) throws ExceptionService, ExceptionDatabase {
        ArrayList<GradeItemNotaFiscalPropria> gr = new ArrayList<GradeItemNotaFiscalPropria>();
        GradeItemNotaFiscalPropria g = new GradeItemNotaFiscalPropria();
        item.setFatorConversao(Double.valueOf(1.0));
        g.setGradeCor(this.findPrimeiraGradeCor(item.getProduto()));
        g.setItemNotaFiscalPropria(item);
        g.setLoteFabricacao((LoteFabricacao)this.findLoteProduto(item.getProduto()));
        g.setDataEntradaSaida(dataEntradaSaida);
        g.setValorCusto(valorUnitario);
        g.setMovimentacaoFisica(item.getModeloFiscal().getMovimentacaoFisica());
        g.setQuantidade(quantidade);
        g.setCentroEstoque(item.getCentroEstoque());
        g.setEmpresa(empresa);
        g.setFatorConversao(item.getFatorConversao());
        g.setEntradaSaida(entradaSaida);
        gr.add(g);
        return gr;
    }

    public Object findLoteProduto(Produto produto) throws ExceptionDatabase {
        LoteFabricacao loteFab = this.serviceLoteFabricacaoImpl.findLoteUnico(produto);
        if (loteFab == null) {
            loteFab = new LoteFabricacao();
            loteFab.setLoteFabricacao("UNICO");
            loteFab.setDataFabricacao(new Date());
            loteFab.setProduto(produto);
            loteFab.setLoteFabricacao("UNICO");
            loteFab.setUnico(Short.valueOf((short)1));
            loteFab.setStatusLoteFabricacao(produto.getStatusLoteFabricacao());
            loteFab.setLoteBloqueado(produto.getStatusLoteFabricacao().getLoteBloqueado());
            loteFab = (LoteFabricacao)CoreDAOFactory.getInstance().getDAOLoteFabricacao().saveOrUpdate(loteFab);
        }
        return loteFab;
    }

    public GradeCor findPrimeiraGradeCor(Produto pro) throws ExceptionService {
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("produto", pro);
        GradeCor gc = (GradeCor)CoreServiceFactory.getServiceGradeCor().execute(cq, "findPrimeiraGradeCor");
        if (gc == null) {
            throw new ExceptionService("Produto: " + pro.getNome() + " n\u00e3o possui Grade de Cor");
        }
        return gc;
    }

    private CentroEstoque findCentroEstoquePadraoEmpresa(Empresa e) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from CentroEstoque e where e.empresa = :emp and  e.tipoCentroEstoque = :tipo and e.tipoEstProprioTerceiros = :tipoEstProprioTerceiros");
        q.setEntity("emp", (Object)e);
        q.setShort("tipo", EnumConstCentroEstPadraoOutros.TIPO_CENTRO_ESTOQUE_PADRAO.getValue().shortValue());
        q.setShort("tipoEstProprioTerceiros", EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue().shortValue());
        List l = q.list();
        if (l.size() > 1) {
            throw new ExceptionService("Existe mais de um centro de estoque padr\u00e3o para a empresa.");
        }
        if (l.isEmpty()) {
            return null;
        }
        return (CentroEstoque)l.get(0);
    }

    private void validarValoresItem(ItemNotaFiscalPropria it) {
        if (it.getQuantidadeTotal() == 0.0) {
            it.setQuantidadeTotal(Double.valueOf(1.0));
        }
        if (it.getValorUnitario() == 0.0) {
            it.setValorUnitario(it.getVrProduto());
        }
    }

    private void verificarTotalizadoresOutrosImpostos(NotaFiscalPropria notaFiscalPropria, Element inf, Short considerarVlrOutrosDespAcess) {
        String vOutro;
        block6: {
            block5: {
                vOutro = inf.getChild("total", this.n).getChild("ICMSTot", this.n).getChildText("vOutro", this.n);
                if (vOutro == null || vOutro.isEmpty()) break block5;
                Double d = new Double(vOutro);
                if (!(d < 0.0)) break block6;
            }
            return;
        }
        if (ToolMethods.isEquals((Object)considerarVlrOutrosDespAcess, (Object)1)) {
            this.considerarValorOutrosCompDespAcess(notaFiscalPropria, vOutro);
        } else {
            this.considerarValorOutrosComoImp(notaFiscalPropria, vOutro);
        }
    }

    private List<ObservacaoNotaPropria> getObsFaturamentoNotaPropria(NotaFiscalPropria nota, String obs) throws ExceptionService {
        ObsFaturamento obsFaturamento = this.findObsFaturamento(nota);
        ObservacaoNotaPropria observacao = new ObservacaoNotaPropria();
        observacao.setConteudo(obs);
        observacao.setObsFaturamento(obsFaturamento);
        observacao.setNotaFiscalPropria(nota);
        ArrayList<ObservacaoNotaPropria> aux = new ArrayList<ObservacaoNotaPropria>();
        aux.add(observacao);
        return aux;
    }

    private ObsFaturamento findObsFaturamento(NotaFiscalPropria nota) throws ExceptionService {
        for (ItemNotaFiscalPropria item : nota.getItensNotaPropria()) {
            if (item.getModeloFiscal().getObservacoesContrib().isEmpty()) continue;
            return ((ModeloFiscalObsContrib)item.getModeloFiscal().getObservacoesContrib().get(0)).getObsFaturamento();
        }
        throw new ExceptionService("Primeiro, informe uma observa\u00e7\u00e3o no Modelo fiscal");
    }

    private void updateLivrosFiscais(NotaFiscalPropria notaFiscalPropria) {
        for (ItemNotaFiscalPropria item : notaFiscalPropria.getItensNotaPropria()) {
            Double valorTotal = item.getVrProduto() + item.getVrServico() - item.getValorDesconto() + item.getValorFrete() + item.getVrSeguro() + item.getValorDespAcessoria() + item.getItemNotaLivroFiscal().getVrIpiIndustria() + item.getItemNotaLivroFiscal().getVrIcmsSt() + item.getItemNotaLivroFiscal().getVrOutros() + item.getItemNotaLivroFiscal().getVrDevICMSST() + item.getItemNotaLivroFiscal().getValorFCPSt() + item.getItemNotaLivroFiscal().getValorIpiDevolucao();
            item.getItemNotaLivroFiscal().setValorTotal(valorTotal);
        }
    }

    private List<Titulo> getTitulosAll(NotaFiscalPropria vo) {
        ArrayList<Titulo> titulos = new ArrayList<Titulo>();
        for (InfPagamentoNfPropria i : vo.getInfPagamentoNfPropria()) {
            for (Titulo t : i.getTitulos()) {
                titulos.add(t);
            }
        }
        return titulos;
    }

    private void calcularTaxaSanidadeAnimal(NotaFiscalPropria nota, List<Produto> produtosTaxaSanidadeAnimal, Double percTaxaSanidadeAnimal) throws ExceptionService {
        Cooperado cooperado = this.getCooperadoPorCliente(nota.getUnidadeFatCliente().getCliente());
        if (cooperado != null && cooperado.getTipoTaxaSanidadeAnimal() != null && cooperado.getTipoTaxaSanidadeAnimal() == 1) {
            Double valorTaxaSanidadeAnimal = 0.0;
            Double qtde = 0.0;
            for (ItemNotaFiscalPropria i : nota.getItensNotaPropria()) {
                Produto p = i.getProduto();
                for (Produto pp : produtosTaxaSanidadeAnimal) {
                    if (!pp.equals((Object)p)) continue;
                    qtde = qtde + i.getQuantidadeTotal();
                }
            }
            if (qtde > 0.0) {
                valorTaxaSanidadeAnimal = ContatoFormatUtil.arrredondarNumero((Double)(qtde / 1000.0 * percTaxaSanidadeAnimal), (int)2);
            }
            nota.getValoresNfPropria().setValorTaxaSanidadeAnimal(ContatoFormatUtil.arrredondarNumero((Double)valorTaxaSanidadeAnimal, (int)2, (int)4));
        }
    }

    private Cooperado getCooperadoPorCliente(Cliente cliente) throws ExceptionService {
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("cliente", cliente);
        return (Cooperado)CoreServiceFactory.getServiceCooperado().execute(r, "findCooperadoPorCliente");
    }

    private void setOutrosImpostosProdutorRural(Element inf, NotaFiscalPropria vo, Short respeitarOutrosImpostos, TagImpostosCooperado tags) {
        if (respeitarOutrosImpostos != null && respeitarOutrosImpostos.equals((short)1) && tags != null) {
            Boolean achouRat = false;
            Boolean achouSenar = false;
            Boolean achouInss = false;
            Boolean achouTaxaSanidade = false;
            List obs = inf.getChild("infAdic", this.n).getChildren("obsCont", this.n);
            for (Element ob : obs) {
                Attribute a = ob.getAttribute("xCampo");
                String valorTexto = ob.getChild("xTexto", this.n).getValue();
                Double valor = new Double(valorTexto);
                if (a.getValue().equals(tags.getTagInss())) {
                    vo.getValoresNfPropria().setValorInss(valor);
                    achouInss = true;
                    continue;
                }
                if (a.getValue().equals(tags.getTagRat())) {
                    vo.getValoresNfPropria().setValorRAT(valor);
                    achouRat = true;
                    continue;
                }
                if (a.getValue().equals(tags.getTagSenar())) {
                    vo.getValoresNfPropria().setValorSenar(valor);
                    achouSenar = true;
                    continue;
                }
                if (!a.getValue().equals(tags.getTagTaxaSanidadeAnimal())) continue;
                vo.getValoresNfPropria().setValorTaxaSanidadeAnimal(valor);
                achouTaxaSanidade = true;
            }
            if (!achouInss.booleanValue()) {
                vo.getValoresNfPropria().setValorInss(Double.valueOf(0.0));
                for (ItemNotaFiscalPropria item : vo.getItensNotaPropria()) {
                    item.getItemNotaLivroFiscal().setVrInss(Double.valueOf(0.0));
                    item.getItemNotaLivroFiscal().setAliquotaInss(Double.valueOf(0.0));
                    item.getItemNotaLivroFiscal().setPercRedBcInss(Double.valueOf(0.0));
                }
            }
            if (!achouRat.booleanValue()) {
                vo.getValoresNfPropria().setValorRAT(Double.valueOf(0.0));
                for (ItemNotaFiscalPropria item : vo.getItensNotaPropria()) {
                    item.getItemNotaLivroFiscal().setValorRat(Double.valueOf(0.0));
                    item.getItemNotaLivroFiscal().setAliquotaRat(Double.valueOf(0.0));
                }
            }
            if (!achouSenar.booleanValue()) {
                vo.getValoresNfPropria().setValorSenar(Double.valueOf(0.0));
                for (ItemNotaFiscalPropria item : vo.getItensNotaPropria()) {
                    item.getItemNotaLivroFiscal().setValorSenar(Double.valueOf(0.0));
                    item.getItemNotaLivroFiscal().setAliquotaSenar(Double.valueOf(0.0));
                }
            }
            if (!achouTaxaSanidade.booleanValue()) {
                vo.getValoresNfPropria().setValorTaxaSanidadeAnimal(Double.valueOf(0.0));
                for (ItemNotaFiscalPropria item : vo.getItensNotaPropria()) {
                    item.getItemNotaLivroFiscal().setValorTaxaSanidadeAnimal(Double.valueOf(0.0));
                    item.getItemNotaLivroFiscal().setFatorTaxaSanidadeAnimal(Double.valueOf(0.0));
                    item.getItemNotaLivroFiscal().setTaxaSanidadeAnimal(Double.valueOf(0.0));
                }
            }
        }
    }

    private void arredondarImpostosCooperado(NotaFiscalPropria nota, Short respeitarImpostos) {
        block8: {
            Iterator iterator;
            Double valorTaxaDif;
            Double valorInssDif;
            Object item;
            Double valorSenarDif;
            Object item2;
            Iterator iterator2;
            Double valorRatDif;
            Double aliqSenar = 0.0;
            Double aliqRat = 0.0;
            Double aliqInss = 0.0;
            Double fatorTaxaSanidade = 0.0;
            Double taxaSanidadeAnimal = 0.0;
            Iterator iterator3 = nota.getItensNotaPropria().iterator();
            if (iterator3.hasNext()) {
                ItemNotaFiscalPropria item3 = (ItemNotaFiscalPropria)iterator3.next();
                aliqSenar = item3.getItemNotaLivroFiscal().getAliquotaSenar();
                aliqRat = item3.getItemNotaLivroFiscal().getAliquotaRat();
                aliqInss = item3.getItemNotaLivroFiscal().getAliquotaInss();
                fatorTaxaSanidade = item3.getItemNotaLivroFiscal().getFatorTaxaSanidadeAnimal();
                taxaSanidadeAnimal = item3.getItemNotaLivroFiscal().getTaxaSanidadeAnimal();
            }
            boolean aliquotasDiferentes = false;
            for (ItemNotaFiscalPropria item4 : nota.getItensNotaPropria()) {
                if (item4.getItemNotaLivroFiscal().getAliquotaSenar().equals(aliqSenar) && item4.getItemNotaLivroFiscal().getAliquotaRat().equals(aliqRat) && item4.getItemNotaLivroFiscal().getAliquotaInss().equals(aliqInss)) continue;
                aliquotasDiferentes = true;
                break;
            }
            if (aliquotasDiferentes) break block8;
            Double valorSenar = 0.0;
            Double valorRat = 0.0;
            Double valorInss = 0.0;
            Double valorTaxaSanidade = 0.0;
            for (ItemNotaFiscalPropria item5 : nota.getItensNotaPropria()) {
                valorSenar = valorSenar + item5.getItemNotaLivroFiscal().getValorSenar();
                valorRat = valorRat + item5.getItemNotaLivroFiscal().getValorRat();
                valorInss = valorInss + item5.getItemNotaLivroFiscal().getVrInss();
                valorTaxaSanidade = valorTaxaSanidade + item5.getItemNotaLivroFiscal().getValorTaxaSanidadeAnimal();
            }
            Double valorTotalRat = ToolFormatter.arrredondarNumero((Double)nota.getValoresNfPropria().getValorRAT(), (int)2);
            Double valorTotalSenar = ToolFormatter.arrredondarNumero((Double)nota.getValoresNfPropria().getValorSenar(), (int)2);
            Double valorTotalInss = ToolFormatter.arrredondarNumero((Double)nota.getValoresNfPropria().getValorInss(), (int)2);
            Double valorTotalTaxaSanidade = ToolFormatter.arrredondarNumero((Double)nota.getValoresNfPropria().getValorTaxaSanidadeAnimal(), (int)2);
            if (respeitarImpostos.equals((short)0)) {
                valorTotalRat = ToolFormatter.arrredondarNumero((Double)(nota.getValoresNfPropria().getValorTotal() * (aliqRat / 100.0)), (int)2);
                valorTotalSenar = ToolFormatter.arrredondarNumero((Double)(nota.getValoresNfPropria().getValorTotal() * (aliqSenar / 100.0)), (int)2);
                valorTotalInss = ToolFormatter.arrredondarNumero((Double)(nota.getValoresNfPropria().getValorTotal() * (aliqInss / 100.0)), (int)2);
                nota.getValoresNfPropria().setValorRAT(valorTotalRat);
                nota.getValoresNfPropria().setValorSenar(valorTotalSenar);
                nota.getValoresNfPropria().setValorInss(valorTotalInss);
            }
            if ((valorRatDif = ToolFormatter.arrredondarNumero((Double)(valorTotalRat - valorRat), (int)2)) != 0.0 && (iterator2 = nota.getItensNotaPropria().iterator()).hasNext()) {
                item2 = (ItemNotaFiscalPropria)iterator2.next();
                item2.getItemNotaLivroFiscal().setValorRat(Double.valueOf(item2.getItemNotaLivroFiscal().getValorRat() + valorRatDif));
            }
            if ((valorSenarDif = ToolFormatter.arrredondarNumero((Double)(valorTotalSenar - valorSenar), (int)2)) != 0.0 && (item2 = nota.getItensNotaPropria().iterator()).hasNext()) {
                item = (ItemNotaFiscalPropria)item2.next();
                item.getItemNotaLivroFiscal().setValorSenar(Double.valueOf(item.getItemNotaLivroFiscal().getValorSenar() + valorSenarDif));
            }
            if ((valorInssDif = ToolFormatter.arrredondarNumero((Double)(valorTotalInss - valorInss), (int)2)) != 0.0 && (item = nota.getItensNotaPropria().iterator()).hasNext()) {
                ItemNotaFiscalPropria item6 = (ItemNotaFiscalPropria)item.next();
                item6.getItemNotaLivroFiscal().setVrInss(Double.valueOf(item6.getItemNotaLivroFiscal().getVrInss() + valorInssDif));
            }
            if ((valorTaxaDif = ToolFormatter.arrredondarNumero((Double)(valorTotalTaxaSanidade - valorTaxaSanidade), (int)2)) != 0.0 && (iterator = nota.getItensNotaPropria().iterator()).hasNext()) {
                ItemNotaFiscalPropria item7 = (ItemNotaFiscalPropria)iterator.next();
                item7.getItemNotaLivroFiscal().setValorTaxaSanidadeAnimal(Double.valueOf(item7.getItemNotaLivroFiscal().getValorTaxaSanidadeAnimal() + valorTaxaDif));
            }
        }
    }

    private void considerarValorOutrosComoImp(NotaFiscalPropria notaFiscalPropria, String vOutro) {
        Double vrOutrosNota = new Double(vOutro);
        if (notaFiscalPropria.getNaturezaOperacao().getEntradaSaida().equals((short)2)) {
            notaFiscalPropria.getValoresNfPropria().setValorOutros(vrOutrosNota);
            Double vrOutrosImpItens = 0.0;
            Double vrTotalBase = 0.0;
            for (ItemNotaFiscalPropria item : notaFiscalPropria.getItensNotaPropria()) {
                vrOutrosImpItens = vrOutrosImpItens + item.getItemNotaLivroFiscal().getVrOutros();
                vrOutrosImpItens = ContatoFormatUtil.arrredondarNumero((Double)vrOutrosImpItens, (int)2);
                vrTotalBase = vrTotalBase + item.getVrProduto();
                vrTotalBase = ContatoFormatUtil.arrredondarNumero((Double)vrTotalBase, (int)2);
                item.getItemNotaLivroFiscal().setAliquotaOutros(item.getProduto().getAliquotaOutros());
            }
            if (vrOutrosNota - vrOutrosImpItens == 0.0) {
                return;
            }
            Double diffOutros = ContatoFormatUtil.arrredondarNumero((Double)(vrOutrosNota - vrOutrosImpItens), (int)2);
            if (diffOutros > 0.0) {
                outros = ((ItemNotaFiscalPropria)notaFiscalPropria.getItensNotaPropria().get(0)).getItemNotaLivroFiscal().getVrOutros();
                outros = ContatoFormatUtil.arrredondarNumero((Double)(outros + diffOutros), (int)2);
                ((ItemNotaFiscalPropria)notaFiscalPropria.getItensNotaPropria().get(0)).getItemNotaLivroFiscal().setVrOutros(outros);
            } else if (diffOutros < 0.0) {
                outros = ((ItemNotaFiscalPropria)notaFiscalPropria.getItensNotaPropria().get(0)).getItemNotaLivroFiscal().getVrOutros();
                outros = ContatoFormatUtil.arrredondarNumero((Double)(outros + diffOutros), (int)2);
                ((ItemNotaFiscalPropria)notaFiscalPropria.getItensNotaPropria().get(0)).getItemNotaLivroFiscal().setVrOutros(outros);
            }
            this.updateLivrosFiscais(notaFiscalPropria);
        }
    }

    private void considerarValorOutrosCompDespAcess(NotaFiscalPropria notaFiscalPropria, String vOutro) {
        notaFiscalPropria.getValoresNfPropria().setValorDespAcessInf(new Double(vOutro));
        notaFiscalPropria.getValoresNfPropria().setTipoDespAcessInf(Short.valueOf((short)0));
    }

    private void setValoresAcessorios(ItemNotaFiscalPropria it, Element child) {
        Element vOutro = child.getChild("vOutro", this.n);
        Element vFrete = child.getChild("vFrete", this.n);
        Element vSeg = child.getChild("vSeg", this.n);
        Element vDesc = child.getChild("vDesc", this.n);
        if (vOutro != null) {
            it.setValorDespAcessoria(Double.valueOf(vOutro.getText()));
            it.setValorDespAcessItemInf(Double.valueOf(vOutro.getText()));
            it.setTipoDespAcessoria(Short.valueOf((short)1));
            it.setDespAcessItem(Short.valueOf((short)1));
        }
        if (vFrete != null) {
            it.setValorFrete(Double.valueOf(vFrete.getText()));
            it.setValorFreteItemInf(Double.valueOf(vFrete.getText()));
            it.setTipoFrete(Short.valueOf((short)1));
            it.setFreteItem(Short.valueOf((short)1));
        }
        if (vSeg != null) {
            it.setVrSeguro(Double.valueOf(vSeg.getText()));
            it.setValorSeguroItemInf(Double.valueOf(vSeg.getText()));
            it.setTipoSeguro(Short.valueOf((short)1));
            it.setSeguroItem(Short.valueOf((short)1));
        }
        if (vDesc != null) {
            it.setValorDesconto(Double.valueOf(vDesc.getText()));
            it.setValorDescontoItemInf(Double.valueOf(vDesc.getText()));
            it.setTipoDesconto(Short.valueOf((short)1));
            it.setDescontoItem(Short.valueOf((short)1));
        }
    }
}

