/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.opcoesrelatorio;

import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.OpcoesRelatorioNodo;
import com.touchcomp.basementor.model.vo.OpcoesRelatorioNodoParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;

public class ServiceOpcoesRelatorio
extends CoreService {
    public static final String SETAR_PARAMETROS_RELATORIO = "setarParametrosRelatorio";

    public Object setarParametrosRelatorio(CoreRequestContext req) throws ExceptionService {
        try {
            String sumario;
            String ultimoRodape;
            String rodape;
            String cabecalho;
            HashMap<String, String> param = (HashMap<String, String>)req.getAttribute("params");
            Nodo nodo = (Nodo)req.getAttribute("nodo");
            Boolean isPaisagem = (Boolean)req.getAttribute("isPaisagem");
            if (param == null) {
                param = new HashMap<String, String>();
            }
            String noData = "";
            OpcoesRelatorioNodo rel = null;
            if (nodo != null) {
                rel = CoreDAOFactory.getInstance().getDAOOpcoesRelatorio().getFirstOpRelatorio(nodo);
            }
            if (rel != null) {
                cabecalho = rel.getOpcoesRelatorios() != null && rel.getOpcoesRelatorios().getSubreportCabecalho() != null ? this.getSubreport(rel.getOpcoesRelatorios().getSubreportCabecalho()) : this.getSubreport("/reports/SUB_CABECALHO.jasper");
                rodape = rel.getOpcoesRelatorios() != null && rel.getOpcoesRelatorios().getSubreportRodape() != null ? this.getSubreport(rel.getOpcoesRelatorios().getSubreportRodape()) : this.getSubreport("/reports/SUB_RODAPE.jasper");
                ultimoRodape = rel.getOpcoesRelatorios() != null && rel.getOpcoesRelatorios().getSubreportLastRodape() != null ? this.getSubreport(rel.getOpcoesRelatorios().getSubreportLastRodape()) : this.getSubreport("/reports/SUB_LAST_RODAPE.jasper");
                sumario = rel.getOpcoesRelatorios() != null && rel.getOpcoesRelatorios().getSubreportSumario() != null ? this.getSubreport(rel.getOpcoesRelatorios().getSubreportSumario()) : this.getSubreport("/reports/SUB_SUMARIO.jasper");
                if (rel.getOpcoesRelatorioNodoParam() != null) {
                    for (OpcoesRelatorioNodoParam op : rel.getOpcoesRelatorioNodoParam()) {
                        param.put(op.getParametro(), op.getValorTexto());
                    }
                }
            } else if (isPaisagem == null || !isPaisagem.booleanValue()) {
                cabecalho = this.getSubreport("/reports/SUB_CABECALHO.jasper");
                rodape = this.getSubreport("/reports/SUB_RODAPE.jasper");
                ultimoRodape = this.getSubreport("/reports/SUB_LAST_RODAPE.jasper");
                sumario = this.getSubreport("/reports/SUB_SUMARIO.jasper");
                noData = this.getSubreport("/reports/SUB_NO_DATA.jasper");
            } else {
                cabecalho = this.getSubreport("/reports/SUB_CABECALHO_PAISAGEM.jasper");
                rodape = this.getSubreport("/reports/SUB_RODAPE_PAISAGEM.jasper");
                ultimoRodape = this.getSubreport("/reports/SUB_LAST_RODAPE_PAISAGEM.jasper");
                sumario = this.getSubreport("/reports/SUB_SUMARIO_PAISAGEM.jasper");
                noData = this.getSubreport("/reports/SUB_NO_DATA_PAISAGEM.jasper");
            }
            param.put("SUBREPORT_CABECALHO", cabecalho);
            param.put("SUBREPORT_RODAPE", rodape);
            param.put("SUBREPORT_LAST_RODAPE", ultimoRodape);
            param.put("SUBREPORT_SUMARIO", sumario);
            param.put("SUB_REPORT_NO_DATA", noData);
            return param;
        }
        catch (IOException ex) {
            throw new ExceptionService("Erro ao gerar as op\u00e7\u00f5es tempor\u00e1rias do relat\u00f3rio.", ex);
        }
    }

    private String getSubreport(String name) throws IOException {
        int len;
        InputStream in = this.getClass().getResourceAsStream(name);
        File tmp = File.createTempFile(name, ".jasper");
        FileOutputStream out = new FileOutputStream(tmp);
        tmp.deleteOnExit();
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) > -1) {
            out.write(buffer, 0, len);
        }
        out.flush();
        return tmp.getAbsolutePath();
    }

    private String getSubreport(byte[] bytes) throws IOException {
        File tmp = File.createTempFile("subreport", ".jasper");
        FileOutputStream out = new FileOutputStream(tmp);
        tmp.deleteOnExit();
        out.write(bytes, 0, bytes.length);
        out.flush();
        return tmp.getAbsolutePath();
    }
}

