/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.ordemservico;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Executante;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.ItemConsumoAtivo;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilListagemOrdemServico {
    private static Long horasExecucao = 0L;
    private static Long minExecucao = 0L;

    protected static JasperPrint gerarListagemOrdemServico(Short filtrarDataCadastro, Date dataCadastroInicial, Date dataCadastroFinal, Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarDataPrevisao, Date dataPrevisaoInicial, Date dataPrevisaoFinal, Short filtrarEquipamento, Long equipamentoInicial, Long equipamentoFinal, Short filtrarLocalAtivo, Long localAtivoInicial, Long localAtivoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short filtrarSolicitante, Long solicitanteInicial, Long solicitanteFinal, Short filtrarResponsavel, Long responsavelInicial, Long responsavelFinal, Short filtrarSetorExecutante, Long setorExecutanteInicial, Long setorExecutanteFinal, Short filtrarTipoServico, Long tipoServicoInicial, Long tipoServicoFinal, Short exibirExecutante, Short exibirProcedimentos, Short status, Short exibirObservacoes, String fecho, HashMap params, Empresa empresa, Short exibirServicosDiagnostico, Nodo nodo) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "SELECT          os.identificador                         AS ID_OS,          os.codigo                                AS CODIGO,          os.dataProgramada                        AS DATA_PROGRAMADA,          os.descricaoServico                      AS DESCRICAO_SERVICO,          os.status                                AS STATUS,          os.equipamento.identificador             AS ID_ATIVO,          os.equipamento.nome                      AS NOME_ATIVO,          os.equipamento.codigo                    AS CODIGO_ATIVO,          solicitante.nome                         AS SOLICITANTE,          responsavel.nome                         AS RESPONSAVEL,          setorEx.descricao                        AS SETOR_EXECUTANTE,          os.prioridade                            AS PRIORIDADE,          f.dataFechamento                         AS DATA_FECHAMENTO,          os.tipoServico.nome                      AS TIPO_SERVICO  FROM OrdemServico os   LEFT  JOIN os.responsavel responsavel  LEFT  JOIN os.solicitante solicitante  LEFT  JOIN os.setorExecutante setorEx LEFT  JOIN os.fechamentoOrdemServico f LEFT  JOIN os.equipamento equip LEFT  JOIN equip.localizacaoAtivo la WHERE (:filtrarDataCadastro    <> 1 OR os.dataCadastro                  BETWEEN :dataCadastroInicial    AND :dataCadastroFinal   )  AND   (:filtrarDataEmissao     <> 1 OR os.dataEmissao                   BETWEEN :dataEmissaoInicial     AND :dataEmissaoFinal    )  AND   (:filtrarDataPrevisao    <> 1 OR os.dataPrevisao                  BETWEEN :dataPrevisaoInicial    AND :dataPrevisaoFinal   )  AND   (:filtrarEquipamento     <> 1 OR os.equipamento.identificador     BETWEEN :equipamentoInicial     AND :equipamentoFinal    ) AND   (:filtrarLocalAtivo      <> 1 OR la.identificador                 BETWEEN :localAtivoInicial     AND :localAtivoFinal      )  AND   (:filtrarEmpresa         <> 1 OR os.empresa.identificador         BETWEEN :empresaInicial         AND :empresaFinal        )  AND   (:filtrarSolicitante     <> 1 OR os.solicitante.identificador     BETWEEN :solicitanteInicial     AND :solicitanteFinal    )  AND   (:filtrarResponsavel     <> 1 OR os.responsavel.identificador     BETWEEN :responsavelInicial     AND :responsavelFinal    )  AND   (:filtrarSetorExecutante <> 1 OR os.setorExecutante.identificador BETWEEN :setorExecutanteInicial AND :setorExecutanteFinal)  AND   (:filtrarTipoServico     <> 1 OR os.tipoServico.identificador     BETWEEN :tipoServicoInicial     AND :tipoServicoFinal    ) ";
        if (!status.equals((short)3)) {
            query = (String)query + " AND (os.status = :status) ";
        }
        query = (String)query + "ORDER BY os.empresa.identificador,          os.identificador ";
        Query q = s.createQuery((String)query);
        q.setShort("filtrarDataCadastro", filtrarDataCadastro.shortValue());
        q.setDate("dataCadastroInicial", dataCadastroInicial);
        q.setDate("dataCadastroFinal", dataCadastroFinal);
        q.setShort("filtrarDataEmissao", filtrarDataEmissao.shortValue());
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setShort("filtrarDataPrevisao", filtrarDataPrevisao.shortValue());
        q.setDate("dataPrevisaoInicial", dataPrevisaoInicial);
        q.setDate("dataPrevisaoFinal", dataPrevisaoFinal);
        q.setShort("filtrarEquipamento", filtrarEquipamento.shortValue());
        q.setLong("equipamentoInicial", equipamentoInicial.longValue());
        q.setLong("equipamentoFinal", equipamentoFinal.longValue());
        q.setShort("filtrarLocalAtivo", filtrarLocalAtivo.shortValue());
        q.setLong("localAtivoInicial", localAtivoInicial.longValue());
        q.setLong("localAtivoFinal", localAtivoFinal.longValue());
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("empresaInicial", empresaInicial.longValue());
        q.setLong("empresaFinal", empresaFinal.longValue());
        q.setShort("filtrarSolicitante", filtrarSolicitante.shortValue());
        q.setLong("solicitanteInicial", solicitanteInicial.longValue());
        q.setLong("solicitanteFinal", solicitanteFinal.longValue());
        q.setShort("filtrarResponsavel", filtrarResponsavel.shortValue());
        q.setLong("responsavelInicial", responsavelInicial.longValue());
        q.setLong("responsavelFinal", responsavelFinal.longValue());
        q.setShort("filtrarSetorExecutante", filtrarSetorExecutante.shortValue());
        q.setLong("setorExecutanteInicial", setorExecutanteInicial.longValue());
        q.setLong("setorExecutanteFinal", setorExecutanteFinal.longValue());
        q.setShort("filtrarTipoServico", filtrarTipoServico.shortValue());
        q.setLong("tipoServicoInicial", tipoServicoInicial.longValue());
        q.setLong("tipoServicoFinal", tipoServicoFinal.longValue());
        if (!status.equals((short)3)) {
            q.setShort("status", status.shortValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List dados = q.list();
        if (exibirExecutante.equals((short)1)) {
            UtilListagemOrdemServico.findExecultantesOrdemServico(dados);
        }
        if (exibirProcedimentos.equals((short)1)) {
            UtilListagemOrdemServico.findServicoFechamentoOrdemServico(dados);
        }
        if (ToolMethods.isEquals((Object)exibirServicosDiagnostico, (Object)1)) {
            UtilListagemOrdemServico.findServicosDiagnostico(dados);
        }
        params.put("FILTRAR_DATA_CADASTRO", filtrarDataCadastro);
        params.put("DATA_CADASTRO_INICIAL", dataCadastroInicial);
        params.put("DATA_CADASTRO_FINAL", dataCadastroFinal);
        params.put("FILTRAR_DATA_EMISSAO", filtrarDataEmissao);
        params.put("DATA_EMISSAO_INICIAL", dataEmissaoInicial);
        params.put("DATA_EMISSAO_FINAL", dataEmissaoFinal);
        params.put("FILTRAR_DATA_PREVISAO", filtrarDataPrevisao);
        params.put("DATA_PREVISAO_INICIAL", dataPrevisaoInicial);
        params.put("DATA_PREVISAO_FINAL", dataPrevisaoFinal);
        params.put("FILTRAR_EQUIPAMENTO", filtrarEquipamento);
        params.put("EQUIPAMENTO_INICIAL", equipamentoInicial);
        params.put("EQUIPAMENTO_FINAL", equipamentoFinal);
        params.put("FILTRAR_LOCAL_ATIVO", filtrarLocalAtivo);
        params.put("LOCAL_ATIVO_INICIAL", localAtivoInicial);
        params.put("LOCAL_ATIVO_FINAL", localAtivoFinal);
        params.put("FILTRAR_EMPRESA", filtrarEmpresa);
        params.put("EMPRESA_INICIAL", empresaInicial);
        params.put("EMPRESA_FINAL", empresaFinal);
        params.put("FILTRAR_SOLICITANTE", filtrarSolicitante);
        params.put("SOLICITANTE_INICIAL", solicitanteInicial);
        params.put("SOLICITANTE_FINAL", solicitanteFinal);
        params.put("FILTRAR_RESPONSAVEL", filtrarResponsavel);
        params.put("RESPONSAVEL_INICIAL", responsavelInicial);
        params.put("RESPONSAVEL_FINAL", responsavelFinal);
        params.put("FILTRAR_SETOR_EXECUTANTE", filtrarSetorExecutante);
        params.put("SETOR_EXECUTANTE_INICIAL", setorExecutanteInicial);
        params.put("SETOR_EXECUTANTE_FINAL", setorExecutanteFinal);
        params.put("FILTRAR_TIPO_SERVICO", filtrarTipoServico);
        params.put("TIPO_SERVICO_INICIAL", tipoServicoInicial);
        params.put("TIPO_SERVICO_FINAL", tipoServicoFinal);
        params.put("EXIBIR_SERVICOS_DIAGNOSTICO", exibirServicosDiagnostico);
        params.put("EXIBIR_OBSERVACOES", exibirObservacoes);
        params.put("STATUS", status);
        params.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", params).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "manutencequipamentos" + File.separator + "ordemservico" + File.separator + "LISTAGEM_ORDEM_SERVICO.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", params);
        relatorio.setAttribute("dados", dados);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    protected static JasperPrint gerarListaCustoOrdemServico(Short filtrarDataCadastro, Date dataCadastroInicial, Date dataCadastroFinal, Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarDataPrevisao, Date dataPrevisaoInicial, Date dataPrevisaoFinal, Short filtrarEquipamento, Long equipamentoInicial, Long equipamentoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short filtrarSolicitante, Long solicitanteInicial, Long solicitanteFinal, Short filtrarResponsavel, Long responsavelInicial, Long responsavelFinal, Short filtrarSetorExecutante, Long setorExecutanteInicial, Long setorExecutanteFinal, Short filtrarTipoServico, Long tipoServicoInicial, Long tipoServicoFinal, Short filtrarLocalizacaoAtivo, Long localizacaoAtivoInicial, Long localizacaoAtivoFinal, Short status, String fecho, HashMap params, Nodo nodo) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "SELECT f.empresa.identificador       AS ID_EMPRESA, f.empresa.pessoa.nome         AS EMPRESA, la.identificador              AS ID_LOCALIZACAO_ATIVO, la.nome                       AS LOCALIZACAO_ATIVO, e.nome                        AS ATIVO, e.codigo                      AS COD_ATIVO, os.codigo                     AS CODIGO, os.dataEmissao                AS DATA_EMISSAO, f                             AS FECHAMENTO_AUX FROM FechamentoOrdemServico f inner join f.ordemServico os inner join os.equipamento e left join e.localizacaoAtivo la WHERE (:filtrarDataCadastro     <> 1 OR os.dataCadastro                    BETWEEN :dataCadastroInicial     AND :dataCadastroFinal     ) AND   (:filtrarDataEmissao      <> 1 OR os.dataEmissao                     BETWEEN :dataEmissaoInicial      AND :dataEmissaoFinal      ) AND   (:filtrarDataPrevisao     <> 1 OR os.dataPrevisao                    BETWEEN :dataPrevisaoInicial     AND :dataPrevisaoFinal     ) AND   (:filtrarEquipamento      <> 1 OR e.identificador                    BETWEEN :equipamentoInicial      AND :equipamentoFinal      ) AND   (:filtrarEmpresa          <> 1 OR os.empresa.identificador           BETWEEN :empresaInicial          AND :empresaFinal          ) AND   (:filtrarSolicitante      <> 1 OR os.solicitante.identificador       BETWEEN :solicitanteInicial      AND :solicitanteFinal      ) AND   (:filtrarResponsavel      <> 1 OR os.responsavel.identificador       BETWEEN :responsavelInicial      AND :responsavelFinal      ) AND   (:filtrarSetorExecutante  <> 1 OR os.setorExecutante.identificador   BETWEEN :setorExecutanteInicial  AND :setorExecutanteFinal  ) AND   (:filtrarTipoServico      <> 1 OR os.tipoServico.identificador       BETWEEN :tipoServicoInicial      AND :tipoServicoFinal      ) AND   (:filtrarLocalizacaoAtivo <> 1 OR la.identificador                   BETWEEN :localizacaoAtivoInicial AND :localizacaoAtivoFinal ) ";
        if (!status.equals((short)3)) {
            query = (String)query + "AND os.status = :status ";
        }
        query = (String)query + "ORDER BY os.empresa.identificador,         la.identificador ";
        Query q = s.createQuery((String)query);
        q.setShort("filtrarDataCadastro", filtrarDataCadastro.shortValue());
        q.setDate("dataCadastroInicial", dataCadastroInicial);
        q.setDate("dataCadastroFinal", dataCadastroFinal);
        q.setShort("filtrarDataEmissao", filtrarDataEmissao.shortValue());
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setShort("filtrarDataPrevisao", filtrarDataPrevisao.shortValue());
        q.setDate("dataPrevisaoInicial", dataPrevisaoInicial);
        q.setDate("dataPrevisaoFinal", dataPrevisaoFinal);
        q.setShort("filtrarEquipamento", filtrarEquipamento.shortValue());
        q.setLong("equipamentoInicial", equipamentoInicial.longValue());
        q.setLong("equipamentoFinal", equipamentoFinal.longValue());
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("empresaInicial", empresaInicial.longValue());
        q.setLong("empresaFinal", empresaFinal.longValue());
        q.setShort("filtrarSolicitante", filtrarSolicitante.shortValue());
        q.setLong("solicitanteInicial", solicitanteInicial.longValue());
        q.setLong("solicitanteFinal", solicitanteFinal.longValue());
        q.setShort("filtrarResponsavel", filtrarResponsavel.shortValue());
        q.setLong("responsavelInicial", responsavelInicial.longValue());
        q.setLong("responsavelFinal", responsavelFinal.longValue());
        q.setShort("filtrarSetorExecutante", filtrarSetorExecutante.shortValue());
        q.setLong("setorExecutanteInicial", setorExecutanteInicial.longValue());
        q.setLong("setorExecutanteFinal", setorExecutanteFinal.longValue());
        q.setShort("filtrarTipoServico", filtrarTipoServico.shortValue());
        q.setLong("tipoServicoInicial", tipoServicoInicial.longValue());
        q.setLong("tipoServicoFinal", tipoServicoFinal.longValue());
        q.setShort("filtrarLocalizacaoAtivo", filtrarLocalizacaoAtivo.shortValue());
        q.setLong("localizacaoAtivoInicial", localizacaoAtivoInicial.longValue());
        q.setLong("localizacaoAtivoFinal", localizacaoAtivoFinal.longValue());
        if (!status.equals((short)3)) {
            q.setShort("status", status.shortValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List result = q.list();
        horasExecucao = 0L;
        minExecucao = 0L;
        for (HashMap h : result) {
            FechamentoOrdemServico fechamentoAux = (FechamentoOrdemServico)h.get("FECHAMENTO_AUX");
            h.put("TEMPO_EXECUCAO", UtilListagemOrdemServico.getTempoExecucao(fechamentoAux));
            h.put("CUSTO_EXECUCAO", UtilListagemOrdemServico.getCustoExecucao(fechamentoAux));
            h.put("CUSTO_MATERIAL", UtilListagemOrdemServico.getCustoMaterial(fechamentoAux));
            h.remove("FECHAMENTO_AUX");
        }
        params.put("TEMPO_EXECUCAO_TOTAL", UtilListagemOrdemServico.transformerTempoEmString(horasExecucao, minExecucao));
        params.put("FILTRAR_DATA_CADASTRO", filtrarDataCadastro);
        params.put("DATA_CADASTRO_INICIAL", dataCadastroInicial);
        params.put("DATA_CADASTRO_FINAL", dataCadastroFinal);
        params.put("FILTRAR_DATA_EMISSAO", filtrarDataEmissao);
        params.put("DATA_EMISSAO_INICIAL", dataEmissaoInicial);
        params.put("DATA_EMISSAO_FINAL", dataEmissaoFinal);
        params.put("FILTRAR_DATA_PREVISAO", filtrarDataPrevisao);
        params.put("DATA_PREVISAO_INICIAL", dataPrevisaoInicial);
        params.put("DATA_PREVISAO_FINAL", dataPrevisaoFinal);
        params.put("FILTRAR_EQUIPAMENTO", filtrarEquipamento);
        params.put("EQUIPAMENTO_INICIAL", equipamentoInicial);
        params.put("EQUIPAMENTO_FINAL", equipamentoFinal);
        params.put("FILTRAR_EMPRESA", filtrarEmpresa);
        params.put("EMPRESA_INICIAL", empresaInicial);
        params.put("EMPRESA_FINAL", empresaFinal);
        params.put("FILTRAR_SOLICITANTE", filtrarSolicitante);
        params.put("SOLICITANTE_INICIAL", solicitanteInicial);
        params.put("SOLICITANTE_FINAL", solicitanteFinal);
        params.put("FILTRAR_RESPONSAVEL", filtrarResponsavel);
        params.put("RESPONSAVEL_INICIAL", responsavelInicial);
        params.put("RESPONSAVEL_FINAL", responsavelFinal);
        params.put("FILTRAR_SETOR_EXECUTANTE", filtrarSetorExecutante);
        params.put("SETOR_EXECUTANTE_INICIAL", setorExecutanteInicial);
        params.put("SETOR_EXECUTANTE_FINAL", setorExecutanteFinal);
        params.put("FILTRAR_TIPO_SERVICO", filtrarTipoServico);
        params.put("TIPO_SERVICO_INICIAL", tipoServicoInicial);
        params.put("TIPO_SERVICO_FINAL", tipoServicoFinal);
        params.put("FILTRAR_LOCALIZACAO_ATIVO", filtrarLocalizacaoAtivo);
        params.put("LOCALIZACAO_ATIVO_INICIAL", localizacaoAtivoInicial);
        params.put("LOCALIZACAO_ATIVO_FINAL", localizacaoAtivoFinal);
        params.put("STATUS", status);
        params.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", params).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "manutencequipamentos" + File.separator + "ordemservico" + File.separator + "LISTAGEM_CUSTO_ORDEM_SERVICO.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", params);
        relatorio.setAttribute("dados", result);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    protected static Double getCustoExecucao(FechamentoOrdemServico fechamentoAux) {
        Double custoExecucao = 0.0;
        for (Executante executante : fechamentoAux.getExecutantes()) {
            custoExecucao = custoExecucao + executante.getValorTotal();
        }
        return custoExecucao;
    }

    protected static String getTempoExecucao(FechamentoOrdemServico fechamentoAux) {
        Long minTotal = 0L;
        Long horasTotal = 0L;
        for (Executante executante : fechamentoAux.getExecutantes()) {
            Double t;
            if (executante.getDataHoraInicio() == null || executante.getDataHoraFinal() == null || (t = DateUtil.calcularDifHoras(executante.getDataHoraInicio(), executante.getDataHoraFinal())) == null || !(t > 0.0)) continue;
            Long segundos = Math.round(t * 3600.0);
            Long horas = segundos / 3600L;
            Long minutos = (segundos - 3600L * horas) / 60L;
            horasTotal = horasTotal + horas;
            minTotal = minTotal + minutos;
            horasExecucao = horasExecucao + horas;
            minExecucao = minExecucao + minutos;
        }
        return UtilListagemOrdemServico.transformerTempoEmString(horasTotal, minTotal);
    }

    protected static Double getCustoMaterial(FechamentoOrdemServico fechamentoAux) {
        Double custoMaterial = 0.0;
        if (fechamentoAux.getConsumoAtivo() != null) {
            for (ItemConsumoAtivo item : fechamentoAux.getConsumoAtivo().getItemConsumoAtivo()) {
                custoMaterial = custoMaterial + item.getValorTotal();
            }
        }
        return custoMaterial;
    }

    protected static JasperPrint gerarListagemOrdemServicoPorEquipamento(Short filtrarDataCadastro, Date dataCadastroInicial, Date dataCadastroFinal, Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarDataPrevisao, Date dataPrevisaoInicial, Date dataPrevisaoFinal, Short filtrarSetorExecutante, Long setorExecutanteInicial, Long setorExecutanteFinal, Short filtrarAtivo, Long ativoInicial, Long ativoFinal, Short filtrarTipoAtivo, Long tipoAtivoInicial, Long tipoAtivoFinal, Short filtrarTipoServico, Long tipoServicoInicial, Long tipoServicoFinal, Short filtrarCentroCusto, Long centroCustoInicial, Long centroCustoFinal, Short status, String fecho, HashMap params, Nodo nodo) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "SELECT os.identificador             AS ID_OS, os.codigo                    AS CODIGO, os.dataProgramada            AS DATA_PROGRAMADA, os.descricaoServico          AS DESCRICAO_SERVICO, os.status                    AS STATUS, os.equipamento.identificador AS ID_ATIVO, os.equipamento.nome          AS NOME_ATIVO, os.equipamento.codigo        AS CODIGO_ATIVO FROM OrdemServico os WHERE (:filtrarDataCadastro    <> 1 OR os.dataCadastro                              BETWEEN :dataCadastroInicial    AND :dataCadastroFinal    ) AND   (:filtrarDataEmissao     <> 1 OR os.dataEmissao                               BETWEEN :dataEmissaoInicial     AND :dataEmissaoFinal     ) AND   (:filtrarDataPrevisao    <> 1 OR os.dataPrevisao                              BETWEEN :dataPrevisaoInicial    AND :dataPrevisaoFinal    ) AND   (:filtrarSetorExecutante <> 1 OR os.setorExecutante.identificador             BETWEEN :setorExecutanteInicial AND :setorExecutanteFinal ) AND   (:filtrarAtivo           <> 1 OR os.equipamento.identificador                 BETWEEN :ativoInicial           AND :ativoFinal           ) AND   (:filtrarTipoAtivo       <> 1 OR os.equipamento.tipoEquipamento.identificador BETWEEN :tipoAtivoInicial       AND :tipoAtivoFinal       ) AND   (:filtrarTipoServico     <> 1 OR os.tipoServico.identificador                 BETWEEN :tipoServicoInicial     AND :tipoServicoFinal     ) AND   (:filtrarCentroCusto     <> 1 OR os.centroCusto.identificador                 BETWEEN :centroCustoInicial     AND :centroCustoFinal     ) ";
        if (!status.equals((short)3)) {
            query = (String)query + "AND os.status = :status ";
        }
        query = (String)query + "ORDER BY os.equipamento.identificador,          os.identificador ";
        Query q = s.createQuery((String)query);
        q.setShort("filtrarDataCadastro", filtrarDataCadastro.shortValue());
        q.setDate("dataCadastroInicial", dataCadastroInicial);
        q.setDate("dataCadastroFinal", dataCadastroFinal);
        q.setShort("filtrarDataEmissao", filtrarDataEmissao.shortValue());
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setShort("filtrarDataPrevisao", filtrarDataPrevisao.shortValue());
        q.setDate("dataPrevisaoInicial", dataPrevisaoInicial);
        q.setDate("dataPrevisaoFinal", dataPrevisaoFinal);
        q.setShort("filtrarSetorExecutante", filtrarSetorExecutante.shortValue());
        q.setLong("setorExecutanteInicial", setorExecutanteInicial.longValue());
        q.setLong("setorExecutanteFinal", setorExecutanteFinal.longValue());
        q.setShort("filtrarAtivo", filtrarAtivo.shortValue());
        q.setLong("ativoInicial", ativoInicial.longValue());
        q.setLong("ativoFinal", ativoFinal.longValue());
        q.setShort("filtrarTipoAtivo", filtrarTipoAtivo.shortValue());
        q.setLong("tipoAtivoInicial", tipoAtivoInicial.longValue());
        q.setLong("tipoAtivoFinal", tipoAtivoFinal.longValue());
        q.setShort("filtrarTipoServico", filtrarTipoServico.shortValue());
        q.setLong("tipoServicoInicial", tipoServicoInicial.longValue());
        q.setLong("tipoServicoFinal", tipoServicoFinal.longValue());
        q.setShort("filtrarCentroCusto", filtrarCentroCusto.shortValue());
        q.setLong("centroCustoInicial", centroCustoInicial.longValue());
        q.setLong("centroCustoFinal", centroCustoFinal.longValue());
        if (!status.equals((short)3)) {
            q.setShort("status", status.shortValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        params.put("FILTRAR_DATA_CADASTRO", filtrarDataCadastro);
        params.put("DATA_CADASTRO_INICIAL", dataCadastroInicial);
        params.put("DATA_CADASTRO_FINAL", dataCadastroFinal);
        params.put("FILTRAR_DATA_PREVISAO", filtrarDataPrevisao);
        params.put("DATA_PREVISAO_INICIAL", dataPrevisaoInicial);
        params.put("DATA_PREVISAO_FINAL", dataPrevisaoFinal);
        params.put("FILTRAR_DATA_EMISSAO", filtrarDataEmissao);
        params.put("DATA_EMISSAO_INICIAL", dataEmissaoInicial);
        params.put("DATA_EMISSAO_FINAL", dataEmissaoFinal);
        params.put("FILTRAR_SETOR_EXECUTANTE", filtrarSetorExecutante);
        params.put("SETOR_EXECUTANTE_INICIAL", setorExecutanteInicial);
        params.put("SETOR_EXECUTANTE_FINAL", setorExecutanteFinal);
        params.put("FILTRAR_ATIVO", filtrarAtivo);
        params.put("ATIVO_INICIAL", ativoInicial);
        params.put("ATIVO_FINAL", ativoFinal);
        params.put("FILTRAR_TIPO_ATIVO", filtrarTipoAtivo);
        params.put("TIPO_ATIVO_INICIAL", tipoAtivoInicial);
        params.put("TIPO_ATIVO_FINAL", tipoAtivoFinal);
        params.put("FILTRAR_TIPO_SERVICO", filtrarTipoServico);
        params.put("TIPO_SERVICO_INICIAL", tipoServicoInicial);
        params.put("TIPO_SERVICO_FINAL", tipoServicoFinal);
        params.put("FILTRAR_CENTRO_CUSTO", filtrarCentroCusto);
        params.put("CENTRO_CUSTO_INICIAL", centroCustoInicial);
        params.put("CENTRO_CUSTO_FINAL", centroCustoFinal);
        params.put("STATUS", status);
        params.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", params).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "manutencequipamentos" + File.separator + "ordemservico" + File.separator + "LISTAGEM_ORDEM_SERVICO_POR_ATIVO.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", params);
        relatorio.setAttribute("dados", q.list());
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private static String transformerTempoEmString(Long horasTotal, Long minTotal) {
        Long calcHoraPorSomaMin = 0L;
        if (minTotal > 0L) {
            calcHoraPorSomaMin = minTotal / 60L;
            horasTotal = horasTotal + calcHoraPorSomaMin;
        }
        Long calcMinutos = 0L;
        if (minTotal > 0L) {
            calcMinutos = minTotal % 60L;
        }
        return ContatoFormatUtil.completaZerosEsquerda((String)horasTotal.toString(), (int)2) + ":" + ContatoFormatUtil.completaZerosEsquerda((String)calcMinutos.toString(), (int)2);
    }

    private static void findExecultantesOrdemServico(List<HashMap> dados) {
        for (HashMap h : dados) {
            Long idOrdemServico = (Long)h.get("ID_OS");
            Session s = CoreBdUtil.getInstance().getSession();
            String query = "SELECT ex.pessoa.nome     AS NOME_PESSOA, ex.pessoa.identificador       AS ID_PESSOA, ex.colaborador.pessoa.nome    AS NOME_COLABORADOR, ex.colaborador.numeroRegistro AS NR_REGISTRO_COLABORADOR, ex.dataHoraInicio             AS DATA_HORA_INICIO, ex.dataHoraFinal              AS DATA_HORA_FINAL, ex.valorHora                  AS VALOR_HORA, ex.valorTotal                 AS VALOR_TOTAL, ex.valorAdicional             AS VALOR_ADICIONAL FROM OrdemServico os   INNER JOIN os.fechamentoOrdemServico f INNER JOIN f.executantes ex  WHERE os.identificador = :id_os ORDER BY ex.identificador";
            Query q = s.createQuery(query);
            q.setLong("id_os", idOrdemServico.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            h.put("LIST_EXECUTANTES", q.list());
        }
    }

    private static void findServicoFechamentoOrdemServico(List<HashMap> dados) {
        for (HashMap h : dados) {
            Long idOrdemServico = (Long)h.get("ID_OS");
            Session s = CoreBdUtil.getInstance().getSession();
            String query = "SELECT sr.nome  AS SERVICO,  sp.identificador    AS ID_SERVICO_PROCEDIMENTO,  sp.executado        AS EXECUTADO  FROM OrdemServico os   LEFT JOIN os.fechamentoOrdemServico f LEFT JOIN f.servicoProcedimentos sp  LEFT JOIN sp.servico sr  WHERE os.identificador = :id_os ORDER BY sp.identificador";
            Query q = s.createQuery(query);
            q.setLong("id_os", idOrdemServico.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List aux = q.list();
            if (aux != null && !aux.isEmpty()) {
                for (HashMap h1 : aux) {
                    Long idServicoProcedimento = (Long)h1.get("ID_SERVICO_PROCEDIMENTO");
                    if (idServicoProcedimento == null) continue;
                    String query1 = "SELECT pr.descricao     AS PROCEDIMENTO, pr.executado                AS EXECUTADO  FROM OrdemServico os   LEFT JOIN os.fechamentoOrdemServico f LEFT JOIN f.servicoProcedimentos sp  LEFT JOIN sp.procedimento pr  WHERE sp.identificador = :idServicoProcedimento ORDER BY pr.identificador";
                    Query q1 = s.createQuery(query1);
                    q1.setLong("idServicoProcedimento", idServicoProcedimento.longValue());
                    q1.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
                    h1.put("LIST_PROCEDIMENTOS", q1.list());
                }
            }
            h.put("LIST_SERVICOS", aux);
        }
    }

    private static void findServicosDiagnostico(List<Map> dados) {
        String query = "select\ns.nome as F_DESCRICAO_SERVICO\nfrom DiagnosticoOSAtivo d\n     inner join d.servicos ss\n         inner join ss.servico s\nWHERE d.ordemServico.identificador = :P_ID_OS";
        for (Map m : dados) {
            Session s = CoreBdUtil.getInstance().getSession();
            Long idOS = (Long)m.get("ID_OS");
            Query q = s.createQuery(query);
            q.setLong("P_ID_OS", idOS.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            m.put("LIST_SERVICO_DIAGNOSTICO", q.list());
        }
    }
}

