/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.ordemservico;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.OrdemServicoNecMateriais;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementor.model.vo.Usuario;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoQTD;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOCARREGAMENTO;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOSALDO;
import mentorcore.utilities.impl.saldoestoque.SaldoEstoqueUtilities;

public class UtilReservarEstoqueOS {
    public void reservarEstoque(OrdemServico ordemServico, CentroEstoque centroEstoqueDestino, Usuario usuario, Short gerarNecessidadeCompra, OpcoesCompraSuprimentos op) throws ExceptionService {
        Short reservar = ordemServico.getReservarEstoque();
        if (reservar != null && reservar == 1) {
            ArrayList itensTransferencia = new ArrayList();
            for (OrdemServicoNecMateriais itensReserva : ordemServico.getOrdemServicoNecMateriais()) {
                itensTransferencia.addAll(this.gerarItensTransferencia(itensReserva, ordemServico.getEmpresa()));
            }
            List listaReserva = this.separaItens(itensTransferencia, 1);
            List listaNecessidade = this.separaItens(itensTransferencia, 2);
            ordemServico.setTransferenciaCentroEstoques(this.gerarTransferencias(listaReserva, centroEstoqueDestino, ordemServico));
            if (gerarNecessidadeCompra != null && gerarNecessidadeCompra == 1 && !listaNecessidade.isEmpty()) {
                ordemServico.setNecessidadeCompra(this.gerarNecessidades(listaNecessidade, ordemServico, usuario, op));
            }
        }
    }

    private List gerarItensTransferencia(OrdemServicoNecMateriais itensNec, Empresa empresa) throws ExceptionService {
        ArrayList ret = new ArrayList();
        List saldosLotes = this.findSaldosPorLotesFabricacaoAbertos(itensNec.getGradeCor(), empresa);
        int i = 0;
        Double qtdRemanescente = itensNec.getQuantidade();
        do {
            HashMap<String, Number> h = new HashMap<String, Number>();
            if (saldosLotes.size() > 0) {
                SaldoEstoqueGeral saldo = (SaldoEstoqueGeral)saldosLotes.get(i);
                if (qtdRemanescente > saldo.getQuantidade()) {
                    qtdRemanescente = qtdRemanescente - saldo.getQuantidade();
                    h.put("quantidade", saldo.getQuantidade());
                } else {
                    h.put("quantidade", qtdRemanescente);
                    qtdRemanescente = 0.0;
                }
                h.put("loteFabricacao", (Number)saldo.getLoteFabricacao());
                h.put("gradeCor", (Number)itensNec.getGradeCor());
                h.put("centroEstoque", (Number)saldo.getCentroEstoque());
                h.put("valorPrecoMedio", saldo.getValorMedio());
                h.put("tipo", 1);
                ret.add(h);
            }
            if (++i < saldosLotes.size()) continue;
            if (!(qtdRemanescente > 0.0)) break;
            HashMap<String, Number> h2 = new HashMap<String, Number>();
            h2.put("quantidade", qtdRemanescente);
            h2.put("tipo", 2);
            h2.put("gradeCor", (Number)itensNec.getGradeCor());
            ret.add(h2);
            itensNec.setQuantidadeRemanc(qtdRemanescente);
            break;
        } while (qtdRemanescente > 0.0);
        return ret;
    }

    private List<TransferenciaCentroEstoque> gerarTransferencias(List<HashMap> itensTransferencia, CentroEstoque centroEstoqueDestino, OrdemServico ordemServico) {
        List trasnferenciasCentroEstoque = ordemServico.getTransferenciaCentroEstoques();
        for (HashMap h : itensTransferencia) {
            this.addToTransferenciaCentroEstoque(centroEstoqueDestino, trasnferenciasCentroEstoque, ordemServico, h);
        }
        return trasnferenciasCentroEstoque;
    }

    private void addToTransferenciaCentroEstoque(CentroEstoque centroEstoqueDestino, List<TransferenciaCentroEstoque> transferenciasCentroEstoque, OrdemServico ordemServico, HashMap h) {
        CentroEstoque centroEstoqueOrigem = (CentroEstoque)h.get("centroEstoque");
        GradeCor gradeCor = (GradeCor)h.get("gradeCor");
        Produto produto = gradeCor.getProdutoGrade().getProduto();
        LoteFabricacao loteFabricacao = (LoteFabricacao)h.get("loteFabricacao");
        Double quantidade = (Double)h.get("quantidade");
        Double valorUnitario = (Double)h.get("valorPrecoMedio");
        TransferenciaCentroEstoque transferenciaCentroEstoque = this.getTransferencia(transferenciasCentroEstoque, centroEstoqueOrigem, centroEstoqueDestino, ordemServico);
        ItemTransfCentroEstoque itemTransfCentroEstoque = this.getItemTransferenciaCentroEstoque(transferenciaCentroEstoque, produto);
        this.getGradeItemTransferenciaCentroEstoque(itemTransfCentroEstoque, gradeCor, loteFabricacao, quantidade, valorUnitario, transferenciaCentroEstoque.getEmpresa());
    }

    private TransferenciaCentroEstoque getTransferencia(List<TransferenciaCentroEstoque> transferenciasCentroEstoque, CentroEstoque centroEstoqueOrigem, CentroEstoque centroEstoqueDestino, OrdemServico ordemServico) {
        TransferenciaCentroEstoque ret = null;
        for (TransferenciaCentroEstoque transferencia : transferenciasCentroEstoque) {
            if (!transferencia.getDestino().equals((Object)centroEstoqueDestino) || !transferencia.getOrigem().equals((Object)centroEstoqueOrigem)) continue;
            ret = transferencia;
            break;
        }
        if (ret == null) {
            ret = new TransferenciaCentroEstoque();
            ret.setDestino(centroEstoqueDestino);
            ret.setOrigem(centroEstoqueOrigem);
            ret.setOrdemServico(ordemServico);
            ret.setDataCadastro(new Date());
            ret.setDataTransferencia(new Date());
            ret.setEmpresa(ordemServico.getEmpresa());
            transferenciasCentroEstoque.add(ret);
        }
        return ret;
    }

    private ItemTransfCentroEstoque getItemTransferenciaCentroEstoque(TransferenciaCentroEstoque transferenciaCentroEstoque, Produto produto) {
        ItemTransfCentroEstoque ret = null;
        for (ItemTransfCentroEstoque itemTransferencia : transferenciaCentroEstoque.getItemTransfCentroEstoque()) {
            if (!itemTransferencia.getProduto().equals((Object)produto)) continue;
            ret = itemTransferencia;
            break;
        }
        if (ret == null) {
            ret = new ItemTransfCentroEstoque();
            ret.setProduto(produto);
            ret.setTransfCentroEstoque(transferenciaCentroEstoque);
            ret.setDestino(transferenciaCentroEstoque.getDestino());
            ret.setOrigem(transferenciaCentroEstoque.getOrigem());
            transferenciaCentroEstoque.getItemTransfCentroEstoque().add(ret);
        }
        return ret;
    }

    private void getGradeItemTransferenciaCentroEstoque(ItemTransfCentroEstoque itemTransfCentroEstoque, GradeCor gradeCor, LoteFabricacao loteFabricacao, Double quantidade, Double valorUnitario, Empresa empresa) {
        GradeItemTransfCentroEstoque ret = null;
        for (GradeItemTransfCentroEstoque gradeItemTransferencia : itemTransfCentroEstoque.getGradeItemTransCentroEst()) {
            if (!gradeItemTransferencia.getGradeCor().equals((Object)gradeCor) || !gradeItemTransferencia.getLoteFabricacao().equals((Object)loteFabricacao)) continue;
            ret = gradeItemTransferencia;
            break;
        }
        if (ret == null) {
            ret = new GradeItemTransfCentroEstoque();
            ret.setDataTransferencia(itemTransfCentroEstoque.getTransfCentroEstoque().getDataTransferencia());
            ret.setLoteFabricacao(loteFabricacao);
            ret.setGradeCor(gradeCor);
            ret.setItemTransfCentroEst(itemTransfCentroEstoque);
            ret.setQuantidade(quantidade);
            ret.setOrigem(itemTransfCentroEstoque.getOrigem());
            ret.setDestino(itemTransfCentroEstoque.getDestino());
            ret.setEmpresa(empresa);
            itemTransfCentroEstoque.getGradeItemTransCentroEst().add(ret);
        }
        Double quantidadeTotal = 0.0;
        for (GradeItemTransfCentroEstoque gradeItemTransfCentroEstoque : itemTransfCentroEstoque.getGradeItemTransCentroEst()) {
            quantidadeTotal = quantidadeTotal + gradeItemTransfCentroEstoque.getQuantidade();
        }
        itemTransfCentroEstoque.setQuantidadeTotal(quantidadeTotal);
    }

    private List findSaldosPorLotesFabricacaoAbertos(GradeCor gradeCor, Empresa empresa) throws ExceptionService {
        Produto produto = gradeCor != null ? gradeCor.getProdutoGrade().getProduto() : null;
        return SaldoEstoqueUtilities.findSaldoGradeCentroEstoqueLoteLista(produto, produto, gradeCor, gradeCor, new Date(), null, null, null, empresa, empresa, EnumConstantsSaldoTIPOSALDO.TIPO_SALDO_LOTE_FABRICACAO, EnumConstantsSaldoQTD.TIPO_SALDO_QTQ_MAIOR_0, EnumConstantsSaldoTIPOCARREGAMENTO.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_DISPONIVEL.getValue(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue(), null);
    }

    private List separaItens(List itensTransferencia, int tipoItem) {
        ArrayList ret = new ArrayList();
        for (Object o : itensTransferencia) {
            HashMap h = (HashMap)o;
            Integer tipo = (Integer)h.get("tipo");
            if (tipo != tipoItem) continue;
            ret.add(o);
        }
        return ret;
    }

    private List gerarNecessidades(List<HashMap> necessidade, OrdemServico ordemServico, Usuario usuario, OpcoesCompraSuprimentos op) {
        ArrayList<NecessidadeCompra> ret = new ArrayList<NecessidadeCompra>();
        for (HashMap h : necessidade) {
            NecessidadeCompra necessidadeCompra = new NecessidadeCompra();
            if (op != null) {
                necessidadeCompra.setSituacaoNecessidadeCompra(op.getSituacaoNecessidadeCadastro());
            }
            necessidadeCompra.setOrdemServico(ordemServico);
            necessidadeCompra.setDataNecessidade(new Date());
            necessidadeCompra.setDataCadastro(new Date());
            necessidadeCompra.setCentroCusto(ordemServico.getCentroCusto());
            necessidadeCompra.setGradeCor((GradeCor)h.get("gradeCor"));
            necessidadeCompra.setQuantidadeNecessidade((Double)h.get("quantidade"));
            necessidadeCompra.setEmpresa(ordemServico.getEmpresa());
            necessidadeCompra.setUsuarioSolicitante(usuario);
            necessidadeCompra.setTipoGeracao(Short.valueOf((short)1));
            necessidadeCompra.setObservacao("Gerado pela OS com cadastro em:" + DateUtil.dateToStr(ordemServico.getDataCadastro()));
            ret.add(necessidadeCompra);
        }
        return ret;
    }
}

