/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.pagamentodecimoterceiro;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.Salario13oColaborador;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;

public class ServicePagamentoDecTerceiroSalario
extends CoreService {
    public static final String FIND_COLABORADORES_PAG_ADD_DEC = "findColaboradoresPagAddDec";
    public static final String FIND_COLABORADORES_PAGAMENTO_DEC_SALARIO = "findColaboradoresPagamentoDecSalario";
    public static final String FIND_VALOR_MEDIA_ADD_PAG_ADD_TERCEIRO = "findValorMediaAddDec";
    public static final String FIND_SALARIO_NOMINAL = "findSalarioNominal";
    public static final String FIND_AFASTAMENTO_PAGAMENTO_DEC = "findAfastamentoPagamentoDec";
    public static final String FIND_AFASTAMENTO_PAGAMENTO_DEC_COM_MATERNIDADE = "findAfastamentoPagamentoDecComMaternidade";
    public static final String FIND_AFASTAMENTO_MATERNIDADE_DEC_TERCEIRO = "findAfastamentoMaternidadeDecTerceiro";
    public static final String VERIFICAR_OCORRENCIA_FALTA_DEC_TERCEIRO = "verificarOcorrenciaFaltaDecTerceiro";
    public static final String VERIFICAR_OCORRENCIA_FALTA_DEC_TERCEIRO_RECISAO = "verificarOcorrenciaFaltaDecRecisao";

    public List findColaboradoresPagAddDec(CoreRequestContext request) {
        Integer ano = (Integer)request.getAttribute("ano");
        Long idEmpresa = (Long)request.getAttribute("idEmpresa");
        Long codigoEventoAddDec = (Long)request.getAttribute("codigoEventoAddDec");
        Date dataPagamento = (Date)request.getAttribute("dataPagamento");
        return CoreDAOFactory.getInstance().getDAOAno13oSalario().findColaboradoresPagAddDecSalario(ano, idEmpresa, codigoEventoAddDec, dataPagamento);
    }

    public List findColaboradoresPagamentoDecSalario(CoreRequestContext request) {
        Integer ano = (Integer)request.getAttribute("ano");
        Long idEmpresa = (Long)request.getAttribute("idEmpresa");
        Date dataPagamento = (Date)request.getAttribute("dataPagamento");
        return CoreDAOFactory.getInstance().getDAOAno13oSalario().findColaboradoresPagamentoDecSalario(ano, idEmpresa, dataPagamento);
    }

    public List findValorMediaAddDec(CoreRequestContext request) throws ExceptionService {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        Integer ano = (Integer)request.getAttribute("ano");
        return CoreDAOFactory.getInstance().getDAOAno13oSalario().findMediaPagamentoDec(colaborador, ano);
    }

    public Double findSalarioNominal(CoreRequestContext request) {
        Salario13oColaborador vo = (Salario13oColaborador)request.getAttribute("salario13");
        return CoreDAOFactory.getInstance().getDAOAno13oSalario().getSalarioNominal(vo);
    }

    public List findAfastamentoPagamentoDec(CoreRequestContext request) {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        Integer ano = (Integer)request.getAttribute("ano");
        return CoreDAOFactory.getInstance().getDAOAno13oSalario().findAfastamentosAnuaisPorColaborador(colaborador, ano);
    }

    public List findAfastamentoPagamentoDecComMaternidade(CoreRequestContext request) {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        Integer ano = (Integer)request.getAttribute("ano");
        return CoreDAOFactory.getInstance().getDAOAno13oSalario().findAfastamentosAnuaisPorColaboradorFeminino(colaborador, ano);
    }

    public List findAfastamentoMaternidadeDecTerceiro(CoreRequestContext request) {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        Integer ano = (Integer)request.getAttribute("ano");
        return CoreDAOFactory.getInstance().getDAOAno13oSalario().findAfastamentosMaternidadePorColaborador(colaborador, ano);
    }

    public Integer verificarOcorrenciaFaltaDecTerceiro(CoreRequestContext request) {
        Salario13oColaborador vo = (Salario13oColaborador)request.getAttribute("salarioDec");
        Integer ano = (Integer)request.getAttribute("ano");
        return CoreDAOFactory.getInstance().getDAOAno13oSalario().verificarFaltasPorPeriodo(vo, ano);
    }

    public Integer verificarOcorrenciaFaltaDecRecisao(CoreRequestContext request) {
        Recisao vo = (Recisao)request.getAttribute("recisao");
        TipoCalculoEvento tpFaltas = (TipoCalculoEvento)request.getAttribute("tpFaltas");
        return CoreDAOFactory.getInstance().getDAOAno13oSalario().verificarFaltasPorPeriodoRecisao13(vo, tpFaltas);
    }
}

