/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.pagamentodecimoterceiro;

import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Salario13oColaborador;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;

public class UtilPagamentoDecTerceiroSalario {
    private Short TP_OCORRENCIA_SEMPRE_CALCULAR_EVENTO = 0;

    public List createSalario13Colaborador(List colaboradores, Date dataPrevisaoPagamento) throws ExceptionService {
        ArrayList<Salario13oColaborador> listasalario13 = new ArrayList<Salario13oColaborador>();
        for (Object o : colaboradores) {
            Colaborador c = (Colaborador)o;
            Salario13oColaborador salario13 = new Salario13oColaborador();
            salario13.setColaborador(c);
            salario13.setDataPagamento(dataPrevisaoPagamento);
            salario13.setSalarioNominal(this.getSalarioNominal(salario13));
            listasalario13.add(salario13);
        }
        return listasalario13;
    }

    public void calcularAvosPagamentoDec(Salario13oColaborador vo, Integer ano) throws ExceptionService {
        GregorianCalendar dataAdmissao = new GregorianCalendar();
        dataAdmissao.setTime(vo.getColaborador().getDataAdmissao());
        Integer avos = 0;
        if (dataAdmissao.get(1) == ano.intValue()) {
            avos = dataAdmissao.getActualMaximum(5) - dataAdmissao.get(5) + 1 > 14 ? Integer.valueOf(12 - dataAdmissao.get(2)) : Integer.valueOf(12 - (dataAdmissao.get(2) + 1));
            vo.setNrAvos(avos);
        } else {
            vo.setNrAvos(Integer.valueOf(12));
        }
        this.verificarAfastadosAnuais(vo, ano);
        this.verificarFaltasPorPeriodo(vo, ano);
    }

    public void calcularAvosPagamentoDecAdiantamento(Salario13oColaborador vo, Integer ano) throws ExceptionService {
        GregorianCalendar dataAdmissao = new GregorianCalendar();
        dataAdmissao.setTime(vo.getColaborador().getDataAdmissao());
        Integer avos = 0;
        if (dataAdmissao.get(1) == ano.intValue()) {
            avos = dataAdmissao.getActualMaximum(5) - dataAdmissao.get(5) + 1 > 14 ? Integer.valueOf(12 - dataAdmissao.get(2)) : Integer.valueOf(12 - (dataAdmissao.get(2) + 1));
            vo.setNrAvos(avos);
        } else {
            vo.setNrAvos(Integer.valueOf(12));
        }
        this.verificarAfastadosAnuaisAdiantamento(vo, ano);
        this.verificarFaltasPorPeriodo(vo, ano);
    }

    private Double getSalarioNominal(Salario13oColaborador vo) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("salario13", vo);
        return (Double)CoreServiceFactory.getServicePagamentoDecTerceiroSalario().execute(request, "findSalarioNominal");
    }

    private void verificarAfastadosAnuais(Salario13oColaborador vo, Integer ano) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("ano", ano);
        request.setAttribute("colaborador", vo.getColaborador());
        List afastamentosMaternidade = new ArrayList();
        List afastamentos = new ArrayList();
        if (vo.getColaborador().getSexo().equals((short)0)) {
            afastamentos = (List)CoreServiceFactory.getServicePagamentoDecTerceiroSalario().execute(request, "findAfastamentoPagamentoDec");
        } else {
            afastamentos = (List)CoreServiceFactory.getServicePagamentoDecTerceiroSalario().execute(request, "findAfastamentoPagamentoDecComMaternidade");
            afastamentosMaternidade = (List)CoreServiceFactory.getServicePagamentoDecTerceiroSalario().execute(request, "findAfastamentoMaternidadeDecTerceiro");
        }
        if (afastamentos.isEmpty()) {
            return;
        }
        Integer avos = vo.getNrAvos();
        Date primeiroJaneiro = DateUtil.intToDate(ano, 1, 1);
        Date trintaUmDezembro = DateUtil.intToDate(ano, 12, 31);
        Integer avosAfastamentos = 0;
        for (Object obj : afastamentos) {
            AfastamentoColaborador afastamento = (AfastamentoColaborador)obj;
            if (afastamento.getDataAfastamento().before(primeiroJaneiro) && (afastamento.getDataRetorno() == null || afastamento.getDataRetorno().after(trintaUmDezembro))) {
                vo.setNrAvos(Integer.valueOf(0));
                return;
            }
            if (afastamento.getDataAfastamento().before(primeiroJaneiro) && afastamento.getDataRetorno() != null && afastamento.getDataRetorno().before(trintaUmDezembro)) {
                avosAfastamentos = this.getAvosAfastamentos(primeiroJaneiro, afastamento.getDataRetorno()) + avosAfastamentos;
                continue;
            }
            if (afastamento.getDataAfastamento().after(primeiroJaneiro) && (afastamento.getDataRetorno() == null || afastamento.getDataRetorno().after(trintaUmDezembro) || afastamento.getDataRetorno().equals(trintaUmDezembro))) {
                avosAfastamentos = this.getAvosAfastamentos(afastamento.getDataAfastamento(), trintaUmDezembro) + avosAfastamentos;
                continue;
            }
            if (!afastamento.getDataAfastamento().after(primeiroJaneiro) || afastamento.getDataRetorno() == null || !afastamento.getDataRetorno().before(trintaUmDezembro)) continue;
            avosAfastamentos = this.getAvosAfastamentos(afastamento.getDataAfastamento(), afastamento.getDataRetorno()) + avosAfastamentos;
        }
        Integer avosMaternidade = 0;
        for (Object obj : afastamentosMaternidade) {
            AfastamentoColaborador afastamento = (AfastamentoColaborador)obj;
            if ((afastamento.getDataAfastamento().before(primeiroJaneiro) || afastamento.getDataAfastamento().equals(primeiroJaneiro)) && afastamento.getDataRetorno() != null && (afastamento.getDataRetorno().before(vo.getDataPagamento()) || afastamento.getDataRetorno().equals(vo.getDataPagamento()))) {
                avosMaternidade = ToolDate.diferenceDayBetweenDatesExclusive((Date)primeiroJaneiro, (Date)afastamento.getDataRetorno()) + 1;
                continue;
            }
            if (afastamento.getDataAfastamento().after(primeiroJaneiro) && (afastamento.getDataRetorno() == null || afastamento.getDataRetorno().after(vo.getDataPagamento()))) {
                avosMaternidade = ToolDate.diferenceDayBetweenDatesExclusive((Date)afastamento.getDataAfastamento(), (Date)trintaUmDezembro) + 1;
                continue;
            }
            if (!afastamento.getDataAfastamento().after(primeiroJaneiro) || afastamento.getDataRetorno() == null || !afastamento.getDataRetorno().before(vo.getDataPagamento())) continue;
            avosMaternidade = ToolDate.diferenceDayBetweenDatesExclusive((Date)afastamento.getDataAfastamento(), (Date)afastamento.getDataRetorno());
        }
        vo.setNrAvos(Integer.valueOf(avos - avosAfastamentos));
        vo.setNrAvosMaternidade(avosMaternidade);
    }

    private void verificarAfastadosAnuaisAdiantamento(Salario13oColaborador vo, Integer ano) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("ano", ano);
        request.setAttribute("colaborador", vo.getColaborador());
        List afastamentos = new ArrayList();
        afastamentos = (List)CoreServiceFactory.getServicePagamentoDecTerceiroSalario().execute(request, "findAfastamentoPagamentoDec");
        if (afastamentos.isEmpty()) {
            return;
        }
        Integer avos = vo.getNrAvos();
        Date primeiroJaneiro = DateUtil.intToDate(ano, 1, 1);
        Date trintaUmDezembro = DateUtil.intToDate(ano, 12, 31);
        Integer avosAfastamentos = 0;
        for (Object obj : afastamentos) {
            AfastamentoColaborador afastamento = (AfastamentoColaborador)obj;
            if (afastamento.getDataAfastamento().before(primeiroJaneiro) && (afastamento.getDataRetorno() == null || afastamento.getDataRetorno().after(trintaUmDezembro))) {
                vo.setNrAvos(Integer.valueOf(0));
                return;
            }
            if (afastamento.getDataAfastamento().before(primeiroJaneiro) && afastamento.getDataRetorno() != null && afastamento.getDataRetorno().before(trintaUmDezembro)) {
                avosAfastamentos = this.getAvosAfastamentos(primeiroJaneiro, afastamento.getDataRetorno()) + avosAfastamentos;
                continue;
            }
            if (afastamento.getDataAfastamento().after(primeiroJaneiro) && (afastamento.getDataRetorno() == null || afastamento.getDataRetorno().after(trintaUmDezembro))) {
                avosAfastamentos = this.getAvosAfastamentos(afastamento.getDataAfastamento(), trintaUmDezembro) + avosAfastamentos;
                continue;
            }
            if (!afastamento.getDataAfastamento().after(primeiroJaneiro) || afastamento.getDataRetorno() == null || !afastamento.getDataRetorno().before(trintaUmDezembro)) continue;
            avosAfastamentos = this.getAvosAfastamentos(afastamento.getDataAfastamento(), afastamento.getDataRetorno()) + avosAfastamentos;
        }
        vo.setNrAvos(Integer.valueOf(avos - avosAfastamentos));
        vo.setNrAvosMaternidade(Integer.valueOf(0));
    }

    private Integer getAvosAfastamentos(Date dataInicial, Date dataFim) {
        boolean continuar = false;
        Integer avos = 0;
        GregorianCalendar dataInicio = new GregorianCalendar();
        dataInicio.setTime(dataInicial);
        GregorianCalendar dataFinal = new GregorianCalendar();
        dataFinal.setTime(dataFim);
        if (dataInicio.get(1) == dataFinal.get(1)) {
            avos = UtilPagamentoDecTerceiroSalario.getPrimeiroAvosDec(dataInicial, dataFinal.getTime());
            dataInicio.add(2, 1);
            dataInicio.getTime();
            do {
                if (dataInicio.before(dataFinal) && dataInicio.get(2) != dataFinal.get(2)) {
                    avos = avos + 1;
                    continuar = true;
                } else {
                    avos = UtilPagamentoDecTerceiroSalario.getUltimoAvosDec(dataInicio.getTime(), dataFinal.getTime(), dataInicial) + avos;
                    continuar = false;
                }
                dataInicio.add(2, 1);
            } while (continuar);
            return avos;
        }
        if (dataInicio.get(1) < dataFinal.get(1)) {
            avos = dataFinal.get(2) + 1;
            if (dataFinal.get(5) < 15) {
                avos = avos - 1;
            }
            return avos;
        }
        return 0;
    }

    private static Integer getPrimeiroAvosDec(Date dataAdmissao, Date dataDemissao) {
        Integer DIAS_TRABALHAOS;
        Integer aux;
        GregorianCalendar dataAdm = new GregorianCalendar();
        dataAdm.setTime(dataAdmissao);
        GregorianCalendar dataDem = new GregorianCalendar();
        dataDem.setTime(dataDemissao);
        if (dataAdm.get(2) == dataDem.get(2) ? (aux = Integer.valueOf(dataDem.get(5) - dataAdm.get(5) + 1)) >= 15 : (DIAS_TRABALHAOS = Integer.valueOf(dataAdm.get(5) - 1)) < 15 && dataAdm.get(5) != 16) {
            return 1;
        }
        return 0;
    }

    private static Integer getUltimoAvosDec(Date dataP, Date dataDemissao, Date dataAdmissao) {
        GregorianCalendar dataFinalFerias = new GregorianCalendar();
        dataFinalFerias.setTime(dataP);
        GregorianCalendar dataFinalDemissao = new GregorianCalendar();
        dataFinalDemissao.setTime(dataDemissao);
        GregorianCalendar dtAdmissao = new GregorianCalendar();
        dtAdmissao.setTime(dataAdmissao);
        if (dataFinalDemissao.get(2) == dtAdmissao.get(2)) {
            return 0;
        }
        Integer DIAS_AFASTADOS = dataFinalDemissao.get(5) - 1;
        Integer DIAS_TRABALHAOS = dataFinalDemissao.getActualMaximum(5) - DIAS_AFASTADOS;
        if (DIAS_TRABALHAOS < 15 && dataFinalDemissao.get(5) != 16) {
            return 1;
        }
        return 0;
    }

    private void verificarFaltasPorPeriodo(Salario13oColaborador vo, Integer ano) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("salarioDec", vo);
        request.setAttribute("ano", ano);
        Integer result = (Integer)CoreServiceFactory.getServicePagamentoDecTerceiroSalario().execute(request, "verificarOcorrenciaFaltaDecTerceiro");
        if ((long)result.intValue() > 0L) {
            Integer avos = vo.getNrAvos();
            vo.setNrAvos(Integer.valueOf(avos - result));
        }
    }
}

