/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.pagtotranspagregado;

import com.touchcomp.basementor.model.vo.ComponenteFrete;
import com.touchcomp.basementor.model.vo.EventoTranspAgregado;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.pagtotranspagregado.model.ListagemAdiantamento;
import mentorcore.service.impl.pagtotranspagregado.model.ListagemComponenteFrete;
import mentorcore.service.impl.pagtotranspagregado.model.ListagemConsumo;
import mentorcore.service.impl.pagtotranspagregado.model.ListagemCte;
import mentorcore.service.impl.pagtotranspagregado.model.ListagemCteNfe;
import mentorcore.service.impl.pagtotranspagregado.model.ListagemCtePlaca;
import mentorcore.service.impl.pagtotranspagregado.model.ListagemOutrosEventos;
import mentorcore.service.impl.pagtotranspagregado.model.ListagemPagtoTranspAgregado;
import mentorcore.service.impl.pagtotranspagregado.model.ListagemPreRps;
import mentorcore.service.impl.pagtotranspagregado.model.ListagemPreRpsPlaca;
import mentorcore.service.impl.pagtotranspagregado.model.ListagemTranspAgregado;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.jdom2.Content;
import org.jdom2.Element;

class UtiLGeraRelArqValorLiquidoTranspAgreg {
    Double vrTotalConsumo = 0.0;
    Double vrTotalEventos = 0.0;
    Double vrTotalBruto = 0.0;
    Double vrTotalDesconto = 0.0;
    Double vrTotalLiquido = 0.0;
    Double vrTotalCompFrete = 0.0;
    Double vrTotalAdiantamento = 0.0;
    Double vrTotalOutrosEventos = 0.0;
    Double vrTotalLiquidoFinal = 0.0;
    Double vrTotalPreRps = 0.0;

    UtiLGeraRelArqValorLiquidoTranspAgreg() {
    }

    List<ListagemTranspAgregado> gerarRelArqValorLiquidoTranspAgreg(Short filtrarDataPagamento, Date dataPagamentoInicial, Date dataPagamentoFinal, Short filtrarTranspAgregado, Long transpAgregadoInicial, Long transpAgregadoFinal, Short exibirSomentePlacaPrincipal, Short exibirCtes, Short exibirPreRps, Short exibirConsumos, Short exibirAdiantamentos, Short exibirOutrosEventos, Short filtrosEventos, List<EventoTranspAgregado> listEventos, Short filtrosComponenteFretes, List<ComponenteFrete> listComponenteFretes) {
        List listTranspAgreg = this.pesquisarTranspAgregado(filtrarDataPagamento, dataPagamentoInicial, dataPagamentoFinal, filtrarTranspAgregado, transpAgregadoInicial, transpAgregadoFinal);
        this.pesquisarPagtoTranspAgregado(listTranspAgreg, filtrarDataPagamento, dataPagamentoInicial, dataPagamentoFinal, exibirSomentePlacaPrincipal, exibirCtes, exibirPreRps, exibirConsumos, exibirAdiantamentos, exibirOutrosEventos, filtrosEventos, listEventos, filtrosComponenteFretes, listComponenteFretes);
        return listTranspAgreg;
    }

    private List pesquisarTranspAgregado(Short filtrarDataPagamento, Date dataPagamentoInicial, Date dataPagamentoFinal, Short filtrarTranspAgregado, Long transpAgregadoInicial, Long transpAgregadoFinal) {
        return this.pesquisarListTranspAgregado(filtrarDataPagamento, dataPagamentoInicial, dataPagamentoFinal, filtrarTranspAgregado, transpAgregadoInicial, transpAgregadoFinal);
    }

    private void pesquisarPagtoTranspAgregado(List<ListagemTranspAgregado> listTranspAgreg, Short filtrarDataPagamento, Date dataPagamentoInicial, Date dataPagamentoFinal, Short exibirSomentePlacaPrincipal, Short exibirCtes, Short exibirPreRps, Short exibirConsumos, Short exibirAdiantamentos, Short exibirOutrosEventos, Short filtrosEventos, List<EventoTranspAgregado> listEventos, Short filtrosComponenteFretes, List<ComponenteFrete> listComponenteFretes) {
        for (ListagemTranspAgregado l : listTranspAgreg) {
            l.setListagemPagtoTranspAgregado(this.pesquisarPagtoTranspAgregado(l.getIdTranspAgregado(), filtrarDataPagamento, dataPagamentoInicial, dataPagamentoFinal));
            this.pesquisarDadosPagtoTranspAgreg(l.getListagemPagtoTranspAgregado(), exibirSomentePlacaPrincipal, exibirCtes, exibirPreRps, exibirConsumos, exibirAdiantamentos, exibirOutrosEventos, filtrosEventos, listEventos, filtrosComponenteFretes, listComponenteFretes);
        }
    }

    private void pesquisarDadosPagtoTranspAgreg(List<ListagemPagtoTranspAgregado> listagemPagtoTranspAgregado, Short exibirSomentePlacaPrincipal, Short exibirCtes, Short exibirPreRps, Short exibirConsumos, Short exibirAdiantamentos, Short exibirOutrosEventos, Short filtrosEventos, List<EventoTranspAgregado> listEventos, Short filtrosComponenteFretes, List<ComponenteFrete> listComponenteFretes) {
        for (ListagemPagtoTranspAgregado l : listagemPagtoTranspAgregado) {
            this.pesquisarConsumo(l, exibirConsumos);
            this.pesquisarEventos(l, filtrosEventos, listEventos);
            this.pesquisarCte(l, exibirCtes, exibirSomentePlacaPrincipal, filtrosComponenteFretes, listComponenteFretes);
            this.pesquisarPreRps(l, exibirPreRps, exibirSomentePlacaPrincipal);
            this.pesquisarAdiantamentos(l, exibirAdiantamentos);
            this.pesquisarOutrosEventos(l, exibirOutrosEventos);
            this.verificarValorTotalCteRps(l);
            this.calcularValorFinalCte(l);
            this.calcularValorFinalPreRps(l);
            this.calcularValorFinalCtePreRps(l);
            l.setVrTotalDeposito(l.getVrTotalLiquidoFinal() - l.getVrTotalAdiantamento() + l.getVrTotalOutrosEventos());
        }
    }

    private void pesquisarConsumo(ListagemPagtoTranspAgregado l, Short exibirConsumos) {
        this.vrTotalConsumo = 0.0;
        ArrayList<ListagemConsumo> toRet = new ArrayList<ListagemConsumo>();
        if (exibirConsumos == 1) {
            List ret = this.pesquisarConsumo(l.getIdPagtoTranspAgregado());
            this.preencherObjetoConsumo(toRet, ret);
        } else {
            this.vrTotalConsumo = this.pesquisarValorTotalConsumo(l.getIdPagtoTranspAgregado());
        }
        l.setListagemConsumo(toRet);
        l.setVrTotalConsumo(this.vrTotalConsumo);
    }

    private void preencherObjetoConsumo(List<ListagemConsumo> toRet, List ret) {
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            ListagemConsumo l = new ListagemConsumo();
            l.setIdConsumo((Long)h.get("idConsumo"));
            l.setNomeConsumo((String)h.get("nomeConsumo"));
            l.setPlaca((String)h.get("placa"));
            l.setHodometro((Double)h.get("hodometro"));
            l.setIdProduto((Long)h.get("idProduto"));
            l.setNomeProduto((String)h.get("nomeProduto"));
            l.setFornecedor((String)h.get("fornecedor"));
            l.setData((Date)h.get("data"));
            l.setVrUnitario((Double)h.get("vrUnitario"));
            l.setQtdTotal((Double)h.get("qtdTotal"));
            l.setVrDesconto((Double)h.get("vrDesconto"));
            l.setVrTotal((Double)h.get("vrTotal"));
            this.vrTotalConsumo = this.vrTotalConsumo + l.getVrTotal();
            toRet.add(l);
        }
    }

    private void pesquisarEventos(ListagemPagtoTranspAgregado l, Short filtrosEventos, List<EventoTranspAgregado> listEventos) {
        this.vrTotalEventos = 0.0;
        if (filtrosEventos == 1) {
            this.vrTotalEventos = this.pesquisarEventos(l.getIdPagtoTranspAgregado(), listEventos);
        }
    }

    private void pesquisarCte(ListagemPagtoTranspAgregado l, Short exibirCtes, Short exibirSomentePlacaPrincipal, Short filtrosComponenteFretes, List<ComponenteFrete> listComponenteFretes) {
        this.vrTotalBruto = 0.0;
        this.vrTotalDesconto = 0.0;
        this.vrTotalLiquido = 0.0;
        this.vrTotalCompFrete = 0.0;
        ArrayList<ListagemCte> toRet = new ArrayList<ListagemCte>();
        if (exibirCtes == 1) {
            List ret = this.pesquisarCte(l.getIdPagtoTranspAgregado());
            this.preencherObjetoCte(toRet, ret, exibirSomentePlacaPrincipal, l.getIdPagtoTranspAgregado(), filtrosComponenteFretes, listComponenteFretes);
        } else {
            List ret = this.pesquisarValorTotalCte(l.getIdPagtoTranspAgregado());
            this.preencherObjectoValorTotalCte(toRet, ret, l.getIdPagtoTranspAgregado(), filtrosComponenteFretes, listComponenteFretes);
        }
        l.setListagemCte(toRet);
        l.setVrTotalBruto(this.vrTotalBruto);
        l.setVrTotalDesconto(this.vrTotalDesconto);
        l.setVrTotalLiquido(this.vrTotalLiquido);
        l.setVrTotalCompFrete(this.vrTotalCompFrete);
    }

    private void preencherObjetoCte(List<ListagemCte> toRet, List ret, Short exibirSomentePlacaPrincipal, Long idPagtoTranspAgregado, Short filtrosComponenteFretes, List<ComponenteFrete> listComponenteFretes) {
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            ListagemCte l = new ListagemCte();
            l.setNumeroCte((Long)h.get("numeroCte"));
            l.setDataEmissao((Date)h.get("dataEmissao"));
            l.setFatura((Long)h.get("fatura"));
            l.setTipoOperacao((String)h.get("tipoOperacao"));
            l.setProdPredominante((String)h.get("prodPredominante"));
            l.setQtdMerc((Double)h.get("qtdMerc"));
            l.setVrMerc((Double)h.get("vrMerc"));
            l.setDistancia((Double)h.get("distancia"));
            l.setChaveCte((String)h.get("chaveCte"));
            l.setNomeRemet((String)h.get("nomeRemet"));
            l.setEnderecoRemet((String)h.get("enderecoRemet"));
            l.setNumeroRemet((String)h.get("numeroRemet"));
            l.setBairroRemet((String)h.get("bairroRemet"));
            l.setCidadeRemet((String)h.get("cidadeRemet"));
            l.setUfRemet((String)h.get("ufRemet"));
            l.setCepRemet((String)h.get("cepRemet"));
            l.setCnpjRemet((String)h.get("cnpjRemet"));
            l.setInscrEstRemet((String)h.get("inscrEstRemet"));
            l.setNomeDest((String)h.get("nomeDest"));
            l.setEnderecoDest((String)h.get("enderecoDest"));
            l.setNumeroDest((String)h.get("numeroDest"));
            l.setBairroDest((String)h.get("bairroDest"));
            l.setCidadeDest((String)h.get("cidadeDest"));
            l.setUfDest((String)h.get("ufDest"));
            l.setCepDest((String)h.get("cepDest"));
            l.setCnpjDest((String)h.get("cnpjDest"));
            l.setInscrEstDest((String)h.get("inscrEstDest"));
            l.setPesoTotalNfes((Double)h.get("pesoTotalNfes"));
            l.setDataPrevViagem((Date)h.get("dataPrevViagem"));
            l.setListagemCtePlaca(this.pesquisarPlacasCte(h, exibirSomentePlacaPrincipal));
            l.setListagemCteNfe(this.pesquisarNotasCTe(l.getNumeroCte(), idPagtoTranspAgregado));
            this.valoresCte(l, (Long)h.get("idCompFrete"), (Double)h.get("vrPercFrete"), (Long)h.get("idCompFrete1"), (Double)h.get("vrPercFrete1"), idPagtoTranspAgregado, filtrosComponenteFretes, listComponenteFretes);
            toRet.add(l);
        }
    }

    private List<ListagemCtePlaca> pesquisarPlacasCte(HashMap h, Short exibirSomentePlacaPrincipal) {
        ArrayList<ListagemCtePlaca> toRet;
        block5: {
            block6: {
                toRet = new ArrayList<ListagemCtePlaca>();
                if (h.get("placa") != null && ((String)h.get("placa")).trim().length() > 0) {
                    toRet.add(this.peencherObjetoPlacaCte((String)h.get("placa")));
                } else if (h.get("placa1") != null && ((String)h.get("placa1")).trim().length() > 0) {
                    toRet.add(this.peencherObjetoPlacaCte((String)h.get("placa1")));
                }
                if (exibirSomentePlacaPrincipal != 0) break block5;
                if (h.get("idConjTransp") == null || (Long)h.get("idConjTransp") <= 0L) break block6;
                List ret = this.pesquisarPlacas((Long)h.get("idConjTransp"));
                for (Object o : ret) {
                    HashMap m = (HashMap)o;
                    toRet.add(this.peencherObjetoPlacaCte((String)m.get("placa")));
                }
                break block5;
            }
            if (h.get("idConjTransp1") == null || (Long)h.get("idConjTransp1") <= 0L) break block5;
            List ret = this.pesquisarPlacas((Long)h.get("idConjTransp1"));
            for (Object o : ret) {
                HashMap m = (HashMap)o;
                toRet.add(this.peencherObjetoPlacaCte((String)m.get("placa")));
            }
        }
        return toRet;
    }

    private ListagemCtePlaca peencherObjetoPlacaCte(String placa) {
        ListagemCtePlaca l = new ListagemCtePlaca();
        l.setPlaca(placa);
        return l;
    }

    private void valoresCte(ListagemCte l, Long idCompFrete, Double vrPercFrete, Long idCompFrete1, Double vrPercFrete1, Long idPagtoTranspAgregado, Short filtrosComponenteFretes, List<ComponenteFrete> listComponenteFretes) {
        Double vrBruto = 0.0;
        Double vrDesconto = 0.0;
        Double vrLiquido = 0.0;
        Double vrCompFrete = 0.0;
        ArrayList<ListagemComponenteFrete> toRet = new ArrayList<ListagemComponenteFrete>();
        List compFrete = this.pesquisarCompFrete(l.getNumeroCte(), idPagtoTranspAgregado);
        for (Object o : compFrete) {
            HashMap m = (HashMap)o;
            if (!this.validarComponenteFreteCompoemCalculo(filtrosComponenteFretes, listComponenteFretes, m)) continue;
            Double vrComp = (Double)m.get("vrComp");
            if (idCompFrete != null && idCompFrete > 0L) {
                if ((Long)m.get("idCompFrete") == idCompFrete) {
                    vrBruto = vrBruto + vrComp;
                    vrDesconto = vrDesconto + vrComp * (vrPercFrete / 100.0);
                    vrLiquido = vrLiquido + (vrComp - vrDesconto);
                    continue;
                }
                vrCompFrete = vrCompFrete + vrComp;
                toRet.add(this.peencherObjetoCompFrete((String)m.get("compFrete"), vrComp));
                continue;
            }
            if (idCompFrete1 == null || idCompFrete1 <= 0L) continue;
            if ((Long)m.get("idCompFrete") == idCompFrete1) {
                vrBruto = vrBruto + vrComp;
                vrDesconto = vrDesconto + vrComp * (vrPercFrete1 / 100.0);
                vrLiquido = vrLiquido + (vrComp - vrDesconto);
                continue;
            }
            vrCompFrete = vrCompFrete + vrComp;
            toRet.add(this.peencherObjetoCompFrete((String)m.get("compFrete"), vrComp));
        }
        l.setVrBruto(vrBruto);
        l.setVrDesconto(vrDesconto);
        l.setVrLiquido(vrLiquido);
        l.setVrCompFrete(vrCompFrete);
        this.vrTotalBruto = this.vrTotalBruto + l.getVrBruto();
        this.vrTotalDesconto = this.vrTotalDesconto + l.getVrDesconto();
        this.vrTotalLiquido = this.vrTotalLiquido + l.getVrLiquido();
        this.vrTotalCompFrete = this.vrTotalCompFrete + l.getVrCompFrete();
        l.setListagemComponenteFrete(toRet);
    }

    private ListagemComponenteFrete peencherObjetoCompFrete(String compFrete, Double vrComp) {
        ListagemComponenteFrete l = new ListagemComponenteFrete();
        l.setNomeCompFrete(compFrete);
        l.setVrCompFrete(vrComp);
        return l;
    }

    private void preencherObjectoValorTotalCte(List<ListagemCte> toRet, List ret, Long idPagtoTranspAgregado, Short filtrosComponenteFretes, List<ComponenteFrete> listComponenteFretes) {
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            ListagemCte l = new ListagemCte();
            l.setNumeroCte((Long)h.get("numeroCte"));
            l.setChaveCte((String)h.get("chaveCte"));
            this.valoresCte(l, (Long)h.get("idCompFrete"), (Double)h.get("vrPercFrete"), (Long)h.get("idCompFrete1"), (Double)h.get("vrPercFrete1"), idPagtoTranspAgregado, filtrosComponenteFretes, listComponenteFretes);
            toRet.add(l);
        }
    }

    private void pesquisarPreRps(ListagemPagtoTranspAgregado l, Short exibirPreRps, Short exibirSomentePlacaPrincipal) {
        this.vrTotalPreRps = 0.0;
        ArrayList<ListagemPreRps> toRet = new ArrayList<ListagemPreRps>();
        if (exibirPreRps == 1) {
            List ret = this.pesquisarPreRps(l.getIdPagtoTranspAgregado());
            this.preencherObjetoPreRps(toRet, ret, exibirSomentePlacaPrincipal);
        } else {
            List ret = this.pesquisarValorTotalPreRps(l.getIdPagtoTranspAgregado());
            this.preencherObjectoValorTotalPreRps(toRet, ret);
        }
        l.setListagemPreRps(toRet);
        l.setVrTotalBruto(this.vrTotalBruto);
        l.setVrTotalDesconto(this.vrTotalDesconto);
        l.setVrTotalLiquido(this.vrTotalLiquido);
    }

    private void preencherObjetoPreRps(List<ListagemPreRps> toRet, List ret, Short exibirSomentePlacaPrincipal) {
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            ListagemPreRps l = new ListagemPreRps();
            l.setNumeroRps((Long)h.get("numeroRps"));
            l.setDataEmissao((Date)h.get("dataEmissao"));
            l.setNumeroNFse((Long)h.get("numeroNFse"));
            l.setTipoOperacao((String)h.get("tipoOperacao"));
            l.setQtdMerc((Double)h.get("qtdMerc"));
            l.setNumeroNota((Integer)h.get("numeroNota"));
            l.setDataEmissaoNota((Date)h.get("dataEmissaoNota"));
            l.setVrNota((Double)h.get("vrNota"));
            l.setChaveNota((String)h.get("chaveNota"));
            l.setNomeTomRem((String)h.get("nomeTomRem"));
            l.setEnderecoTomRem((String)h.get("enderecoTomRem"));
            l.setNumeroTomRem((String)h.get("numeroTomRem"));
            l.setBairroTomRem((String)h.get("bairroTomRem"));
            l.setCidadeTomRem((String)h.get("cidadeTomRem"));
            l.setUfTomRem((String)h.get("ufTomRem"));
            l.setCepTomRem((String)h.get("cepTomRem"));
            l.setCnpjTomRem((String)h.get("cnpjTomRem"));
            l.setInscrEstTomRem((String)h.get("inscrEstTomRem"));
            l.setNomeDest((String)h.get("nomeDest"));
            l.setEnderecoDest((String)h.get("enderecoDest"));
            l.setNumeroDest((String)h.get("numeroDest"));
            l.setBairroDest((String)h.get("bairroDest"));
            l.setCidadeDest((String)h.get("cidadeDest"));
            l.setUfDest((String)h.get("ufDest"));
            l.setCepDest((String)h.get("cepDest"));
            l.setCnpjDest((String)h.get("cnpjDest"));
            l.setInscrEstDest((String)h.get("inscrEstDest"));
            l.setListagemPreRpsPlaca(this.pesquisarPlacasPreRps(h, exibirSomentePlacaPrincipal));
            l.setVrBruto((Double)h.get("vrBruto"));
            this.vrTotalPreRps = this.vrTotalPreRps + l.getVrBruto();
            l.setIndice(l.getVrBruto() / l.getQtdMerc());
            this.valoresPreRps(l, (Double)h.get("vrPercFrete"));
            toRet.add(l);
        }
    }

    private List<ListagemPreRpsPlaca> pesquisarPlacasPreRps(HashMap h, Short exibirSomentePlacaPrincipal) {
        ArrayList<ListagemPreRpsPlaca> toRet = new ArrayList<ListagemPreRpsPlaca>();
        toRet.add(this.peencherObjetoPlacaPreRps((String)h.get("placa")));
        if (exibirSomentePlacaPrincipal == 0) {
            List ret = this.pesquisarPlacas((Long)h.get("idConjTransp"));
            for (Object o : ret) {
                HashMap m = (HashMap)o;
                toRet.add(this.peencherObjetoPlacaPreRps((String)m.get("placa")));
            }
        }
        return toRet;
    }

    private ListagemPreRpsPlaca peencherObjetoPlacaPreRps(String placa) {
        ListagemPreRpsPlaca l = new ListagemPreRpsPlaca();
        l.setPlaca(placa);
        return l;
    }

    private void valoresPreRps(ListagemPreRps l, Double vrPercFrete) {
        l.setVrDesconto(l.getVrBruto() * (vrPercFrete / 100.0));
        l.setVrLiquido(l.getVrBruto() - l.getVrDesconto());
        this.vrTotalBruto = this.vrTotalBruto + l.getVrBruto();
        this.vrTotalDesconto = this.vrTotalDesconto + l.getVrDesconto();
        this.vrTotalLiquido = this.vrTotalLiquido + l.getVrLiquido();
    }

    private void preencherObjectoValorTotalPreRps(List<ListagemPreRps> toRet, List ret) {
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            ListagemPreRps l = new ListagemPreRps();
            l.setNumeroRps((Long)h.get("numeroRps"));
            l.setVrBruto((Double)h.get("vrBruto"));
            this.vrTotalPreRps = this.vrTotalPreRps + l.getVrBruto();
            this.valoresPreRps(l, (Double)h.get("vrPercFrete"));
            toRet.add(l);
        }
    }

    private void pesquisarAdiantamentos(ListagemPagtoTranspAgregado l, Short exibirAdiantamentos) {
        this.vrTotalAdiantamento = 0.0;
        ArrayList<ListagemAdiantamento> toRet = new ArrayList<ListagemAdiantamento>();
        if (exibirAdiantamentos == 1) {
            List ret = this.pesquisarAdiantamento(l.getIdPagtoTranspAgregado());
            this.preencherObjetoAdiantamento(toRet, ret);
        } else {
            this.vrTotalAdiantamento = this.pesquisarValorTotalAdiantamento(l.getIdPagtoTranspAgregado());
        }
        l.setListagemAdiantamento(toRet);
        l.setVrTotalAdiantamento(this.vrTotalAdiantamento);
    }

    private void preencherObjetoAdiantamento(List<ListagemAdiantamento> toRet, List ret) {
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            ListagemAdiantamento l = new ListagemAdiantamento();
            l.setIdAdiantamento((Long)h.get("idAdiantamento"));
            l.setData((Date)h.get("data"));
            l.setTotalParcela((Short)h.get("totalParcela"));
            l.setValor((Double)h.get("valor"));
            l.setParcela((Short)h.get("parcela"));
            l.setDataVencimento((Date)h.get("dataVencimento"));
            l.setVrParcela((Double)h.get("vrParcela"));
            l.setObservacao((String)h.get("observacao"));
            this.vrTotalAdiantamento = this.vrTotalAdiantamento + l.getVrParcela();
            toRet.add(l);
        }
    }

    private void pesquisarOutrosEventos(ListagemPagtoTranspAgregado l, Short exibirOutrosEventos) {
        this.vrTotalOutrosEventos = 0.0;
        ArrayList<ListagemOutrosEventos> toRet = new ArrayList<ListagemOutrosEventos>();
        if (exibirOutrosEventos == 1) {
            List ret = this.pesquisarOutrosEventos(l.getIdPagtoTranspAgregado());
            this.preencherObjetoOutrosEventos(toRet, ret);
        } else {
            List ret = this.pesquisarValorTotalOutrosEventos(l.getIdPagtoTranspAgregado());
            this.preencherObjetoValorTotalOutrosEventos(ret);
        }
        l.setListagemOutrosEventos(toRet);
        l.setVrTotalOutrosEventos(this.vrTotalOutrosEventos);
    }

    private void preencherObjetoOutrosEventos(List<ListagemOutrosEventos> toRet, List ret) {
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            ListagemOutrosEventos l = new ListagemOutrosEventos();
            l.setEvento((String)h.get("evento"));
            l.setTipoEvento((Short)h.get("tipoEvento"));
            l.setReferencia((Double)h.get("referencia"));
            l.setObservacao((String)h.get("observacao"));
            if (l.getTipoEvento() == 0) {
                l.setValorProvento((Double)h.get("valor"));
            } else {
                l.setValorDesconto((Double)h.get("valor"));
            }
            this.vrTotalOutrosEventos = this.vrTotalOutrosEventos + (l.getValorProvento() - l.getValorDesconto());
            toRet.add(l);
        }
    }

    private void preencherObjetoValorTotalOutrosEventos(List ret) {
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            Double valorProvento = 0.0;
            Double valorDesconto = 0.0;
            if ((Short)h.get("tipoEvento") == 0) {
                valorProvento = (Double)h.get("valor");
            } else {
                valorDesconto = (Double)h.get("valor");
            }
            this.vrTotalOutrosEventos = this.vrTotalOutrosEventos + (valorProvento - valorDesconto);
        }
    }

    private void verificarValorTotalCteRps(ListagemPagtoTranspAgregado l) {
        l.setVrTotalDesconto(l.getVrTotalDesconto() + this.vrTotalEventos);
        l.setVrTotalLiquido(l.getVrTotalLiquido() - this.vrTotalEventos);
    }

    private void calcularValorFinalCte(ListagemPagtoTranspAgregado l) {
        this.vrTotalLiquidoFinal = 0.0;
        if (!l.getListagemCte().isEmpty()) {
            for (ListagemCte i : l.getListagemCte()) {
                if (l.getVrTotalConsumo() == 0.0 && i.getVrLiquido() == 0.0 && l.getVrTotalLiquido() == 0.0) {
                    i.setVrConsumo(0.0);
                } else {
                    i.setVrConsumo(l.getVrTotalConsumo() * i.getVrLiquido() / l.getVrTotalLiquido());
                }
                i.setVrEmitirCte(i.getVrLiquido() - i.getVrConsumo() + i.getVrCompFrete());
                this.vrTotalLiquidoFinal = this.vrTotalLiquidoFinal + i.getVrEmitirCte();
            }
        }
        l.setVrTotalLiquidoFinal(this.vrTotalLiquidoFinal);
    }

    private void calcularValorFinalPreRps(ListagemPagtoTranspAgregado l) {
        for (ListagemPreRps i : l.getListagemPreRps()) {
            Double vrEvento = i.getVrBruto() * this.vrTotalEventos / this.vrTotalPreRps;
            i.setVrDesconto(i.getVrDesconto() + vrEvento);
            i.setVrLiquido(i.getVrLiquido() - vrEvento);
            i.setVrConsumo(l.getVrTotalConsumo() * i.getVrLiquido() / l.getVrTotalLiquido());
            i.setVrEmitirPreRps(i.getVrLiquido() - i.getVrConsumo());
            this.vrTotalLiquidoFinal = this.vrTotalLiquidoFinal + i.getVrEmitirPreRps();
        }
        l.setVrTotalLiquidoFinal(this.vrTotalLiquidoFinal);
    }

    private void calcularValorFinalCtePreRps(ListagemPagtoTranspAgregado l) {
        if (l.getListagemCte().isEmpty() && l.getListagemPreRps().isEmpty()) {
            l.setVrTotalLiquidoFinal(this.vrTotalLiquidoFinal - l.getVrTotalConsumo());
        }
    }

    List gerarXmlCteValorLiquido(ListagemTranspAgregado listagemTranspAgregado) {
        ArrayList<Object> lista = new ArrayList<Object>();
        for (ListagemPagtoTranspAgregado p : listagemTranspAgregado.getListagemPagtoTranspAgregado()) {
            for (ListagemCte c : p.getListagemCte()) {
                lista.add(this.criarXmlCte(c));
            }
        }
        return lista;
    }

    private Object criarXmlCte(ListagemCte c) {
        Element cte = new Element("Cte");
        cte.addContent((Content)new Element("Numero").setText(c.getNumeroCte().toString()));
        cte.addContent((Content)new Element("Chave").setText(c.getChaveCte()));
        cte.addContent((Content)new Element("Valor_Emitir").setText(this.formatarNumeros(c.getVrEmitirCte(), 2)));
        cte.addContent((Content)new Element("Valor_Liquido").setText(this.formatarNumeros(c.getVrLiquido() - c.getVrConsumo(), 2)));
        cte.addContent((Collection)this.criarXmlComponente(c));
        return cte;
    }

    private List criarXmlComponente(ListagemCte c) {
        ArrayList<Element> listComponente = new ArrayList<Element>();
        for (ListagemComponenteFrete f : c.getListagemComponenteFrete()) {
            Element componente = new Element("Componente");
            componente.addContent((Content)new Element("Nome").setText(f.getNomeCompFrete()));
            componente.addContent((Content)new Element("Valor").setText(this.formatarNumeros(f.getVrCompFrete(), 2)));
            listComponente.add(componente);
        }
        return listComponente;
    }

    private String formatarNumeros(Double num, int decimalSize) {
        if (num == null) {
            num = 0.0;
        }
        DecimalFormat form = new DecimalFormat();
        form = (DecimalFormat)DecimalFormat.getInstance(Locale.ENGLISH);
        form.setMaximumIntegerDigits(15);
        form.applyPattern("###0.00");
        form.setMaximumFractionDigits(decimalSize);
        form.setMinimumFractionDigits(decimalSize);
        String aux = form.format(num);
        return aux;
    }

    private List<ListagemTranspAgregado> pesquisarListTranspAgregado(Short filtrarDataPagamento, Date dataPagamentoInicial, Date dataPagamentoFinal, Short filtrarTranspAgregado, Long transpAgregadoInicial, Long transpAgregadoFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT p.transportadorAgregado.identificador                       AS idTranspAgregado, p.transportadorAgregado.pessoa.nome                         AS nomeTranspAgregado, p.transportadorAgregado.pessoa.complemento.cnpj             AS cnpj, p.transportadorAgregado.pessoa.complemento.inscEst          AS inscEst, p.transportadorAgregado.formaPagamento.descricao            AS formaPagamento, p.transportadorAgregado.pessoa.endereco.logradouro          AS endereco, p.transportadorAgregado.pessoa.endereco.bairro              AS bairro, p.transportadorAgregado.pessoa.endereco.numero              AS numero, p.transportadorAgregado.pessoa.endereco.cidade.descricao    AS cidade, p.transportadorAgregado.pessoa.endereco.cidade.uf.descricao AS uf, p.transportadorAgregado.pessoa.endereco.cep                 AS cep, p.transportadorAgregado.pessoa.observacao                 AS observacao, p.transportadorAgregado.rntrc                               AS rntrc FROM PagtoTranspAgregado p WHERE (:filtrarDataPagamento <> 1 OR p.grupoPagtoTranspAgregado.dataPagto BETWEEN :dataPagamentoInicial AND :dataPagamentoFinal) AND (:filtrarTranspAgregado <> 1 OR p.transportadorAgregado.identificador BETWEEN :transpAgregadoInicial AND :transpAgregadoFinal) ORDER BY p.transportadorAgregado.pessoa.nome");
        q.setShort("filtrarDataPagamento", filtrarDataPagamento.shortValue());
        q.setDate("dataPagamentoInicial", dataPagamentoInicial);
        q.setDate("dataPagamentoFinal", dataPagamentoFinal);
        q.setShort("filtrarTranspAgregado", filtrarTranspAgregado.shortValue());
        q.setLong("transpAgregadoInicial", transpAgregadoInicial.longValue());
        q.setLong("transpAgregadoFinal", transpAgregadoFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<ListagemTranspAgregado> toRet = new ArrayList<ListagemTranspAgregado>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            ListagemTranspAgregado l = new ListagemTranspAgregado();
            l.setIdTranspAgregado((Long)h.get("idTranspAgregado"));
            l.setNomeTranspAgregado((String)h.get("nomeTranspAgregado"));
            l.setCnpj((String)h.get("cnpj"));
            l.setInscEst((String)h.get("inscEst"));
            l.setFormaPagamento((String)h.get("formaPagamento"));
            l.setEndereco((String)h.get("endereco"));
            l.setBairro((String)h.get("bairro"));
            l.setNumero((String)h.get("numero"));
            l.setCidade((String)h.get("cidade"));
            l.setUf((String)h.get("uf"));
            l.setCep((String)h.get("cep"));
            l.setRntrc((String)h.get("rntrc"));
            l.setObservacao((String)h.get("observacao"));
            toRet.add(l);
        }
        return toRet;
    }

    private List<ListagemPagtoTranspAgregado> pesquisarPagtoTranspAgregado(Long idTranspAgregado, Short filtrarDataPagamento, Date dataPagamentoInicial, Date dataPagamentoFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT p.identificador                         AS idPagtoTranspAgregado, p.grupoPagtoTranspAgregado.dataInicial  AS dataInicial, p.grupoPagtoTranspAgregado.dataFinal    AS dataFinal, p.grupoPagtoTranspAgregado.dataPagto    AS dataPagamento FROM PagtoTranspAgregado p WHERE (:filtrarDataPagamento <> 1 OR p.grupoPagtoTranspAgregado.dataPagto BETWEEN :dataPagamentoInicial AND :dataPagamentoFinal) AND p.transportadorAgregado.identificador = :idTranspAgregado ORDER BY p.identificador");
        q.setShort("filtrarDataPagamento", filtrarDataPagamento.shortValue());
        q.setDate("dataPagamentoInicial", dataPagamentoInicial);
        q.setDate("dataPagamentoFinal", dataPagamentoFinal);
        q.setLong("idTranspAgregado", idTranspAgregado.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        ArrayList<ListagemPagtoTranspAgregado> toRet = new ArrayList<ListagemPagtoTranspAgregado>();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            ListagemPagtoTranspAgregado l = new ListagemPagtoTranspAgregado();
            l.setIdPagtoTranspAgregado((Long)h.get("idPagtoTranspAgregado"));
            l.setDataInicial((Date)h.get("dataInicial"));
            l.setDataFinal((Date)h.get("dataFinal"));
            l.setDataPagamento((Date)h.get("dataPagamento"));
            toRet.add(l);
        }
        return toRet;
    }

    private List pesquisarConsumo(Long idPagtoTranspAgregado) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT i.identificador                     AS idItemConsumo, c.identificador                     AS idConsumo, n.descricao                         AS nomeConsumo, v.placa                             AS placa, c.hodometro                         AS hodometro, i.produto.identificador             AS idProduto, i.produto.nome                      AS nomeProduto, s.nome                              AS fornecedor, c.dataConsumo                       AS data, i.valorUnitario                     AS vrUnitario, SUM(g.quantidade)                   AS qtdTotal, i.valorDesconto                     AS vrDesconto, i.valorTotal                        AS vrTotal FROM ItemConsumoPagtoTranspAgregado p INNER JOIN p.itemConsumoAtivo i LEFT JOIN  i.naturezaRequisicao n INNER JOIN i.consumoAtivo c INNER JOIN c.equipamento e LEFT JOIN  e.veiculo v LEFT JOIN  i.unidadeFatFornecedor u LEFT JOIN  u.fornecedor f LEFT JOIN  f.pessoa s INNER JOIN i.gradeItemConsumoAtivo g WHERE p.pagtoTranspAgregado.identificador = :idPagtoTranspAgregado GROUP BY i.identificador, c.identificador, n.descricao, v.placa, c.hodometro, i.produto.identificador, i.produto.nome, s.nome, c.dataConsumo, i.valorUnitario, i.valorDesconto, i.valorTotal ORDER BY n.descricao, v.placa");
        q.setLong("idPagtoTranspAgregado", idPagtoTranspAgregado.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private Double pesquisarValorTotalConsumo(Long idPagtoTranspAgregado) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT SUM(i.valorTotal) FROM ItemConsumoPagtoTranspAgregado p INNER JOIN  p.itemConsumoAtivo i WHERE p.pagtoTranspAgregado.identificador = :idPagtoTranspAgregado");
        q.setLong("idPagtoTranspAgregado", idPagtoTranspAgregado.longValue());
        if (q.uniqueResult() == null) {
            return 0.0;
        }
        return (Double)q.uniqueResult();
    }

    private Double pesquisarEventos(Long idPagtoTranspAgregado, List<EventoTranspAgregado> listEventos) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "SELECT DISTINCT SUM(p.valor) AS valor FROM ItemPagtoTranspAgregado p WHERE p.pagtoTranspAgregado.identificador = :idPagtoTranspAgregado AND p.eventoTranspAgregado.identificador IN (";
        boolean i = true;
        for (EventoTranspAgregado e : listEventos) {
            if (i) {
                query = (String)query + e.getIdentificador().toString();
                continue;
            }
            query = ", " + e.getIdentificador().toString();
        }
        query = (String)query + ")";
        Query q = s.createQuery((String)query);
        q.setLong("idPagtoTranspAgregado", idPagtoTranspAgregado.longValue());
        if (q.uniqueResult() == null) {
            return 0.0;
        }
        return (Double)q.uniqueResult();
    }

    private List pesquisarCte(Long idPagtoTranspAgregado) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT c.numero                                                                            AS numeroCte, c.dataEmissao                                                                       AS dataEmissao, f.identificador                                                                     AS fatura, c.tipoOperacaoFrete.descricao                                                       AS tipoOperacao, r.descricao                                                                         AS prodPredominante, i.qtdTotalMercadorias                                                               AS qtdMerc, i.valorTotalMercadorias                                                             AS vrMerc, c.remetenteDestinatario.distanciaKm                                                 AS distancia, c.chaveCte                                                                          AS chaveCte, c.dataPrevViagem                                                                    AS dataPrevViagem, c.pesoTotalNfes                                                                     AS pesoTotalNfes, c.remetenteDestinatario.pessoaRemetente.descricao                                   AS nomeRemet, c.remetenteDestinatario.pessoaRemetente.endereco.logradouro                         AS enderecoRemet, c.remetenteDestinatario.pessoaRemetente.endereco.numero                             AS numeroRemet, c.remetenteDestinatario.pessoaRemetente.endereco.bairro                             AS bairroRemet, c.remetenteDestinatario.pessoaRemetente.endereco.cidade.descricao                   AS cidadeRemet, c.remetenteDestinatario.pessoaRemetente.endereco.cidade.uf.sigla                    AS ufRemet, c.remetenteDestinatario.pessoaRemetente.endereco.cep                                AS cepRemet, c.remetenteDestinatario.pessoaRemetente.pessoaTransporte.pessoa.complemento.cnpj    AS cnpjRemet, c.remetenteDestinatario.pessoaRemetente.inscricaoEstadual                           AS inscrEstRemet, c.remetenteDestinatario.pessoaDestinatario.descricao                                AS nomeDest, c.remetenteDestinatario.pessoaDestinatario.endereco.logradouro                      AS enderecoDest, c.remetenteDestinatario.pessoaDestinatario.endereco.numero                          AS numeroDest, c.remetenteDestinatario.pessoaDestinatario.endereco.bairro                          AS bairroDest, c.remetenteDestinatario.pessoaDestinatario.endereco.cidade.descricao                AS cidadeDest, c.remetenteDestinatario.pessoaDestinatario.endereco.cidade.uf.sigla                 AS ufDest, c.remetenteDestinatario.pessoaDestinatario.endereco.cep                             AS cepDest, c.remetenteDestinatario.pessoaDestinatario.pessoaTransporte.pessoa.complemento.cnpj AS cnpjDest, c.remetenteDestinatario.pessoaDestinatario.inscricaoEstadual                        AS inscrEstDest, t.componenteFrete.identificador                                                     AS idCompFrete, t.vrPercentualFrete                                                                 AS vrPercFrete, v.placa                                                                             AS placa, t.identificador                                                                     AS idConjTransp, t1.componenteFrete.identificador                                                    AS idCompFrete1, t1.vrPercentualFrete                                                                AS vrPercFrete1, v1.placa                                                                            AS placa1, t1.identificador                                                                    AS idConjTransp1 FROM CteNfPagtoTranspAgregado p INNER JOIN  p.cte c INNER JOIN  c.cteInfCarga i LEFT JOIN   i.produtoPredominante r LEFT JOIN   c.conjuntoTransportador t LEFT JOIN   t.conjuntoTranspVeiculo j LEFT JOIN   j.veiculo v LEFT JOIN \tc.faturaCte f LEFT JOIN \tc.cteComplementar m LEFT JOIN \tm.conjuntoTransportador t1 LEFT JOIN   t1.conjuntoTranspVeiculo j1 LEFT JOIN   j1.veiculo v1 WHERE p.pagtoTranspAgregado.identificador = :idPagtoTranspAgregado AND (j.placaPrincipal = :principal OR j1.placaPrincipal = :principal) ORDER BY v.placa, v1.placa, c.numero");
        q.setLong("idPagtoTranspAgregado", idPagtoTranspAgregado.longValue());
        q.setShort("principal", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List pesquisarPlacas(Long idConjTransp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT v.placa AS placa FROM ConjuntoTransportador  c LEFT JOIN   c.conjuntoTranspVeiculo j LEFT JOIN   j.veiculo v WHERE c.identificador = :idConjTransp AND j.placaPrincipal = :principal");
        q.setLong("idConjTransp", idConjTransp.longValue());
        q.setShort("principal", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List<ListagemCteNfe> pesquisarNotasCTe(Long numeroCte, Long idPagtoTranspAgregado) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT p.nrNota        AS nrNota, p.dataEmissao   AS dataEmissaoNota, p.chaveNFe      AS chaveNota FROM CTeNFe p WHERE p.cte.numero = :numeroCte AND p.cte.cteNfTranspAgregado.pagtoTranspAgregado.identificador = :idPagtoTranspAgregado");
        q.setLong("idPagtoTranspAgregado", idPagtoTranspAgregado.longValue());
        q.setLong("numeroCte", numeroCte.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        ArrayList<ListagemCteNfe> toRet = new ArrayList<ListagemCteNfe>();
        List ret = q.list();
        for (Object o : ret) {
            HashMap h = (HashMap)o;
            ListagemCteNfe i = new ListagemCteNfe();
            i.setNumeroNota((Integer)h.get("nrNota"));
            i.setDataEmissaoNota((Date)h.get("dataEmissaoNota"));
            i.setChaveNota((String)h.get("chaveNota"));
            toRet.add(i);
        }
        return toRet;
    }

    private List pesquisarCompFrete(Long numeroCte, Long idPagtoTranspAgregado) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT p.componenteFrete.identificador AS idCompFrete, p.componenteFrete.descricao     AS compFrete, p.valor                         AS vrComp FROM ItemCte p WHERE p.cte.numero = :numeroCte AND p.cte.cteNfTranspAgregado.pagtoTranspAgregado.identificador = :idPagtoTranspAgregado");
        q.setLong("idPagtoTranspAgregado", idPagtoTranspAgregado.longValue());
        q.setLong("numeroCte", numeroCte.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List pesquisarValorTotalCte(Long idPagtoTranspAgregado) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT c.numero                            AS numeroCte, c.chaveCte                          AS chaveCte, t.componenteFrete.identificador     AS idCompFrete, t.vrPercentualFrete                 AS vrPercFrete, t1.componenteFrete.identificador    AS idCompFrete1, t1.vrPercentualFrete                AS vrPercFrete1 FROM CteNfPagtoTranspAgregado p INNER JOIN  p.cte c LEFT JOIN   c.conjuntoTransportador t LEFT JOIN \tc.cteComplementar m LEFT JOIN \tm.conjuntoTransportador t1 WHERE p.pagtoTranspAgregado.identificador = :idPagtoTranspAgregado ORDER BY c.numero");
        q.setLong("idPagtoTranspAgregado", idPagtoTranspAgregado.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List pesquisarPreRps(Long idPagtoTranspAgregado) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT r.numero                                                            AS numeroRps, r.dataEmissao                                                       AS dataEmissao, r.numeroNFse                                                        AS numeroNFse, s.tipoOperacao.descricao                                            AS tipoOperacao, s.quantidadeTotalCarga                                              AS qtdMerc, n.nrNota                                                            AS numeroNota, n.dataEmissao                                                       AS dataEmissaoNota, n.valorDocumento                                                    AS vrNota, n.chaveNFe                                                          AS chaveNota, s.unidadeTomPrestRPS.descricao                                      AS nomeTomRem, s.unidadeTomPrestRPS.endereco.logradouro                            AS enderecoTomRem, s.unidadeTomPrestRPS.endereco.numero                                AS numeroTomRem, s.unidadeTomPrestRPS.endereco.bairro                                AS bairroTomRem, s.unidadeTomPrestRPS.endereco.cidade.descricao                      AS cidadeTomRem, s.unidadeTomPrestRPS.endereco.cidade.uf.sigla                       AS ufTomRem, s.unidadeTomPrestRPS.endereco.cep                                   AS cepTomRem, s.unidadeTomPrestRPS.tomadorPrestadorRPS.pessoa.complemento.cnpj    AS cnpjTomRem, s.unidadeTomPrestRPS.inscricaoEstadual                              AS inscrEstTomRem, d.nome                                                              AS nomeDest, d.endereco.logradouro                                               AS enderecoDest, d.endereco.numero                                                   AS numeroDest, d.endereco.bairro                                                   AS bairroDest, d.endereco.cidade.descricao                                         AS cidadeDest, d.endereco.cidade.uf.sigla                                          AS ufDest, d.endereco.cep                                                      AS cepDest, d.complemento.cnpj                                                  AS cnpjDest, d.complemento.inscEst                                               AS inscrEstDest, c.identificador                                                     AS idConjTransp, c.vrPercentualFrete                                                 AS vrPercFrete, v.placa                                                             AS placa, s.valorFrete                                                        AS vrBruto, s.identificador                                                     AS ID_PRE_RPS FROM PreRpsPagtoTranspAgregado p INNER JOIN  p.preRps s LEFT JOIN   s.conjuntoTransportador c LEFT JOIN   c.conjuntoTranspVeiculo t LEFT JOIN   t.veiculo v LEFT JOIN   s.preRpsTransporteNfe as n LEFT JOIN   s.rps r LEFT JOIN   s.destinatario d WHERE p.pagtoTranspAgregado.identificador = :idPagtoTranspAgregado AND t.placaPrincipal = :principal ORDER BY v.placa, r.numero");
        q.setLong("idPagtoTranspAgregado", idPagtoTranspAgregado.longValue());
        q.setShort("principal", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List pesquisarValorTotalPreRps(Long idPagtoTranspAgregado) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT r.numero            AS numeroRps, n.nrNota            AS numeroNota, c.vrPercentualFrete AS vrPercFrete, s.valorFrete        AS vrBruto FROM PreRpsPagtoTranspAgregado p INNER JOIN  p.preRps s LEFT JOIN   s.conjuntoTransportador c LEFT JOIN   s.preRpsTransporteNfe as n LEFT JOIN   s.rps r WHERE p.pagtoTranspAgregado.identificador = :idPagtoTranspAgregado ORDER BY r.numero");
        q.setLong("idPagtoTranspAgregado", idPagtoTranspAgregado.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List pesquisarAdiantamento(Long idPagtoTranspAgregado) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT i.adiantamentoTranspAgregado.identificador  AS idAdiantamento, i.adiantamentoTranspAgregado.data           AS data, i.adiantamentoTranspAgregado.numParcelas    AS totalParcela, i.adiantamentoTranspAgregado.valor          AS valor, i.titulo.numParcTituloEstnota               AS parcela, i.titulo.dataVencimento                     AS dataVencimento, i.titulo.valor                              AS vrParcela, i.adiantamentoTranspAgregado.observacao     AS observacao FROM ItemAdPagtoTranspAgregado p INNER JOIN  p.itemAdTranspAgregado i WHERE p.pagtoTranspAgregado.identificador = :idPagtoTranspAgregado ORDER BY i.adiantamentoTranspAgregado.identificador");
        q.setLong("idPagtoTranspAgregado", idPagtoTranspAgregado.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private Double pesquisarValorTotalAdiantamento(Long idPagtoTranspAgregado) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT SUM(i.titulo.valor) FROM ItemAdPagtoTranspAgregado p INNER JOIN  p.itemAdTranspAgregado i WHERE p.pagtoTranspAgregado.identificador = :idPagtoTranspAgregado");
        q.setLong("idPagtoTranspAgregado", idPagtoTranspAgregado.longValue());
        if (q.uniqueResult() == null) {
            return 0.0;
        }
        return (Double)q.uniqueResult();
    }

    private List pesquisarOutrosEventos(Long idPagtoTranspAgregado) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT p.eventoTranspAgregado.descricao    AS evento, p.eventoTranspAgregado.tipoEvento   AS tipoEvento, p.referencia                        AS referencia, p.valor                             AS valor, p.descricao                         AS observacao FROM ItemPagtoTranspAgregado p WHERE p.pagtoTranspAgregado.identificador = :idPagtoTranspAgregado AND p.valorInformado = :valorInformado ORDER BY p.eventoTranspAgregado.descricao");
        q.setLong("idPagtoTranspAgregado", idPagtoTranspAgregado.longValue());
        q.setShort("valorInformado", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List pesquisarValorTotalOutrosEventos(Long idPagtoTranspAgregado) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT p.eventoTranspAgregado.tipoEvento   AS tipoEvento, p.valor                             AS valor FROM ItemPagtoTranspAgregado p WHERE p.pagtoTranspAgregado.identificador = :idPagtoTranspAgregado AND p.valorInformado = :valorInformado");
        q.setLong("idPagtoTranspAgregado", idPagtoTranspAgregado.longValue());
        q.setShort("valorInformado", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private boolean validarComponenteFreteCompoemCalculo(Short filtrosComponenteFretes, List<ComponenteFrete> listComponenteFretes, HashMap m) {
        if (ToolMethods.isEquals((Object)filtrosComponenteFretes, (Object)1)) {
            for (ComponenteFrete c : listComponenteFretes) {
                if (!ToolMethods.isEquals((Object)c.getIdentificador(), (Object)((Long)m.get("idCompFrete")))) continue;
                return false;
            }
        }
        return true;
    }
}

