/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.pedido;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class AuxListagemPedidosCondPagamento
implements Comparator {
    public JasperPrint listagemPedidosPorCondicoesPagamento(CoreRequestContext r) throws JRException, ExceptionService {
        Double valorCond;
        Date dataInicial = (Date)r.getAttribute("DATA_INICIAL");
        Date dataFinal = (Date)r.getAttribute("DATA_FINAL");
        Empresa empresa = (Empresa)r.getAttribute("EMPRESA");
        Short selecaoDatas = (Short)r.getAttribute("TIPO_DATA");
        Nodo nodo = (Nodo)r.getAttribute("NODO");
        Short oredenacao = (Short)r.getAttribute("ORDENACAO");
        List<HashMap> data = this.getDataForReportCondicoesPagamento(dataInicial, dataFinal, selecaoDatas, empresa);
        double valorTotal = 0.0;
        for (HashMap h : data) {
            valorCond = (Double)h.get("VALOR_TOTAL");
            valorTotal += valorCond.doubleValue();
        }
        for (HashMap h : data) {
            valorCond = (Double)h.get("VALOR_TOTAL");
            h.put("PERCENTUAL", valorCond / (valorTotal > 0.0 ? valorTotal : 1.0));
        }
        if (!ToolMethods.isEquals((Object)oredenacao, (Object)0)) {
            for (HashMap h : data) {
                h.put("ORDENACAO", oredenacao);
            }
            Collections.sort(data, new AuxListagemPedidosCondPagamento());
        }
        HashMap params = new HashMap(r.toHashMap());
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", params).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        Object path = System.getProperty("user.dir");
        path = (String)path + File.separator + "reports" + File.separator + "mercado" + File.separator + "gestaovendas" + File.separator + "pedido" + File.separator + "listagens" + File.separator + "listagempedidoscondpag" + File.separator + "LISTAGEM_PEDIDOS_POR_CONDICAO_PAGAMENTO.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", params);
        relatorio.setAttribute("dados", data);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private List<HashMap> getDataForReportCondicoesPagamento(Date dataInicial, Date dataFinal, Short selecaoDatas, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = " select sum(p.valorTotal) as VALOR_TOTAL, c.nome AS CONDICAO_PAG, c.identificador as ID_CONDICAO_PAG, p.condPagMut as PARCELAS   from Pedido p inner join p.condicoesPagamento c inner join p.situacaoPedido s where p.empresa = :empresa  and s.cancelarTitulos = :nao";
        switch (selecaoDatas) {
            case 0: {
                query = (String)query + " and p.dataEmissao between :dataInicial and :dataFinal";
                break;
            }
            case 1: {
                query = (String)query + " and p.dataPrevisaoSaida between :dataInicial and :dataFinal";
                break;
            }
            case 2: {
                query = (String)query + " and p.dataPrevisaoFat between :dataInicial and :dataFinal";
                break;
            }
        }
        query = (String)query + " group by c.nome,c.identificador,p.condPagMut order by c.identificador";
        Query q = s.createQuery((String)query);
        q.setShort("nao", (short)0);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public int compare(Object o1, Object o2) {
        Double n2;
        Double n1;
        HashMap h1 = (HashMap)o1;
        HashMap h2 = (HashMap)o2;
        Short ordenacao = (Short)h1.get("ORDENACAO");
        if (ToolMethods.isEquals((Object)ordenacao, (Object)1)) {
            n1 = (Double)h1.get("PERCENTUAL");
            n2 = (Double)h2.get("PERCENTUAL");
        } else {
            n1 = (Double)h2.get("PERCENTUAL");
            n2 = (Double)h1.get("PERCENTUAL");
        }
        return n1.compareTo(n2);
    }
}

