/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.pedido;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFatResEstoquePed;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFatTipoReservaEstPedido;
import com.touchcomp.basementor.constants.enums.pedido.EnumConstGeracaoTitulosPreVendaPedido;
import com.touchcomp.basementor.constants.enums.pedido.EnumValidacaoPedido;
import com.touchcomp.basementor.model.impl.ValidacaoPedidoItem;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.InfPagamentoPedido;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.SituacaoCotacaoVendas;
import com.touchcomp.basementor.model.vo.SituacaoNecessidadeCompra;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.mail.ExceptionEmail;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.validacaoliberacaopedido.CompValidacaoLiberacaoPedido;
import com.touchcomp.basementorservice.helpers.impl.pedido.HelperPedido;
import com.touchcomp.basementorservice.service.impl.pedido.ServicePedidoImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.exceptions.ExceptionValidation;
import mentorcore.utilities.CoreUtilityFactory;

class AuxSavePedido {
    private final OpcoesFaturamento opcoesFaturamento;
    private final OpcoesFinanceiras opcoesFinanceiras;
    private final OpcoesContabeis opcoesContabeis;
    private OpcoesCompraSuprimentos opcoesCompras;
    private OpcoesRelacionamento opcoesRelacionamento;
    private Usuario usuario;
    private EnumValidacaoPedido validarPedido;
    private static TLogger logger = TLogger.get(AuxSavePedido.class);

    public AuxSavePedido(OpcoesFaturamento opcoesFaturamento, OpcoesFinanceiras opcoesFinanceiras, OpcoesCompraSuprimentos opcoescompra, Usuario usuario, OpcoesRelacionamento opcoesRelationamento, OpcoesContabeis opcoesContabeis, EnumValidacaoPedido validarPedido) {
        this.opcoesFaturamento = opcoesFaturamento;
        this.opcoesFinanceiras = opcoesFinanceiras;
        this.opcoesContabeis = opcoesContabeis;
        this.opcoesCompras = opcoescompra;
        this.opcoesRelacionamento = opcoesRelationamento;
        this.usuario = usuario;
        this.validarPedido = validarPedido;
    }

    public AuxSavePedido(OpcoesFaturamento opcoesFaturamento, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis) {
        this.opcoesFaturamento = opcoesFaturamento;
        this.opcoesFinanceiras = opcoesFinanceiras;
        this.opcoesContabeis = opcoesContabeis;
    }

    ValidacaoPedidoItem savePedido(Pedido p) throws ExceptionService {
        p.setUsuarioUltMod(this.usuario);
        ValidacaoPedidoItem val = this.newValidacaoPedidoItem();
        this.analisarPedido(p, val);
        this.throwExCasoBloqueado(val);
        ((HelperPedido)ConfApplicationContext.getBean(HelperPedido.class)).setDataPrevisaoSaida(p, this.opcoesFaturamento);
        p = this.salvarAtualizarPedidoDB(p);
        LinkedList<Email> emails = new LinkedList<Email>();
        this.criarEmails(p, emails);
        this.sendEmails(emails);
        val.setPedido(p);
        return val;
    }

    ValidacaoPedidoItem savePedido(List<Pedido> p) throws ExceptionService {
        return this.saveUpdatePedidos(p);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void analisarPedido(Pedido p, ValidacaoPedidoItem val) throws ExceptionService {
        try {
            this.atualizarSitCotVendas(p, this.opcoesFaturamento.getSituacaoCotVendasPedido());
            if (!this.validarQtdeItens(p)) {
                throw new ExceptionService("Erro ao validar a quantidade de itens!\n1-Valida\u00e7\u00e3o Situa\u00e7\u00e3o Cota\u00e7\u00e3o Vendas.");
            }
            this.verificarTitulos(p);
            if (!this.validarQtdeItens(p)) {
                throw new ExceptionService("Erro ao validar a quantidade de itens!\n2-Valida\u00e7\u00e3o T\u00edtulos.");
            }
            this.avaliarBloquearPedido(p, val);
            if (!this.validarQtdeItens(p)) {
                throw new ExceptionService("Erro ao validar a quantidade de itens!\n3-Valida\u00e7\u00e3o Bloqueio Pedidos.");
            }
            this.reservarEstoque(p);
            if (!this.validarQtdeItens(p)) {
                throw new ExceptionService("Erro ao validar a quantidade de itens!\n4-Valida\u00e7\u00e3o Reserva Estoque.");
            }
            if (this.validarTransferencias(p)) return;
        }
        catch (ExceptionBase | ExceptionGeracaoTitulos | ExceptionValidation ex) {
            logger.error(ex.getClass(), ex);
            throw new ExceptionService(ex);
        }
    }

    public ValidacaoPedidoItem saveUpdatePedidos(List<Pedido> pedidos) throws ExceptionService {
        LinkedList<Pedido> ret = new LinkedList<Pedido>();
        ValidacaoPedidoItem val = this.newValidacaoPedidoItem();
        for (Pedido pedido : pedidos) {
            this.analisarPedido(pedido, val);
        }
        this.throwExCasoBloqueado(val);
        for (Pedido pedido : pedidos) {
            ((HelperPedido)ConfApplicationContext.getBean(HelperPedido.class)).setDataPrevisaoSaida(pedido, this.opcoesFaturamento);
            pedido.setUsuarioUltMod(this.usuario);
            ret.add(this.salvarAtualizarPedidoDB(pedido));
        }
        LinkedList<Email> emails = new LinkedList<Email>();
        for (Pedido pedido : pedidos) {
            this.criarEmail(pedido, emails);
        }
        this.sendEmails(emails);
        val.setPedidos(ret);
        return val;
    }

    private void avaliarBloquearPedido(Pedido p, ValidacaoPedidoItem val) throws ExceptionBase {
        ((CompValidacaoLiberacaoPedido)Context.get(CompValidacaoLiberacaoPedido.class)).validarPedido(this.opcoesFaturamento, this.opcoesFinanceiras, p, val, this.validarPedido, this.opcoesFaturamento.getConfValidacaoPedidos());
    }

    private void verificarTitulos(Pedido p) throws ExceptionService, ExceptionGeracaoTitulos, ExceptionValidation, ExceptionInvalidData {
        if (p.getSituacaoPedido() != null && p.getSituacaoPedido().getCancelarTitulos() != null && p.getSituacaoPedido().getCancelarTitulos().equals((short)1) || p.getGeracaoTituloPedido() == null && p.getExpedicao() != null && !p.getExpedicao().isEmpty() && ((Expedicao)p.getExpedicao().get(0)).getNotaFiscalPropria() != null) {
            p.getInfPagamentoPedido().clear();
            p.getInfPagamentoPedido().addAll(new ArrayList());
            for (ItemPedido it : p.getItemPedido()) {
                for (GradeItemPedido g : it.getGradeItemPedido()) {
                    g.setMovimentacaoFisica(Short.valueOf((short)0));
                }
            }
            return;
        }
        if (p.getSituacaoPedido() != null && (ToolMethods.isAffirmative((Number)p.getSituacaoPedido().getNaoGerarTitulosPedido()) || ToolMethods.isEquals((Object)p.getSituacaoPedido().getGerarFinanceiroNFCe(), (Object)EnumConstGeracaoTitulosPreVendaPedido.NAO_GERAR_TITULOS.getValue()))) {
            if (p.getIdentificador() != null) {
                this.limparTitulos(p);
            }
        } else {
            if (!this.existeTitulos(p)) {
                this.criarTitulos(p);
            }
            if (this.existeTitulos(p)) {
                CoreUtilityFactory.getUtilityTitulos().validarTitulos(p.getCondicoesPagamento(), this.opcoesFinanceiras, this.getTitulosPedido(p));
            }
            this.validarValoresTitulos(p);
        }
    }

    private void limparTitulos(Pedido pedido) {
        if (pedido.getInfPagamentoPedido() != null) {
            for (InfPagamentoPedido inf : pedido.getInfPagamentoPedido()) {
                if (inf.getTitulos() == null) continue;
                inf.getTitulos().clear();
            }
        }
    }

    private void criarTitulos(Pedido pedido) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        CoreUtilityFactory.getUtilityTitulos().criarTitulos(pedido, this.opcoesFinanceiras, this.opcoesFaturamento, this.opcoesContabeis);
    }

    private void validarValoresTitulos(Pedido p) throws ExceptionValidation {
        CoreUtilityFactory.getUtilityTitulos().validarValoresTitulo(p);
    }

    private void atualizarSitCotVendas(Pedido p, SituacaoCotacaoVendas sit) {
        if (sit == null) {
            return;
        }
        if (p.getCotacaoVendas() == null) {
            return;
        }
        CoreDAOFactory.getInstance().getDAOCotacaoVendas().atualizarSituacaoCotacaoVendas(p.getCotacaoVendas(), sit);
        if (p.getCotacaoVendas().getPreCotacaoVenda() == null) {
            return;
        }
        CoreDAOFactory.getInstance().getDAOPreCotacaoVendas().atualizarSituacaoCotacaoVendas(p.getCotacaoVendas().getPreCotacaoVenda(), sit);
    }

    private void reservarEstoque(Pedido p) throws ExceptionService {
        try {
            SituacaoNecessidadeCompra sitNec = null;
            CentroCusto cc = null;
            if (this.opcoesCompras != null) {
                sitNec = this.opcoesCompras.getSituacaoNecessidadeCadastro();
                cc = this.opcoesCompras.getCentroCustoNecessidadeCompra();
            }
            ServicePedidoImpl service = (ServicePedidoImpl)Context.get(ServicePedidoImpl.class);
            service.reservarGerarNecCompra(p, EnumConstantsMentorSimNao.get((Object)this.opcoesFaturamento.getCriarNecessidadeCompra()), this.opcoesFaturamento.getSituacaoPedidosNecessidade(), this.usuario, cc, sitNec, this.opcoesFaturamento.getCentroEstoqueReserva(), EnumConstOpFatTipoReservaEstPedido.get((Object)this.opcoesFaturamento.getTipoReservaEstoquePedido()));
        }
        catch (ExceptionInvalidState ex) {
            throw new ExceptionService(ex.getMessage(), ex);
        }
    }

    private void sendEmails(final List<Email> emails) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Email email : emails) {
                    try {
                        ToolSendEmail.sendEmailWithException((Email)email);
                    }
                    catch (ExceptionEmail ex) {
                        logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
                    }
                }
            }
        });
    }

    private void criarEmail(Pedido p, List<Email> emails) throws ExceptionService {
        Email gen = CoreUtilityFactory.getUtilityPedido().gerarEmail(p, this.opcoesRelacionamento, this.usuario);
        if (gen != null) {
            emails.add(gen);
        }
    }

    private void throwExCasoBloqueado(ValidacaoPedidoItem val) throws ExceptionService {
        if (val.contemErro((short)2)) {
            throw new ExceptionService(val.getProblemasEncontrados());
        }
    }

    private ValidacaoPedidoItem newValidacaoPedidoItem() {
        ValidacaoPedidoItem val = new ValidacaoPedidoItem();
        if (this.opcoesFaturamento.getConfValidacaoPedidos() != null) {
            // empty if block
        }
        return val;
    }

    private Pedido salvarAtualizarPedidoDB(Pedido p) throws ExceptionService {
        try {
            p = (Pedido)CoreDAOFactory.getInstance().getDAOPedido().saveOrUpdate(p);
            return p;
        }
        catch (ExceptionDatabase ex) {
            throw new ExceptionService(ex);
        }
    }

    private void criarEmails(Pedido p, List<Email> emails) throws ExceptionService {
        this.criarEmail(p, emails);
    }

    private boolean existeTitulos(Pedido p) {
        for (InfPagamentoPedido i : p.getInfPagamentoPedido()) {
            if (i.getTitulos() == null || i.getTitulos().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private List<Titulo> getTitulosPedido(Pedido p) {
        ArrayList<Titulo> titulos = new ArrayList<Titulo>();
        for (InfPagamentoPedido i : p.getInfPagamentoPedido()) {
            titulos.addAll(i.getTitulos());
        }
        return titulos;
    }

    private boolean validarQtdeItens(Pedido p) {
        Integer nrItens = p.getItemPedido().size();
        return ToolMethods.isEquals((Object)p.getNrTotalItens(), (Object)nrItens);
    }

    private boolean validarTransferencias(Pedido p) throws ExceptionService {
        if (ToolMethods.isEquals((Object)p.getReservarEstoque(), (Object)0)) {
            return true;
        }
        if (p.getSituacaoPedido().getCancelarTitulos() != null && p.getSituacaoPedido().getCancelarTitulos().equals((short)1)) {
            return true;
        }
        if (!ToolMethods.isWithData((Collection)p.getTransferencias()) && !ToolMethods.isWithData((Collection)p.getNecessidadesCompra()) && ToolMethods.isEquals((Object)p.getModoReservaEstoque(), (Object)EnumConstOpFatResEstoquePed.RESERVAR_TRANSFERENCIA_ESTOQUE.getValue())) {
            throw new ExceptionService("5-O pedido est\u00e1 marcado para reservar estoque, mas nao existe nenhuma transfer\u00eancia ou necessidade de compra vinculada ao pedido!");
        }
        return true;
    }
}

