/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.pedido;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilPedidoOtimizado {
    Object getProdutosKitsByTexto(String texto, OpcoesFaturamento opcoesFaturamento, Empresa empresa, Pessoa pessoaCliente, Pessoa pessoaRepresentante, UnidadeFederativa uf, Date dataEmissao, Moeda moeda) throws ExceptionService {
        return this.findPrecoProdutoTabelaBase(texto, empresa, uf, dataEmissao, moeda);
    }

    private void orderLista(List ret) {
        Collections.sort(ret, new Comparator<HashMap>(this){

            @Override
            public int compare(HashMap o1, HashMap o2) {
                HashMap h1 = o1;
                HashMap h2 = o2;
                Produto p1 = (Produto)h1.get("PRODUTO");
                Produto p2 = (Produto)h2.get("PRODUTO");
                return p1.getNome().compareToIgnoreCase(p2.getNome());
            }
        });
    }

    private void getPrecosBase(List<HashMap> produtos, Moeda moeda, Date dataEmissao) {
        if (produtos != null) {
            for (HashMap h : produtos) {
                Long idTabelaBase = (Long)h.get("ID_TABELA_BASE");
                Produto produto = (Produto)h.get("PRODUTO");
                String hql = "select t.valorVenda as VALOR_VENDA from TabelaPrecoBaseProduto t  where t.produto=:produto  and :data between t.tabelaPrecoBase.dataInicial and t.tabelaPrecoBase.dataFinal and t.tabelaPrecoBase.identificador = :idTabelaBase and t.ativo=:sim and t.tabelaPrecoBase.moeda = :moeda and t.produto.ativo = :sim";
                Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
                q.setEntity("produto", (Object)produto);
                q.setShort("sim", (short)1);
                q.setEntity("moeda", (Object)moeda);
                q.setLong("idTabelaBase", idTabelaBase.longValue());
                q.setDate("data", dataEmissao);
                q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
                q.setMaxResults(1);
                HashMap hh = (HashMap)q.uniqueResult();
                if (hh == null) continue;
                h.put("VALOR_VENDA", (Double)hh.get("VALOR_VENDA"));
            }
        }
    }

    private List findPrecoProdutoTabelaBase(String texto, Empresa empresa, UnidadeFederativa uf, Date dataEmissao, Moeda moeda) throws ExceptionService {
        LinkedList<? extends HashMap> ret = new LinkedList<HashMap>();
        ret.addAll(this.findProdutoDescricaoTabelaBase(texto, empresa, dataEmissao, moeda));
        this.orderLista(ret);
        return ret;
    }

    private Collection<? extends HashMap> findProdutoDescricaoTabelaBase(String text, Empresa empresa, Date dataEmissao, Moeda moeda) {
        String onlyNumber;
        if (text.length() > 115) {
            return new LinkedList();
        }
        if (text.length() < 3) {
            return new LinkedList();
        }
        Criteria c = CoreBdUtil.getInstance().getSession().createCriteria(TabelaPrecoBaseProduto.class);
        c.createAlias("tabelaPrecoBase", "tp");
        c.createAlias("produto", "p");
        c.add((Criterion)Restrictions.eq((String)"ativo", (Object)1));
        c.add((Criterion)Restrictions.eq((String)"p.ativo", (Object)1));
        c.add((Criterion)Restrictions.eq((String)"tp.tabelaPrincipal", (Object)1));
        c.add((Criterion)Restrictions.eq((String)"tp.empresa", (Object)empresa));
        c.add((Criterion)Restrictions.eq((String)"tp.moeda", (Object)moeda));
        c.add((Criterion)Restrictions.le((String)"tp.dataInicial", (Object)dataEmissao));
        c.add((Criterion)Restrictions.ge((String)"tp.dataFinal", (Object)dataEmissao));
        Disjunction orD = Restrictions.disjunction();
        c.add((Criterion)orD);
        boolean useEq = false;
        if (text.startsWith("=")) {
            useEq = true;
            text = text.substring(1);
        }
        if ((onlyNumber = ToolString.onlyNumbers((String)text)).length() == text.length() && onlyNumber.length() < 10) {
            orD.add((Criterion)Restrictions.eq((String)"p.identificador", (Object)Long.valueOf(onlyNumber)));
        }
        if (text.length() < 30) {
            if (!useEq) {
                orD.add(Restrictions.ilike((String)"p.codigoAuxiliar", (Object)("%" + text.toUpperCase() + "%")));
            } else {
                orD.add((Criterion)Restrictions.eq((String)"p.codigoAuxiliar", (Object)text));
            }
        }
        if (!useEq) {
            orD.add(Restrictions.ilike((String)"p.nome", (Object)("%" + text.toUpperCase() + "%")));
        } else {
            orD.add((Criterion)Restrictions.eq((String)"p.nome", (Object)text));
        }
        ProjectionList sel = Projections.projectionList();
        sel.add((Projection)Projections.property((String)"produto"), "PRODUTO");
        sel.add((Projection)Projections.property((String)"valorVenda"), "VALOR_VENDA");
        c.setProjection((Projection)sel);
        c.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List l = c.list();
        return l;
    }
}

