/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.pedidocomercio2;

import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.ControleEntregaPedidoComercio;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemPedidoComercio;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.PedidoComercio;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SituacaoItemPedido;
import com.touchcomp.basementor.model.vo.Titulo;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.pedidocomercio2.UtilPedidoComercio;

public class ServicePedidoComercio
extends CoreService {
    public static final String PESQUISAR_PEDIDO_ABERTO = "pesquisarPedidoAberto";
    public static final String GET_PRODUTOS_BY_TEXTO = "getProdutosByTexto";
    public static final String GET_TABELA_PRECO_CUPOM_BY_PRODUTO = "getTabelaPrecoCupomByProduto";
    public static final String GET_ITENS_PEDIDO_SITUACAO_ITEM = "getItensPedidoSituacaoItem";
    public static final String ATUALIZAR_SIT_ITENS_PEDIDO_COMERCIO = "atualizarSitItensPedidoComercio";
    public static final String FIND_PEDIDO_BLOQUEADOS = "findPedidoBloqueados";
    public static final String DELETAR_PEDIDO_COMERCIO = "deletarPedidoComercio";
    public static final String PESQUISAR_ITEM_PEDIDO_POR_PRODUTO_AND_PESSOA = "pesquisarItemPedidoPorProdutoAndPessoa";
    public static final String PESQUISAR_PEDIDO_VENDA_FINANCEIRA = "pesquisarPedidoVendaFinanceira";

    public List pesquisarPedidoAberto(CoreRequestContext r) throws ExceptionService {
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOPedidoComercio().pesquisarPedidoAberto(empresa);
    }

    public Object getProdutosByTexto(CoreRequestContext cq) throws ExceptionService {
        String texto = (String)cq.getAttribute("texto");
        OpcoesFaturamento opcoesFaturamento = (OpcoesFaturamento)cq.getAttribute("opcoesFaturamento");
        Empresa empresa = (Empresa)cq.getAttribute("empresa");
        return new UtilPedidoComercio().getProdutosKitsByTexto(texto, opcoesFaturamento, empresa);
    }

    public Object getTabelaPrecoCupomByProduto(CoreRequestContext cq) throws ExceptionService {
        Produto produto = (Produto)cq.getAttribute("produto");
        Empresa emp = (Empresa)cq.getAttribute("empresa");
        return new UtilPedidoComercio().findTabelaPrecoByProdutoAndConverter(produto, emp);
    }

    public List getItensPedidoSituacaoItem(CoreRequestContext r) throws ExceptionService {
        SituacaoItemPedido situacao = (SituacaoItemPedido)r.getAttribute("situacaoItem");
        Short tipoFiltro = (Short)r.getAttribute("tipoFiltro");
        Date dataIn = (Date)r.getAttribute("dataIn");
        Date dataFim = (Date)r.getAttribute("dataFim");
        return CoreDAOFactory.getInstance().getDAOPedidoComercio().getItensPedidoSituacaoItem(situacao, tipoFiltro, dataIn, dataFim);
    }

    public boolean atualizarSitItensPedidoComercio(CoreRequestContext r) throws ExceptionService, ExceptionDatabase {
        List itensPedido = (List)r.getAttribute("itensPedido");
        CoreDAOFactory.getInstance().getDAOPedidoComercio().atualizarSitItensPedidoComercio(itensPedido);
        return true;
    }

    public Object findPedidoBloqueados(CoreRequestContext request) {
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        Long idClienteInicial = (Long)request.getAttribute("idClienteInicial");
        Long idClienteFinal = (Long)request.getAttribute("idClienteFinal");
        Short filtraCliente = (Short)request.getAttribute("filtrarCliente");
        Short filtraData = (Short)request.getAttribute("filtrarData");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOPedidoComercio().findPedidoBloqueados(filtraData, dataInicial, dataFinal, filtraCliente, idClienteInicial, idClienteFinal, empresa);
    }

    public PedidoComercio deletarPedidoComercio(CoreRequestContext r) throws ExceptionDatabase, ExceptionService {
        PedidoComercio vo = (PedidoComercio)r.getAttribute("vo");
        for (Titulo t : vo.getTitulos()) {
            for (BoletoTitulo b : t.getBoletoTitulo()) {
                CoreDAOFactory.getInstance().getDAOBoletoTitulo().deletarTituloBoleto(b);
            }
        }
        List controlesEntrega = CoreDAOFactory.getInstance().getDAOPedidoComercio().findControleEntregaPedidoComercio(vo.getIdentificador());
        if (controlesEntrega != null && !controlesEntrega.isEmpty()) {
            for (Object ob : controlesEntrega) {
                ControleEntregaPedidoComercio c = (ControleEntregaPedidoComercio)ob;
                CoreDAOFactory.getInstance().getDAOPedidoComercio().delete(c);
            }
        }
        vo = (PedidoComercio)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOPedidoComercio(), vo.getIdentificador());
        CoreDAOFactory.getInstance().getDAOPedidoComercio().delete(vo);
        return null;
    }

    public List<ItemPedidoComercio> pesquisarItemPedidoPorProdutoAndPessoa(CoreRequestContext r) {
        Date dataInicial = (Date)r.getAttribute("dataInicial");
        Date dataFinal = (Date)r.getAttribute("dataFinal");
        Pessoa pessoa = (Pessoa)r.getAttribute("pessoa");
        Produto produto = (Produto)r.getAttribute("produto");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOItemPedidoComercio().pesquisarItemPedidoPorProdutoAndPessoa(dataInicial, dataFinal, empresa, pessoa, produto);
    }

    public List pesquisarPedidoVendaFinanceira(CoreRequestContext r) throws ExceptionService {
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        Date dataInicial = (Date)r.getAttribute("dataInicial");
        Date dataFinal = (Date)r.getAttribute("dataFinal");
        return CoreDAOFactory.getInstance().getDAOPedidoComercio().pesquisarPedidoVendaFinanceira(empresa, dataInicial, dataFinal);
    }
}

