/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.pedidocomercio2;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import org.hibernate.query.Query;

public class UtilPedidoComercio {
    Object getProdutosKitsByTexto(String texto, OpcoesFaturamento opcoesFaturamento, Empresa empresa) throws ExceptionService {
        LinkedList ret = new LinkedList();
        ret.addAll(this.findProdutoDescricao(texto, empresa));
        ret.addAll(this.findProdutoIdCodigoBarras(texto, empresa));
        this.orderLista(ret);
        return ret;
    }

    private List findProdutoDescricao(String text, Empresa empresa) throws ExceptionService {
        if (text.length() > 115) {
            return new LinkedList();
        }
        if (text.length() < 3) {
            return new LinkedList();
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery("select distinct p.identificador, p.nome, u.sigla, t.valorVenda, f.nome, cp.descricao  from TabelaPrecoCupomFiscalProduto t inner join t.produto p inner join p.unidadeMedida u left  join p.fabricante f left  join p.classificacaoProdutos cp  where upper(p.nome) like :nome and t.tabPrecoCupomFiscal.empresa = :empresa and p.ativo = :ativo");
        q.setString("nome", "%" + text.toUpperCase() + "%");
        q.setEntity("empresa", (Object)empresa);
        q.setShort("ativo", (short)1);
        List l = q.list();
        l = this.setFlag(l, (short)0);
        return l;
    }

    public List findProdutoIdCodigoBarras(String text, Empresa empresa) {
        if (text.trim().length() > 13) {
            return new LinkedList();
        }
        Long idPRod = 0L;
        try {
            idPRod = new Long(text);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Object query = "select distinct p.identificador, p.nome, u.sigla, t.valorVenda, f.nome, cp.descricao  from TabelaPrecoCupomFiscalProduto t inner join t.produto p inner join p.unidadeMedida u left join p.fabricante f left join p.codigoBarras c left  join p.classificacaoProdutos cp  where (upper(p.codigoAuxiliar) like :nome  or c.codigoBarras = :codigo ";
        if (idPRod > 0L) {
            query = (String)query + " or cast(p.identificador as long )=:identificador ";
        }
        query = (String)query + ") and t.tabPrecoCupomFiscal.empresa = :empresa and p.ativo = :ativo";
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)query);
        q.setString("nome", "%" + text.toUpperCase() + "%");
        q.setString("codigo", text);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("ativo", (short)1);
        if (idPRod > 0L) {
            q.setLong("identificador", idPRod.longValue());
        }
        List l = q.list();
        l = this.setFlag(l, (short)0);
        return l;
    }

    public List findTabelaPrecoByProdutoAndConverter(Produto prod, Empresa empresa) {
        String query = "select distinct t.valorVenda  from TabelaPrecoCupomFiscalProduto t where t.produto = :produto  and t.tabPrecoCupomFiscal.empresa = :empresa and t.produto.ativo = :ativo";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(query);
        q.setEntity("empresa", (Object)empresa);
        q.setEntity("produto", (Object)prod);
        q.setShort("ativo", (short)1);
        List l = q.list();
        l = this.setFlagByProd(l, (short)0, prod);
        return l;
    }

    private Collection findKitProdutoCodigo(String texto, Empresa empresa) {
        if (texto.length() > 17) {
            return new LinkedList();
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery("select k.identificador, k.descricao,k.codigoKit, t.valorVenda  from TabelaPrecoCupomKit t inner join t.kitProdutos k where upper(k.codigoKit) like :nome and t.tabelaPrecoCupomFiscal.empresa = :empresa");
        q.setString("nome", "%" + texto.toUpperCase() + "%");
        q.setEntity("empresa", (Object)empresa);
        List l = q.list();
        l = this.setFlag(l, (short)1);
        return l;
    }

    private Collection findKitProdutoDescricao(String texto, Empresa empresa) {
        if (ToolString.stringIsANumber((String)texto).booleanValue()) {
            return new LinkedList();
        }
        if (texto.length() > 145) {
            return new LinkedList();
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery("select k.identificador, k.descricao,k.codigoKit, t.valorVenda  from TabelaPrecoCupomKit t inner join t.kitProdutos k where upper(k.descricao) like :nome and t.tabelaPrecoCupomFiscal.empresa = :empresa");
        q.setString("nome", "%" + texto.toUpperCase() + "%");
        q.setEntity("empresa", (Object)empresa);
        List l = q.list();
        l = this.setFlag(l, (short)1);
        return l;
    }

    private List setFlag(List l, short flag) {
        LinkedList<Object[]> toRet = new LinkedList<Object[]>();
        for (Object o : l) {
            Object[] ar = (Object[])o;
            Object[] ar1 = new Object[]{ar[0], ar[1], ar[2], ar[3], ar[4], ar[5], flag};
            toRet.add(ar1);
        }
        return toRet;
    }

    private void orderLista(List ret) {
        Collections.sort(ret, new Comparator<Object[]>(this){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                String s1 = (String)o1[1];
                String s2 = (String)o2[1];
                return s1.compareToIgnoreCase(s2);
            }
        });
    }

    private List setFlagByProd(List l, short flag, Produto prod) {
        LinkedList<Object[]> toRet = new LinkedList<Object[]>();
        for (Object o : l) {
            Object[] ar1 = new Object[]{prod.getIdentificador(), prod.getNome(), prod.getUnidadeMedida().getSigla(), (Double)o, prod.getFabricante() != null ? prod.getFabricante().getNome() : "", prod.getClassificacaoProdutos() != null ? prod.getClassificacaoProdutos().getDescricao() : "", flag};
            toRet.add(ar1);
        }
        return toRet;
    }
}

