/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.planejamentovendasproditens;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.impl.VOEngenhariaProdutos;
import com.touchcomp.basementor.model.vo.ItemPlanProducaoOSLinProd;
import com.touchcomp.basementor.model.vo.ItemPlanejamentoProdLinProd;
import com.touchcomp.basementor.model.vo.PlanejVendasProd;
import com.touchcomp.basementor.model.vo.PlanejVendasProdItens;
import com.touchcomp.basementor.model.vo.PlanejVendasProdPlanLinProd;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementorservice.components.estoque.CompEstoque;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoQTD;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOCARREGAMENTO;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOSALDO;

public class UtilPlanejamentoVendasProd {
    private final PlanejVendasProd planejVendasProd;
    private final boolean flagCalcularTudo = true;
    private final List<VOEngenhariaProdutos> cacheConsulta = new ArrayList<VOEngenhariaProdutos>();

    public UtilPlanejamentoVendasProd(PlanejVendasProd planejVendasProd, boolean flagCalcularTudo) {
        this.planejVendasProd = planejVendasProd;
    }

    List processarDados() throws ExceptionService {
        LinkedList temp = new LinkedList();
        this.clearDataItens();
        for (PlanejVendasProdPlanLinProd planejamento : this.planejVendasProd.getPlanejamentos()) {
            for (ItemPlanejamentoProdLinProd itemPlan : planejamento.getPlanejProdLinhaProd().getItemplanProdLinProd()) {
                for (ItemPlanProducaoOSLinProd itemPlanProducaoOS : itemPlan.getItemPlanProducaoOS()) {
                    PlanejVendasProdItens found = this.getItem(itemPlanProducaoOS);
                    HashMap<String, PlanejVendasProdItens> h = new HashMap<String, PlanejVendasProdItens>();
                    h.put("item", found);
                    temp.add(h);
                    this.setValorCustoMargem(found, h);
                    this.setValorVenda(found);
                    this.setTotais(found);
                }
            }
        }
        return temp;
    }

    private PlanejVendasProdItens getItem(ItemPlanProducaoOSLinProd itemPlanProducaoOS) {
        PlanejVendasProdItens found;
        List aux = this.planejVendasProd.getItens().stream().filter(item -> item.getGradeFormulaProduto().equals((Object)itemPlanProducaoOS.getGradeFormulaProduto())).collect(Collectors.toList());
        if (!aux.isEmpty()) {
            found = (PlanejVendasProdItens)aux.get(0);
        } else {
            found = new PlanejVendasProdItens();
            found.setGradeCor(itemPlanProducaoOS.getItemPlanejamentoProducao().getGradeCor());
            found.setGradeFormulaProduto(itemPlanProducaoOS.getGradeFormulaProduto());
            this.planejVendasProd.getItens().add(found);
        }
        found.setQuantidadePlanProducao(Double.valueOf(found.getQuantidadePlanProducao() + itemPlanProducaoOS.getQuantidade()));
        found.setQuantidadePlanVendaPed(Double.valueOf(found.getQuantidadePlanVendaPed() + itemPlanProducaoOS.getQuantidade()));
        return found;
    }

    private void clearDataItens() {
    }

    private void getValorCustoPcpLinha(PlanejVendasProdItens found, HashMap h) throws ExceptionService {
        List<VOEngenhariaProdutos> lista;
        short carregarCapacidadeRoteiroApont = 0;
        carregarCapacidadeRoteiroApont = this.planejVendasProd.getTipoCapacidadeProdutiva() == 1 ? (short)1 : 0;
        short tipoAnaliseCustoIndireto = 0;
        Long idAnaliseCusto = null;
        if (this.planejVendasProd.getTipoAnaliseCustoPCPLinha() == 0) {
            tipoAnaliseCustoIndireto = 0;
        } else {
            tipoAnaliseCustoIndireto = 1;
            idAnaliseCusto = this.planejVendasProd.getAnaliseCustoProd().getIdentificador();
        }
        Long idMoeda = null;
        if (this.planejVendasProd.getMoedaMatPrima() != null) {
            idMoeda = this.planejVendasProd.getMoedaMatPrima().getIdentificador();
        }
        if ((lista = CoreServiceFactory.getServiceEngenhariaProdutos().calcularEngenhariaProdutos(this.planejVendasProd.getDataBase(), this.planejVendasProd.getDataProdInicial(), this.planejVendasProd.getDataProdFinal(), 1.0, 999, tipoAnaliseCustoIndireto, idAnaliseCusto, (short)0, found.getGradeFormulaProduto().getIdentificador(), found.getGradeFormulaProduto().getIdentificador(), idMoeda, (short)0, this.planejVendasProd.getCarregarTabPrecosMatPrima(), carregarCapacidadeRoteiroApont, this.cacheConsulta, this.planejVendasProd.getEmpresa(), this.planejVendasProd.getPercentualEficiencia())).size() > 0) {
            VOEngenhariaProdutos vo = lista.get(0);
            found.setValorCustoUltCusto(vo.getTotalGeralUltPrecoCusto());
            found.setValorCustoPrMedio(vo.getTotalGeralUltPrecoMedio());
            found.setCapacidadeProdutivaTotal(vo.getCapacidadeRoteiro());
            found.setCapacidadeProdutivaUtilizada(vo.getCapacidadeUtilizada());
            h.put("voEngenharia", vo);
        }
    }

    private void setTotais(PlanejVendasProdItens found) {
        found.setQuantidadePlanVendaTotal(Double.valueOf(found.getQuantidadePlanVendaMan() + found.getQuantidadePlanVendaPed()));
        found.setValorTotalVenda(Double.valueOf(found.getValorVendaUnit() * found.getQuantidadePlanVendaTotal()));
        found.setValorMargemPrMedio(Double.valueOf(found.getValorVendaUnit() - found.getValorCustoPrMedio()));
        found.setValorMargemUltCusto(Double.valueOf(found.getValorVendaUnit() - found.getValorCustoUltCusto()));
        found.setValorDifMargemPrMedio(Double.valueOf(found.getValorTotalVenda() - found.getValorCustoPrMedio() * found.getQuantidadePlanVendaTotal()));
        found.setValorDifMargemTotal(Double.valueOf(found.getValorTotalVenda() - found.getValorCustoUltCusto() * found.getQuantidadePlanVendaTotal()));
    }

    private void setValorCustoMargem(PlanejVendasProdItens found, HashMap h) throws ExceptionService {
        if (this.planejVendasProd.getTipoPesqCusto() == 1) {
            this.setCustoEstoque(found);
        }
        if (this.planejVendasProd.getTipoPesqCusto() == 2) {
            this.getValorCustoPcpLinha(found, h);
        }
        if (this.planejVendasProd.getTipoPesqCusto() == 3) {
            this.setCustoTabPrecos(found);
        }
    }

    private void setCustoTabPrecos(PlanejVendasProdItens item) {
        Optional<TabelaPrecoBaseProduto> found = this.planejVendasProd.getTabelaPrecosBase().getProdutos().stream().filter(it -> it.getProduto().equals((Object)item.getGradeCor().getProdutoGrade().getProduto())).findFirst();
        if (found.isPresent()) {
            item.setValorCustoPrMedio(found.get().getValorCusto());
            item.setValorCustoUltCusto(found.get().getValorCusto());
        }
    }

    private void setCustoEstoque(PlanejVendasProdItens found) throws ExceptionService {
        CompEstoque compEstoque = (CompEstoque)Context.get(CompEstoque.class);
        Double vlr = compEstoque.getUltimoCusto(found.getGradeCor().getProdutoGrade().getProduto(), this.planejVendasProd.getEmpresa());
        found.setValorCustoUltCusto(vlr);
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("produto", found.getGradeCor().getProdutoGrade().getProduto());
        request.setAttribute("empresa", this.planejVendasProd.getEmpresa());
        request.setAttribute("data", this.planejVendasProd.getDataBase());
        request.setAttribute("tipoSaldo", EnumConstantsSaldoTIPOSALDO.TIPO_SALDO_PRODUTO.value);
        request.setAttribute("tipoQtde", EnumConstantsSaldoQTD.TIPO_SALDO_QTQ_TUDO.value);
        request.setAttribute("tipoCarregamento", EnumConstantsSaldoTIPOCARREGAMENTO.TIPO_SALDO_QTQ_VLR_SOMENTE_VALOR.value);
        request.setAttribute("tipoDisponibilidade", EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue());
        request.setAttribute("tipoEstoqueCentroEstoque", EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue());
        request.setAttribute("idParceiro", null);
        vlr = (Double)CoreServiceFactory.getServiceSaldoEstProprio().execute(request, "findPrecoMedioProduto");
        found.setValorCustoPrMedio(vlr);
        found.setValorCustoUltCusto(vlr);
    }

    private void setValorVenda(PlanejVendasProdItens item) {
        Optional<TabelaPrecoBaseProduto> found = this.planejVendasProd.getTabelaPrecosBase().getProdutos().stream().filter(it -> it.getProduto().equals((Object)item.getGradeCor().getProdutoGrade().getProduto())).findFirst();
        if (found.isPresent()) {
            item.setValorVendaUnit(found.get().getValorVenda());
        }
    }
}

