/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.planoconta;

import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;
import java.util.HashMap;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.planoconta.UtilGeraContaPessoa;
import mentorcore.service.impl.planoconta.UtilGerarListagemPlanoContas;
import net.sf.jasperreports.engine.JasperPrint;

public class ServicePlanoConta
extends CoreService {
    public static final String GERAR_LISTAGEM_PLANO_CONTA = "gerarListagemPlanoConta";
    public static final String GERAR_NOVO_PLANO_CONTA_ANTECIPACAO_FORNECEDOR = "gerarNovoPlanoContaAntecipacaoFornecedor";
    public static final String GERAR_NOVO_PLANO_CONTA_ANTECIPACAO_CLIENTE = "gerarNovoPlanoContaAntecipacaoCliente";
    public static final String ATUALIZAR_DATA_CADASTRO_PC = "atualizarDataCadastroPC";
    public static final String EXISTE_CONTAS_DEPENDENTES = "exiteContasDependentes";
    public static final String ATUALIZAR_NAT_OP_CONTAS = "atualizarNatOPContas";
    public static final String FIND_BY_GRUPO = "findByGrupo";
    public static final String FIND_NEXT_REDUZIDA = "findNextReduzida";
    public static final String FIND_NEXT_SEQUENCIAL = "findNextSequencial";
    public static final String GERAR_NOVO_PLANO_CONTA = "gerarNovoPlanoConta";
    public static final String SALVAR_PLANO_CONTA = "salvarPlanoConta";
    public static final String ATUALIZAR_CLASSIFICACAO_CONTAS = "atualizarClassificacaoContas";

    public JasperPrint gerarListagemPlanoConta(CoreRequestContext request) throws ExceptionService {
        Integer grauConta = (Integer)request.getAttribute("grauConta");
        Integer ordem = (Integer)request.getAttribute("ordem");
        String contaInicial = (String)request.getAttribute("contaInicial");
        String contaFinal = (String)request.getAttribute("contaFinal");
        String fecho = (String)request.getAttribute("fecho");
        Integer folha = (Integer)request.getAttribute("folha");
        HashMap params = (HashMap)request.getAttribute("parametros");
        Nodo nodo = (Nodo)request.getAttribute("nodo");
        return new UtilGerarListagemPlanoContas().gerarListagemPlanoConta(grauConta, ordem, contaInicial, contaFinal, fecho, folha, params, nodo);
    }

    public PlanoConta gerarNovoPlanoContaAntecipacaoFornecedor(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        String cnpj = (String)request.getAttribute("cnpj");
        PlanoConta pc = (PlanoConta)request.getAttribute("planoConta");
        String descricao = (String)request.getAttribute("descricao");
        OpcoesContabeis opcoesContabeis = (OpcoesContabeis)request.getAttribute("opcoesContabeis");
        return new UtilGeraContaPessoa().gerarNovoPlanoContaAntecipacaoFornecedor(pc, cnpj, descricao, opcoesContabeis);
    }

    public PlanoConta gerarNovoPlanoContaAntecipacaoCliente(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        String cnpj = (String)request.getAttribute("cnpj");
        PlanoConta pc = (PlanoConta)request.getAttribute("planoConta");
        String descricao = (String)request.getAttribute("descricao");
        OpcoesContabeis opcoesContabeis = (OpcoesContabeis)request.getAttribute("opcoesContabeis");
        return new UtilGeraContaPessoa().gerarNovoPlanoContaAntecipacaoCliente(pc, cnpj, descricao, opcoesContabeis);
    }

    public Boolean atualizarDataCadastroPC(CoreRequestContext request) {
        Date dataBase = (Date)request.getAttribute("dataBase");
        Date dataAlt = (Date)request.getAttribute("dataAlt");
        return CoreDAOFactory.getInstance().getDAOPlanoConta().atualizarDataCadastroPC(dataBase, dataAlt);
    }

    public Boolean exiteContasDependentes(CoreRequestContext request) {
        String endCount;
        String beginCount;
        PlanoConta vo = (PlanoConta)request.getAttribute("plano");
        String codigo = vo.getCodigo();
        if (codigo.substring(1, 10).equalsIgnoreCase("000000000")) {
            beginCount = codigo.substring(0, 1) + "000000000";
            endCount = codigo.substring(0, 1) + "999999999";
        } else if (codigo.substring(2, 10).equalsIgnoreCase("00000000")) {
            beginCount = codigo.substring(0, 2) + "00000000";
            endCount = codigo.substring(0, 2) + "99999999";
        } else if (codigo.substring(3, 10).equalsIgnoreCase("0000000")) {
            beginCount = codigo.substring(0, 3) + "0000000";
            endCount = codigo.substring(0, 3) + "9999999";
        } else if (codigo.substring(5, 10).equalsIgnoreCase("00000")) {
            beginCount = codigo.substring(0, 5) + "00000";
            endCount = codigo.substring(0, 5) + "99999";
        } else {
            return false;
        }
        return CoreDAOFactory.getInstance().getDAOPlanoConta().existeContasDependentes(beginCount, endCount, codigo);
    }

    public Object atualizarNatOPContas(CoreRequestContext request) throws ExceptionService {
        return CoreDAOFactory.getInstance().getDAOPlanoConta().atualizarNatOPContas(request);
    }

    public Object findByGrupo(CoreRequestContext request) throws ExceptionDatabase {
        String grupo = request.getAttribute("grupo").toString();
        grupo = ToolString.completaZeros((String)grupo, (int)10);
        Object ob = CoreDAOFactory.getInstance().getDAOPlanoConta().findByCriteriaUniqueResult("codigo", grupo, 0);
        if (ob != null) {
            return (PlanoConta)ob;
        }
        throw new ExceptionDatabase("Grupo de conta n\u00e3o cadastrado!");
    }

    public Object findNextReduzida(CoreRequestContext request) throws ExceptionDatabase {
        String obj = CoreDAOFactory.getInstance().getDAOPlanoConta().getNextReduzida();
        String strReduz = obj.toString();
        int intReduz = Integer.valueOf(strReduz);
        strReduz = ToolString.completaZeros((String)String.valueOf(++intReduz), (int)5, (boolean)true);
        return strReduz;
    }

    public Object findNextSequencial(CoreRequestContext request) throws ExceptionDatabase {
        String grupo = (String)request.getAttribute("grupo");
        String obj = CoreDAOFactory.getInstance().getDAOPlanoConta().getNextSequencial(grupo);
        String strReduz = obj.toString().substring(5, 10);
        long intReduz = Long.valueOf(strReduz.trim());
        strReduz = ToolString.completaZeros((String)String.valueOf(++intReduz), (int)5, (boolean)true);
        return strReduz;
    }

    public PlanoConta gerarNovoPlanoConta(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        PlanoConta planoConta = (PlanoConta)request.getAttribute("planoConta");
        String cnpj = (String)request.getAttribute("cnpj");
        String descricao = (String)request.getAttribute("descricao");
        OpcoesContabeis opcoesContabeis = (OpcoesContabeis)request.getAttribute("opcoesContabeis");
        return new UtilGeraContaPessoa().gerarNovoPlanoConta(planoConta, cnpj, descricao, opcoesContabeis);
    }

    public PlanoConta salvarPlanoConta(CoreRequestContext request) throws ExceptionDatabase {
        PlanoConta planoConta = (PlanoConta)request.getAttribute("planoConta");
        planoConta = (PlanoConta)CoreDAOFactory.getInstance().getDAOPlanoConta().saveOrUpdate(planoConta);
        return planoConta;
    }

    public Object atualizarClassificacaoContas(CoreRequestContext request) throws ExceptionService {
        return CoreDAOFactory.getInstance().getDAOPlanoConta().atualizarClassificacaoContas(request);
    }
}

