/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.planoconta;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.vo.DeParaNaturezaOpPC;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaContabilSped;
import com.touchcomp.basementorservice.helpers.impl.planoconta.HelperPlanoConta;
import com.touchcomp.basementorservice.service.impl.deparanaturezaoppc.ServiceDeParaNaturezaOpPC;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

class UtilGeraContaPessoa {
    UtilGeraContaPessoa() {
    }

    private Long findCodigoGrupo(String aux) {
        Session s = CoreBdUtil.getInstance().getSession();
        Long codigo1 = new Long(aux);
        Long codigo2 = new Long(aux.substring(0, 5) + "99999");
        String hql = "select max(cast(pc.codigo as numeric(10,0))+1) from plano_conta pc where cast(pc.codigo as numeric(10,0)) between :codigo1 and :codigo2";
        NativeQuery q = s.createSQLQuery(hql);
        q.setLong("codigo1", codigo1.longValue());
        q.setLong("codigo2", codigo2.longValue());
        Object ob = q.uniqueResult();
        if (ob != null && ob instanceof BigDecimal) {
            return ((BigDecimal)ob).longValue();
        }
        return ((BigInteger)ob).longValue();
    }

    public PlanoConta gerarNovoPlanoConta(PlanoConta planoConta, String cnpj, String descricaoConta, OpcoesContabeis opcoesContabeis) throws ExceptionService, ExceptionDatabase {
        String aux;
        PlanoConta pc;
        if (planoConta != null && ((HelperPlanoConta)Context.get(HelperPlanoConta.class)).isAnalitica(planoConta)) {
            return planoConta;
        }
        if (cnpj != null && cnpj.length() > 8) {
            cnpj = cnpj.substring(0, 8);
        }
        if ((pc = this.getPlanoContaClientes(aux = planoConta.getCodigo(), cnpj, opcoesContabeis)) == null) {
            Long codigo = this.findCodigoGrupo(aux);
            if (codigo != null) {
                pc = new PlanoConta();
                pc.setIdentificador(null);
                CoreRequestContext request = new CoreRequestContext();
                request.setAttribute("grupo", aux);
                String reduzida = (String)CoreServiceFactory.getServicePlanoConta().findNextReduzida(request);
                String sequencial = (String)CoreServiceFactory.getServicePlanoConta().findNextSequencial(request);
                pc.setMarca(Integer.valueOf(EnumConstSinteticoAnalitico.ANALITICO.getValueInt()));
                pc.setReduzida(reduzida);
                pc.setSeq(sequencial);
                pc.setCodigo(codigo.toString());
                pc.setDescricao(descricaoConta);
                pc.setEmpresa(opcoesContabeis.getEmpresa());
                pc.setDataCadastro(new Date());
                aux = aux.substring(0, 5);
                DeParaNaturezaOpPC d = this.getNaturezaOperacaoPC(aux);
                if (d == null) {
                    throw new ExceptionService("N\u00e3o foi encontrado nenhuma Natureza de Opera\u00e7\u00e3o para o grupo de Conta " + aux + ". \nVerifique o Cadastro de Natureza de Opera\u00e7\u00e3o Plano de Contas no recurso 741.");
                }
                pc.setNaturezaOperacaoPC(d.getNaturezaOperacaoPC());
                PlanoContaContabilSped ps = new PlanoContaContabilSped();
                ps.setPlanoConta(pc);
                ps.setPlanoContaSped(d.getPlanoContaSped());
                pc.getPlanoContaContabilSped().add(ps);
            } else {
                throw new ExceptionService("Erro ao gerar Plano de Conta!");
            }
        }
        return pc;
    }

    private PlanoConta findPlanoContaExistenteCliente(String cnpj) {
        Session s = CoreBdUtil.getInstance().getSession();
        cnpj = (String)cnpj + "%";
        String hql = "select cp.planoContaAtivo  from Cliente c inner join c.pessoa p inner join p.contasPessoa cp where  c.pessoa.complemento.cnpj like :cnpj";
        Query q = s.createQuery(hql);
        q.setText("cnpj", (String)cnpj);
        q.setMaxResults(1);
        return (PlanoConta)q.uniqueResult();
    }

    private PlanoConta findPlanoContaExistenteFornecedor(String cnpj) {
        Session s = CoreBdUtil.getInstance().getSession();
        cnpj = (String)cnpj + "%";
        String hql = "select cp.planoContaPassivo  from Fornecedor f inner join f.pessoa p inner join p.contasPessoa cp where p.complemento.cnpj like :cnpj ";
        Query q = s.createQuery(hql);
        q.setText("cnpj", (String)cnpj);
        q.setMaxResults(1);
        return (PlanoConta)q.uniqueResult();
    }

    private PlanoConta findPlanoContaExistenteInstFinanceira(String cnpj) {
        Session s = CoreBdUtil.getInstance().getSession();
        cnpj = (String)cnpj + "%";
        String hql = "select if.planoConta  from ContaValores if where if.agenciaValor.pessoa.complemento.cnpj like :cnpj ";
        Query q = s.createQuery(hql);
        q.setText("cnpj", (String)cnpj);
        q.setMaxResults(1);
        return (PlanoConta)q.uniqueResult();
    }

    public PlanoConta findPlanoContaExistenteRepresentante(String cnpj) {
        Session s = CoreBdUtil.getInstance().getSession();
        cnpj = (String)cnpj + "%";
        String hql = "select cp.planoContaPassivo  from Representante r inner join r.pessoa p inner join p.contasPessoa cp where p.complemento.cnpj like :cnpj ";
        Query q = s.createQuery(hql);
        q.setText("cnpj", (String)cnpj);
        q.setMaxResults(1);
        return (PlanoConta)q.uniqueResult();
    }

    public PlanoConta findPlanoContaExistenteTransportador(String cnpj) {
        Session s = CoreBdUtil.getInstance().getSession();
        cnpj = (String)cnpj + "%";
        String hql = "select t.planoConta  from Transportador t where t.pessoa.complemento.cnpj like :cnpj ";
        Query q = s.createQuery(hql);
        q.setText("cnpj", (String)cnpj);
        q.setMaxResults(1);
        return (PlanoConta)q.uniqueResult();
    }

    public PlanoConta findPlanoContaExistenteAdiantamentoFornecedor(String cnpj, String contaSintetica) throws ExceptionService {
        String q = "SELECT GCP.ID_PC_ANTEC_ATIVO  FROM FORNECEDOR   F  JOIN PESSOA       P ON P.ID_PESSOA       = F.ID_PESSOA  JOIN GERACAO_CONTA_PESSOA       GCP ON P.ID_PESSOA       = GCP.ID_PESSOA  JOIN PLANO_CONTA PC ON PC.ID_PLANO_CONTA = GCP.ID_PC_ANTEC_ATIVO  JOIN COMPLEMENTO  C ON C.ID_COMPLEMENTO  = P.ID_COMPLEMENTO  WHERE       RPAD(SUBSTRING (PC.CODIGO FROM 1 FOR 5), 10, '0') = :CONTA_SINTETICA  AND C.CNPJ LIKE :CNPJ_FORNECEDOR";
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery query = s.createSQLQuery(q);
        query.setString("CNPJ_FORNECEDOR", cnpj + "%");
        query.setString("CONTA_SINTETICA", contaSintetica);
        query.setMaxResults(1);
        Integer idPlanoConta = (Integer)query.uniqueResult();
        if (idPlanoConta != null) {
            PlanoConta planoConta = (PlanoConta)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOPlanoConta(), idPlanoConta.longValue());
            return planoConta;
        }
        return null;
    }

    public PlanoConta findPlanoContaExistenteAdiantamentoCliente(String cnpj, String contaSintetica) throws ExceptionService {
        String q = "SELECT PC.ID_PLANO_CONTA  FROM CLIENTE      C  JOIN PESSOA       P ON P.ID_PESSOA       = C.ID_PESSOA  JOIN GERACAO_CONTA_PESSOA G ON G.ID_PESSOA = P.ID_PESSOA JOIN PLANO_CONTA PC ON PC.ID_PLANO_CONTA = G.ID_PC_ANTEC_ATIVO  JOIN COMPLEMENTO CO ON CO.ID_COMPLEMENTO = P.ID_COMPLEMENTO  WHERE       RPAD(SUBSTRING (PC.CODIGO FROM 1 FOR 5), 10, '0') = :CONTA_SINTETICA  AND CO.CNPJ LIKE :CNPJ_CLIENTE";
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery query = s.createSQLQuery(q);
        query.setString("CNPJ_CLIENTE", cnpj + "%");
        query.setString("CONTA_SINTETICA", contaSintetica);
        query.setMaxResults(1);
        Integer idPlanoConta = (Integer)query.uniqueResult();
        if (idPlanoConta != null) {
            PlanoConta planoConta = (PlanoConta)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOPlanoConta(), idPlanoConta.longValue());
            return planoConta;
        }
        return null;
    }

    private PlanoConta getPlanoContaClientes(String aux, String cnpj, OpcoesContabeis opcoesContabeis) throws ExceptionService {
        PlanoConta planoConta = null;
        if (planoConta == null) {
            if (cnpj != null && !cnpj.isEmpty()) {
                planoConta = this.findPlanoContaExistenteCliente(cnpj);
            }
            if (planoConta != null && opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaCliente() != null && aux.equals(opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaCliente().getCodigo())) {
                return planoConta;
            }
        }
        if ((planoConta = null) == null) {
            if (cnpj != null && !cnpj.isEmpty()) {
                planoConta = this.findPlanoContaExistenteFornecedor(cnpj);
            }
            if (planoConta != null && opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaFornecedor() != null && aux.equals(opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaFornecedor().getCodigo())) {
                return planoConta;
            }
        }
        if ((planoConta = null) == null) {
            if (cnpj != null && !cnpj.isEmpty()) {
                planoConta = this.findPlanoContaExistenteInstFinanceira(cnpj);
            }
            if (planoConta != null && opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaInstFinanceira() != null && aux.equals(opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaInstFinanceira().getCodigo())) {
                return planoConta;
            }
        }
        if ((planoConta = null) == null) {
            if (cnpj != null && !cnpj.isEmpty()) {
                planoConta = this.findPlanoContaExistenteRepresentante(cnpj);
            }
            if (planoConta != null && opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaRepresentante() != null && aux.equals(opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaRepresentante().getCodigo())) {
                return planoConta;
            }
        }
        if ((planoConta = null) == null) {
            if (cnpj != null && !cnpj.isEmpty()) {
                planoConta = this.findPlanoContaExistenteTransportador(cnpj);
            }
            if (planoConta != null && opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaTransportador() != null && aux.equals(opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaTransportador().getCodigo())) {
                return planoConta;
            }
        }
        if ((planoConta = null) == null) {
            if (cnpj != null && !cnpj.isEmpty()) {
                planoConta = this.findPlanoContaExistenteAdiantamentoFornecedor(cnpj, aux);
            }
            if (planoConta != null && opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoAntecipFornecedor() != null && aux.equals(opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoAntecipFornecedor().getCodigo())) {
                return planoConta;
            }
        }
        if ((planoConta = null) == null) {
            if (cnpj != null && !cnpj.isEmpty()) {
                planoConta = this.findPlanoContaExistenteAdiantamentoCliente(cnpj, aux);
            }
            if (planoConta != null && opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoAntecipCliente() != null && aux.equals(opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoAntecipCliente().getCodigo())) {
                return planoConta;
            }
        }
        return planoConta;
    }

    private DeParaNaturezaOpPC getNaturezaOperacaoPC(String codigo) {
        String aux;
        ServiceDeParaNaturezaOpPC serviceDePara = (ServiceDeParaNaturezaOpPC)ConfApplicationContext.getBean(ServiceDeParaNaturezaOpPC.class);
        StringBuilder sb = new StringBuilder(codigo);
        DeParaNaturezaOpPC found = null;
        for (int i = 0; i < sb.length() && (found = serviceDePara.getDeParaNaturezaOpPC(aux = sb.substring(0, sb.length() - i))) == null; ++i) {
        }
        return found;
    }

    public PlanoConta gerarNovoPlanoContaAntecipacaoFornecedor(PlanoConta planoConta, String cnpj, String descricao, OpcoesContabeis opcoesContabeis) throws ExceptionService, ExceptionDatabase {
        return this.gerarNovoPlanoConta(planoConta, cnpj, descricao, opcoesContabeis);
    }

    public PlanoConta gerarNovoPlanoContaAntecipacaoCliente(PlanoConta planoConta, String cnpj, String descricao, OpcoesContabeis opcoesContabeis) throws ExceptionService, ExceptionDatabase {
        return this.gerarNovoPlanoConta(planoConta, cnpj, descricao, opcoesContabeis);
    }
}

