/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.planoconta;

import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilGerarListagemPlanoContas {
    public JasperPrint gerarListagemPlanoConta(Integer grauConta, Integer ordem, String contaInicial, String contaFinal, String fecho, Integer folha, HashMap params, Nodo nodo) throws ExceptionService {
        params.put("FECHO", fecho);
        params.put("FOLHA", folha);
        List contas = this.getPlanoContasParaListagem(grauConta, ordem, contaInicial, contaFinal);
        CoreRequestContext relatorio = new CoreRequestContext();
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", params).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        relatorio.setAttribute("path", this.getPath());
        relatorio.setAttribute("parametros", params);
        relatorio.setAttribute("dados", contas);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    public List getPlanoContasParaListagem(Integer grauConta, Integer ordem, String contaInicial, String contaFinal) {
        String orderBy = " left(pc.codigo,5), pc.marca, pc.descricao";
        Object defaultQuery = " select  pc.codigo as codigo,  pc.marca as marca,  pc.reduzida as reduzida,  pc.seq as seq,  pc.data_cadastro as data_cadastro,  pc.id_plano_conta as id_plano_conta,  pc.id_emp as id_emp,  pc.descricao as descricao,  n.descricao as natureza from PLANO_CONTA PC  left join natureza_operacao_pc n on n.id_natureza_operacao_pc = pc.id_natureza_operacao  where ";
        switch (grauConta) {
            case 1: {
                defaultQuery = (String)defaultQuery + " substring(PC.codigo from 2 for 10)  like '000000000' and ";
                break;
            }
            case 2: {
                defaultQuery = (String)defaultQuery + " substring(PC.codigo from 3 for 10)  like '00000000' and ";
                break;
            }
            case 3: {
                defaultQuery = (String)defaultQuery + " substring(PC.codigo from 4 for 10)  like '0000000' and ";
                break;
            }
            case 4: {
                defaultQuery = (String)defaultQuery + " substring(PC.codigo from 6 for 10)  like '00000' and ";
                break;
            }
            case 5: {
                orderBy = ordem == 1 ? " left(pc.codigo,5), pc.marca, pc.descricao " : " pc.codigo ";
            }
        }
        defaultQuery = (String)defaultQuery + " pc.codigo between :cod1 and :cod2 ";
        defaultQuery = (String)defaultQuery + " order by " + orderBy;
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery((String)defaultQuery);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        q.setString("cod1", contaInicial);
        q.setString("cod2", contaFinal);
        return q.list();
    }

    private String getPath() {
        return CoreUtilityFactory.getUtilityJasperReports().getPathReports() + "cadastros" + File.separator + "controladoria" + File.separator + "gestaocontabilidade" + File.separator + "planocontas" + File.separator + "listagemplanocontas" + File.separator + "LISTAGEM_PLANO_CONTA.jasper";
    }
}

