/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.planomanutencaoativo;

import com.touchcomp.basementor.model.vo.AtivoDataUltimaManutencao;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.GeracaoOrdemServicoPlanoManutencao;
import com.touchcomp.basementor.model.vo.LocalizacaoAtivo;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesManutencEquip;
import com.touchcomp.basementor.model.vo.OrdemServicoAlteracaoDataProgramacao;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivo;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivoAtivo;
import com.touchcomp.basementor.model.vo.SetorExecutante;
import com.touchcomp.basementor.model.vo.TipoPontoControle;
import com.touchcomp.basementor.model.vo.TipoPontoControleAtivo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.service.impl.coleta.ServiceColetaImpl;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.ordemservico.UtilReservarEstoqueOS;
import mentorcore.service.impl.planomanutencaoativo.UtilPlanoManutencaoAtivo;
import net.sf.jasperreports.engine.JasperPrint;

public class ServicePlanoManutencaoAtivo
extends CoreService {
    public static final String FIND_PLANO_MANUTENCAO_ACUMULATIVO = "findPlanoManutencaoAcumulativo";
    public static final String FIND_PLANO_MANUTENCAO_EXCEDIDO = "findPlanoManutencaoExcedido";
    public static final String GERAR_ORDEM_SERVICO_POR_PLANO = "gerarOrdemServicoPorPlano";
    public static final String SALVAR_GERACAO = "salvarGeracao";
    public static final String GET_ULTIMA_DATA_MANUTENCAO = "getUltimaDataManutencao";
    public static final String DELETE_GERACAO = "deleteGeracao";
    public static final String BUILD_PLANO_MANUTENCAO_ATIVO_ATIVO = "buildPlanoManutencaoAtivoAtivo";
    public static final String FIND_COLETA_LIMITE = "findColetaLimite";
    public static final String GERAR_LISTAGEM_PLANO_MANUTENCAO = "gerarListagemPlanoManutencao";

    public List<PlanoManutencaoAtivo> findPlanoManutencaoAcumulativo(CoreRequestContext request) throws ExceptionService {
        Equipamento ativo = (Equipamento)request.getAttribute("ativo");
        TipoPontoControle tipoPontoControle = (TipoPontoControle)request.getAttribute("tipoPontoControle");
        return UtilPlanoManutencaoAtivo.findPlanoManutencaoAcumulativo(ativo, tipoPontoControle);
    }

    public List<PlanoManutencaoAtivoAtivo> findPlanoManutencaoExcedido(CoreRequestContext request) throws ExceptionService {
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        SetorExecutante setorExecutante = (SetorExecutante)request.getAttribute("setorExecutante");
        LocalizacaoAtivo localizacaoAtivo = (LocalizacaoAtivo)request.getAttribute("localizacaoAtivo");
        Empresa empresaLogada = (Empresa)request.getAttribute("empresaLogada");
        Short opcaoPesquisa = (Short)request.getAttribute("opcaoPesquisa");
        Short gerarOSAtivoNaoExisteOS = (Short)request.getAttribute("gerarOSAtivoNaoExisteOS");
        return UtilPlanoManutencaoAtivo.findPlanoManutencaoExcedido(dataInicial, dataFinal, setorExecutante, localizacaoAtivo, empresaLogada, opcaoPesquisa, gerarOSAtivoNaoExisteOS);
    }

    public List<OrdemServicoAlteracaoDataProgramacao> gerarOrdemServicoPorPlano(CoreRequestContext request) throws ExceptionService {
        List planoManutencaoAtivoAtivo = (List)request.getAttribute("planoManutencaoAtivoAtivo");
        Short opcaoPesquisa = (Short)request.getAttribute("opcaoPesquisa");
        OpcoesManutencEquip opcoes = (OpcoesManutencEquip)request.getAttribute("opcoesManutencao");
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        Pessoa solicitante = (Pessoa)request.getAttribute("solicitante");
        Pessoa responsavel = (Pessoa)request.getAttribute("responsavel");
        return UtilPlanoManutencaoAtivo.gerarOrdemServicoPorPlano(planoManutencaoAtivoAtivo, opcaoPesquisa, dataInicial, dataFinal, opcoes, solicitante, responsavel);
    }

    public GeracaoOrdemServicoPlanoManutencao salvarGeracao(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        GeracaoOrdemServicoPlanoManutencao geracaoOrdemServicoPlanoManutencao = (GeracaoOrdemServicoPlanoManutencao)request.getAttribute("geracaoOrdemServicoPlanoManutencao");
        CentroEstoque centroEstoqueReserva = (CentroEstoque)request.getAttribute("centroEstoqueReserva");
        Short gerarNecessidadeCompra = (Short)request.getAttribute("gerarNecessidadeCompra");
        Usuario usuario = (Usuario)request.getAttribute("usuario");
        OpcoesCompraSuprimentos op = (OpcoesCompraSuprimentos)request.getAttribute("opcoesCompraSuprimentos");
        ServiceColetaImpl service = this.getBean(ServiceColetaImpl.class);
        for (OrdemServicoAlteracaoDataProgramacao ordemServicoAlteracao : geracaoOrdemServicoPlanoManutencao.getOrdemServicoAlteracaoDataProgramacao()) {
            List planos = ordemServicoAlteracao.getOrdemServico().getPlanosManutencaoAtivo();
            for (PlanoManutencaoAtivo plano : planos) {
                for (AtivoDataUltimaManutencao at : plano.getAtivos()) {
                    if (!ordemServicoAlteracao.getOrdemServico().getEquipamento().equals((Object)at.getAtivo()) || !plano.getTipoControle().getIdentificador().equals(1L)) continue;
                    for (TipoPontoControleAtivo tipoPontoControleAtivo : ordemServicoAlteracao.getOrdemServico().getEquipamento().getTipoPontoControleAtivo()) {
                        Coleta ultimaColeta = service.findColetaAnterior(ordemServicoAlteracao.getOrdemServico().getEquipamento(), tipoPontoControleAtivo.getTipoPontoControle());
                        if (ultimaColeta == null || !ultimaColeta.getTipoPontoControle().equals((Object)tipoPontoControleAtivo.getTipoPontoControle())) continue;
                        ordemServicoAlteracao.getOrdemServico().setColeta(ultimaColeta);
                        at.setValorAcumulado(Integer.valueOf(0));
                    }
                }
            }
            new UtilReservarEstoqueOS().reservarEstoque(ordemServicoAlteracao.getOrdemServico(), centroEstoqueReserva, usuario, gerarNecessidadeCompra, op);
        }
        return UtilPlanoManutencaoAtivo.salvarGeracao(geracaoOrdemServicoPlanoManutencao);
    }

    public Timestamp getUltimaDataManutencao(CoreRequestContext request) throws ExceptionService {
        PlanoManutencaoAtivo planoManutencaoAtivo = (PlanoManutencaoAtivo)request.getAttribute("planoManutencaoAtivo");
        Equipamento ativo = (Equipamento)request.getAttribute("ativo");
        Short opcaoPesquisa = (Short)request.getAttribute("opcaoPesquisa");
        return CoreDAOFactory.getInstance().getDAOEquipamento().getUltimaDataManutencao(planoManutencaoAtivo, ativo, opcaoPesquisa);
    }

    public void deleteGeracao(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        GeracaoOrdemServicoPlanoManutencao geracaoOrdemServicoPlanoManutencao = (GeracaoOrdemServicoPlanoManutencao)request.getAttribute("geracaoOrdemServicoPlanoManutencao");
        UtilPlanoManutencaoAtivo.deleteGeracao(geracaoOrdemServicoPlanoManutencao);
    }

    public List<PlanoManutencaoAtivoAtivo> buildPlanoManutencaoAtivoAtivo(CoreRequestContext request) throws ExceptionService {
        List planosAcumulativos = (List)request.getAttribute("planosAcumulativos");
        List planosPeriodicos = (List)request.getAttribute("planosPeriodicos");
        List planosSobDemanda = (List)request.getAttribute("planosSobDemanda");
        Empresa empresaLogada = (Empresa)request.getAttribute("empresaLogada");
        Short opcaoPesquisa = (Short)request.getAttribute("opcaoPesquisa");
        Boolean validar = (Boolean)request.getAttribute("validar");
        Short gerarOSAtivoNaoExisteOS = (Short)request.getAttribute("gerarOSAtivoNaoExisteOS");
        return UtilPlanoManutencaoAtivo.buildPlanoManutencaoAtivoAtivo(planosAcumulativos, planosPeriodicos, planosSobDemanda, empresaLogada, null, null, null, validar, opcaoPesquisa, gerarOSAtivoNaoExisteOS);
    }

    public Coleta findColetaLimite(CoreRequestContext request) throws ExceptionService {
        Equipamento ativo = (Equipamento)request.getAttribute("ativo");
        TipoPontoControle tipoPontoControle = (TipoPontoControle)request.getAttribute("tipoPontoControle");
        PlanoManutencaoAtivo planoManutencaoAtivo = (PlanoManutencaoAtivo)request.getAttribute("planoManutencaoAtivo");
        return UtilPlanoManutencaoAtivo.findColetaLimite(ativo, tipoPontoControle, planoManutencaoAtivo);
    }

    public JasperPrint gerarListagemPlanoManutencao(CoreRequestContext request) throws ExceptionService {
        Short tipoPontoControle = (Short)request.getAttribute("TIPO_CONTROLE");
        Short filtrarPlanoManutencaoAtivo = (Short)request.getAttribute("FILTRAR_PLANO_MANUTENCAO_ATIVO");
        Long planoManutencaoAtivoInicial = (Long)request.getAttribute("PLANO_MANUTENCAO_ATIVO_INICIAL");
        Long planoManutencaoAtivoFinal = (Long)request.getAttribute("PLANO_MANUTENCAO_ATIVO_FINAL");
        Short filtrarAtivo = (Short)request.getAttribute("FILTRAR_ATIVO");
        Long ativoInicial = (Long)request.getAttribute("ATIVO_INICIAL");
        Long ativoFinal = (Long)request.getAttribute("ATIVO_FINAL");
        Short filtrarEmpresa = (Short)request.getAttribute("FILTRAR_EMPRESA");
        Long empresaInicial = (Long)request.getAttribute("EMPRESA_INICIAL");
        Long empresaFinal = (Long)request.getAttribute("EMPRESA_FINAL");
        Short filtrarTipoServico = (Short)request.getAttribute("FILTRAR_TIPO_SERVICO");
        Long tipoServicoInicial = (Long)request.getAttribute("TIPO_SERVICO_INICIAL");
        Long tipoServicoFinal = (Long)request.getAttribute("TIPO_SERVICO_FINAL");
        Short filtrarSetorExecutante = (Short)request.getAttribute("FILTRAR_SETOR_EXECUTANTE");
        Long setorExecutanteInicial = (Long)request.getAttribute("SETOR_EXECUTANTE_INICIAL");
        Long setorExecutanteFinal = (Long)request.getAttribute("SETOR_EXECUTANTE_FINAL");
        Short exibirDetalhesPlano = (Short)request.getAttribute("EXIBIR_DETALHES");
        Short nivelDetalhamento = (Short)request.getAttribute("NIVEL_DETALHAMENTO");
        String fecho = (String)request.getAttribute("FECHO");
        Nodo nodo = (Nodo)request.getAttribute("NODO");
        HashMap defaultParams = (HashMap)request.getAttribute("DEFAULT_PARAMS");
        return UtilPlanoManutencaoAtivo.gerarListagemPlanoManutencao(tipoPontoControle, filtrarPlanoManutencaoAtivo, planoManutencaoAtivoInicial, planoManutencaoAtivoFinal, filtrarAtivo, ativoInicial, ativoFinal, filtrarEmpresa, empresaInicial, empresaFinal, filtrarTipoServico, tipoServicoInicial, tipoServicoFinal, filtrarSetorExecutante, setorExecutanteInicial, setorExecutanteFinal, exibirDetalhesPlano, nivelDetalhamento, fecho, nodo, defaultParams);
    }
}

