/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.planomanutencaoativo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.opcoesmanutencaoativos.EnumConstGerarDiagnosticoFechamento;
import com.touchcomp.basementor.constants.enums.ordemservico.EnumConstStatusOrdemServico;
import com.touchcomp.basementor.model.vo.AtivoDataUltimaManutencao;
import com.touchcomp.basementor.model.vo.AtivoTipoPontoControle;
import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.CronogramaOrdemServico;
import com.touchcomp.basementor.model.vo.CronogramaPlanoManutencaoAtivo;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivo;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoItens;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoServProc;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoServico;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.GeracaoOrdemServicoPlanoManutencao;
import com.touchcomp.basementor.model.vo.LocalizacaoAtivo;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.OpcoesManutencEquip;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.OrdemServicoAlteracaoDataProgramacao;
import com.touchcomp.basementor.model.vo.OrdemServicoNecMateriais;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivo;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivoAtivo;
import com.touchcomp.basementor.model.vo.PreProcedimento;
import com.touchcomp.basementor.model.vo.PreProdutoPrevManutencao;
import com.touchcomp.basementor.model.vo.PreServicoProcedimento;
import com.touchcomp.basementor.model.vo.Procedimento;
import com.touchcomp.basementor.model.vo.ProdutoPrevManutencao;
import com.touchcomp.basementor.model.vo.ServicoProcedimento;
import com.touchcomp.basementor.model.vo.SetorExecutante;
import com.touchcomp.basementor.model.vo.SetorExecutanteServicos;
import com.touchcomp.basementor.model.vo.TipoPontoControle;
import com.touchcomp.basementorservice.service.impl.coleta.ServiceColetaImpl;
import com.touchcomp.basementorservice.service.impl.ordemservico.ServiceOrdemServicoImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilPlanoManutencaoAtivo {
    private static final ServiceOrdemServicoImpl serviceOrdemServicoImpl = (ServiceOrdemServicoImpl)Context.get(ServiceOrdemServicoImpl.class);

    UtilPlanoManutencaoAtivo() {
    }

    static List<PlanoManutencaoAtivoAtivo> findPlanoManutencaoExcedido(Date dataInicial, Date dataFinal, SetorExecutante setorExecutante, LocalizacaoAtivo localizacaoAtivo, Empresa empresaLogada, Short opcaoPesquisa, Short gerarOSAtivoNaoExisteOS) throws ExceptionService {
        if (dataInicial != null) {
            dataInicial = UtilPlanoManutencaoAtivo.dateMaxMinTime(dataInicial, false);
            dataFinal = UtilPlanoManutencaoAtivo.dateMaxMinTime(dataFinal, true);
        }
        List<PlanoManutencaoAtivo> planosAcumulativos = UtilPlanoManutencaoAtivo.getPlanoManutencaoAcumulativos(setorExecutante, empresaLogada, localizacaoAtivo);
        List<PlanoManutencaoAtivo> planosPeriodicos = UtilPlanoManutencaoAtivo.getPlanoManutencaoPeriodicos(dataInicial, dataFinal, setorExecutante, localizacaoAtivo, empresaLogada, opcaoPesquisa);
        return UtilPlanoManutencaoAtivo.clearPlanosSemAtivo(UtilPlanoManutencaoAtivo.buildPlanoManutencaoAtivoAtivo(planosAcumulativos, planosPeriodicos, new LinkedList<PlanoManutencaoAtivo>(), empresaLogada, localizacaoAtivo, dataInicial, dataFinal, true, opcaoPesquisa, gerarOSAtivoNaoExisteOS));
    }

    public static List<PlanoManutencaoAtivoAtivo> clearPlanosSemAtivo(List<PlanoManutencaoAtivoAtivo> planos) {
        ArrayList<PlanoManutencaoAtivoAtivo> toReturn = new ArrayList<PlanoManutencaoAtivoAtivo>();
        for (PlanoManutencaoAtivoAtivo planoManutencaoAtivoAtivo : planos) {
            if (planoManutencaoAtivoAtivo.getAtivoTipoPontoControle().isEmpty()) continue;
            toReturn.add(planoManutencaoAtivoAtivo);
        }
        return toReturn;
    }

    private static Date dateMaxMinTime(Date date, Boolean isMax) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (isMax.booleanValue()) {
            calendar.set(10, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
        } else {
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        }
        return calendar.getTime();
    }

    private static List<PlanoManutencaoAtivo> getPlanoManutencaoAcumulativos(SetorExecutante setorExecutante, Empresa empresaLogada, LocalizacaoAtivo localizacaoAtivo) throws ExceptionService {
        Object query = "SELECT DISTINCT p FROM PlanoManutencaoAtivo p INNER JOIN p.setorExecutantesServicos s INNER JOIN p.ativos a WHERE p.tipoControle.identificador = :acumulativo AND p.ativo = :ativo ";
        if (empresaLogada != null) {
            query = (String)query + "AND p.empresa.identificador = :idEmpresa ";
        }
        if (setorExecutante != null) {
            query = (String)query + "AND s.setorExecutante.identificador = :idSetorExecutante ";
        }
        if (localizacaoAtivo != null) {
            query = (String)query + "AND a.ativo.localizacaoAtivo.identificador = :idLocalizacaoAtivo ";
        }
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery((String)query);
        q.setShort("ativo", (short)1);
        q.setLong("acumulativo", 1L);
        if (empresaLogada != null) {
            q.setLong("idEmpresa", empresaLogada.getIdentificador().longValue());
        }
        if (setorExecutante != null) {
            q.setLong("idSetorExecutante", setorExecutante.getIdentificador().longValue());
        }
        if (localizacaoAtivo != null) {
            q.setLong("idLocalizacaoAtivo", localizacaoAtivo.getIdentificador().longValue());
        }
        List planosAcumulados = q.list();
        return UtilPlanoManutencaoAtivo.getPlanosLimitesExcedidos(planosAcumulados);
    }

    private static List<PlanoManutencaoAtivo> getPlanosLimitesExcedidos(List<PlanoManutencaoAtivo> planosAcumulados) throws ExceptionService {
        ArrayList<PlanoManutencaoAtivo> planosLimitesExcedidos = new ArrayList<PlanoManutencaoAtivo>();
        for (PlanoManutencaoAtivo planoManutencaoAtivo : planosAcumulados) {
            for (AtivoDataUltimaManutencao ativoDataUltimaManutencao : planoManutencaoAtivo.getAtivos()) {
                ServiceColetaImpl service = (ServiceColetaImpl)Context.get(ServiceColetaImpl.class);
                Coleta ultimaColeta = service.findColetaAnterior(ativoDataUltimaManutencao.getAtivo(), planoManutencaoAtivo.getTipoPontoControle());
                Integer valorUltimaManutencao = UtilPlanoManutencaoAtivo.getValorUltimaManutencao(ativoDataUltimaManutencao.getAtivo(), planoManutencaoAtivo.getTipoPontoControle(), planoManutencaoAtivo);
                if (ultimaColeta == null || ultimaColeta.getValorAcumulado() <= valorUltimaManutencao + planoManutencaoAtivo.getLimite() || planosLimitesExcedidos.contains(planoManutencaoAtivo)) continue;
                planosLimitesExcedidos.add(planoManutencaoAtivo);
            }
        }
        return planosLimitesExcedidos;
    }

    private static Integer getValorUltimaManutencao(Equipamento ativo, TipoPontoControle tipoPontoControle, PlanoManutencaoAtivo planoManutencaoAtivo) {
        String query = "SELECT a.coletaLimite.valorColeta FROM AtivoTipoPontoControle a WHERE a.ativo.identificador = :idAtivo AND a.tipoPontoControle.identificador = :idTipoPontoControle AND a.planoManutencaoAtivoAtivo.planoManutencaoAtivo.identificador = :idPlanoManutencaoAtivo AND a.identificador = (SELECT MAX(a2.identificador)                        FROM AtivoTipoPontoControle a2                        WHERE a2.ativo.identificador = :idAtivo                        AND a2.tipoPontoControle.identificador = :idTipoPontoControle                        AND a2.planoManutencaoAtivoAtivo.planoManutencaoAtivo.identificador =:idPlanoManutencaoAtivo                        )";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(query);
        q.setLong("idAtivo", ativo.getIdentificador().longValue());
        q.setLong("idTipoPontoControle", tipoPontoControle.getIdentificador().longValue());
        q.setLong("idPlanoManutencaoAtivo", planoManutencaoAtivo.getIdentificador().longValue());
        Integer valorToReturn = (Integer)q.uniqueResult();
        if (valorToReturn != null) {
            return valorToReturn;
        }
        return 0;
    }

    private static List<PlanoManutencaoAtivo> getPlanoManutencaoPeriodicos(Date dataInicial, Date dataFinal, SetorExecutante setorExecutante, LocalizacaoAtivo localizacaoAtivo, Empresa empresaLogada, Short opcaoPesquisa) {
        Object query = "SELECT DISTINCT p FROM PlanoManutencaoAtivo p INNER JOIN p.setorExecutantesServicos s INNER JOIN p.ativos a WHERE p.tipoControle.identificador = :periodico AND p.ativo = :ativo ";
        if (empresaLogada != null) {
            query = (String)query + "AND p.empresa.identificador = :idEmpresa ";
        }
        if (setorExecutante != null) {
            query = (String)query + "AND s.setorExecutante.identificador = :idSetorExecutante ";
        }
        if (localizacaoAtivo != null) {
            query = (String)query + "AND a.ativo.localizacaoAtivo.identificador =:idLocalizacaoAtivo";
        }
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery((String)query);
        q.setShort("ativo", (short)1);
        q.setLong("periodico", 2L);
        if (empresaLogada != null) {
            q.setLong("idEmpresa", empresaLogada.getIdentificador().longValue());
        }
        if (setorExecutante != null) {
            q.setLong("idSetorExecutante", setorExecutante.getIdentificador().longValue());
        }
        if (localizacaoAtivo != null) {
            q.setLong("idLocalizacaoAtivo", localizacaoAtivo.getIdentificador().longValue());
        }
        List planosPeriodicos = q.list();
        return UtilPlanoManutencaoAtivo.getPlanosPeriodicosExcedidos(planosPeriodicos, dataInicial, dataFinal, opcaoPesquisa);
    }

    private static List<PlanoManutencaoAtivo> getPlanosPeriodicosExcedidos(List<PlanoManutencaoAtivo> planosPeriodicos, Date dataInicial, Date dataFinal, Short opcaoPesquisa) {
        ArrayList<PlanoManutencaoAtivo> planosExcedidos = new ArrayList<PlanoManutencaoAtivo>();
        if (dataInicial == null) {
            for (PlanoManutencaoAtivo planoManutencaoAtivo : planosPeriodicos) {
                for (AtivoDataUltimaManutencao ativoDataUltimaManutencao : planoManutencaoAtivo.getAtivos()) {
                    Timestamp dataUltimaManutencao = CoreDAOFactory.getInstance().getDAOEquipamento().getUltimaDataManutencao(planoManutencaoAtivo, ativoDataUltimaManutencao.getAtivo(), opcaoPesquisa);
                    if (dataUltimaManutencao == null) {
                        dataUltimaManutencao = ativoDataUltimaManutencao.getDataUltimaManutencao();
                    }
                    if (!DateUtil.dataSemHora(new Date()).after(DateUtil.nextDays(DateUtil.dataSemHora(dataUltimaManutencao), planoManutencaoAtivo.getPeriodicidade())) && !DateUtil.dataSemHora(new Date()).equals(DateUtil.nextDays(DateUtil.dataSemHora(dataUltimaManutencao), planoManutencaoAtivo.getPeriodicidade())) || planosExcedidos.contains(planoManutencaoAtivo)) continue;
                    planosExcedidos.add(planoManutencaoAtivo);
                }
            }
        } else {
            for (PlanoManutencaoAtivo planoManutencaoAtivo : planosPeriodicos) {
                for (AtivoDataUltimaManutencao ativoDataUltimaManutencao : planoManutencaoAtivo.getAtivos()) {
                    Date dataUltimaManutencao = CoreDAOFactory.getInstance().getDAOEquipamento().getUltimaDataManutencao(planoManutencaoAtivo, ativoDataUltimaManutencao.getAtivo(), opcaoPesquisa);
                    dataUltimaManutencao = DateUtil.nextDays(DateUtil.dataSemHora(UtilPlanoManutencaoAtivo.getDateUltimaManutencao(ativoDataUltimaManutencao, dataUltimaManutencao)), planoManutencaoAtivo.getPeriodicidade());
                    if (planosExcedidos.contains(planoManutencaoAtivo) || !UtilPlanoManutencaoAtivo.verificaIntevaloDataUltimaManutencao(dataUltimaManutencao, dataInicial, dataFinal, planoManutencaoAtivo.getPeriodicidade()).booleanValue()) continue;
                    planosExcedidos.add(planoManutencaoAtivo);
                }
            }
        }
        return planosExcedidos;
    }

    private static Boolean dateBetween(Date date, Date inicialTarget, Date finalTarget) {
        if ((date.equals(inicialTarget) || date.after(inicialTarget)) && (date.equals(finalTarget) || date.before(finalTarget))) {
            return true;
        }
        return false;
    }

    static List<PlanoManutencaoAtivoAtivo> buildPlanoManutencaoAtivoAtivo(List<PlanoManutencaoAtivo> planosAcumulativos, List<PlanoManutencaoAtivo> planosPeriodicos, List<PlanoManutencaoAtivo> planosSobDemanda, Empresa empresaLogada, LocalizacaoAtivo localizacaoAtivo, Date dataInicial, Date dataFinal, Boolean validar, Short opcaoPesquisa, Short gerarOSAtivoNaoExisteOS) throws ExceptionService {
        List<PlanoManutencaoAtivoAtivo> planosToReturn = new ArrayList<PlanoManutencaoAtivoAtivo>();
        for (PlanoManutencaoAtivo planoManutencaoAtivo : planosAcumulativos) {
            planosToReturn.add(UtilPlanoManutencaoAtivo.buildPlanoManutencaoAtivoAtivoInternal(planoManutencaoAtivo, empresaLogada, localizacaoAtivo, dataInicial, dataFinal, validar, opcaoPesquisa, true, gerarOSAtivoNaoExisteOS));
        }
        for (PlanoManutencaoAtivo planoManutencaoAtivo : planosPeriodicos) {
            planosToReturn.add(UtilPlanoManutencaoAtivo.buildPlanoManutencaoAtivoAtivoInternal(planoManutencaoAtivo, empresaLogada, localizacaoAtivo, dataInicial, dataFinal, validar, opcaoPesquisa, true, gerarOSAtivoNaoExisteOS));
        }
        planosToReturn = UtilPlanoManutencaoAtivo.clearPlanosSemAtivo(planosToReturn);
        for (PlanoManutencaoAtivo planoManutencaoAtivo : planosSobDemanda) {
            planosToReturn.add(UtilPlanoManutencaoAtivo.buildPlanoManutencaoAtivoAtivoInternal(planoManutencaoAtivo, empresaLogada, localizacaoAtivo, dataInicial, dataFinal, validar, opcaoPesquisa, false, gerarOSAtivoNaoExisteOS));
        }
        return planosToReturn;
    }

    private static PlanoManutencaoAtivoAtivo buildPlanoManutencaoAtivoAtivoInternal(PlanoManutencaoAtivo planoManutencaoAtivo, Empresa empresaLogada, LocalizacaoAtivo localizacaoAtivo, Date dataInicial, Date dataFinal, Boolean validar, Short opcaoPesquisa, boolean setTipoPontoControle, Short gerarOSAtivoNaoExisteOS) throws ExceptionService {
        PlanoManutencaoAtivoAtivo newPlanoManutencaoAtivoAtivo = new PlanoManutencaoAtivoAtivo();
        newPlanoManutencaoAtivoAtivo.setDataCadastro(new Date());
        newPlanoManutencaoAtivoAtivo.setEmpresa(empresaLogada);
        newPlanoManutencaoAtivoAtivo.setPlanoManutencaoAtivo(planoManutencaoAtivo);
        if (setTipoPontoControle) {
            newPlanoManutencaoAtivoAtivo.getAtivoTipoPontoControle().addAll(UtilPlanoManutencaoAtivo.getAtivoTipoPontoControle(planoManutencaoAtivo, empresaLogada, localizacaoAtivo, newPlanoManutencaoAtivoAtivo, dataInicial, dataFinal, validar, opcaoPesquisa, gerarOSAtivoNaoExisteOS));
        }
        return newPlanoManutencaoAtivoAtivo;
    }

    private static List<AtivoTipoPontoControle> getAtivoTipoPontoControle(PlanoManutencaoAtivo planoManutencaoAtivo, Empresa empresaLogada, LocalizacaoAtivo localizacaoAtivo, PlanoManutencaoAtivoAtivo newPlanoManutencaoAtivoAtivo, Date dataInicial, Date dataFinal, Boolean validar, Short opcaoPesquisa, Short gerarOSAtivoNaoExisteOS) throws ExceptionService {
        ArrayList<AtivoTipoPontoControle> toReturn = new ArrayList<AtivoTipoPontoControle>();
        for (AtivoDataUltimaManutencao ativoDataUltimaManutencao : planoManutencaoAtivo.getAtivos()) {
            if (!ToolMethods.isEquals((Object)gerarOSAtivoNaoExisteOS, (Object)EnumConstantsMentorSimNao.NAO.value) && (!ToolMethods.isEquals((Object)gerarOSAtivoNaoExisteOS, (Object)EnumConstantsMentorSimNao.SIM.value) || !UtilPlanoManutencaoAtivo.validarOSAtivoPlanoMan(empresaLogada, planoManutencaoAtivo, ativoDataUltimaManutencao.getAtivo()))) continue;
            AtivoTipoPontoControle ativoTipoPontoControle = new AtivoTipoPontoControle();
            ativoTipoPontoControle.setEmpresa(empresaLogada);
            ativoTipoPontoControle.setDataCadastro(new Date());
            ativoTipoPontoControle.setPlanoManutencaoAtivoAtivo(newPlanoManutencaoAtivoAtivo);
            ativoTipoPontoControle.setAtivo(ativoDataUltimaManutencao.getAtivo());
            ativoTipoPontoControle.setTipoPontoControle(planoManutencaoAtivo.getTipoPontoControle());
            if (planoManutencaoAtivo.getTipoPontoControle() != null) {
                ServiceColetaImpl service = (ServiceColetaImpl)Context.get(ServiceColetaImpl.class);
                Coleta ultimaColeta = service.findColetaAnterior(ativoDataUltimaManutencao.getAtivo(), planoManutencaoAtivo.getTipoPontoControle());
                ativoTipoPontoControle.setColetaLimite(ultimaColeta);
            }
            if (planoManutencaoAtivo.getTipoControle().getIdentificador() == 2L && (!validar.booleanValue() || UtilPlanoManutencaoAtivo.isValidPeriodico(planoManutencaoAtivo, ativoDataUltimaManutencao, localizacaoAtivo, dataInicial, dataFinal, opcaoPesquisa))) {
                if (toReturn.contains(ativoTipoPontoControle)) continue;
                toReturn.add(ativoTipoPontoControle);
                continue;
            }
            if (planoManutencaoAtivo.getTipoControle().getIdentificador() == 1L && (!validar.booleanValue() || UtilPlanoManutencaoAtivo.isValidAcumulativo(planoManutencaoAtivo, ativoDataUltimaManutencao, localizacaoAtivo, ativoTipoPontoControle))) {
                if (toReturn.contains(ativoTipoPontoControle)) continue;
                toReturn.add(ativoTipoPontoControle);
                continue;
            }
            if (planoManutencaoAtivo.getTipoControle().getIdentificador() != 3L || toReturn.contains(ativoTipoPontoControle)) continue;
            toReturn.add(ativoTipoPontoControle);
        }
        return toReturn;
    }

    private static boolean validarOSAtivoPlanoMan(Empresa empresa, PlanoManutencaoAtivo planoManutencaoAtivo, Equipamento ativo) {
        List listOrdemServico = serviceOrdemServicoImpl.pesquisarOrdemServicoEmpresaAtivoStatusPlanoManAtivo(empresa, ativo, Short.valueOf(EnumConstStatusOrdemServico.ABERTO.getValue()), planoManutencaoAtivo);
        return listOrdemServico == null || listOrdemServico.isEmpty();
    }

    private static Boolean existsOsAberta(Equipamento ativo, PlanoManutencaoAtivo plano) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT os.identificador FROM OrdemServico os INNER JOIN os.planosManutencaoAtivo plano WHERE os.equipamento.identificador = :idAtivo AND plano.identificador = :idPlano AND os.status = :aberta ";
        Query q = s.createQuery(query);
        s.createQuery(query);
        q.setLong("idAtivo", ativo.getIdentificador().longValue());
        q.setLong("idPlano", plano.getIdentificador().longValue());
        q.setShort("aberta", EnumConstStatusOrdemServico.ABERTO.getValue());
        return !q.list().isEmpty();
    }

    private static boolean isValidPeriodico(PlanoManutencaoAtivo planoManutencaoAtivo, AtivoDataUltimaManutencao ativoDataUltimaManutencao, LocalizacaoAtivo localizacaoAtivo, Date dataInicial, Date dataFinal, Short opcaoPesquisa) {
        Timestamp dataUltimaManutencao = CoreDAOFactory.getInstance().getDAOEquipamento().getUltimaDataManutencao(planoManutencaoAtivo, ativoDataUltimaManutencao.getAtivo(), opcaoPesquisa);
        if (dataUltimaManutencao == null) {
            dataUltimaManutencao = ativoDataUltimaManutencao.getDataUltimaManutencao();
        }
        return dataInicial == null ? !(!DateUtil.dataSemHora(new Date()).after(DateUtil.nextDays(DateUtil.dataSemHora(dataUltimaManutencao), planoManutencaoAtivo.getPeriodicidade())) && !DateUtil.dataSemHora(new Date()).equals(DateUtil.nextDays(DateUtil.dataSemHora(dataUltimaManutencao), planoManutencaoAtivo.getPeriodicidade())) || localizacaoAtivo != null && !localizacaoAtivo.equals((Object)ativoDataUltimaManutencao.getAtivo().getLocalizacaoAtivo())) : UtilPlanoManutencaoAtivo.verificaIntevaloDataUltimaManutencao(dataUltimaManutencao, dataInicial, dataFinal, planoManutencaoAtivo.getPeriodicidade()) != false && (localizacaoAtivo == null || localizacaoAtivo.equals((Object)ativoDataUltimaManutencao.getAtivo().getLocalizacaoAtivo()));
    }

    private static boolean isValidAcumulativo(PlanoManutencaoAtivo planoManutencaoAtivo, AtivoDataUltimaManutencao ativoDataUltimaManutencao, LocalizacaoAtivo localizacaoAtivo, AtivoTipoPontoControle ativoTipoPontoControle) throws ExceptionService {
        ServiceColetaImpl service = (ServiceColetaImpl)Context.get(ServiceColetaImpl.class);
        Coleta ultimaColeta = service.findColetaAnterior(ativoDataUltimaManutencao.getAtivo(), planoManutencaoAtivo.getTipoPontoControle());
        if (ultimaColeta == null) {
            return false;
        }
        if (ativoDataUltimaManutencao.getValorAcumulado() >= planoManutencaoAtivo.getLimite()) {
            ativoTipoPontoControle.setTipoPontoControle(ultimaColeta.getTipoPontoControle());
            ativoTipoPontoControle.setColetaLimite(ultimaColeta);
            return true;
        }
        return false;
    }

    static List<OrdemServicoAlteracaoDataProgramacao> gerarOrdemServicoPorPlano(List<PlanoManutencaoAtivoAtivo> planosManutencaoAtivoAtivo, Short opcaoPesquisa, Date dataInicial, Date dataFinal, OpcoesManutencEquip op, Pessoa solicitante, Pessoa responsavel) {
        List<OrdemServicoAlteracaoDataProgramacao> ordensServicoGeradas = new ArrayList<OrdemServicoAlteracaoDataProgramacao>();
        for (PlanoManutencaoAtivoAtivo planoManutencaoAtivoAtivo : planosManutencaoAtivoAtivo) {
            for (AtivoTipoPontoControle ativo1 : planoManutencaoAtivoAtivo.getAtivoTipoPontoControle()) {
                for (SetorExecutanteServicos setorExec : planoManutencaoAtivoAtivo.getPlanoManutencaoAtivo().getSetorExecutantesServicos()) {
                    ordensServicoGeradas = UtilPlanoManutencaoAtivo.getOrdemServicoAlteracaoDataProgramacao(ativo1, setorExec, ordensServicoGeradas, opcaoPesquisa, dataInicial, dataFinal, op, solicitante, responsavel);
                }
            }
        }
        return ordensServicoGeradas;
    }

    private static void setServicosOS(OrdemServicoAlteracaoDataProgramacao found, List<PreServicoProcedimento> preServicosProcedimentos) {
        Boolean achou = false;
        for (PreServicoProcedimento preServicoProcedimento : preServicosProcedimentos) {
            for (ServicoProcedimento servProcedimento : found.getOrdemServico().getFechamentoOrdemServico().getServicoProcedimentos()) {
                if (!servProcedimento.getServico().getIdentificador().equals(preServicoProcedimento.getServico().getIdentificador())) continue;
                servProcedimento.getProcedimento().addAll(UtilPlanoManutencaoAtivo.getProcedimentos(preServicoProcedimento, servProcedimento, found));
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            ServicoProcedimento servicoProcedimento = new ServicoProcedimento();
            servicoProcedimento.setDataCadastro(new Date());
            servicoProcedimento.setPreServicoProcedimento(preServicoProcedimento);
            servicoProcedimento.setEmpresa(preServicoProcedimento.getEmpresa());
            servicoProcedimento.setFechamentoOrdemServico(found.getOrdemServico().getFechamentoOrdemServico());
            servicoProcedimento.setServico(preServicoProcedimento.getServico());
            servicoProcedimento.setProcedimento(UtilPlanoManutencaoAtivo.getProcedimentos(preServicoProcedimento, servicoProcedimento, found));
            found.getOrdemServico().getFechamentoOrdemServico().getServicoProcedimentos().add(servicoProcedimento);
        }
    }

    private static List<Procedimento> getProcedimentos(PreServicoProcedimento preServicoProcedimento, ServicoProcedimento servicoProcedimento, OrdemServicoAlteracaoDataProgramacao found) {
        ArrayList<Procedimento> procedimentos = new ArrayList<Procedimento>();
        for (PreProcedimento preProcedimento : preServicoProcedimento.getPreProcedimento()) {
            Procedimento procedimento = new Procedimento();
            procedimento.setDataCadastro(new Date());
            procedimento.setDescricao(preProcedimento.getDescricao());
            procedimento.setEmpresa(preProcedimento.getEmpresa());
            procedimento.setServicoProcedimento(servicoProcedimento);
            procedimento.setPreProcedimento(preProcedimento);
            procedimento.setProdutosPrevisaoManutencao(UtilPlanoManutencaoAtivo.getProdutosPrevisaoManutencao(procedimento, preProcedimento, found));
            procedimentos.add(procedimento);
        }
        return procedimentos;
    }

    private static List<ProdutoPrevManutencao> getProdutosPrevisaoManutencao(Procedimento procedimento, PreProcedimento preProcedimento, OrdemServicoAlteracaoDataProgramacao found) {
        ArrayList<ProdutoPrevManutencao> produtosPrevManutencao = new ArrayList<ProdutoPrevManutencao>();
        ArrayList materiais = new ArrayList();
        for (PreProdutoPrevManutencao preProdutoPrevManutencao : preProcedimento.getPreProdutosPrevisaoManutencao()) {
            ProdutoPrevManutencao produtoPrevManutencao = new ProdutoPrevManutencao();
            produtoPrevManutencao.setDataCadastro(new Date());
            produtoPrevManutencao.setEmpresa(preProdutoPrevManutencao.getEmpresa());
            produtoPrevManutencao.setPreProdutoPrevManutencao(preProdutoPrevManutencao);
            produtoPrevManutencao.setProcedimento(procedimento);
            produtoPrevManutencao.setGradeCor(preProdutoPrevManutencao.getGradeCor());
            produtoPrevManutencao.setQtdPrevista(preProdutoPrevManutencao.getQtdPrevista());
            produtosPrevManutencao.add(produtoPrevManutencao);
            OrdemServicoNecMateriais necMateriais = new OrdemServicoNecMateriais();
            necMateriais.setGradeCor(preProdutoPrevManutencao.getGradeCor());
            necMateriais.setQuantidade(preProdutoPrevManutencao.getQtdPrevista());
            necMateriais.setOrdemServico(found.getOrdemServico());
            found.getOrdemServico().getOrdemServicoNecMateriais().add(necMateriais);
        }
        return produtosPrevManutencao;
    }

    private static List<OrdemServicoAlteracaoDataProgramacao> getOrdemServicoAlteracaoDataProgramacao(AtivoTipoPontoControle ativoPontoControle, SetorExecutanteServicos setorExec, List<OrdemServicoAlteracaoDataProgramacao> ordensServicoGeradas, Short opcaoPesquisa, Date dataInicial, Date dataFinal, OpcoesManutencEquip op, Pessoa solicitante, Pessoa responsavel) {
        OrdemServicoNecMateriais necMateriais = new OrdemServicoNecMateriais();
        Timestamp dataUltimaManutencao = CoreDAOFactory.getInstance().getDAOEquipamento().getUltimaDataManutencao(ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo(), ativoPontoControle.getAtivo(), opcaoPesquisa);
        ArrayList<OrdemServico> temp = new ArrayList<OrdemServico>();
        if (ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getTipoControle().getIdentificador() == 1L) {
            os = new OrdemServico();
            os.setDataEmissao((Date)ativoPontoControle.getColetaLimite().getDataHoraColeta());
            os.setDataProgramada(DateUtil.toTimestamp(os.getDataEmissao()));
            UtilPlanoManutencaoAtivo.setOutrosDadosOSAndCronograma(os, solicitante, responsavel, ativoPontoControle, setorExec);
            temp.add(os);
        } else if (ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getTipoControle().getIdentificador() == 2L) {
            if (dataUltimaManutencao != null) {
                List<Date> newDatasUltimaManutencao = UtilPlanoManutencaoAtivo.geraDataUltimaManutencaoComPeriodicidade(dataUltimaManutencao, dataInicial, dataFinal, ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getPeriodicidade());
                Iterator iterator = newDatasUltimaManutencao.iterator();
                while (iterator.hasNext()) {
                    Date newDataUltimaManutencao = (Date)iterator.next();
                    OrdemServico os = new OrdemServico();
                    os.setDataEmissao(newDataUltimaManutencao);
                    os.setDataProgramada(DateUtil.toTimestamp(os.getDataEmissao()));
                    UtilPlanoManutencaoAtivo.setOutrosDadosOSAndCronograma(os, solicitante, responsavel, ativoPontoControle, setorExec);
                    temp.add(os);
                }
            } else {
                for (AtivoDataUltimaManutencao ativoDataUltimaManutencao : ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getAtivos()) {
                    if (!ativoDataUltimaManutencao.getAtivo().equals((Object)ativoPontoControle.getAtivo())) continue;
                    List<Date> newDatasUltimaManutencao = UtilPlanoManutencaoAtivo.geraDataUltimaManutencaoComPeriodicidade(ativoDataUltimaManutencao.getDataUltimaManutencao(), dataInicial, dataFinal, ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getPeriodicidade());
                    for (Date newDataUltimaManutencao : newDatasUltimaManutencao) {
                        OrdemServico os = new OrdemServico();
                        os.setDataEmissao(newDataUltimaManutencao);
                        os.setDataProgramada(DateUtil.toTimestamp(os.getDataEmissao()));
                        UtilPlanoManutencaoAtivo.setOutrosDadosOSAndCronograma(os, solicitante, responsavel, ativoPontoControle, setorExec);
                        temp.add(os);
                    }
                }
            }
        } else if (ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getTipoControle().getIdentificador() == 3L) {
            os = new OrdemServico();
            os.setDataEmissao(new Date());
            os.setDataProgramada(DateUtil.toTimestamp(os.getDataEmissao()));
            UtilPlanoManutencaoAtivo.setOutrosDadosOSAndCronograma(os, solicitante, responsavel, ativoPontoControle, setorExec);
            temp.add(os);
        }
        for (OrdemServico os : temp) {
            OrdemServicoAlteracaoDataProgramacao ordemServicoAlteracaoDataProgramacao = new OrdemServicoAlteracaoDataProgramacao();
            ordemServicoAlteracaoDataProgramacao.setDataCadastro(new Date());
            ordemServicoAlteracaoDataProgramacao.setEmpresa(os.getEmpresa());
            ordemServicoAlteracaoDataProgramacao.setOrdemServico(os);
            ordemServicoAlteracaoDataProgramacao.setDataProgramacaoAntiga(os.getDataProgramada());
            if (os.getDataProgramada() != null) {
                ordensServicoGeradas.add(ordemServicoAlteracaoDataProgramacao);
            }
            UtilPlanoManutencaoAtivo.criarFechDiagnostico(ordemServicoAlteracaoDataProgramacao, setorExec, op);
        }
        return ordensServicoGeradas;
    }

    static GeracaoOrdemServicoPlanoManutencao salvarGeracao(GeracaoOrdemServicoPlanoManutencao vo) throws ExceptionDatabase, ExceptionService {
        UtilPlanoManutencaoAtivo.atualizaDataOs(vo.getOrdemServicoAlteracaoDataProgramacao());
        ArrayList<OrdemServicoAlteracaoDataProgramacao> ordensAlteracaoSaved = new ArrayList<OrdemServicoAlteracaoDataProgramacao>();
        GeracaoOrdemServicoPlanoManutencao geracaoToReturn = (GeracaoOrdemServicoPlanoManutencao)CoreDAOFactory.getInstance().getDAOGeracaoOrdemServicoPlanoManutencao().saveOrUpdate(vo);
        for (OrdemServicoAlteracaoDataProgramacao os : vo.getOrdemServicoAlteracaoDataProgramacao()) {
            FechamentoOrdemServico fechamento = os.getOrdemServico().getFechamentoOrdemServico();
            DiagnosticoOSAtivo diagnostico = os.getOrdemServico().getDiagnosticoOSAtivo();
            os.setGeracaoOrdemServicoPlanoManutencao(geracaoToReturn);
            OrdemServicoAlteracaoDataProgramacao osAlteracaoSaved = (OrdemServicoAlteracaoDataProgramacao)CoreDAOFactory.getInstance().getDAOOrdemServicoAlteracaoDataProgramacao().saveOrUpdate(os);
            OrdemServico osSaved = osAlteracaoSaved.getOrdemServico();
            if (fechamento != null) {
                fechamento.setOrdemServico(osSaved);
            } else if (diagnostico != null) {
                diagnostico.setOrdemServico(osSaved);
            }
            ordensAlteracaoSaved.add(osAlteracaoSaved);
        }
        geracaoToReturn.getOrdemServicoAlteracaoDataProgramacao().clear();
        geracaoToReturn.getOrdemServicoAlteracaoDataProgramacao().addAll(ordensAlteracaoSaved);
        return geracaoToReturn;
    }

    private static void atualizaDataOs(List<OrdemServicoAlteracaoDataProgramacao> ordensServicoAlteracaoDataProgramacao) {
        for (OrdemServicoAlteracaoDataProgramacao ordemServicoAlteracaoDataProgramacao : ordensServicoAlteracaoDataProgramacao) {
            if (ordemServicoAlteracaoDataProgramacao.getDataProgramacaoReal() == null) continue;
            ordemServicoAlteracaoDataProgramacao.getOrdemServico().setDataProgramada(ordemServicoAlteracaoDataProgramacao.getDataProgramacaoReal());
        }
    }

    static void deleteGeracao(GeracaoOrdemServicoPlanoManutencao geracaoOrdemServicoPlanoManutencao) throws ExceptionDatabase, ExceptionService {
        UtilPlanoManutencaoAtivo.deleteFechamentosGerados(geracaoOrdemServicoPlanoManutencao);
        geracaoOrdemServicoPlanoManutencao = (GeracaoOrdemServicoPlanoManutencao)CoreDAOFactory.getInstance().getDAOGeracaoOrdemServicoPlanoManutencao().findByPrimaryKey(geracaoOrdemServicoPlanoManutencao.getIdentificador());
        CoreDAOFactory.getInstance().getDAOGeracaoOrdemServicoPlanoManutencao().delete(geracaoOrdemServicoPlanoManutencao);
    }

    private static void deleteFechamentosGerados(GeracaoOrdemServicoPlanoManutencao geracaoOrdemServicoPlanoManutencao) throws ExceptionDatabase, ExceptionService {
        ArrayList<FechamentoOrdemServico> fechamentos = new ArrayList<FechamentoOrdemServico>();
        for (OrdemServicoAlteracaoDataProgramacao ordemServicoAlteracaoDataProgramacao : geracaoOrdemServicoPlanoManutencao.getOrdemServicoAlteracaoDataProgramacao()) {
            FechamentoOrdemServico fechamentosToDelete = UtilPlanoManutencaoAtivo.findFechamentoOSPorOS(ordemServicoAlteracaoDataProgramacao.getOrdemServico());
            ordemServicoAlteracaoDataProgramacao.getOrdemServico().setFechamentoOrdemServico(null);
            if (fechamentosToDelete == null) continue;
            fechamentosToDelete.setOrdemServico(null);
            fechamentos.add(fechamentosToDelete);
        }
        CoreService.simpleDeleteCollection(CoreDAOFactory.getInstance().getDAOFechamentoOrdemServicoCore(), fechamentos);
    }

    private static FechamentoOrdemServico findFechamentoOSPorOS(OrdemServico ordemServico) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "FROM FechamentoOrdemServico f where f.ordemServico = :idOs";
        Query q = s.createQuery(query);
        q.setLong("idOs", ordemServico.getIdentificador().longValue());
        return (FechamentoOrdemServico)q.uniqueResult();
    }

    static List<PlanoManutencaoAtivo> findPlanoManutencaoAcumulativo(Equipamento ativo, TipoPontoControle tipoPontoControle) {
        if (ativo == null || tipoPontoControle == null) {
            return null;
        }
        String query = "SELECT DISTINCT a.planoManutencaoAtivo FROM AtivoDataUltimaManutencao a WHERE a.ativo.identificador = :idAtivo AND a.planoManutencaoAtivo.tipoPontoControle.identificador = :idTipoPontoControle AND a.planoManutencaoAtivo.ativo = 1 ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(query);
        q.setLong("idAtivo", ativo.getIdentificador().longValue());
        q.setLong("idTipoPontoControle", tipoPontoControle.getIdentificador().longValue());
        return q.list();
    }

    static Coleta findColetaLimite(Equipamento ativo, TipoPontoControle tipoPontoControle, PlanoManutencaoAtivo planoManutencaoAtivo) {
        if (ativo == null || tipoPontoControle == null || planoManutencaoAtivo == null) {
            return null;
        }
        String query = "SELECT a.coletaLimite FROM AtivoTipoPontoControle a WHERE a.ativo.identificador = :idAtivo AND a.tipoPontoControle = :idTipoPontoControle AND a.planoManutencaoAtivoAtivo.planoManutencaoAtivo.identificador = :idPlanoManutencaoAtivo AND a.planoManutencaoAtivoAtivo.planoManutencaoAtivo.ativo = 1 AND a.identificador = (SELECT MAX(a2.identificador)                        FROM AtivoTipoPontoControle a2                        WHERE a2.ativo.identificador = :idAtivo                        AND a2.tipoPontoControle = :idTipoPontoControle                        AND a2.planoManutencaoAtivoAtivo.planoManutencaoAtivo.identificador = :idPlanoManutencaoAtivo                        AND a2.planoManutencaoAtivoAtivo.planoManutencaoAtivo.ativo = 1 ) ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(query);
        q.setLong("idAtivo", ativo.getIdentificador().longValue());
        q.setLong("idTipoPontoControle", tipoPontoControle.getIdentificador().longValue());
        q.setLong("idPlanoManutencaoAtivo", planoManutencaoAtivo.getIdentificador().longValue());
        return (Coleta)q.uniqueResult();
    }

    static JasperPrint gerarListagemPlanoManutencao(Short tipoControle, Short filtrarPlanoManutencaoAtivo, Long planoManutencaoAtivoInicial, Long planoManutencaoAtivoFinal, Short filtrarAtivo, Long ativoInicial, Long ativoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short filtrarTipoServico, Long tipoServicoInicial, Long tipoServicoFinal, Short filtrarSetorExecutante, Long setorExecutanteInicial, Long setorExecutanteFinal, Short exibirDetalhesPlano, Short nivelDetalhamento, String fecho, Nodo nodo, HashMap defaultParams) throws ExceptionService {
        Object query = "SELECT plano.identificador          AS ID_PLANO,             plano.descricao              AS DESCRICAO_PLANO,             plano.tipoControle.descricao AS TIPO_CONTROLE,             plano.tipoServico.nome       AS TIPO_SERVICO,             plano.periodicidade          AS PERIODICIDADE,             tipoPontoControle.descricao  AS TIPO_PONTO_CONTROLE,             plano.limite                 AS LIMITE,             plano.limiteAlerta           AS LIMITE_ALERTA FROM PlanoManutencaoAtivo                 plano LEFT JOIN plano.tipoPontoControle tipoPontoControle WHERE (:filtrarPlanoManutencaoAtivo <> 1 OR plano.identificador                 BETWEEN :planoManutencaoAtivoInicial AND :planoManutencaoAtivoFinal) AND   (:filtrarEmpresa              <> 1 OR plano.empresa.identificador         BETWEEN :empresaInicial              AND :empresaFinal             ) AND   (:filtrarTipoServico          <> 1 OR plano.tipoServico.identificador     BETWEEN :tipoServicoInicial          AND :tipoServicoFinal         ) ";
        if (tipoControle == 0) {
            query = (String)query + "AND plano.tipoControle.descricao like 'Periodico' ";
        } else if (tipoControle == 1) {
            query = (String)query + "AND plano.tipoControle.descricao like 'Acumulativo' ";
        }
        query = (String)query + "ORDER BY plano.identificador ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery((String)query);
        q.setShort("filtrarPlanoManutencaoAtivo", filtrarPlanoManutencaoAtivo.shortValue());
        q.setLong("planoManutencaoAtivoInicial", planoManutencaoAtivoInicial.longValue());
        q.setLong("planoManutencaoAtivoFinal", planoManutencaoAtivoFinal.longValue());
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("empresaInicial", empresaInicial.longValue());
        q.setLong("empresaFinal", empresaFinal.longValue());
        q.setShort("filtrarTipoServico", filtrarTipoServico.shortValue());
        q.setLong("tipoServicoInicial", tipoServicoInicial.longValue());
        q.setLong("tipoServicoFinal", tipoServicoFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List<HashMap> planos = q.list();
        for (HashMap plano : planos) {
            Long idPlano = (Long)plano.get("ID_PLANO");
            String query2 = "SELECT DISTINCT             t.identificador AS ID_ATIVO,              t.codigo        AS COD_ATIVO,              t.nome          AS ATIVO,             c.identificador AS ID_TIPO_PONTO_CONTROLE FROM AtivoDataUltimaManutencao a INNER JOIN a.ativo t LEFT JOIN t.tipoPontoControleAtivo p LEFT JOIN p.tipoPontoControle c WHERE a.planoManutencaoAtivo.identificador = :idPlano AND (:filtrarAtivo <> 1 OR t.identificador BETWEEN :ativoInicial AND :ativoFinal)";
            q = s.createQuery(query2);
            q.setLong("idPlano", idPlano.longValue());
            q.setShort("filtrarAtivo", filtrarAtivo.shortValue());
            q.setLong("ativoInicial", ativoInicial.longValue());
            q.setLong("ativoFinal", ativoFinal.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List ativos = q.list();
            for (HashMap h : ativos) {
                Long idAtivo = (Long)h.get("ID_ATIVO");
                Long idTipoPontoControle = (Long)h.get("ID_TIPO_PONTO_CONTROLE");
                if (idAtivo == null || idTipoPontoControle == null) continue;
                String query4 = "SELECT MAX(c.valorColeta) FROM Coleta c INNER JOIN c.ativo a INNER JOIN c.tipoPontoControle t WHERE a.identificador = :idAtivo AND t.identificador = :idTipoPontoControle";
                q = s.createQuery(query4);
                q.setLong("idAtivo", idAtivo.longValue());
                q.setLong("idTipoPontoControle", idTipoPontoControle.longValue());
                Integer valorColeta = (Integer)q.uniqueResult();
                h.put("VALOR_COLETA", valorColeta);
            }
            plano.put("ATIVOS", ativos);
            String query3 = "FROM SetorExecutanteServicos s WHERE s.planoManutencaoAtivo.identificador = :idPlano AND (:filtrarSetorExecutante <> 1 OR s.setorExecutante.identificador BETWEEN :setorExecutanteInicial AND :setorExecutanteFinal)";
            q = s.createQuery(query3);
            q.setLong("idPlano", idPlano.longValue());
            q.setShort("filtrarSetorExecutante", filtrarSetorExecutante.shortValue());
            q.setLong("setorExecutanteInicial", setorExecutanteInicial.longValue());
            q.setLong("setorExecutanteFinal", setorExecutanteFinal.longValue());
            List setores = q.list();
            plano.put("SETORES", setores);
        }
        if (defaultParams == null) {
            defaultParams = new HashMap<String, Short>();
        }
        defaultParams.put("TIPO_CONTROLE", tipoControle);
        defaultParams.put("FILTRAR_PLANO_MANUTENCAO_ATIVO", filtrarPlanoManutencaoAtivo);
        defaultParams.put("PLANO_MANUTENCAO_ATIVO_INICIAL", (Short)((Object)planoManutencaoAtivoInicial));
        defaultParams.put("PLANO_MANUTENCAO_ATIVO_FINAL", (Short)((Object)planoManutencaoAtivoFinal));
        defaultParams.put("FILTRAR_ATIVO", filtrarAtivo);
        defaultParams.put("ATIVO_INICIAL", (Short)((Object)ativoInicial));
        defaultParams.put("ATIVO_FINAL", (Short)((Object)ativoFinal));
        defaultParams.put("FILTRAR_EMPRESA", filtrarEmpresa);
        defaultParams.put("EMPRESA_INICIAL", (Short)((Object)empresaInicial));
        defaultParams.put("EMPRESA_FINAL", (Short)((Object)empresaFinal));
        defaultParams.put("FILTRAR_SETOR_EXECUTANTE", filtrarSetorExecutante);
        defaultParams.put("SETOR_EXECUTANTE_INICIAL", (Short)((Object)setorExecutanteInicial));
        defaultParams.put("SETOR_EXECUTANTE_FINAL", (Short)((Object)setorExecutanteFinal));
        defaultParams.put("FILTRAR_TIPO_SERVICO", filtrarTipoServico);
        defaultParams.put("TIPO_SERVICO_INICIAL", (Short)((Object)tipoServicoInicial));
        defaultParams.put("TIPO_SERVICO_FINAL", (Short)((Object)tipoServicoFinal));
        defaultParams.put("EXIBIR_DETALHES", exibirDetalhesPlano);
        defaultParams.put("NIVEL_DETALHAMENTO", nivelDetalhamento == null ? (short)0 : nivelDetalhamento);
        defaultParams.put("FECHO", (Short)((Object)fecho));
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", defaultParams).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "manutencequipamentos" + File.separator + "planomanutencaoativo" + File.separator + "LISTAGEM_PLANO_MANUTENCAO.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        if (filtrarAtivo == 1) {
            planos = UtilPlanoManutencaoAtivo.cleanPlanosSemAtivo(planos);
        }
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", defaultParams);
        relatorio.setAttribute("dados", planos);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private static List<HashMap> cleanPlanosSemAtivo(List<HashMap> planos) {
        ArrayList<HashMap> planosToReturn = new ArrayList<HashMap>();
        for (HashMap h : planos) {
            if (h.get("ATIVOS") == null || ((List)h.get("ATIVOS")).isEmpty()) continue;
            planosToReturn.add(h);
        }
        return planosToReturn;
    }

    private static Date getDateUltimaManutencao(AtivoDataUltimaManutencao ativoDataUltimaManutencao, Date dataUltimaManutencao) {
        if (dataUltimaManutencao != null) {
            return dataUltimaManutencao;
        }
        return ativoDataUltimaManutencao.getDataUltimaManutencao();
    }

    private static Boolean verificaIntevaloDataUltimaManutencao(Date dataUltimaManutencao, Date dataInicial, Date dataFinal, Integer periodicidade) {
        Integer periodicidadeReal = periodicidade;
        Integer diffDiasDatas = DateUtil.diferenceDayBetweenDates(dataUltimaManutencao, dataFinal);
        Integer osPendentes = diffDiasDatas / periodicidadeReal;
        if (DateUtil.dateBetween(dataUltimaManutencao, dataInicial = UtilPlanoManutencaoAtivo.dateMaxMinTime(dataInicial, false), dataFinal = UtilPlanoManutencaoAtivo.dateMaxMinTime(dataFinal, true)).booleanValue()) {
            return true;
        }
        for (int i = 0; i < osPendentes; ++i) {
            Date newDataUltimaManutencao = DateUtil.nextDays(dataUltimaManutencao, periodicidade);
            if (DateUtil.dateBetween(newDataUltimaManutencao, dataInicial, dataFinal).booleanValue()) {
                return true;
            }
            periodicidade = periodicidade + periodicidadeReal;
        }
        return false;
    }

    private static List<Date> geraDataUltimaManutencaoComPeriodicidade(Date dataUltimaManutencao, Date dataInicial, Date dataFinal, Integer periodicidade) {
        ArrayList<Date> datas = new ArrayList<Date>();
        if (dataInicial == null && dataFinal == null) {
            datas.add(DateUtil.nextDays(dataUltimaManutencao, periodicidade));
            return datas;
        }
        ArrayList<Date> datasManutencoes = new ArrayList<Date>();
        Integer periodicidadeReal = periodicidade;
        Integer diffDiasDatas = DateUtil.diferenceDayBetweenDates(dataUltimaManutencao, dataFinal);
        Integer osPendentes = diffDiasDatas / periodicidadeReal;
        dataInicial = UtilPlanoManutencaoAtivo.dateMaxMinTime(dataInicial, false);
        dataFinal = UtilPlanoManutencaoAtivo.dateMaxMinTime(dataFinal, true);
        for (int i = 0; i < osPendentes; ++i) {
            Date newDataUltimaManutencao = DateUtil.nextDays(dataUltimaManutencao, periodicidade);
            datasManutencoes.add(newDataUltimaManutencao);
            periodicidade = periodicidade + periodicidadeReal;
        }
        if (!datasManutencoes.isEmpty() && DateUtil.dateBetween((Date)datasManutencoes.get(datasManutencoes.size() - 1), dataInicial, dataFinal).booleanValue()) {
            return datasManutencoes;
        }
        return datas;
    }

    private static List<CronogramaPlanoManutencaoAtivo> getPlanoManutencaoCronograma(OrdemServico os, CronogramaOrdemServico crono) {
        ArrayList<CronogramaPlanoManutencaoAtivo> planos = new ArrayList<CronogramaPlanoManutencaoAtivo>();
        if (os.getPlanosManutencaoAtivo() != null && !os.getPlanosManutencaoAtivo().isEmpty()) {
            for (PlanoManutencaoAtivo p : os.getPlanosManutencaoAtivo()) {
                CronogramaPlanoManutencaoAtivo c = new CronogramaPlanoManutencaoAtivo();
                c.setCronograma(crono);
                c.setPlanoManutencaoAtivo(p);
                planos.add(c);
            }
        }
        return planos;
    }

    private static void criarFechDiagnostico(OrdemServicoAlteracaoDataProgramacao osProgramacao, SetorExecutanteServicos setorExec, OpcoesManutencEquip op) {
        if (ToolMethods.isEquals((Object)op.getGerarDiagnosticoFechamento(), (Object)EnumConstGerarDiagnosticoFechamento.TIPO_GERA_FECHA_DIAG_FECHAMENTO.getValue())) {
            UtilPlanoManutencaoAtivo.criarFechamento(osProgramacao, setorExec);
        } else if (ToolMethods.isEquals((Object)op.getGerarDiagnosticoFechamento(), (Object)EnumConstGerarDiagnosticoFechamento.TIPO_GERA_FECHA_DIAG_DIAGNOSTICO.getValue())) {
            UtilPlanoManutencaoAtivo.criarDiagnostico(osProgramacao, setorExec.getPreServicoProcedimentos());
        }
    }

    private static void criarDiagnostico(OrdemServicoAlteracaoDataProgramacao osProgramacao, List<PreServicoProcedimento> preServicoProcedimentos) {
        DiagnosticoOSAtivo vo = osProgramacao.getOrdemServico().getDiagnosticoOSAtivo();
        if (vo == null) {
            vo = new DiagnosticoOSAtivo();
        }
        vo.setDataCadastro(new Date());
        vo.setDataNecessidade(null);
        vo.setGerarPedAlmoxarifado(Short.valueOf((short)0));
        vo.setObservacao("Diagnostico OS.");
        vo.setOrdemServico(osProgramacao.getOrdemServico());
        vo.getOrdemServico().setDiagnosticoOSAtivo(vo);
        UtilPlanoManutencaoAtivo.setServicosOSDiagnostico(vo, preServicoProcedimentos);
    }

    private static void setServicosOSDiagnostico(DiagnosticoOSAtivo vo, List<PreServicoProcedimento> preServicosProcedimentos) {
        for (PreServicoProcedimento preServicoProcedimento : preServicosProcedimentos) {
            List filtered = vo.getServicos().stream().filter(item -> item.getPreServicoProcedimento().equals((Object)preServicoProcedimento)).collect(Collectors.toList());
            if (!filtered.isEmpty()) continue;
            DiagnosticoOSAtivoServico found = new DiagnosticoOSAtivoServico();
            found.setPreServicoProcedimento(preServicoProcedimento);
            found.setDiagnosticoOSAtivo(vo);
            found.setServico(preServicoProcedimento.getServico());
            vo.getServicos().add(found);
            UtilPlanoManutencaoAtivo.getProcedimentosDiagnostico(preServicoProcedimento, found);
        }
    }

    private static void getProcedimentosDiagnostico(PreServicoProcedimento preServicoProcedimento, DiagnosticoOSAtivoServico vo) {
        for (PreProcedimento preProcedimento : preServicoProcedimento.getPreProcedimento()) {
            List filtered = vo.getProcedimentos().stream().filter(item -> item.getPreProcedimento().equals((Object)preServicoProcedimento)).collect(Collectors.toList());
            if (!filtered.isEmpty()) continue;
            DiagnosticoOSAtivoServProc found = new DiagnosticoOSAtivoServProc();
            found.setDiagnosticoOSAtivoServ(vo);
            found.setObservacaoProcedimento(preProcedimento.getDescricao());
            found.setPreProcedimento(preProcedimento);
            vo.getProcedimentos().add(found);
            UtilPlanoManutencaoAtivo.getProdutosPrevisaoManutencaoDiagnostico(preProcedimento, found);
        }
    }

    private static void getProdutosPrevisaoManutencaoDiagnostico(PreProcedimento preProcedimento, DiagnosticoOSAtivoServProc found) {
        for (PreProdutoPrevManutencao preProdutoPrevManutencao : preProcedimento.getPreProdutosPrevisaoManutencao()) {
            DiagnosticoOSAtivoItens produtoPrevManutencao = new DiagnosticoOSAtivoItens();
            produtoPrevManutencao.setDiagnosticoOSAtivoServProc(found);
            produtoPrevManutencao.setGradeCor(preProdutoPrevManutencao.getGradeCor());
            produtoPrevManutencao.setQuantidade(preProdutoPrevManutencao.getQtdPrevista());
            found.getItens().add(produtoPrevManutencao);
        }
    }

    private static void criarFechamento(OrdemServicoAlteracaoDataProgramacao osProgramacao, SetorExecutanteServicos setorExec) {
        FechamentoOrdemServico fechamento = new FechamentoOrdemServico();
        fechamento.setDataCadastro(new Date());
        fechamento.setEmpresa(osProgramacao.getOrdemServico().getEmpresa());
        fechamento.setOrdemServico(osProgramacao.getOrdemServico());
        fechamento.setOsFechada(Short.valueOf((short)0));
        osProgramacao.getOrdemServico().setFechamentoOrdemServico(fechamento);
        UtilPlanoManutencaoAtivo.setServicosOS(osProgramacao, setorExec.getPreServicoProcedimentos());
    }

    private static void setarServicoAndProcedimentoFechamentoOrDiagnostico(OrdemServicoAlteracaoDataProgramacao os, SetorExecutanteServicos setorExec, OpcoesManutencEquip op) {
        if (ToolMethods.isEquals((Object)op.getGerarDiagnosticoFechamento(), (Object)EnumConstGerarDiagnosticoFechamento.TIPO_GERA_FECHA_DIAG_FECHAMENTO.getValue())) {
            UtilPlanoManutencaoAtivo.setServicosOS(os, setorExec.getPreServicoProcedimentos());
        } else if (ToolMethods.isEquals((Object)op.getGerarDiagnosticoFechamento(), (Object)EnumConstGerarDiagnosticoFechamento.TIPO_GERA_FECHA_DIAG_DIAGNOSTICO.getValue())) {
            UtilPlanoManutencaoAtivo.setServicosOSDiagnostico(os.getOrdemServico().getDiagnosticoOSAtivo(), setorExec.getPreServicoProcedimentos());
        }
    }

    private static void setOutrosDadosOSAndCronograma(OrdemServico os, Pessoa solicitante, Pessoa responsavel, AtivoTipoPontoControle ativoPontoControle, SetorExecutanteServicos setorExec) {
        os.setDataCadastro(new Date());
        os.setEmpresa(ativoPontoControle.getEmpresa());
        os.setSolicitante(solicitante);
        os.setResponsavel(responsavel);
        os.setStatus(Short.valueOf(EnumConstStatusOrdemServico.ABERTO.getValue()));
        os.setGerado(Short.valueOf((short)1));
        os.setTipoServico(ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getTipoServico());
        os.setPrioridade(ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getPrioridade());
        os.setDescricaoServico("Ordem Servi\u00e7o gerada por Plano de Manuten\u00e7\u00e3o Id. " + ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getIdentificador() + " - " + ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getDescricao());
        os.setEquipamento(ativoPontoControle.getAtivo());
        os.setCentroCusto(ativoPontoControle.getAtivo().getCentroCusto());
        os.setSetorExecutante(setorExec.getSetorExecutante());
        os.setFornecedor(setorExec.getFornecedor());
        os.setReservarEstoque(ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getReservarEstoque());
        os.getPlanosManutencaoAtivo().add(ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo());
        CronogramaOrdemServico cronograma = new CronogramaOrdemServico();
        cronograma.setDataProgramada(DateUtil.toTimestamp(os.getDataEmissao()));
        cronograma.setCentroCusto(ativoPontoControle.getAtivo().getCentroCusto());
        cronograma.setDataCadastro(new Date());
        cronograma.setStatus(Short.valueOf(EnumConstStatusOrdemServico.ABERTO.getValue()));
        cronograma.setTipoServico(ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getTipoServico());
        cronograma.setEquipamento(ativoPontoControle.getAtivo());
        cronograma.setSimulado(Short.valueOf((short)0));
        cronograma.setSetorExecutante(setorExec.getSetorExecutante());
        cronograma.setEmpresa(ativoPontoControle.getEmpresa());
        cronograma.setOrdemServico(os);
        cronograma.setPlanoManutencao(UtilPlanoManutencaoAtivo.getPlanoManutencaoCronograma(os, cronograma));
        os.setCronogramaOrdemServico(cronograma);
    }
}

