/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.previsaoimpostosncmnbm;

import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.Ncm;
import com.touchcomp.basementor.model.vo.PrevisaoImpostosNCMNBM;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.RegraExcecaoNCM;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionFileManipulation;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.utilities.CoreUtilityFactory;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

class AuxPrevisaoImpostosNCMNBM {
    AuxPrevisaoImpostosNCMNBM() {
    }

    public void importarAquivo(File csv, HashMap hashMap) throws ExceptionDatabase, ExceptionFileManipulation, ExceptionService {
        Integer indiceAliquotaEstadual = (Integer)hashMap.get("aliquota.estadual");
        Integer indiceAliquotaFederalImp = (Integer)hashMap.get("aliquota.federal.importada");
        Integer indiceAliquotaFederalNac = (Integer)hashMap.get("aliquota.federal.nacional");
        Integer indiceAliquotaMun = (Integer)hashMap.get("aliquota.municipal");
        Integer indiceExcecaoNCM = (Integer)hashMap.get("excecao.ncm");
        Integer indiceCodigoNCM = (Integer)hashMap.get("codigo.ncm");
        Integer indiceDescricaoNCM = (Integer)hashMap.get("descricao.ncm");
        Integer indiceTipo = (Integer)hashMap.get("tipo");
        UnidadeFederativa uf = (UnidadeFederativa)hashMap.get("uf");
        List prevs = (List)CoreService.simpleFindAll(CoreDAOFactory.getInstance().getDAOPrevisaoImpostosNCMNBM());
        List<Object[]> dados = CoreUtilityFactory.getUtilCSVFile().readCSV(csv);
        for (Object[] o : dados) {
            String codigoNCM = (String)o[indiceCodigoNCM - 1];
            String descricaoNCM = (String)o[indiceDescricaoNCM - 1];
            String codigoExcecao = (String)o[indiceExcecaoNCM - 1];
            String codigoTabela = (String)o[indiceTipo - 1];
            String aliqFedNacional = (String)o[indiceAliquotaFederalNac - 1];
            String aliqFedImportada = (String)o[indiceAliquotaFederalImp - 1];
            String aliqMunicipal = (String)o[indiceAliquotaMun - 1];
            String aliqEstadual = (String)o[indiceAliquotaEstadual - 1];
            if (!codigoTabela.equalsIgnoreCase("0")) continue;
            this.importarPrevisao(codigoNCM, descricaoNCM, codigoExcecao, aliqFedNacional, aliqFedImportada, aliqEstadual, aliqMunicipal, uf, prevs);
        }
        for (PrevisaoImpostosNCMNBM prev : prevs) {
            CoreDAOFactory.getInstance().getDAOPrevisaoImpostosNCMNBM().saveOrUpdate(prev);
        }
    }

    private Ncm getNCM(String codigoNCM, String descricaoNCM) throws ExceptionDatabase {
        Criteria c = CoreBdUtil.getInstance().getSession().createCriteria(Ncm.class);
        c.add((Criterion)Restrictions.eq((String)"codigo", (Object)codigoNCM));
        c.addOrder(Order.desc((String)"identificador"));
        c.setMaxResults(1);
        Ncm n = (Ncm)c.uniqueResult();
        if (n == null) {
            n = new Ncm();
            n.setAliquotaIpi(Double.valueOf(0.0));
            n.setCodigo(codigoNCM);
            n.setDescricao(descricaoNCM);
        } else {
            n.setDescricao(descricaoNCM);
        }
        n = (Ncm)CoreDAOFactory.getInstance().getDAOPrevisaoImpostosNCMNBM().saveOrUpdate(n);
        CoreBdUtil.getInstance().getSession().flush();
        return n;
    }

    private RegraExcecaoNCM getRegraExcecaoNCM(String codigoExcecao, Ncm n) throws ExceptionDatabase {
        RegraExcecaoNCM r = null;
        for (RegraExcecaoNCM regraExcecaoNCM : n.getRegraExcecaoNCM()) {
            if (regraExcecaoNCM.getCodigo() == null || !regraExcecaoNCM.getCodigo().equalsIgnoreCase(codigoExcecao)) continue;
            r = regraExcecaoNCM;
            break;
        }
        if (r == null) {
            r = new RegraExcecaoNCM();
            r.setCodigo(codigoExcecao);
            r.setDescricao(codigoExcecao);
            r.setNcm(n);
            n.getRegraExcecaoNCM().add(r);
        } else {
            r.setDescricao(codigoExcecao);
        }
        return r;
    }

    private void importarPrevisao(String codigoNCM, String descricaoNCM, String codigoExcecao, String aliqNacional, String aliqImportada, String aliquotaEstadual, String aliquotaMunicipal, UnidadeFederativa uf, List<PrevisaoImpostosNCMNBM> prevs) throws ExceptionDatabase {
        codigoNCM = ToolString.completaZeros((String)codigoNCM, (int)8, (boolean)true);
        codigoExcecao = codigoExcecao != null && codigoExcecao.trim().length() > 0 ? ToolString.completaZeros((String)codigoExcecao, (int)3, (boolean)true) : null;
        codigoExcecao = null;
        System.out.println("\n\nCodigo NCM: " + codigoNCM);
        System.out.println("Descricao NCM: " + descricaoNCM);
        System.out.println("Codigo Excecao: " + codigoExcecao);
        System.out.println("UF: " + uf.toString());
        PrevisaoImpostosNCMNBM p = this.getPrevisaoImpostosNCM(codigoNCM, descricaoNCM, codigoExcecao, uf, prevs);
        p.setAliquotaEstadual(new Double(aliquotaEstadual));
        p.setAliquotaMunicipal(new Double(aliquotaMunicipal));
        p.setAliquotaFederalImp(new Double(aliqImportada));
        p.setAliquotaFederalNac(new Double(aliqNacional));
    }

    private PrevisaoImpostosNCMNBM getPrevisaoImpostosNCM(Ncm n, RegraExcecaoNCM r, UnidadeFederativa uf) {
        Criteria c = CoreBdUtil.getInstance().getSession().createCriteria(PrevisaoImpostosNCMNBM.class);
        c.add((Criterion)Restrictions.eq((String)"ncm", (Object)n));
        c.add((Criterion)Restrictions.eq((String)"unidadeFederativa", (Object)uf));
        if (r != null) {
            c.add((Criterion)Restrictions.eq((String)"regraExcecaoNCM", (Object)r));
        }
        c.setMaxResults(1);
        PrevisaoImpostosNCMNBM p = (PrevisaoImpostosNCMNBM)c.uniqueResult();
        return p;
    }

    private PrevisaoImpostosNCMNBM getPrevisaoImpostosNCM(String codigoNcm, String descNcm, String codigoExcecao, UnidadeFederativa uf, List<PrevisaoImpostosNCMNBM> prevs) throws ExceptionDatabase {
        for (PrevisaoImpostosNCMNBM prev : prevs) {
            if ((prev.getNcm() == null || !prev.getNcm().getCodigo().equals(codigoNcm) || codigoExcecao != null) && (prev.getNcm() == null || !prev.getNcm().getCodigo().equals(codigoNcm) || prev.getRegraExcecaoNCM() == null || !codigoExcecao.equals(prev.getRegraExcecaoNCM().getCodigo()))) continue;
            return prev;
        }
        PrevisaoImpostosNCMNBM p = new PrevisaoImpostosNCMNBM();
        p.setNcm(this.getNCM(codigoNcm, descNcm));
        if (codigoExcecao != null && !codigoExcecao.isEmpty()) {
            p.setRegraExcecaoNCM(this.getRegraExcecaoNCM(codigoExcecao, p.getNcm()));
        }
        p.setUnidadeFederativa(uf);
        prevs.add(p);
        return p;
    }

    Double pesquisarAliquotaPrevistaImpostos(Produto produto, IncidenciaIcms incidenciaIcms, UnidadeFederativa uf) {
        if (ToolMethods.isWithData((Number)produto.getAliqImpEstimadaEst()) || ToolMethods.isWithData((Number)produto.getAliqImpEstimadaFed()) || ToolMethods.isWithData((Number)produto.getAliqImpEstimadaMun())) {
            return produto.getAliqImpEstimadaEst() + produto.getAliqImpEstimadaFed() + produto.getAliqImpEstimadaMun();
        }
        String codigoInc = incidenciaIcms.getCodigo();
        PrevisaoImpostosNCMNBM prev = this.getPrevisaoImpostosNCM(produto.getNcm(), produto.getRegraExcecaoNCM(), uf);
        if (prev == null) {
            return 0.0;
        }
        if (codigoInc.startsWith("0") || codigoInc.startsWith("8") || codigoInc.startsWith("4") || codigoInc.startsWith("5") || codigoInc.startsWith("3")) {
            return prev.getAliquotaEstadual() + prev.getAliquotaMunicipal() + prev.getAliquotaFederalNac();
        }
        return prev.getAliquotaEstadual() + prev.getAliquotaMunicipal() + prev.getAliquotaFederalImp();
    }
}

