/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.produto;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilRentabilidadeProduto {
    public JasperPrint gerarRentabilidade(CoreRequestContext r) throws ExceptionService {
        Integer idEmpresa = (Integer)r.getAttribute("ID_EMPRESA");
        Date dataInicial = (Date)r.getAttribute("DATA_INICIAL");
        Date dataFinal = (Date)r.getAttribute("DATA_FINAL");
        Integer filtrarEspecie = (Integer)r.getAttribute("FILTRAR_ESPECIE");
        Integer filtrarCliente = (Integer)r.getAttribute("FILTRAR_CLIENTE");
        Integer filtrarProduto = (Integer)r.getAttribute("FILTRAR_PRODUTO");
        Integer filtrarSubEspecie = (Integer)r.getAttribute("FILTRAR_SUB_ESPECIE");
        Integer filtrarRepresentante = (Integer)r.getAttribute("FILTRAR_REPRESENTANTE");
        Integer filtrarFabricante = (Integer)r.getAttribute("FILTRAR_FABRICANTE");
        Integer clienteInicial = (Integer)r.getAttribute("ID_CLIENTE_INICIAL");
        Integer clienteFinal = (Integer)r.getAttribute("ID_CLIENTE_FINAL");
        Integer fabricanteInicial = (Integer)r.getAttribute("ID_FABRICANTE_INICIAL");
        Integer fabricanteFinal = (Integer)r.getAttribute("ID_FABRICANTE_FINAL");
        Integer represInicial = (Integer)r.getAttribute("ID_REPRES_INICIAL");
        Integer represFinal = (Integer)r.getAttribute("ID_REPRES_FINAL");
        Integer produtoInicial = (Integer)r.getAttribute("ID_PRODUTO_INICIAL");
        Integer produtoFinal = (Integer)r.getAttribute("ID_PRODUTO_FINAL");
        Integer especieInicial = (Integer)r.getAttribute("ID_ESPECIE_INICIAL");
        Integer especieFinal = (Integer)r.getAttribute("ID_ESPECIE_FINAL");
        Integer subEspecieInicial = (Integer)r.getAttribute("ID_SUB_ESPECIE_INICIAL");
        Integer subEspecieFinal = (Integer)r.getAttribute("ID_SUB_ESPECIE_FINAL");
        String ordenacao = (String)r.getAttribute("ORDENACAO");
        Integer tipoRentabilidade = (Integer)r.getAttribute("TIPO_RENTABILIDADE");
        Integer tipoPrecoMedio = (Integer)r.getAttribute("TIPO_PRECO_MEDIO");
        List rentabilidade = this.getDadosRentabilidade(idEmpresa, dataInicial, dataFinal, filtrarEspecie, filtrarCliente, filtrarProduto, filtrarSubEspecie, filtrarRepresentante, filtrarFabricante, clienteInicial, clienteFinal, fabricanteInicial, fabricanteFinal, represInicial, represFinal, produtoInicial, produtoFinal, especieInicial, especieFinal, subEspecieInicial, subEspecieFinal, ordenacao, tipoRentabilidade, tipoPrecoMedio);
        this.processaDados(rentabilidade, ordenacao);
        HashMap<String, Integer> parametros = new HashMap<String, Integer>();
        parametros.putAll(r.toHashMap());
        parametros.put("TIPO_PRECO_MEDIO", (Integer)r.getAttribute("TIPO_PRECO_MEDIO"));
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "mercado" + File.separator + "gestaovendas" + File.separator + "controlemetas" + File.separator + "listagens" + File.separator + "listagemrentabilidade" + File.separator + "LISTAGEM_RENTABILIDADE.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", parametros);
        relatorio.setAttribute("dados", rentabilidade);
        Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return (JasperPrint)jasperPrint;
    }

    public List getDadosRentabilidade(Integer idEmpresa, Date dataInicial, Date dataFinal, Integer filtrarEspecie, Integer filtrarCliente, Integer filtrarProduto, Integer filtrarSubEspecie, Integer filtrarRepresentante, Integer filtrarFabricante, Integer clienteInicial, Integer clienteFinal, Integer fabricanteInicial, Integer fabricanteFinal, Integer represInicial, Integer represFinal, Integer produtoInicial, Integer produtoFinal, Integer especieInicial, Integer especieFinal, Integer subEspecieInicial, Integer subEspecieFinal, String ordenacao, Integer tipoRentabilidade, Integer tipoPrecoMedio) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = this.getQueryRentabilidade(ordenacao, tipoRentabilidade, filtrarCliente, filtrarEspecie, filtrarFabricante, filtrarProduto, filtrarRepresentante, filtrarSubEspecie);
        NativeQuery q = s.createSQLQuery(query);
        if (filtrarProduto == 1) {
            q.setInteger("produtoInicial", produtoInicial.intValue());
            q.setInteger("produtoFinal", produtoFinal.intValue());
        }
        q.setInteger("idEmpresa", idEmpresa.intValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        if (filtrarEspecie == 1) {
            q.setInteger("especieInicial", especieInicial.intValue());
            q.setInteger("especieFinal", especieFinal.intValue());
        }
        if (filtrarSubEspecie == 1) {
            q.setInteger("subEspecieInicial", subEspecieInicial.intValue());
            q.setInteger("subEspecieFinal", subEspecieFinal.intValue());
        }
        if (filtrarCliente == 1) {
            q.setInteger("clienteInicial", clienteInicial.intValue());
            q.setInteger("clienteFinal", clienteFinal.intValue());
        }
        if (filtrarRepresentante == 1) {
            q.setInteger("represInicial", represInicial.intValue());
            q.setInteger("represFinal", represFinal.intValue());
        }
        if (filtrarFabricante == 1) {
            q.setInteger("fabricanteInicial", fabricanteInicial.intValue());
            q.setInteger("fabricanteFinal", fabricanteFinal.intValue());
        }
        q.setInteger("tipoPrecoMedio", tipoPrecoMedio.intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private String getQueryRentabilidade(String ordenacao, Integer tipoRentabilidade, Integer filtrarCliente, Integer filtrarEspecie, Integer filtrarFabricante, Integer filtrarProduto, Integer filtrarRepresentante, Integer filtrarSubEspecie) {
        String groupBy;
        String querySelect;
        if (tipoRentabilidade == 0) {
            querySelect = " select s.cliente, s.nome_cliente, ";
            groupBy = " group by s.cliente, s.nome_cliente ";
        } else if (tipoRentabilidade == 1) {
            querySelect = " select s.id_produto, s.codigo_produto, s.nome_produto, s.um_produto, ";
            groupBy = " group by s.id_produto, s.codigo_produto, s.nome_produto, s.um_produto ";
        } else {
            querySelect = " select s.representante, s.nome_representante, ";
            groupBy = " group by s.representante, s.nome_representante ";
        }
        String querySelectSum = " sum(s.qtd_venda) as quantidade,   sum(s.vr_custo_compra) as valor_compra,  sum(s.vr_venda) as valor_venda,  sum(s.vr_custo_compra) as vr_custo_compra ";
        Object queryBody = " from rentabilidade_produto ( ";
        queryBody = filtrarProduto == 1 ? (String)queryBody + " :produtoInicial, :produtoFinal, " : (String)queryBody + " null, null, ";
        queryBody = (String)queryBody + " :idEmpresa, :dataInicial, :dataFinal, ";
        queryBody = filtrarEspecie == 1 ? (String)queryBody + " :especieInicial, :especieFinal, " : (String)queryBody + " null, null, ";
        queryBody = filtrarSubEspecie == 1 ? (String)queryBody + " :subEspecieInicial, :subEspecieFinal, " : (String)queryBody + " null, null, ";
        queryBody = filtrarCliente == 1 ? (String)queryBody + " :clienteInicial, :clienteFinal, " : (String)queryBody + " null, null, ";
        queryBody = filtrarRepresentante == 1 ? (String)queryBody + " :represInicial, :represFinal, " : (String)queryBody + " null, null, ";
        queryBody = filtrarFabricante == 1 ? (String)queryBody + " :fabricanteInicial, :fabricanteFinal,  " : (String)queryBody + " null, null, ";
        queryBody = (String)queryBody + " :tipoPrecoMedio) s";
        Object orderBy = "";
        if (!ordenacao.equalsIgnoreCase("percentual ascending") && !ordenacao.equalsIgnoreCase("percentual descending")) {
            orderBy = " order by " + ordenacao;
        }
        String queryReport = querySelect + querySelectSum + (String)queryBody + groupBy + (String)orderBy;
        return queryReport;
    }

    private void processaDados(List dados, String ordenacao) {
        for (Object o : dados) {
            HashMap h = (HashMap)o;
            Double quantidade = (Double)h.get("QUANTIDADE");
            Double valorCompra = (Double)h.get("VALOR_COMPRA");
            Double valorVenda = (Double)h.get("VALOR_VENDA");
            Double vrCustoCompra = (Double)h.get("VR_CUSTO_COMPRA");
            quantidade = quantidade == null ? 0.0 : quantidade;
            valorCompra = valorCompra == null ? 0.0 : valorCompra;
            valorVenda = valorVenda == null ? 0.0 : valorVenda;
            vrCustoCompra = vrCustoCompra == null ? 0.0 : vrCustoCompra;
            Double precoMedioCompra = vrCustoCompra / (quantidade > 0.0 ? quantidade : 1.0);
            Double precoMedioVenda = valorVenda / (quantidade > 0.0 ? quantidade : 1.0);
            Double percRentabilidade = (1.0 - precoMedioCompra / (precoMedioVenda > 0.0 ? precoMedioVenda : 1.0)) * 100.0;
            h.put("PRECO_MEDIO_COMPRA", precoMedioCompra);
            h.put("PRECO_MEDIO_VENDA", precoMedioVenda);
            h.put("PERCENTUAL", percRentabilidade);
        }
        if (ordenacao.equalsIgnoreCase("percentual ascending") || ordenacao.equalsIgnoreCase("percentual descending")) {
            this.getListaOrdenadaPercentual(dados, ordenacao);
        }
    }

    private void getListaOrdenadaPercentual(List dados, final String ordenacao) {
        Collections.sort(dados, new Comparator(){

            public int compare(Object o1, Object o2) {
                Double numero1 = (Double)((HashMap)o1).get("PERCENTUAL");
                Double numero2 = (Double)((HashMap)o2).get("PERCENTUAL");
                if (ordenacao.equalsIgnoreCase("percentual ascending")) {
                    return numero1.compareTo(numero2);
                }
                return numero2.compareTo(numero1);
            }
        });
    }

    private void getListaOrdenada(List<HashMap> dados) {
        Collections.sort(dados, new Comparator(this){

            public int compare(Object o1, Object o2) {
                Long numero1 = (Long)((HashMap)o1).get("NUMERO");
                Long numero2 = (Long)((HashMap)o2).get("NUMERO");
                return numero1.compareTo(numero2);
            }
        });
    }
}

