/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.provisao;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.ItemProvisaoDissidio;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.ProvisaoDissidioColetivo;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.rh.calculofolha.UtilCalculoFolhaPagamento;
import mentorcore.tools.DateUtil;

public class UtilProvisaoDissidioColetivo {
    public List createProvisaoDissidioColetivo(ProvisaoDissidioColetivo vo) {
        Double aliqInss = vo.getAliquotaInss();
        Double aliqFgts = vo.getAliquotaFgts();
        Double aliqTerceiros = vo.getAliquotaTerceiros();
        Double aliqRat = vo.getAliquotaRat();
        Double indiceFap = vo.getIndiceFap();
        Date periodoInicial = vo.getPeriodoInicial();
        Date periodoFinal = vo.getPeriodoFinal();
        boolean continuar = true;
        List colaboradores = this.findColaboradores();
        ItemProvisaoDissidio item = null;
        ArrayList<ItemProvisaoDissidio> itens = new ArrayList<ItemProvisaoDissidio>();
        Date periodoAux = null;
        for (Colaborador c : colaboradores) {
            periodoAux = periodoInicial;
            continuar = true;
            do {
                if (periodoAux.after(periodoFinal)) {
                    continuar = false;
                }
                if (continuar) {
                    Double baseCalculo = this.getBaseCalculo(periodoAux, c, vo);
                    item = new ItemProvisaoDissidio();
                    item.setColaborador(c);
                    item.setBaseCalculo(baseCalculo);
                    item.setFgts(ContatoFormatUtil.arrredondarNumero((Double)(baseCalculo * (aliqFgts / 100.0)), (int)2));
                    item.setInssEmpresa(this.getInssEmpresa(baseCalculo, aliqInss, vo));
                    item.setRat(ContatoFormatUtil.arrredondarNumero((Double)(baseCalculo * indiceFap * (aliqRat / 100.0)), (int)2));
                    item.setTerceiros(ContatoFormatUtil.arrredondarNumero((Double)(baseCalculo * aliqTerceiros / 100.0), (int)2));
                    item.setDataCompetencia(periodoAux);
                    item.setTotalProvisao(ContatoFormatUtil.arrredondarNumero((Double)(item.getBaseCalculo() + item.getFgts() + item.getRat() + item.getTerceiros() + item.getInssEmpresa()), (int)2));
                    itens.add(item);
                }
                periodoAux = DateUtil.nextMonth(periodoAux, 1);
            } while (continuar);
        }
        return itens;
    }

    private Double getBaseCalculo(Date periodoInicial, Colaborador c, ProvisaoDissidioColetivo p) {
        String hql = " select distinct m  from MovimentoFolha m  where  m.colaborador = :colaborador   and  m.aberturaPeriodo.dataInicio = :periodo  and  m.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento ";
        MovimentoFolha mov = (MovimentoFolha)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)c).setDate("periodo", periodoInicial).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).uniqueResult();
        if (mov == null) {
            return ContatoFormatUtil.arrredondarNumero((Double)(this.calcularBasePorSalario(c, periodoInicial) * (p.getIndice() / 100.0)), (int)2);
        }
        return ContatoFormatUtil.arrredondarNumero((Double)(this.calcularBaseEvento(mov) * (p.getIndice() / 100.0)), (int)2);
    }

    private List findColaboradores() {
        String hql = " select distinct c  from Colaborador c  where  c.ativo = :sim  and  c.dataDemissao is null  and  c.tipoColaborador.identificador = :empregado";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empregado", EnumConstTipoColaborador.EMPREGADO.getValue()).setShort("sim", (short)1).list();
    }

    private Double calcularBaseEvento(MovimentoFolha mov) {
        Double retorno = 0.0;
        for (ItemMovimentoFolha i : mov.getItensMovimentoFolha()) {
            if (!i.getEventoColaborador().getTipoCalculoEvento().getCompoeDissidioColetivo().equals((short)1)) continue;
            if (i.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue())) {
                retorno = retorno + i.getValor();
                continue;
            }
            retorno = retorno - i.getValor();
        }
        return retorno;
    }

    private Double calcularBasePorSalario(Colaborador c, Date periodoInicial) {
        return new UtilCalculoFolhaPagamento().findSalarioNominal(c, periodoInicial);
    }

    private Double getInssEmpresa(Double baseCalculo, Double aliqInss, ProvisaoDissidioColetivo vo) {
        if (vo.getPossuiDesoneracao().equals((short)0)) {
            return ContatoFormatUtil.arrredondarNumero((Double)(baseCalculo * (aliqInss / 100.0)), (int)2);
        }
        Double percDesoneracao = vo.getPercDesoneracao();
        percDesoneracao = 100.0 - percDesoneracao;
        Double valorInss = ContatoFormatUtil.arrredondarNumero((Double)(baseCalculo * (aliqInss / 100.0)), (int)2);
        return ContatoFormatUtil.arrredondarNumero((Double)(valorInss * (percDesoneracao / 100.0)), (int)2);
    }
}

