/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.recepcaomercadorias;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.EmailGrupoNecCompra;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.RecepcaoMercadorias;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.obsdinamica.CompOBSDinamica;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.EnumConstRecipientType;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.HashSet;

public class AuxEmailNecessidadeRecepcao {
    public static Email criarEmailNecessidadeCompra(NecessidadeCompra necessidadeCompra, OpcoesRelacionamento opcoesRelacionamento) throws ExceptionReflection, ExceptionInvalidData {
        HashSet<Email.Destinatario> destinatarios = new HashSet<Email.Destinatario>();
        AuxEmailNecessidadeRecepcao.criarDestinatarios(necessidadeCompra, destinatarios);
        return AuxEmailNecessidadeRecepcao.criarEmail(destinatarios, ((CompOBSDinamica)ConfApplicationContext.getBean(CompOBSDinamica.class)).build((Object)necessidadeCompra, opcoesRelacionamento.getModeloEmailNecessidade().getTituloEmail()), ((CompOBSDinamica)ConfApplicationContext.getBean(CompOBSDinamica.class)).build((Object)necessidadeCompra, opcoesRelacionamento.getModeloEmailNecessidade().getObjectObsDinamica().getObservacao()), opcoesRelacionamento);
    }

    public static Email criarEmailRecepcaoMercadorias(RecepcaoMercadorias recepcaoMercadorias, OpcoesRelacionamento opcoesRelacionamento) {
        HashSet<Email.Destinatario> destinatarios = new HashSet<Email.Destinatario>();
        StringBuilder corpoMensagemNecessidades = new StringBuilder();
        corpoMensagemNecessidades.append("Necessidades vinculadas:\n");
        for (OrdemCompra ordemCompra : recepcaoMercadorias.getOrdemCompra()) {
            for (ItemCotacaoCompra itemCotacaoCompra : ordemCompra.getCotacaoCompra().getItensCotacaoCompra()) {
                for (NecessidadeCompra necessidadeCompra : itemCotacaoCompra.getNecessidadesCompra()) {
                    corpoMensagemNecessidades.append("\nNecessidade: ").append(necessidadeCompra.getIdentificador()).append("\n");
                    AuxEmailNecessidadeRecepcao.criarDestinatarios(necessidadeCompra, destinatarios);
                }
            }
        }
        String corpoMensagem = (opcoesRelacionamento.getModeloEmailNecessidade().getModelo() + corpoMensagemNecessidades.toString()).replace("\n", "<BR>");
        return AuxEmailNecessidadeRecepcao.criarEmail(destinatarios, opcoesRelacionamento.getModeloEmailNecessidade().getTituloEmail(), corpoMensagem, opcoesRelacionamento);
    }

    private static void criarDestinatarios(NecessidadeCompra necessidadeCompra, HashSet<Email.Destinatario> destinatarios) {
        for (EmailGrupoNecCompra emailGrupoNecCompra : necessidadeCompra.getEmailGrupoNecCompra()) {
            destinatarios.add(new Email.Destinatario(emailGrupoNecCompra.getEmail(), EnumConstRecipientType.TO));
        }
    }

    private static Email criarEmail(HashSet<Email.Destinatario> destinatarios, String assunto, String corpoMensagem, OpcoesRelacionamento opcoesRelacionamento) {
        Email email = new Email();
        email.setRemetente(opcoesRelacionamento.getServidorEmailNecessidade().getEmail());
        if (ToolMethods.isNotNull((Object)opcoesRelacionamento.getEnviarCopiaNecessidade()).booleanValue() && ToolMethods.isEquals((Object)opcoesRelacionamento.getEnviarCopiaNecessidade(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            destinatarios.add(new Email.Destinatario(opcoesRelacionamento.getEmailCopiaFaturamento(), EnumConstRecipientType.TO));
        }
        email.setDestinatarios(destinatarios);
        email.setAssunto(assunto);
        email.setCorpoMensagem(corpoMensagem);
        email.setServidor(new Email.ServidorEmail(opcoesRelacionamento.getServidorEmailNecessidade().getServidor(), opcoesRelacionamento.getServidorEmailNecessidade().getServidorImap(), opcoesRelacionamento.getServidorEmailNecessidade().getServidorPop(), opcoesRelacionamento.getServidorEmailNecessidade().getEmail(), opcoesRelacionamento.getServidorEmailNecessidade().getSenha(), opcoesRelacionamento.getServidorEmailNecessidade().getPortaEmail(), opcoesRelacionamento.getServidorEmailNecessidade().getNaoAutenticarEmail(), opcoesRelacionamento.getServidorEmailNecessidade().getLogin(), opcoesRelacionamento.getServidorEmailNecessidade().getServerProperties(), opcoesRelacionamento.getServidorEmailNecessidade().getGerarArquivoExtensaoEml(), opcoesRelacionamento.getServidorEmailNecessidade().getDebugServer()));
        return email;
    }
}

