/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.recepcaomercadorias;

import com.touchcomp.basementor.constants.ConstantsNotaFiscal;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EvtNFeManifestoDest;
import com.touchcomp.basementor.model.vo.GradeItemOrdemCompra;
import com.touchcomp.basementor.model.vo.GradeItemRecepcaoMercadorias;
import com.touchcomp.basementor.model.vo.ItemRecepcaoMercadorias;
import com.touchcomp.basementor.model.vo.ItemUnidadeMedida;
import com.touchcomp.basementor.model.vo.LoteFabRecepcaoXML;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.RecepcaoMercadorias;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.service.impl.unidadefatfornecedor.ServiceUnidadeFatFornecedorImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public class UtilImportarRecepcaoMercadorias {
    private static final TLogger logger = TLogger.get(UtilImportarRecepcaoMercadorias.class);
    private Namespace n = Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe");
    private final ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedorImpl = (ServiceUnidadeFatFornecedorImpl)Context.get(ServiceUnidadeFatFornecedorImpl.class);

    public RecepcaoMercadorias importarRecepcao(List dePara, String xml, Empresa empresa, Integer nrNFe, String serieNFe, String chaveNFe, Date dataEmissaoNFe, String codModDocFiscal, Usuario usuario, EvtNFeManifestoDest evt, List<HashMap> itensXML, Short naoRatearValoresAcessorios, Short naoRatearValoresAgregado, Short naoRatearValoresDesconto, Short naoRatearValoresFrete, Short naoRatearValoresSeguro, NotaFiscalTerceiros notaTerceiros) throws JDOMException, IOException, ExceptionService, ExceptionDatabase {
        SAXBuilder sb = new SAXBuilder();
        Document d = sb.build((InputStream)new ByteArrayInputStream(ToolString.clearInvalidUTF8Char((String)xml).getBytes()));
        Element inf = d.getRootElement().getChild("NFe", this.n).getChild("infNFe", this.n);
        CondicoesPagamento condicoesPagamento = (CondicoesPagamento)itensXML.getFirst().get("condicaoPagamento");
        RecepcaoMercadorias vo = new RecepcaoMercadorias();
        UnidadeFatFornecedor unidadeFatFornecedor = this.findFornecedor(inf);
        List itensRecepcao = this.gerarItemRecepcaoMercadorias(vo, itensXML);
        vo.setEmpresa(empresa);
        vo.setUsuario(usuario);
        vo.setDataCadastro(new Date());
        vo.setDataEntradaSaida(new Date());
        vo.setItemRecepcao(itensRecepcao);
        if (notaTerceiros != null) {
            vo.setNotaImpXml(Short.valueOf((short)1));
            vo.setNotaFiscalTerceiros(notaTerceiros);
        } else {
            vo.setNotaFiscalTerceiros(this.getNotaTerceiros(condicoesPagamento, unidadeFatFornecedor, nrNFe, serieNFe, chaveNFe, dataEmissaoNFe, codModDocFiscal, evt, naoRatearValoresAcessorios, naoRatearValoresAgregado, naoRatearValoresDesconto, naoRatearValoresFrete, naoRatearValoresSeguro));
            if (vo.getNotaFiscalTerceiros() != null && vo.getNotaFiscalTerceiros().getDataEntrada() != null) {
                vo.setDataEntradaSaida(vo.getNotaFiscalTerceiros().getDataEntrada());
            }
        }
        vo.getNotaFiscalTerceiros().setObservacao(this.getOrdemCompraBase(itensRecepcao));
        return vo;
    }

    private String getOrdemCompraBase(List<ItemRecepcaoMercadorias> listItemRecepcaoMercadorias) {
        for (ItemRecepcaoMercadorias i : listItemRecepcaoMercadorias) {
            if (!(i.getQuantidadeTotal() > 0.0)) continue;
            return i.getItemOrdemCompra().getOrdemCompra().getObservacao();
        }
        return "";
    }

    private UnidadeFatFornecedor findFornecedor(Element inf) throws ExceptionService {
        Element cnpjCpf = null;
        Element emit = inf.getChild("emit", ConstantsNotaFiscal.NAMESPACE_XML_NFE_X1);
        cnpjCpf = emit.getChild("CNPJ", ConstantsNotaFiscal.NAMESPACE_XML_NFE_X1) != null ? emit.getChild("CNPJ", ConstantsNotaFiscal.NAMESPACE_XML_NFE_X1) : emit.getChild("CPF", ConstantsNotaFiscal.NAMESPACE_XML_NFE_X1);
        String inscEst = emit.getChild("IE", this.n).getText();
        UnidadeFatFornecedor u = this.serviceUnidadeFatFornecedorImpl.getCNPJInscEstAtivo(cnpjCpf.getText(), inscEst);
        if (ToolMethods.isNull((Object)u).booleanValue()) {
            inscEst = ToolString.completaZerosEsquerda((String)inscEst, (int)13);
            u = this.serviceUnidadeFatFornecedorImpl.getCNPJInscEstAtivo(cnpjCpf.getText(), inscEst);
        }
        if (ToolMethods.isEquals((Object)u, null)) {
            throw new ExceptionService("Fornecedor n\u00e3o encontrado na base de dados. CNPJ: " + cnpjCpf.getText() + ", Inscricao Estadual: " + inscEst);
        }
        return u;
    }

    private List gerarItemRecepcaoMercadorias(RecepcaoMercadorias recepcao, List<HashMap> itensXML) throws ExceptionService {
        ArrayList<ItemRecepcaoMercadorias> itensRecepcao = new ArrayList<ItemRecepcaoMercadorias>();
        for (HashMap hash : itensXML) {
            List itens = (List)hash.get("itens");
            for (HashMap hh : itens) {
                GradeItemOrdemCompra ioc = (GradeItemOrdemCompra)hh.get("gradeItemOrdemCompra");
                Double quantidade = (Double)hh.get("qtdConvertida");
                Double qtdRecepionadaXML = (Double)hh.get("qtdRecepionada");
                ItemRecepcaoMercadorias itemRec = new ItemRecepcaoMercadorias();
                itemRec.setItemOrdemCompra(ioc.getItemOrdemCompra());
                itemRec.setItemUnidMedFatorConversao((ItemUnidadeMedida)hh.get("itemUnidadeMedida"));
                itemRec.setRecepcaoMercadoria(recepcao);
                itemRec.setGradeItemRecMercadorias(this.getGradeRecepcaoMercadorias(itemRec, ioc, quantidade, qtdRecepionadaXML));
                List<LoteFabRecepcaoXML> lotes = this.getLotesXML((List)hash.get("lotesFab"), itemRec);
                itemRec.setLotesFabRecepcaoXML(lotes);
                itemRec.setDescricaoComplementar((String)hash.get("descricaoProduto"));
                itemRec.setUnidadeMedidaXML((String)hash.get("unidadeMedidaXML"));
                itensRecepcao.add(itemRec);
            }
        }
        return itensRecepcao;
    }

    private List<GradeItemRecepcaoMercadorias> getGradeRecepcaoMercadorias(ItemRecepcaoMercadorias itemRec, GradeItemOrdemCompra ioc, Double qtd, Double qtdRecepionadaXML) {
        GradeItemRecepcaoMercadorias grm = new GradeItemRecepcaoMercadorias();
        grm.setItemRecepcaoMercadoria(itemRec);
        grm.setGradeItemOrdemCompra(ioc);
        grm.setQuantidade(qtd);
        grm.setQuantidadeForn(qtdRecepionadaXML);
        if (grm.getQuantidade() == null) {
            grm.setQuantidade(qtdRecepionadaXML);
        }
        ArrayList<GradeItemRecepcaoMercadorias> grades = new ArrayList<GradeItemRecepcaoMercadorias>();
        grades.add(grm);
        return grades;
    }

    private ModeloDocFiscal findModeloDocFiscalPorCodigo(String codModDocFiscal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from ModeloDocFiscal m where m.codigo = :codigo");
        q.setString("codigo", codModDocFiscal);
        return (ModeloDocFiscal)q.uniqueResult();
    }

    private SituacaoDocumento findSituacaoDocumentoPorCodigo(String codSitDoc) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from SituacaoDocumento m where m.codigo = :codigo");
        q.setString("codigo", codSitDoc);
        return (SituacaoDocumento)q.uniqueResult();
    }

    private NotaFiscalTerceiros getNotaTerceiros(CondicoesPagamento condicoesPagamento, UnidadeFatFornecedor unidadeFatFornecedor, Integer nrNFe, String serieNFe, String chaveNFe, Date dataEmissaoNFe, String codModDocFiscal, EvtNFeManifestoDest evt, Short naoRatearValoresAcessorios, Short naoRatearValoresAgregado, Short naoRatearValoresDesconto, Short naoRatearValoresFrete, Short naoRatearValoresSeguro) {
        NotaFiscalTerceiros nota = new NotaFiscalTerceiros();
        nota.setUnidadeFatFornecedor(unidadeFatFornecedor);
        nota.setCategoriaPessoa(nota.getUnidadeFatFornecedor().getCategoriaPessoa());
        nota.setClassificacaoPessoas(nota.getUnidadeFatFornecedor().getFornecedor().getClassificacaoPessoa());
        nota.setUfPrestacao(unidadeFatFornecedor.getPessoa().getEndereco().getCidade().getUf());
        nota.setCidadePrestacao(unidadeFatFornecedor.getPessoa().getEndereco().getCidade());
        nota.setNumeroNota(nrNFe);
        nota.setSerie(serieNFe);
        nota.setChaveNFE(chaveNFe);
        nota.setDataEmissao(dataEmissaoNFe);
        nota.setCondicoesPagamento(condicoesPagamento);
        if (nota.getEvtNFeManifestoDest().contains(evt)) {
            nota.getEvtNFeManifestoDest().add(evt);
        }
        nota.setModeloDocFiscal(this.findModeloDocFiscalPorCodigo(codModDocFiscal));
        nota.setSituacaoDocumento(this.findSituacaoDocumentoPorCodigo("00"));
        nota.setNaoRatearVlrAcess(naoRatearValoresAcessorios);
        nota.setNaoRatearVlrAgregado(naoRatearValoresAgregado);
        nota.setNaoRatearVlrDesconto(naoRatearValoresDesconto);
        nota.setNaoRatearVlrFrete(naoRatearValoresFrete);
        nota.setNaoRatearVlrSeguro(naoRatearValoresSeguro);
        return nota;
    }

    private List<LoteFabRecepcaoXML> getLotesXML(List<HashMap> lista, ItemRecepcaoMercadorias itemRecepcaoMercadorias) {
        ArrayList<LoteFabRecepcaoXML> lotes = new ArrayList<LoteFabRecepcaoXML>();
        if (lista != null && !lista.isEmpty()) {
            for (HashMap h : lista) {
                LoteFabRecepcaoXML lote = new LoteFabRecepcaoXML();
                lote.setNumeroLote((String)h.get("nLote"));
                lote.setQuantidade((Double)h.get("qLote"));
                lote.setDataFabricacao((Date)h.get("dFab"));
                lote.setDataValidade((Date)h.get("dVal"));
                lote.setItemRecepcaoMercadorias(itemRecepcaoMercadorias);
                lotes.add(lote);
            }
        }
        return lotes;
    }
}

