/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.reinf;

import com.touchcomp.basementor.model.vo.ApuracaoReinf;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemReinf2010;
import com.touchcomp.basementor.model.vo.ItemReinf4010;
import com.touchcomp.basementor.model.vo.ItemReinf4020;
import com.touchcomp.basementor.model.vo.ItemReinf4020NaoIdentificado;
import com.touchcomp.basementor.model.vo.ItemReinf4040;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.R1000;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.reinf.UtilityApuracaoReinf2010;
import mentorcore.service.impl.reinf.UtilityApuracaoReinf2020;
import mentorcore.service.impl.reinf.UtilityApuracaoReinf4040;

public class ServiceApuracaoReinf
extends CoreService {
    public static final String EFETUAR_APURACAO_NOTAS_REINF = "efetuarApuracaoNotasReinf";
    public static final String REPROCESSAR_APURACAO_NOTAS_REINF = "reprocessarApuracaoNotasReinf";

    public HashMap efetuarApuracaoNotasReinf(CoreRequestContext r) {
        HashMap<String, List<Object>> h = new HashMap<String, List<Object>>();
        Date dataInicial = (Date)r.getAttribute("dataInicial");
        Date dataFinal = (Date)r.getAttribute("dataFinal");
        GrupoEmpresa grupoEmpresa = (GrupoEmpresa)r.getAttribute("grupoEmpresa");
        Boolean filtrarNotasRetidas = (Boolean)r.getAttribute("filtrarNotasRetidas");
        R1000 r1000 = (R1000)r.getAttribute("r1000");
        OpcoesContabeis opcoesContabeis = (OpcoesContabeis)r.getAttribute("opcoesContabeis");
        List<ItemReinf2010> itens2010 = new UtilityApuracaoReinf2010().apurarItens2010(dataInicial, dataFinal, grupoEmpresa, filtrarNotasRetidas);
        List itens2020 = new UtilityApuracaoReinf2020().apurarItens2020(dataInicial, dataFinal, grupoEmpresa, filtrarNotasRetidas);
        List<ItemReinf4010> itens4010 = new UtilityApuracaoReinf2010().apuracaoValores4010(dataInicial, dataFinal, grupoEmpresa);
        List<ItemReinf4020> itens4020 = new UtilityApuracaoReinf2010().apuracaoValores4020(dataInicial, dataFinal, grupoEmpresa, r1000, opcoesContabeis);
        List<ItemReinf4040> itens4040 = new UtilityApuracaoReinf4040().apuracaoValores4040(dataInicial, dataFinal);
        List<ItemReinf4020NaoIdentificado> itens4020NaoIdentificado = new UtilityApuracaoReinf4040().apuracaoValores4020NaoIdentificado(dataInicial, dataFinal);
        h.put("2010", itens2010);
        h.put("2020", itens2020);
        h.put("4010", itens4010);
        h.put("4020", itens4020);
        h.put("4040", itens4040);
        h.put("4020NaoIdentificado", itens4020NaoIdentificado);
        return h;
    }

    public ApuracaoReinf reprocessarApuracaoNotasReinf(CoreRequestContext r) {
        Date dataInicial = (Date)r.getAttribute("dataInicial");
        Date dataFinal = (Date)r.getAttribute("dataFinal");
        GrupoEmpresa grupoEmpresa = (GrupoEmpresa)r.getAttribute("grupoEmpresa");
        R1000 r1000 = (R1000)r.getAttribute("r1000");
        OpcoesContabeis opcoesContabeis = (OpcoesContabeis)r.getAttribute("opcoesContabeis");
        ItemReinf4020 itemReinf4020 = (ItemReinf4020)r.getAttribute("itemReinf4020");
        ApuracaoReinf apuracaoReinf = (ApuracaoReinf)r.getAttribute("apuracaoReinf");
        apuracaoReinf = new UtilityApuracaoReinf2010().reprocessarValores4020(dataInicial, dataFinal, grupoEmpresa, r1000, opcoesContabeis, itemReinf4020, apuracaoReinf);
        return apuracaoReinf;
    }
}

