/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.reinf;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.geracaotitulosimpostosretidos.EnumConstGeracaoTitulosImpostosRetidos;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.model.vo.ApuracaoReinf;
import com.touchcomp.basementor.model.vo.BaixaTituloPisCofins;
import com.touchcomp.basementor.model.vo.CadastroNacionalObra;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemReinf2010;
import com.touchcomp.basementor.model.vo.ItemReinf4010;
import com.touchcomp.basementor.model.vo.ItemReinf4020;
import com.touchcomp.basementor.model.vo.ItemReinfNotas2010;
import com.touchcomp.basementor.model.vo.ItemReinfNotas4010;
import com.touchcomp.basementor.model.vo.ItemReinfNotas4020;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;

public class UtilityApuracaoReinf2010 {
    public List<ItemReinf2010> apurarItens2010(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, Boolean filtrarNotasRetidas) {
        List<NotaFiscalTerceiros> notas = this.findNotas(dataInicial, dataFinal, grupoEmpresa, filtrarNotasRetidas);
        ArrayList<ItemReinf2010> itens = new ArrayList<ItemReinf2010>();
        for (NotaFiscalTerceiros nota : notas) {
            Short indicadorEmpreitada;
            Short indicadorObra = nota.getInformarNotaObra();
            if (indicadorObra == null) {
                indicadorObra = 0;
            }
            if ((indicadorEmpreitada = nota.getTipoObraConstrucao()) == null) {
                indicadorEmpreitada = 0;
            }
            CadastroNacionalObra cno = nota.getCadastroNacionalObra();
            Boolean achou = false;
            for (ItemReinf2010 item : itens) {
                if (!item.getPessoa().equals((Object)nota.getUnidadeFatFornecedor().getFornecedor().getPessoa()) || !item.getIndicadorObra().equals(indicadorObra) || !item.getIndicadorEmpreitada().equals(indicadorEmpreitada) || cno != null && !item.getCno().equals((Object)cno) || !item.getEmpresa().equals((Object)nota.getEmpresa())) continue;
                ItemReinfNotas2010 ii = new ItemReinfNotas2010();
                ii.setNotaTerceiros(nota);
                ii.setItemReinf2010(item);
                item.getItens().add(ii);
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            ItemReinf2010 i = new ItemReinf2010();
            i.setPessoa(nota.getUnidadeFatFornecedor().getFornecedor().getPessoa());
            i.setIndicadorObra(indicadorObra);
            i.setIndicadorEmpreitada(indicadorEmpreitada);
            i.setCno(cno);
            i.setEmpresa(nota.getEmpresa());
            ItemReinfNotas2010 ii = new ItemReinfNotas2010();
            ii.setNotaTerceiros(nota);
            ii.setItemReinf2010(i);
            i.getItens().add(ii);
            itens.add(i);
        }
        return itens;
    }

    private List<NotaFiscalTerceiros> findNotas(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, Boolean filtrarNotasRetidas) {
        List ret;
        Object hql = " From NotaFiscalTerceiros nt  where  nt.dataEntrada between :dataInicial and :dataFinal  and nt.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and nt.modeloDocFiscal.modeloServico = :modeloServico and not exists(select i.identificador                from ItemReinfNotas2010 i                 where i.notaTerceiros.identificador = nt.identificador)";
        if (filtrarNotasRetidas.booleanValue()) {
            hql = (String)hql + " and nt.valoresNfTerceiros.valorInss > 0";
        }
        if ((ret = CoreBdUtil.getInstance().getSession().createQuery((String)hql).setDate("dataInicial", dataInicial).setDate("dataFinal", dataFinal).setEntity("grupoEmpresa", (Object)grupoEmpresa).setShort("modeloServico", (short)1).list()) == null || ret.isEmpty()) {
            return new ArrayList<NotaFiscalTerceiros>();
        }
        ArrayList<NotaFiscalTerceiros> nt = new ArrayList<NotaFiscalTerceiros>();
        for (Object object : ret) {
            NotaFiscalTerceiros nota = (NotaFiscalTerceiros)object;
            if (!ToolMethods.isStrWithData((String)nota.getUnidadeFatFornecedor().getFornecedor().getPessoa().getComplemento().getCnpj()) || nota.getUnidadeFatFornecedor().getFornecedor().getPessoa().getComplemento().getCnpj().length() != 14) continue;
            nt.add(nota);
        }
        return nt;
    }

    public List<ItemReinf4010> apuracaoValores4010(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        ArrayList<ItemReinf4010> itens = new ArrayList<ItemReinf4010>();
        String hql = " select distinct nt From NotaFiscalTerceiros nt  inner join nt.infPagamentoNfTerceiros inf  inner join inf.titulos titulo  where  nt.dataEntrada < :dataInicial  and nt.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and nt.modeloDocFiscal.modeloServico = :modeloServico  and (titulo is not null and titulo.dataVencimento between :dataInicial and :dataFinal and  titulo.pessoa = nt.unidadeFatFornecedor.fornecedor.pessoa) and nt.valoresNfTerceiros.valorIrrf > 0  and nt.unidadeFatFornecedor.pessoa.complemento.tipoPessoa = 0  and not exists(select i.identificador                from ItemReinfNotas4010 i                 where i.notaTerceiros.identificador = nt.identificador)";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicial", dataInicial).setDate("dataFinal", dataFinal).setEntity("grupoEmpresa", (Object)grupoEmpresa).setShort("modeloServico", (short)1).list();
        if (ret == null || ret.isEmpty()) {
            return new ArrayList<ItemReinf4010>();
        }
        for (NotaFiscalTerceiros nfe : ret) {
            boolean achou = false;
            for (ItemReinf4010 item : itens) {
                if (!item.getPessoa().equals((Object)nfe.getUnidadeFatFornecedor().getPessoa())) continue;
                achou = true;
                ItemReinfNotas4010 i = new ItemReinfNotas4010();
                i.setNotaTerceiros(nfe);
                i.setItemReinf(item);
                item.getItensNotas().add(i);
                break;
            }
            if (achou) continue;
            ItemReinf4010 item = new ItemReinf4010();
            item.setEmpresa(nfe.getEmpresa());
            item.setPessoa(nfe.getUnidadeFatFornecedor().getPessoa());
            ItemReinfNotas4010 i = new ItemReinfNotas4010();
            i.setNotaTerceiros(nfe);
            i.setItemReinf(item);
            item.getItensNotas().add(i);
            itens.add(item);
        }
        return itens;
    }

    public List<ItemReinf4020> apuracaoValores4020(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, R1000 reinf, OpcoesContabeis opcoesContabeis) {
        ArrayList<ItemReinf4020> itens = new ArrayList<ItemReinf4020>();
        String hqlIrrf = " select distinct nt From NotaFiscalTerceiros nt  inner join nt.infPagamentoNfTerceiros inf  inner join inf.titulos titulo inner join nt.unidadeFatFornecedor uff inner join uff.pessoa p inner join p.complemento c inner join uff.fornecedor f inner join nt.itemNotaTerceiros int inner join int.modeloFiscal mf inner join nt.modeloDocFiscal mdf where   ((nt.valoresNfTerceiros.valorIrrf > 0 ) and ( nt.dataEmissao between :dataInicial and :dataFinal  ) and nt.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and nt.modeloDocFiscal.modeloServico = :modeloServico  and nt.unidadeFatFornecedor.pessoa.complemento.tipoPessoa != 0  and not exists(select i.identificador                from ItemReinfNotas4020 i                 where i.notaTerceiros.identificador = nt.identificador                 and i.itemReinf.apuracaoReinf.periodo between :dataInicial and :dataFinal )) or ((nt.valoresNfTerceiros.valorIrrf = 0 )  and ( nt.dataEmissao between :dataInicial and :dataFinal  ) and nt.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and nt.modeloDocFiscal.modeloServico = :modeloServico  and nt.unidadeFatFornecedor.pessoa.complemento.tipoPessoa != 0  and CHAR_LENGTH(c.cnpj) = 14  and (f.tipoEpp = :nao) and mf.reinfNaturezaRendimento is not null  and ((mf.tipoIRRF = :tipoIrrfCalcular) or (mf.tipoIRRF = :tipoIrrfHabilitar))  and not exists(select i.identificador                from ItemReinfNotas4020 i                 where i.notaTerceiros.identificador = nt.identificador                 and i.itemReinf.apuracaoReinf.periodo between :dataInicial and :dataFinal )) ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hqlIrrf).setDate("dataInicial", dataInicial).setDate("dataFinal", dataFinal).setEntity("grupoEmpresa", (Object)grupoEmpresa).setShort("modeloServico", EnumConstantsMentorSimNao.SIM.getValue()).setShort("nao", EnumConstantsMentorSimNao.NAO.getValue()).setShort("tipoIrrfCalcular", (short)1).setShort("tipoIrrfHabilitar", (short)2).list();
        for (NotaFiscalTerceiros nfe : ret) {
            boolean achou = false;
            for (ItemReinf4020 item : itens) {
                if (!item.getEmpresa().equals((Object)nfe.getEmpresa()) || !item.getPessoa().equals((Object)nfe.getUnidadeFatFornecedor().getPessoa())) continue;
                achou = true;
                ItemReinfNotas4020 i = new ItemReinfNotas4020();
                i.setNotaTerceiros(nfe);
                i.setItemReinf(item);
                i.setBaseIrrf(nfe.getValoresNfTerceiros().getValorTotal());
                i.setValorIrrf(nfe.getValoresNfTerceiros().getValorIrrf());
                i.setNaturezaRendimento(((ItemNotaTerceiros)nfe.getItemNotaTerceiros().get(0)).getNaturezaRendimento());
                item.getItensNotas().add(i);
                break;
            }
            if (achou) continue;
            ItemReinf4020 item = new ItemReinf4020();
            item.setEmpresa(nfe.getEmpresa());
            item.setPessoa(nfe.getUnidadeFatFornecedor().getPessoa());
            ItemReinfNotas4020 i = new ItemReinfNotas4020();
            i.setNotaTerceiros(nfe);
            i.setItemReinf(item);
            i.setBaseIrrf(nfe.getValoresNfTerceiros().getValorTotal());
            i.setValorIrrf(nfe.getValoresNfTerceiros().getValorIrrf());
            i.setNaturezaRendimento(((ItemNotaTerceiros)nfe.getItemNotaTerceiros().get(0)).getNaturezaRendimento());
            item.getItensNotas().add(i);
            itens.add(item);
        }
        if (ToolMethods.isEquals((Object)opcoesContabeis.getTipoGeracaoTitulosImpostosRetidos(), (Object)EnumConstGeracaoTitulosImpostosRetidos.GERAR_TITULO_APURACAO_REINF.getValue())) {
            this.criarApuracaoValores4020Impostos(grupoEmpresa, dataInicial, dataFinal, itens);
        } else {
            String hqlOutrasRetencoes = " select distinct nt From NotaFiscalTerceiros nt  inner join nt.infPagamentoNfTerceiros inf  inner join inf.titulos titulo where   (  nt.valoresNfTerceiros.valorLei10833 > 0 or nt.valoresNfTerceiros.valorContSoc > 0 ) and nt.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and (titulo is not null and titulo.dataVencimento between :dataInicial and :dataFinal and  titulo.pessoa = nt.unidadeFatFornecedor.fornecedor.pessoa) and nt.modeloDocFiscal.modeloServico = :modeloServico  and nt.unidadeFatFornecedor.pessoa.complemento.tipoPessoa != 0  and not exists(select i.identificador                from ItemReinfNotas4020 i                 where i.notaTerceiros.identificador = nt.identificador                 and i.itemReinf.apuracaoReinf.periodo between :dataInicial and :dataFinal )";
            ret = CoreBdUtil.getInstance().getSession().createQuery(hqlOutrasRetencoes).setDate("dataInicial", dataInicial).setDate("dataFinal", dataFinal).setEntity("grupoEmpresa", (Object)grupoEmpresa).setShort("modeloServico", (short)1).list();
            for (NotaFiscalTerceiros nfee : ret) {
                boolean achou = false;
                ItemNotaTerceiros itemNfe = (ItemNotaTerceiros)nfee.getItemNotaTerceiros().get(0);
                for (ItemReinf4020 item : itens) {
                    if (!item.getEmpresa().equals((Object)nfee.getEmpresa()) || !item.getPessoa().equals((Object)nfee.getUnidadeFatFornecedor().getPessoa())) continue;
                    achou = true;
                    ItemReinfNotas4020 i = new ItemReinfNotas4020();
                    i.setNotaTerceiros(nfee);
                    i.setItemReinf(item);
                    if (itemNfe.getItemNotaLivroFiscal().getPercRedLei10833() == 0.0) {
                        i.setBaseAgregado(nfee.getValoresNfTerceiros().getValorTotal());
                    } else {
                        i.setBaseAgregado(Double.valueOf(nfee.getValoresNfTerceiros().getValorTotal() - nfee.getValoresNfTerceiros().getValorTotal() * itemNfe.getItemNotaLivroFiscal().getPercRedLei10833() / 100.0));
                    }
                    i.setValorAgregado(nfee.getValoresNfTerceiros().getValorLei10833());
                    i.setBaseCofins(nfee.getValoresNfTerceiros().getValorTotal());
                    i.setValorCofins(nfee.getValoresNfTerceiros().getValorCofinsST());
                    i.setBaseCsll(nfee.getValoresNfTerceiros().getValorTotal());
                    i.setValorCsll(nfee.getValoresNfTerceiros().getValorContSoc());
                    i.setBasePis(nfee.getValoresNfTerceiros().getValorTotal());
                    i.setValorPis(nfee.getValoresNfTerceiros().getValorPisSt());
                    i.setNaturezaRendimento(((ItemNotaTerceiros)nfee.getItemNotaTerceiros().get(0)).getNaturezaRendimento());
                    item.getItensNotas().add(i);
                    break;
                }
                if (achou) continue;
                ItemReinf4020 item = new ItemReinf4020();
                item.setEmpresa(nfee.getEmpresa());
                item.setPessoa(nfee.getUnidadeFatFornecedor().getPessoa());
                ItemReinfNotas4020 i = new ItemReinfNotas4020();
                i.setNotaTerceiros(nfee);
                i.setItemReinf(item);
                i.setBaseAgregado(nfee.getValoresNfTerceiros().getValorTotal());
                i.setValorAgregado(nfee.getValoresNfTerceiros().getValorLei10833());
                i.setBaseCofins(nfee.getValoresNfTerceiros().getValorTotal());
                i.setValorCofins(nfee.getValoresNfTerceiros().getValorCofinsST());
                i.setBaseCsll(nfee.getValoresNfTerceiros().getValorTotal());
                i.setValorCsll(nfee.getValoresNfTerceiros().getValorContSoc());
                i.setBasePis(nfee.getValoresNfTerceiros().getValorTotal());
                i.setValorPis(nfee.getValoresNfTerceiros().getValorPisSt());
                i.setNaturezaRendimento(((ItemNotaTerceiros)nfee.getItemNotaTerceiros().get(0)).getNaturezaRendimento());
                item.getItensNotas().add(i);
                itens.add(item);
            }
        }
        return itens;
    }

    private void criarApuracaoValores4020Impostos(GrupoEmpresa grupoEmpresa, Date dataInicial, Date dataFinal, List<ItemReinf4020> itens) {
        List listBaixaTitulosPisCofins = CoreBdUtil.getInstance().getSession().createQuery("SELECT b FROM       BaixaTituloPisCofins    b INNER JOIN b.baixaTitulo           a INNER JOIN a.titulo                t INNER JOIN t.empresa               e INNER JOIN e.empresaDados          m INNER JOIN m.grupoEmpresa          g INNER JOIN a.grupoDeBaixaFormas    u INNER JOIN u.grupoDeBaixa          p INNER JOIN b.modeloDocFiscal       o INNER JOIN b.tituloPisCofins       i INNER JOIN i.titulo                s INNER JOIN s.pessoa                x INNER JOIN x.complemento           l INNER JOIN s.infPagamentoNfTerceiros ip WHERE g                      = :grupoEmpresa AND   p.dataLiquidacao     BETWEEN :dataInicial  AND :dataFinal AND   o.modeloServico            = :sim AND   l.tipoPessoa               = :tipoPessoa").setEntity("grupoEmpresa", (Object)grupoEmpresa).setDate("dataInicial", dataInicial).setDate("dataFinal", dataFinal).setShort("sim", EnumConstantsMentorSimNao.SIM.getValue()).setShort("tipoPessoa", EnumConstTipoPessoaComplementar.JURIDICA.getEnumId().shortValue()).list();
        if (ToolMethods.isWithData((Collection)listBaixaTitulosPisCofins)) {
            for (BaixaTituloPisCofins baixaTituloPisCofins : listBaixaTitulosPisCofins) {
                ItemReinf4020 itemReinf4020 = new ItemReinf4020();
                itemReinf4020.setPessoa(baixaTituloPisCofins.getBaixaTitulo().getTitulo().getPessoa());
                itemReinf4020.setEmpresa(baixaTituloPisCofins.getBaixaTitulo().getTitulo().getEmpresa());
                ItemReinfNotas4020 itemReinfNotas4020 = new ItemReinfNotas4020();
                itemReinfNotas4020.setNotaTerceiros(baixaTituloPisCofins.getBaixaTitulo().getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros());
                itemReinfNotas4020.setPessoa(baixaTituloPisCofins.getBaixaTitulo().getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getUnidadeFatFornecedor().getPessoa());
                itemReinfNotas4020.setBaseCsll(baixaTituloPisCofins.getValorBCCsll());
                itemReinfNotas4020.setValorCsll(baixaTituloPisCofins.getValorCsll());
                itemReinfNotas4020.setBaseCofins(baixaTituloPisCofins.getValorBCCofins());
                itemReinfNotas4020.setValorCofins(baixaTituloPisCofins.getValorCofins());
                itemReinfNotas4020.setBasePis(baixaTituloPisCofins.getValorBCPis());
                itemReinfNotas4020.setValorPis(baixaTituloPisCofins.getValorPis());
                itemReinfNotas4020.setBaseAgregado(baixaTituloPisCofins.getValorBCLei10833());
                itemReinfNotas4020.setValorAgregado(baixaTituloPisCofins.getValorLei10833());
                itemReinfNotas4020.setNaturezaRendimento(baixaTituloPisCofins.getNatRendReinf());
                itemReinfNotas4020.setItemReinf(itemReinf4020);
                itemReinf4020.getItensNotas().add(itemReinfNotas4020);
                itens.add(itemReinf4020);
            }
        }
    }

    public ApuracaoReinf reprocessarValores4020(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, R1000 reinf1000, OpcoesContabeis opcoesContabeis, ItemReinf4020 itemReinf4020Referencia, ApuracaoReinf vo) {
        String hqlIrrf = " select distinct nt From NotaFiscalTerceiros nt  inner join nt.infPagamentoNfTerceiros inf  inner join inf.titulos titulo inner join nt.unidadeFatFornecedor uff inner join uff.pessoa p inner join p.complemento c inner join uff.fornecedor f inner join nt.itemNotaTerceiros int inner join int.modeloFiscal mf inner join nt.modeloDocFiscal mdf where   ((nt.valoresNfTerceiros.valorIrrf > 0 ) and ( nt.dataEmissao between :dataInicial and :dataFinal  ) and nt.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and nt.modeloDocFiscal.modeloServico = :modeloServico  and nt.unidadeFatFornecedor.pessoa.complemento.tipoPessoa != 0  and nt.unidadeFatFornecedor.pessoa = :pessoa)  or ((nt.valoresNfTerceiros.valorIrrf = 0 )  and ( nt.dataEmissao between :dataInicial and :dataFinal  ) and nt.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and nt.modeloDocFiscal.modeloServico = :modeloServico  and nt.unidadeFatFornecedor.pessoa.complemento.tipoPessoa != 0  and CHAR_LENGTH(c.cnpj) = 14  and (f.tipoEpp = :nao) and mf.reinfNaturezaRendimento is not null  and ((mf.tipoIRRF = :tipoIrrfCalcular) or (mf.tipoIRRF = :tipoIrrfHabilitar))  and nt.unidadeFatFornecedor.pessoa = :pessoa) ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hqlIrrf).setDate("dataInicial", dataInicial).setDate("dataFinal", dataFinal).setEntity("grupoEmpresa", (Object)grupoEmpresa).setShort("modeloServico", EnumConstantsMentorSimNao.SIM.getValue()).setShort("nao", EnumConstantsMentorSimNao.NAO.getValue()).setShort("tipoIrrfCalcular", (short)1).setShort("tipoIrrfHabilitar", (short)2).setEntity("pessoa", (Object)itemReinf4020Referencia.getPessoa()).list();
        for (ItemReinf4020 itemReinf4020 : vo.getItensReinf4020()) {
            if (!ToolMethods.isEquals((Object)itemReinf4020.getIdentificador(), (Object)itemReinf4020Referencia.getIdentificador())) continue;
            itemReinf4020.getItensNotas().clear();
            itemReinf4020.setItensNotas(new ArrayList());
            for (NotaFiscalTerceiros nfe : ret) {
                if (!ToolMethods.isEquals((Object)itemReinf4020.getEmpresa(), (Object)nfe.getEmpresa())) continue;
                ItemReinfNotas4020 i = new ItemReinfNotas4020();
                i.setNotaTerceiros(nfe);
                i.setItemReinf(itemReinf4020);
                i.setBaseIrrf(nfe.getValoresNfTerceiros().getValorTotal());
                i.setValorIrrf(nfe.getValoresNfTerceiros().getValorIrrf());
                i.setNaturezaRendimento(((ItemNotaTerceiros)nfe.getItemNotaTerceiros().get(0)).getNaturezaRendimento());
                itemReinf4020.getItensNotas().add(i);
            }
            if (ToolMethods.isEquals((Object)opcoesContabeis.getTipoGeracaoTitulosImpostosRetidos(), (Object)EnumConstGeracaoTitulosImpostosRetidos.GERAR_TITULO_APURACAO_REINF.getValue())) {
                this.reprocessarApuracaoValores4020Impostos(grupoEmpresa, dataInicial, dataFinal, itemReinf4020);
                break;
            }
            this.reprocessarApuracaoValores4020OutrasRetencoes(dataInicial, dataFinal, grupoEmpresa, reinf1000, itemReinf4020);
            break;
        }
        return vo;
    }

    private void reprocessarApuracaoValores4020Impostos(GrupoEmpresa grupoEmpresa, Date dataInicial, Date dataFinal, ItemReinf4020 itemReinf4020) {
        List listBaixaTitulosPisCofins = CoreBdUtil.getInstance().getSession().createQuery("SELECT b FROM       BaixaTituloPisCofins    b INNER JOIN b.baixaTitulo           a INNER JOIN a.titulo                t INNER JOIN t.empresa               e INNER JOIN e.empresaDados          m INNER JOIN m.grupoEmpresa          g INNER JOIN a.grupoDeBaixaFormas    u INNER JOIN u.grupoDeBaixa          p INNER JOIN b.modeloDocFiscal       o INNER JOIN b.tituloPisCofins       i INNER JOIN i.titulo                s INNER JOIN s.pessoa                x INNER JOIN x.complemento           l WHERE g                      = :grupoEmpresa AND   p.dataLiquidacao     BETWEEN :dataInicial  AND :dataFinal AND   o.modeloServico            = :sim AND   l.tipoPessoa               = :tipoPessoa AND   x.pessoa                   = :pessoa").setEntity("grupoEmpresa", (Object)grupoEmpresa).setDate("dataInicial", dataInicial).setDate("dataFinal", dataFinal).setShort("sim", EnumConstantsMentorSimNao.SIM.getValue()).setShort("tipoPessoa", EnumConstTipoPessoaComplementar.JURIDICA.getEnumId().shortValue()).setEntity("pessoa", (Object)itemReinf4020.getPessoa()).list();
        if (ToolMethods.isWithData((Collection)listBaixaTitulosPisCofins)) {
            for (BaixaTituloPisCofins baixaTituloPisCofins : listBaixaTitulosPisCofins) {
                ItemReinfNotas4020 itemReinfNotas4020 = new ItemReinfNotas4020();
                itemReinfNotas4020.setNotaTerceiros(baixaTituloPisCofins.getBaixaTitulo().getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros());
                itemReinfNotas4020.setPessoa(baixaTituloPisCofins.getBaixaTitulo().getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getUnidadeFatFornecedor().getPessoa());
                itemReinfNotas4020.setBaseCsll(baixaTituloPisCofins.getValorBCCsll());
                itemReinfNotas4020.setValorCsll(baixaTituloPisCofins.getValorCsll());
                itemReinfNotas4020.setBaseCofins(baixaTituloPisCofins.getValorBCCofins());
                itemReinfNotas4020.setValorCofins(baixaTituloPisCofins.getValorCofins());
                itemReinfNotas4020.setBasePis(baixaTituloPisCofins.getValorBCPis());
                itemReinfNotas4020.setValorPis(baixaTituloPisCofins.getValorPis());
                itemReinfNotas4020.setBaseAgregado(baixaTituloPisCofins.getValorBCLei10833());
                itemReinfNotas4020.setValorAgregado(baixaTituloPisCofins.getValorLei10833());
                itemReinfNotas4020.setNaturezaRendimento(baixaTituloPisCofins.getNatRendReinf());
                itemReinfNotas4020.setItemReinf(itemReinf4020);
                itemReinf4020.getItensNotas().add(itemReinfNotas4020);
            }
        }
    }

    private void reprocessarApuracaoValores4020OutrasRetencoes(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, R1000 reinf1000, ItemReinf4020 itemReinf4020) {
        String hqlOutrasRetencoes = " select distinct nt From NotaFiscalTerceiros nt  inner join nt.infPagamentoNfTerceiros inf  inner join inf.titulos titulo where   (  nt.valoresNfTerceiros.valorLei10833 > 0 or nt.valoresNfTerceiros.valorContSoc > 0 ) and nt.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and (titulo is not null and titulo.dataVencimento between :dataInicial and :dataFinal and  titulo.pessoa = nt.unidadeFatFornecedor.fornecedor.pessoa) and nt.modeloDocFiscal.modeloServico = :modeloServico  and nt.unidadeFatFornecedor.pessoa.complemento.tipoPessoa != 0  and nt.unidadeFatFornecedor.pessoa = :pessoa";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hqlOutrasRetencoes).setDate("dataInicial", dataInicial).setDate("dataFinal", dataFinal).setEntity("grupoEmpresa", (Object)grupoEmpresa).setEntity("pessoa", (Object)itemReinf4020.getPessoa()).setShort("modeloServico", (short)1).list();
        for (NotaFiscalTerceiros nfee : ret) {
            if (!ToolMethods.isEquals((Object)itemReinf4020.getEmpresa(), (Object)nfee.getEmpresa())) continue;
            ItemNotaTerceiros itemNfe = (ItemNotaTerceiros)nfee.getItemNotaTerceiros().get(0);
            ItemReinfNotas4020 i = new ItemReinfNotas4020();
            i.setNotaTerceiros(nfee);
            i.setItemReinf(itemReinf4020);
            if (itemNfe.getItemNotaLivroFiscal().getPercRedLei10833() == 0.0) {
                i.setBaseAgregado(nfee.getValoresNfTerceiros().getValorTotal());
            } else {
                i.setBaseAgregado(Double.valueOf(nfee.getValoresNfTerceiros().getValorTotal() - nfee.getValoresNfTerceiros().getValorTotal() * itemNfe.getItemNotaLivroFiscal().getPercRedLei10833() / 100.0));
            }
            i.setValorAgregado(nfee.getValoresNfTerceiros().getValorLei10833());
            i.setBaseCofins(nfee.getValoresNfTerceiros().getValorTotal());
            i.setValorCofins(nfee.getValoresNfTerceiros().getValorCofinsST());
            i.setBaseCsll(nfee.getValoresNfTerceiros().getValorTotal());
            i.setValorCsll(nfee.getValoresNfTerceiros().getValorContSoc());
            i.setBasePis(nfee.getValoresNfTerceiros().getValorTotal());
            i.setValorPis(nfee.getValoresNfTerceiros().getValorPisSt());
            i.setNaturezaRendimento(((ItemNotaTerceiros)nfee.getItemNotaTerceiros().get(0)).getNaturezaRendimento());
            itemReinf4020.getItensNotas().add(i);
        }
    }
}

