/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.reinf;

import com.touchcomp.basementor.model.vo.CadastroNacionalObra;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemReinf2020;
import com.touchcomp.basementor.model.vo.ItemReinfNotas2020;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;

public class UtilityApuracaoReinf2020 {
    public List apurarItens2020(Date dataInicio, Date dataFinal, GrupoEmpresa grupoEmpresa, Boolean filtrarNotasRetidas) {
        ItemReinfNotas2020 ii;
        ItemReinf2020 i;
        ItemReinfNotas2020 ii2;
        CadastroNacionalObra cno;
        Short indicadorEmpreitada;
        Short indicadorObra;
        Boolean achou;
        List<Rps> listaRps = this.findRps(dataInicio, dataFinal, grupoEmpresa, filtrarNotasRetidas);
        List<NotaFiscalPropria> listaNotas = this.findNotas(dataInicio, dataFinal, grupoEmpresa, filtrarNotasRetidas);
        ArrayList<ItemReinf2020> itens = new ArrayList<ItemReinf2020>();
        for (Rps rps : listaRps) {
            achou = false;
            indicadorObra = rps.getIsObra();
            if (indicadorObra == null) {
                indicadorObra = 0;
            }
            if ((indicadorEmpreitada = rps.getTipoObraConstrucao()) == null) {
                indicadorEmpreitada = 0;
            }
            cno = rps.getCadastroNacionalObra();
            for (ItemReinf2020 item : itens) {
                if (!item.getPessoa().equals((Object)rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa()) || !item.getIndicadorObra().equals(indicadorObra) || !item.getIndicadorEmpreitada().equals(indicadorEmpreitada) || cno != null && !item.getCno().equals((Object)cno) || !item.getEmpresa().equals((Object)rps.getEmpresa())) continue;
                ii2 = new ItemReinfNotas2020();
                ii2.setRps(rps);
                ii2.setItemReinf2020(item);
                item.getItens().add(ii2);
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            i = new ItemReinf2020();
            i.setPessoa(rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa());
            i.setIndicadorObra(indicadorObra);
            i.setIndicadorEmpreitada(indicadorEmpreitada);
            i.setCno(cno);
            i.setEmpresa(rps.getEmpresa());
            ii = new ItemReinfNotas2020();
            ii.setRps(rps);
            ii.setItemReinf2020(i);
            i.getItens().add(ii);
            itens.add(i);
        }
        for (NotaFiscalPropria n : listaNotas) {
            achou = false;
            indicadorObra = n.getInformarNotaObra();
            if (indicadorObra == null) {
                indicadorObra = 0;
            }
            if ((indicadorEmpreitada = n.getTipoObraConstrucao()) == null) {
                indicadorEmpreitada = 0;
            }
            cno = n.getCadastroNacionalObra();
            for (ItemReinf2020 item : itens) {
                if (!item.getPessoa().equals((Object)n.getUnidadeFatCliente().getCliente().getPessoa()) || !item.getIndicadorObra().equals(indicadorObra) || !item.getIndicadorEmpreitada().equals(indicadorEmpreitada) || cno != null && !item.getCno().equals((Object)cno) || !item.getEmpresa().equals((Object)n.getEmpresa())) continue;
                ii2 = new ItemReinfNotas2020();
                ii2.setNotaPropria(n);
                ii2.setItemReinf2020(item);
                item.getItens().add(ii2);
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            i = new ItemReinf2020();
            i.setPessoa(n.getUnidadeFatCliente().getCliente().getPessoa());
            i.setIndicadorObra(indicadorObra);
            i.setIndicadorEmpreitada(indicadorEmpreitada);
            i.setCno(cno);
            i.setEmpresa(n.getEmpresa());
            ii = new ItemReinfNotas2020();
            ii.setNotaPropria(n);
            ii.setItemReinf2020(i);
            i.getItens().add(ii);
            itens.add(i);
        }
        return itens;
    }

    private List<Rps> findRps(Date dataInicio, Date dataFinal, GrupoEmpresa grupoEmpresa, Boolean filtrarNotasRetidas) {
        List ret;
        Object hql = " from Rps rps  where rps.dataEmissao between :dataInicial and :dataFinal  and rps.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and rps.status <> :cancelado and not exists(select i.identificador                from ItemReinfNotas2020 i                 where i.rps.identificador = rps.identificador)";
        if (filtrarNotasRetidas.booleanValue()) {
            hql = (String)hql + " and rps.valorInss > 0";
        }
        if ((ret = CoreBdUtil.getInstance().getSession().createQuery((String)hql).setDate("dataInicial", dataInicio).setDate("dataFinal", dataFinal).setShort("cancelado", (short)2).setEntity("grupoEmpresa", (Object)grupoEmpresa).list()) != null && ret.isEmpty()) {
            return new ArrayList<Rps>();
        }
        return ret;
    }

    private List<NotaFiscalPropria> findNotas(Date dataInicio, Date dataFinal, GrupoEmpresa grupoEmpresa, Boolean filtrarNotasRetidas) {
        List ret;
        Object hql = " from NotaFiscalPropria n  where n.dataEmissaoNota between :dataInicial and :dataFinal  and n.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and (n.situacaoDocumento.codigo <> :cod2 or n.situacaoDocumento.codigo <> :cod3  or n.situacaoDocumento.codigo <> :cod4) and n.modeloDocFiscal.modeloServico = :modeloServico and not exists(select i.identificador                from ItemReinfNotas2020 i                 where i.notaPropria.identificador = n.identificador)";
        if (filtrarNotasRetidas.booleanValue()) {
            hql = (String)hql + " and n.valoresNfPropria.valorInss > 0";
        }
        if ((ret = CoreBdUtil.getInstance().getSession().createQuery((String)hql).setDate("dataInicial", dataInicio).setDate("dataFinal", dataFinal).setEntity("grupoEmpresa", (Object)grupoEmpresa).setShort("modeloServico", (short)1).setString("cod2", "02").setString("cod3", "03").setString("cod4", "04").list()) != null && ret.isEmpty()) {
            return new ArrayList<NotaFiscalPropria>();
        }
        ArrayList<NotaFiscalPropria> nt = new ArrayList<NotaFiscalPropria>();
        for (Object object : ret) {
            NotaFiscalPropria nota = (NotaFiscalPropria)object;
            if (!ToolMethods.isStrWithData((String)nota.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getCnpj()) || nota.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getCnpj().length() != 14) continue;
            nt.add(nota);
        }
        return ret;
    }
}

