/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.reinf;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemCooperadoJuros;
import com.touchcomp.basementor.model.vo.ItemDistribuicaoSobraCooperado;
import com.touchcomp.basementor.model.vo.ItemReinf4020NaoIdentificado;
import com.touchcomp.basementor.model.vo.ItemReinf4040;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;

public class UtilityApuracaoReinf4040 {
    public List<ItemReinf4040> apuracaoValores4040(Date dataInicial, Date dataFinal) {
        List<ItemDistribuicaoSobraCooperado> listItemDistribuicaoSobraCooperado = this.findItemDistribuicaoSobraCooperado(dataInicial, dataFinal, EnumConstTipoPessoaComplementar.FISICA.getEnumId());
        List<ItemCooperadoJuros> listItemCooperadoJuros = this.findItemCooperadoJuros(dataInicial, dataFinal, EnumConstTipoPessoaComplementar.FISICA.getEnumId());
        ArrayList<ItemReinf4040> listItens4040 = new ArrayList<ItemReinf4040>();
        for (ItemDistribuicaoSobraCooperado itemDistribuicaoSobraCooperado : listItemDistribuicaoSobraCooperado) {
            this.criarItemReinf4040(listItens4040, itemDistribuicaoSobraCooperado.getDistribuicaoSobraCooperado().getEmpresa(), itemDistribuicaoSobraCooperado.getDistribuicaoSobraCooperado().getDataVencimento(), itemDistribuicaoSobraCooperado.getValorTotal(), itemDistribuicaoSobraCooperado.getValorIrrf(), itemDistribuicaoSobraCooperado.getValorDistribuicao(), itemDistribuicaoSobraCooperado.getCooperado().getCliente().getPessoa().getComplemento().getCnpj());
        }
        for (ItemCooperadoJuros itemCooperadoJuros : listItemCooperadoJuros) {
            this.criarItemReinf4040(listItens4040, itemCooperadoJuros.getProvisaoJuros().getEmpresa(), itemCooperadoJuros.getProvisaoJuros().getDataMovimento(), itemCooperadoJuros.getValorProvisionado(), itemCooperadoJuros.getValorIrrfJurosCoop(), itemCooperadoJuros.getValorProvisionado(), itemCooperadoJuros.getCooperado().getCliente().getPessoa().getComplemento().getCnpj());
        }
        return listItens4040;
    }

    public void criarItemReinf4040(List<ItemReinf4040> listItens4040, Empresa empresa, Date dataPagamento, Double valorLiquido, Double vlrIrrf, Double baseIrrf, String cpf) {
        ItemReinf4040 item4040 = new ItemReinf4040();
        item4040.setEmpresa(empresa);
        item4040.setDataPagamento(dataPagamento);
        item4040.setBaseIrrf(baseIrrf);
        item4040.setVlrIrrf(vlrIrrf);
        item4040.setLiquido(valorLiquido);
        item4040.setCpf(cpf);
        listItens4040.add(item4040);
    }

    public List<ItemReinf4020NaoIdentificado> apuracaoValores4020NaoIdentificado(Date dataInicial, Date dataFinal) {
        List<ItemCooperadoJuros> listItemCooperadoJuros = this.findItemCooperadoJuros(dataInicial, dataFinal, EnumConstTipoPessoaComplementar.JURIDICA.getEnumId());
        ArrayList<ItemReinf4020NaoIdentificado> listItens4020NaoIdentificado = new ArrayList<ItemReinf4020NaoIdentificado>();
        for (ItemCooperadoJuros i : listItemCooperadoJuros) {
            this.criarItemReinf4020NaoIdentificado(listItens4020NaoIdentificado, i.getProvisaoJuros().getEmpresa(), i.getCooperado().getCliente().getPessoa().getComplemento().getCnpj(), i.getValorProvisionado(), i.getValorProvisionado(), i.getValorIrrfJurosCoop(), i.getProvisaoJuros().getDataMovimento());
        }
        return listItens4020NaoIdentificado;
    }

    public void criarItemReinf4020NaoIdentificado(List<ItemReinf4020NaoIdentificado> listItens4020NaoIdentificado, Empresa empresa, String cnpj, Double valorBruto, Double baseIrrf, Double valorIrrf, Date dataPagamento) {
        ItemReinf4020NaoIdentificado itens4020NaoIdentificado = new ItemReinf4020NaoIdentificado();
        itens4020NaoIdentificado.setEmpresa(empresa);
        itens4020NaoIdentificado.setCpf(cnpj);
        itens4020NaoIdentificado.setValorBruto(valorBruto);
        itens4020NaoIdentificado.setBaseIrrf(baseIrrf);
        itens4020NaoIdentificado.setValorIrrf(valorIrrf);
        itens4020NaoIdentificado.setDataPagamento(dataPagamento);
        listItens4020NaoIdentificado.add(itens4020NaoIdentificado);
    }

    private List<ItemDistribuicaoSobraCooperado> findItemDistribuicaoSobraCooperado(Date dataInicial, Date dataFinal, Short tipoPessoa) {
        return CoreBdUtil.getInstance().getSession().createQuery("SELECT i FROM       ItemDistribuicaoSobraCooperado i INNER JOIN i.distribuicaoSobraCooperado   d INNER JOIN i.cooperado                    c INNER JOIN c.cliente                      l INNER JOIN l.pessoa                       p INNER JOIN p.complemento                  o WHERE d.dataVencimento BETWEEN :dataInicial AND :dataFinal AND   o.tipoPessoa           = :tipoPessoa").setDate("dataInicial", dataInicial).setDate("dataFinal", dataFinal).setShort("tipoPessoa", tipoPessoa.shortValue()).list();
    }

    private List<ItemCooperadoJuros> findItemCooperadoJuros(Date dataInicial, Date dataFinal, Short tipoPessoa) {
        return CoreBdUtil.getInstance().getSession().createQuery("SELECT i FROM       ItemCooperadoJuros i INNER JOIN i.provisaoJuros    d INNER JOIN i.cooperado        c INNER JOIN c.cliente          l INNER JOIN l.pessoa           p INNER JOIN p.complemento      o WHERE d.dataMovimento BETWEEN :dataInicial AND :dataFinal AND   o.tipoPessoa          = :tipoPessoa").setDate("dataInicial", dataInicial).setDate("dataFinal", dataFinal).setShort("tipoPessoa", tipoPessoa.shortValue()).list();
    }
}

