/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.reinf;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaPropriaComercializacaoRural;
import com.touchcomp.basementor.model.vo.ReinfClienteComRural;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;

public class UtilityReinfComercializacaoProdRural {
    public List findNotasPropriasAquisicaoRural(Date periodoInicial, Date periodoFinal, Empresa empresa) {
        String hql = " select distinct np  from NotaFiscalPropria np  where  np.dataEntradaSaida between :periodoInicial and :periodoFinal  and  np.empresa = :empresa  and  np.situacaoDocumento.codigo != 02  and  exists (             from ItemNotaFiscalPropria i             inner join i.itemNotaLivroFiscal il            inner join il.cfop cf            where cf.cfopComercializacaoProdRural=:sim            and i.notaFiscalPropria = np ) ";
        List notas = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setEntity("empresa", (Object)empresa).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).list();
        if (notas == null || notas.isEmpty()) {
            return new ArrayList();
        }
        return this.processarNotasProprias(notas);
    }

    private List processarNotasProprias(List notas) {
        ArrayList<ReinfClienteComRural> clientes = new ArrayList<ReinfClienteComRural>();
        for (Object obj : notas) {
            NotaFiscalPropria nota = (NotaFiscalPropria)obj;
            boolean achou = false;
            if (nota.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getCnpj().isEmpty() || nota.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getCnpj().length() != 14) continue;
            for (ReinfClienteComRural reinf : clientes) {
                if (!reinf.getCliente().equals((Object)nota.getUnidadeFatCliente().getCliente())) continue;
                reinf.getNotas().add(new NotaPropriaComercializacaoRural(reinf, nota));
                achou = true;
                break;
            }
            if (achou) continue;
            ReinfClienteComRural newC = new ReinfClienteComRural(nota.getUnidadeFatCliente().getCliente());
            newC.getNotas().add(new NotaPropriaComercializacaoRural(newC, nota));
            clientes.add(newC);
        }
        return clientes;
    }
}

