/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.relatorioscontabilidade;

import com.touchcomp.basementor.model.vo.LinhasIndiceEconomico;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

class AuxAvaliarExpressao {
    private int contador = 0;
    private int MAX_AVALIACAO = 500;

    AuxAvaliarExpressao() {
    }

    String calcularExpressaoString(String formula, List<LinhasIndiceEconomico> linhas) throws ExceptionService {
        String str = this.avaliarFormula(formula, linhas);
        return str;
    }

    private Object getFixedValue(String chave, List<LinhasIndiceEconomico> linhas, String formula) throws ExceptionService {
        ++this.contador;
        if (this.contador > this.MAX_AVALIACAO) {
            throw new ExceptionService("Redundancia encontrada." + formula);
        }
        if (chave.startsWith("linha")) {
            String linha = chave.substring(chave.indexOf("_") + 1);
            Integer index = new Integer(linha) - 1;
            if (index > linhas.size()) {
                throw new ExceptionService("Verifique as formulas pois utilizam uma linha invalida: " + chave);
            }
            LinhasIndiceEconomico ind = linhas.get(index);
            String exp = ind.getExpressao();
            System.out.println(exp);
            return "\nlinha_" + (index + 1) + "{ " + this.calcularExpressaoString(ind.getExpressao(), linhas) + " }\n";
        }
        if (chave.startsWith("saldo.anterior.pc") || chave.startsWith("debitos.pc") || chave.startsWith("creditos.pc") || chave.startsWith("plano.conta")) {
            String codigoPC = chave.substring(chave.indexOf("_") + 1);
            PlanoConta pc = this.getPlanoConta(codigoPC);
            return pc != null ? pc.getDescricao() : "Conta n\u00e3o encontrada ou inativa";
        }
        return null;
    }

    private String avaliarFormula(String expressao, List<LinhasIndiceEconomico> linhas) throws ExceptionService {
        List token = ToolString.getReplaceTokens((String)expressao);
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Object o : token) {
            StringToken sk = (StringToken)o;
            m.put(sk.getChave(), this.getFixedValue(sk.getChave(), linhas, expressao));
        }
        String tocalc = ToolString.build((String)expressao, m);
        return tocalc;
    }

    private PlanoConta getPlanoConta(String codigoPC) throws ExceptionService {
        Criteria c = CoreBdUtil.getInstance().getSession().createCriteria(PlanoConta.class);
        c.add((Criterion)Restrictions.eq((String)"codigo", (Object)codigoPC));
        c.add((Criterion)Restrictions.eq((String)"ativo", (Object)1));
        c.setMaxResults(1);
        return (PlanoConta)c.uniqueResult();
    }
}

