/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.relpessoacontato;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Usuario;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.relpessoacontato.UtilAtualizaAtendimentosCliente;
import mentorcore.service.impl.relpessoacontato.UtilConsultaAtendimentos;
import mentorcore.service.impl.relpessoacontato.UtilEnviarRegistroUsuarios;
import mentorcore.service.impl.relpessoacontato.UtilEnviarTicketsAberto;
import mentorcore.service.impl.relpessoacontato.UtilRegistraUsuarioTouch;

public class ServiceRelPessoaContato
extends CoreService {
    public static final String ENVIAR_TICKETS_ABERTO = "enviarTicketsAberto";
    public static final String ENVIAR_SOLICITACOES_REABERTURA = "enviarSolicitacoesReabertura";
    public static final String ENVIAR_NOTAS_ATENDIMENTO = "enviarNotasAtendimento";
    public static final String ATUALIZAR_ATENDIMENTOS = "atualizarAtendimentos";
    public static final String CONSULTA_TICKETS_ABERTO = "consultaTicketsAberto";
    public static final String FIND_PROXIMO_NR_PROTOCOLO = "findProximoNrProtocolo";
    public static final String CARREGAR_ATENDIMENTOS = "carregarAtendimentos";
    public static final String ENVIO_REGISTRO_ATUALIZA_USUARIO = "enviaRegistroAtualizaUsuario";
    public static final String RECEBE_REGISTRO_ATUALIZACAO_USUARIO = "recebeRegistroAtualizacaoUsuario";
    public static final String GET_ATENDIMENTOS_NOTA_ATENDIMENTO = "getAtendimentosNotaAtendimento";
    public static final String EXISTE_ATENDIMENTOS_NOTA_ATENDIMENTO = "existeAtendimentosNotaAtendimento";

    public void enviarTicketsAberto(CoreRequestContext cq) throws Exception {
        String servidor = (String)cq.getAttribute("enderecoServidor");
        new UtilEnviarTicketsAberto().enviarTicketsAberto(servidor);
    }

    public void enviarSolicitacoesReabertura(CoreRequestContext cq) throws Exception {
        String servidor = (String)cq.getAttribute("enderecoServidor");
        new UtilEnviarTicketsAberto().enviarSolicitacoesReabertura(servidor);
    }

    public void enviarNotasAtendimento(CoreRequestContext cq) throws Exception {
        String servidor = (String)cq.getAttribute("enderecoServidor");
        new UtilEnviarTicketsAberto().enviarNotasAtendimentoTickets(servidor);
    }

    public void atualizarAtendimentos(CoreRequestContext cq) throws Exception {
        Empresa empresa = (Empresa)cq.getAttribute("empresa");
        Usuario user = (Usuario)cq.getAttribute("usuario");
        String servidor = (String)cq.getAttribute("enderecoServidor");
        new UtilAtualizaAtendimentosCliente().consultaAtendimentos(user, empresa, servidor);
    }

    public String consultaTicketsAberto(CoreRequestContext cq) throws Exception {
        String mensagem = (String)cq.getAttribute("mensagem");
        return new UtilConsultaAtendimentos().consultaAtendimentos(mensagem);
    }

    public Object findProximoNrProtocolo(CoreRequestContext req) throws ExceptionService, ExceptionDatabase {
        return CoreDAOFactory.getInstance().getDAORelPessoaContato().findProximoNrProtocolo();
    }

    public Object carregarAtendimentos(CoreRequestContext req) throws ExceptionService, ExceptionDatabase {
        Short status = (Short)req.getAttribute("status");
        Short filtrarData = (Short)req.getAttribute("filtrarData");
        Date dataInicial = (Date)req.getAttribute("dataInicial");
        Date dataFinal = (Date)req.getAttribute("dataFinal");
        Usuario usario = (Usuario)req.getAttribute("usuario");
        return CoreDAOFactory.getInstance().getDAOLocalTicketAtendTouch().carregarAtendimentos(status, filtrarData, dataInicial, dataFinal, usario);
    }

    public Usuario enviaRegistroAtualizaUsuario(CoreRequestContext cq) throws Exception {
        String servidor = (String)cq.getAttribute("servidor");
        Usuario user = (Usuario)cq.getAttribute("user");
        Empresa emp = (Empresa)cq.getAttribute("empresa");
        return new UtilEnviarRegistroUsuarios().registraAtualizaUsuarioTouch(user, emp, servidor);
    }

    public String recebeRegistroAtualizacaoUsuario(CoreRequestContext cq) throws Exception {
        String mensagem = (String)cq.getAttribute("mensagem");
        return new UtilRegistraUsuarioTouch().registrarAtualizarUsuario(mensagem);
    }

    public List getAtendimentosNotaAtendimento(CoreRequestContext cq) throws Exception {
        Usuario usuario = (Usuario)cq.getAttribute("usuario");
        return CoreDAOFactory.getInstance().getDAORelPessoaContato().getAtendimentosNotaAtendimento(usuario);
    }

    public Boolean existeAtendimentosNotaAtendimento(CoreRequestContext cq) throws Exception {
        Usuario usuario = (Usuario)cq.getAttribute("usuario");
        return CoreDAOFactory.getInstance().getDAORelPessoaContato().existeAtendimentosNotaAtendimento(usuario);
    }
}

