/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.relpessoacontato;

import com.touchcomp.basementor.constants.enums.relpessoacontato.EnumConstRelPessoaContStatus;
import com.touchcomp.basementor.constants.enums.relpessoacontato.EnumConstTicketAtendStatus;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LocalTicketAtendPrevisoes;
import com.touchcomp.basementor.model.vo.LocalTicketAtendTouch;
import com.touchcomp.basementor.model.vo.LocalTicketAtendTouchLog;
import com.touchcomp.basementor.model.vo.LocalTicketAtendTouchLogTar;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.webservices.touch.input.TEMPResumoAtendimento;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.finder.BaseCriteria;
import mentorcore.service.CoreService;
import mentorcore.utilities.CoreUtilityFactory;

class UtilAtualizaAtendimentosCliente {
    private static final TLogger logger = TLogger.get(UtilAtualizaAtendimentosCliente.class);

    UtilAtualizaAtendimentosCliente() {
    }

    public void consultaAtendimentos(Usuario user, Empresa emp, String servidor) throws ExceptionService {
        try {
            if (user.getIdentificador() == null || user.getIdentificador() <= 0L) {
                return;
            }
            List<TEMPResumoAtendimento> res = CoreUtilityFactory.getUtilityAbrirTicketChamadoTouch().consultarChamados(emp, user, servidor);
            this.processarRetorno(res, user, emp);
        }
        catch (Exception e) {
            logger.error(e.getClass(), (Throwable)e);
            throw new ExceptionService("Erro ao atualizar Tickets.\n" + e.getMessage(), e);
        }
    }

    private void processarRetorno(List<TEMPResumoAtendimento> res, Usuario user, Empresa emp) throws Exception {
        ArrayList<LocalTicketAtendTouch> ticketsAbertos = new ArrayList<LocalTicketAtendTouch>();
        for (TEMPResumoAtendimento relacionamento : res) {
            Long nrProtocolo = relacionamento.getNrProtocolo();
            Date prevista = relacionamento.getDataPrevista();
            Date cadastro = relacionamento.getDataCadastro();
            Date fechamento = relacionamento.getDataFechamento();
            String solucao = relacionamento.getSolucao();
            String descricao = relacionamento.getDescricao();
            String assunto = relacionamento.getAssunto();
            Short status = relacionamento.getStatus();
            Long nodo = relacionamento.getIdNodo();
            Integer versaoTicket = relacionamento.getVersaoTicket();
            LocalTicketAtendTouch l = this.findLocalTicket(nrProtocolo);
            if (l == null) {
                l = new LocalTicketAtendTouch();
                l.setDataCadastro(cadastro);
                l.setEmpresa(emp);
                l.setNodo(this.getNodo(nodo));
                l.setUsuario(user);
                l.setNrProtocolo(nrProtocolo);
                l.setSolucao(solucao);
                l.setObservacao(assunto);
            }
            if (versaoTicket != null) {
                l.setVersaoTicket(Short.valueOf(versaoTicket.shortValue()));
            }
            this.processaStatus(l, status);
            l.setDataPrevista(prevista);
            l.setDataFechamento(fechamento);
            l.setDadosAtendimento(descricao);
            this.setLogsAtendimentos(l, relacionamento);
            this.setAgendamentos(l, relacionamento);
            l = (LocalTicketAtendTouch)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOLocalTicketAtendTouch(), l);
            ticketsAbertos.add(l);
        }
        this.verificaEFecha(ticketsAbertos, user);
    }

    private void verificaEFecha(List<LocalTicketAtendTouch> atendimentos, Usuario user) throws ExceptionService {
        BaseCriteria b = BaseCriteria.create(LocalTicketAtendTouch.class);
        b.and().equal("status", (short)0);
        b.and().equal("usuario", user);
        List all = CoreService.executeSearch(b);
        for (LocalTicketAtendTouch local : all) {
            if (atendimentos.contains(local)) continue;
            local.setStatus(Short.valueOf(EnumConstTicketAtendStatus.FECHADO_DEFINITIVAMENTE.getValue()));
            local.setSolucao("Atendimento fechado localmente, para mais detalhes consultar o suporte.");
            CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOLocalTicketAtendTouch(), local);
        }
    }

    private LocalTicketAtendTouch findLocalTicket(Long nrProt) throws ExceptionService {
        if (nrProt == null) {
            return null;
        }
        return (LocalTicketAtendTouch)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOLocalTicketAtendTouch(), "nrProtocolo", nrProt, 0);
    }

    private Nodo getNodo(Long nodo) throws ExceptionService {
        if (nodo == null) {
            return null;
        }
        return (Nodo)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAONodo(), "identificador", nodo, 0);
    }

    private void setLogsAtendimentos(LocalTicketAtendTouch l, TEMPResumoAtendimento relacionamento) {
        List logs = relacionamento.getLogAtendimentos();
        l.getLogsAtendimento().clear();
        for (TEMPResumoAtendimento.VOLogAtendimento log : logs) {
            Date dataAgendamento = log.getDataAgendamento();
            Short finalizado = log.getFinalizado();
            Double tempoDispendido = log.getTempoDispendido();
            Date dataInicial = log.getDataInicial();
            Date dataFinal = log.getDataFinal();
            Long idUsuario = log.getIdUsuario();
            Long idLogAtendimento = log.getIdLogAtendimento();
            Long idUsuarioAgendamento = log.getIdUsuarioAgendamento();
            String usuarioAgendamento = log.getUsuarioAgendamento();
            String usuario = log.getUsuario();
            LocalTicketAtendTouchLog lt = new LocalTicketAtendTouchLog();
            lt.setIdentificador(idLogAtendimento);
            lt.setDataAgendamento(dataAgendamento);
            lt.setDataFinal(dataFinal);
            lt.setDataInicial(dataInicial);
            lt.setFinalizado(finalizado);
            lt.setIdUsuarioAgendamento(idUsuarioAgendamento);
            lt.setIdUsuarioAtendimento(idUsuario);
            lt.setLocalTicketAtendTouch(l);
            lt.setTempoDispendido(tempoDispendido);
            lt.setUsuario(usuario);
            lt.setUsuarioAgendamento(usuarioAgendamento);
            this.setTarefas(lt, log.getTarefas());
            l.getLogsAtendimento().add(lt);
        }
    }

    private void setTarefas(LocalTicketAtendTouchLog lt, List<TEMPResumoAtendimento.VOTarefa> logsTarefa) {
        if (logsTarefa == null) {
            return;
        }
        lt.getTarefas().clear();
        for (TEMPResumoAtendimento.VOTarefa log : logsTarefa) {
            String tarefa = log.getDescricao();
            Long idTarefa = log.getIdTarefa();
            LocalTicketAtendTouchLogTar t = new LocalTicketAtendTouchLogTar();
            t.setTarefa(tarefa);
            t.setIdentificador(idTarefa);
            t.setLogAtendimento(lt);
            lt.getTarefas().add(t);
        }
    }

    private void setAgendamentos(LocalTicketAtendTouch l, TEMPResumoAtendimento relacionamento) {
        for (TEMPResumoAtendimento.VOReagendamentos r : relacionamento.getReagendamentos()) {
            Optional<LocalTicketAtendPrevisoes> found = l.getLogsPrevisoes().stream().filter(i -> ToolMethods.isEquals((Object)String.valueOf(r.getIdentificador()), (Object)i.getNrReciboMsg())).findFirst();
            LocalTicketAtendPrevisoes prev = null;
            if (found.isPresent()) {
                prev = found.get();
            } else {
                prev = new LocalTicketAtendPrevisoes();
                l.getLogsPrevisoes().add(prev);
            }
            prev.setDataAgendamento(r.getDataPrevista());
            prev.setInfoAdicional(r.getInfoAdicional());
            prev.setLocalTicketAtendTouch(l);
            prev.setMotivo(r.getMotivo());
            prev.setNrReciboMsg(r.getIdentificador().toString());
        }
    }

    private void processaStatus(LocalTicketAtendTouch l, Short status) {
        if (status == null) {
            l.setStatus(Short.valueOf(EnumConstTicketAtendStatus.ABERTO_ATEND_TOUCH.value));
            return;
        }
        if (status.shortValue() == EnumConstRelPessoaContStatus.ABERTO_ATEND_TOUCH.getValue()) {
            l.setStatus(Short.valueOf(EnumConstTicketAtendStatus.ABERTO_ATEND_TOUCH.value));
            return;
        }
        if (status.shortValue() == EnumConstRelPessoaContStatus.ABERTO_ATEND_TOUCH_TICKET.getValue()) {
            l.setStatus(Short.valueOf(EnumConstTicketAtendStatus.ABERTO_TICKET_REC_TOUCH.value));
            return;
        }
        if (status.shortValue() == EnumConstRelPessoaContStatus.FECHADO_AGUARDANDO_NOTA.getValue()) {
            l.setStatus(Short.valueOf(EnumConstTicketAtendStatus.FECHADO_AGUARDANDO_NOTA.value));
            return;
        }
        if (status.shortValue() == EnumConstRelPessoaContStatus.FECHADO_DEFINITIVAMENTE.getValue() && l.getDataFechamento() != null) {
            l.setStatus(Short.valueOf(EnumConstTicketAtendStatus.FECHADO_DEFINITIVAMENTE.value));
            return;
        }
    }
}

