/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.relpessoacontato;

import com.touchcomp.basementor.model.vo.LogConsultaAtendimentos;
import com.touchcomp.basementor.model.vo.UsuarioClienteContSistemas;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.tools.DateUtil;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class UtilConsultaAtendimentos {
    private final int VERSAO_TICKET = 2;

    public String consultaAtendimentos(String mensagem) throws Exception {
        Date now = new Date();
        Document d = new SAXBuilder().build((InputStream)new ByteArrayInputStream(mensagem.getBytes()));
        Element root = d.getRootElement();
        String empresa = root.getChildText("cnpjEmp");
        String cnpjUsuario = root.getChildText("cnpjUser");
        UsuarioClienteContSistemas user = this.getUsuarioClienteContSistemas(empresa, cnpjUsuario);
        List<HashMap> atendimentos = new ArrayList<HashMap>();
        if (user != null) {
            LogConsultaAtendimentos log = this.getLogUltimaConsulta(user);
            atendimentos = this.getAtendimentos(user, log);
            this.saveNovoLog(user, now);
        }
        return this.buildResp(atendimentos);
    }

    private UsuarioClienteContSistemas getUsuarioClienteContSistemas(String empresa, String cnpjUsuario) {
        String query = "select u from UsuarioClienteContSistemas u inner join u.pessoa pU  inner join pU.complemento cU inner join u.clienteContSistemas c inner join c.tomadorPrestadorRps t inner join t.pessoa p inner join p.complemento compC left join c.clienteContSistCnpj cc left join cc.pessoa pc left join pc.complemento comp where (compC.cnpj = :cnpjEmp or comp.cnpj =:cnpjEmp) and cU.cnpj = :cnpjUser";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(query);
        q.setString("cnpjEmp", empresa);
        q.setString("cnpjUser", cnpjUsuario);
        q.setMaxResults(1);
        return (UsuarioClienteContSistemas)q.uniqueResult();
    }

    private void saveNovoLog(UsuarioClienteContSistemas user, Date now) throws ExceptionService {
        LogConsultaAtendimentos log = new LogConsultaAtendimentos();
        log.setDataConsulta(now);
        log.setUsuarioClienteContSistemas(user);
        CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOAdicionaisContratoLocacao(), log);
    }

    private List<HashMap> getAtendimentos(UsuarioClienteContSistemas user, LogConsultaAtendimentos log) {
        Date data = new Date();
        if (log != null) {
            data = log.getDataConsulta();
        }
        String query = "select l.identificador as ID_ATENDIMENTO, l.nrProtocolo as NR_PROTOCOLO, l.dataPrevFinalizacao as DATA_PREVISTA, pr.nome as USUARIO_RESPONSAVEL, l.finalizado as FINALIZADO, l.assunto as ASSUNTO, l.solucao as SOLUCAO, n.identificador as ID_NODO, l.dataRelacionamento as DATA_ATENDIMENTO from RelPessoaContato l inner join l.usuarioResponsavel ur inner join ur.pessoa pr left join l.nodo n where l.usuarioCliContSistemas = :usuarioClienteContSistemas and (l.dataAtualizacao >= :dataConsulta  or l.finalizado = :nao)";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(query);
        q.setEntity("usuarioClienteContSistemas", (Object)user);
        q.setDate("dataConsulta", data);
        q.setShort("nao", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List temp = q.list();
        this.putLogsAtendimento(temp);
        return temp;
    }

    private void putLogsAtendimento(List<HashMap> temp) {
        for (HashMap h : temp) {
            Long idAtend = (Long)h.get("ID_ATENDIMENTO");
            String query = "select r.identificador as ID_LOG_ATENDIMENTO, r.dataAgendamento as DATA_AGENDAMENTO, r.finalizado as FINALIZADO, r.tempoDispendiado as TEMPO_DISPENDIDO, r.dataInicial as DATA_INICIAL, r.dataFinal as DATA_FINAL, u.identificador as ID_USUARIO, p.nome as USUARIO, ua.identificador as ID_USUARIO_AGENDAMENTO, pa.nome as USUARIO_AGENDAMENTO from RelPessoaContatoLog r  inner join r.usuario u  inner join u.pessoa p inner join r.relPessoaContato rp  left join r.usuarioAgendamento ua left join ua.pessoa pa where rp.identificador=:id_rel";
            Query q = CoreBdUtil.getInstance().getSession().createQuery(query);
            q.setLong("id_rel", idAtend.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List aux = q.list();
            h.put("LOG_ATENDIMENTOS", aux);
            this.putTarefas(aux);
        }
    }

    private void putLogAtendimentos(Element ele, List<HashMap> logs) {
        Element root = new Element("logsAtendimento");
        ele.addContent((Content)root);
        for (HashMap h : logs) {
            Long idLogAtendimento = (Long)h.get("ID_LOG_ATENDIMENTO");
            Date dataAgendamento = (Date)h.get("DATA_AGENDAMENTO");
            Short finalizado = (Short)h.get("FINALIZADO");
            Double tempoDispendido = (Double)h.get("TEMPO_DISPENDIDO");
            Date dataInicial = (Date)h.get("DATA_INICIAL");
            Date dataFinal = (Date)h.get("DATA_FINAL");
            Long idUsuario = (Long)h.get("ID_USUARIO");
            String usuario = (String)h.get("USUARIO");
            Long idUsuarioAgendamento = (Long)h.get("ID_USUARIO_AGENDAMENTO");
            String usuarioAgendamento = (String)h.get("USUARIO_AGENDAMENTO");
            List tarefas = (List)h.get("TAREFAS");
            Element el = new Element("logs");
            el.addContent((Content)new Element("idLogAtendimento").setText(idLogAtendimento.toString()));
            if (dataAgendamento != null) {
                el.addContent((Content)new Element("dataAgendamento").setText(DateUtil.dateToStr(dataAgendamento, "dd/MM/yyyy hh:mm:ss")));
            }
            if (finalizado != null) {
                el.addContent((Content)new Element("finalizado").setText(finalizado.toString()));
            }
            if (tempoDispendido != null) {
                el.addContent((Content)new Element("tempoDispendido").setText(tempoDispendido.toString()));
            }
            if (dataInicial != null) {
                el.addContent((Content)new Element("dataInicial").setText(DateUtil.dateToStr(dataInicial, "dd/MM/yyyy hh:mm:ss")));
            }
            if (dataFinal != null) {
                el.addContent((Content)new Element("dataFinal").setText(DateUtil.dateToStr(dataFinal, "dd/MM/yyyy hh:mm:ss")));
            }
            if (idUsuario != null) {
                el.addContent((Content)new Element("idUsuario").setText(idUsuario.toString()));
                el.addContent((Content)new Element("usuario").setText(usuario));
            }
            if (idUsuarioAgendamento != null) {
                el.addContent((Content)new Element("idUsuarioAgendamento").setText(idUsuarioAgendamento.toString()));
                el.addContent((Content)new Element("usuarioAgendamento").setText(usuarioAgendamento));
            }
            this.putTarefas(el, tarefas);
            root.addContent((Content)el);
        }
    }

    private void putTarefas(Element ele, List<HashMap> tarefas) {
        Element root = new Element("tarefas");
        ele.addContent((Content)root);
        for (HashMap h : tarefas) {
            Long idTarefa = (Long)h.get("ID_TAREFA");
            String tarefa = (String)h.get("TAREFA");
            Element el = new Element("logs");
            el.addContent((Content)new Element("idTarefa").setText(idTarefa.toString()));
            el.addContent((Content)new Element("tarefa").setText(tarefa));
            root.addContent((Content)el);
        }
    }

    private void putTarefas(List<HashMap> aux) {
        for (HashMap h : aux) {
            Long idLogAtend = (Long)h.get("ID_LOG_ATENDIMENTO");
            String query = "select r.identificador as ID_TAREFA, r.tarefa as TAREFA from RelPessoaContatoLogTar r  inner join r.relPessoaContatoLog rp  where rp.identificador=:id_rel";
            Query q = CoreBdUtil.getInstance().getSession().createQuery(query);
            q.setLong("id_rel", idLogAtend.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List temp = q.list();
            h.put("TAREFAS", temp);
        }
    }

    private String buildResp(List<HashMap> atendimentos) {
        Element root = new Element("touchcomp");
        for (HashMap h : atendimentos) {
            Long nrProtocolo = (Long)h.get("NR_PROTOCOLO");
            Date dataPrevista = (Date)h.get("DATA_PREVISTA");
            Date dataAtendimento = (Date)h.get("DATA_ATENDIMENTO");
            String usuarioResp = (String)h.get("USUARIO_RESPONSAVEL");
            String usuarioFinalizacao = (String)h.get("USUARIO_FINALIZACAO");
            Short finalizado = (Short)h.get("FINALIZADO");
            Long idNodo = (Long)h.get("ID_NODO");
            String solucao = (String)h.get("SOLUCAO");
            String assunto = (String)h.get("ASSUNTO");
            List logs = (List)h.get("LOG_ATENDIMENTOS");
            solucao = ToolString.clearSpecialCharacXMLFile((String)solucao);
            assunto = ToolString.clearSpecialCharacXMLFile((String)assunto);
            Element rel = new Element("atendimento");
            rel.setAttribute("versaoTicket", String.valueOf(2));
            rel.addContent((Content)new Element("nrProtocolo").setText(nrProtocolo.toString()));
            rel.addContent((Content)new Element("dataPrevista").setText(DateUtil.dateToStr(dataPrevista, "dd-MM-yyyy HH:mm:ss.SSS")));
            rel.addContent((Content)new Element("dataCadastro").setText(DateUtil.dateToStr(dataAtendimento, "dd-MM-yyyy HH:mm:ss.SSS")));
            rel.addContent((Content)new Element("usuarioResp").setText(usuarioResp));
            if (finalizado != null) {
                rel.addContent((Content)new Element("finalizado").setText(finalizado.toString()));
            } else {
                rel.addContent((Content)new Element("finalizado").setText("0"));
            }
            if (idNodo != null) {
                rel.addContent((Content)new Element("nodo").setText(idNodo.toString()));
            }
            String descricao = "Consultor Responsavel: " + usuarioResp;
            descricao = descricao + "\n\n";
            descricao = descricao + "Consultor Finalizacao:" + (usuarioFinalizacao != null ? usuarioFinalizacao : "");
            descricao = descricao + "\n\n";
            if (solucao != null && solucao.trim().length() > 0) {
                descricao = descricao + "Solucao: " + solucao;
            }
            rel.addContent((Content)new Element("descricao").setText(descricao));
            rel.addContent((Content)new Element("assunto").setText(assunto));
            rel.addContent((Content)new Element("solucao").setText(solucao));
            this.putLogAtendimentos(rel, logs);
            root.addContent((Content)rel);
        }
        Format format = Format.getPrettyFormat();
        format.setEncoding("ISO-8859-1");
        return new XMLOutputter(format).outputString(new Document(root));
    }

    private LogConsultaAtendimentos getLogUltimaConsulta(UsuarioClienteContSistemas user) {
        String query = "select l from LogConsultaAtendimentos l where l.usuarioClienteContSistemas = :usuarioClienteContSistemas and l.dataConsulta = (select max(l1.dataConsulta)from LogConsultaAtendimentos l1 where l1.usuarioClienteContSistemas = :usuarioClienteContSistemas)";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(query);
        q.setEntity("usuarioClienteContSistemas", (Object)user);
        q.setMaxResults(1);
        return (LogConsultaAtendimentos)q.uniqueResult();
    }
}

