/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.relpessoacontato;

import com.touchcomp.basementor.model.vo.LocalTicketAtSolReab;
import com.touchcomp.basementor.model.vo.LocalTicketAtendTouch;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.service.impl.localticketatendtouch.ServiceLocalTicketAtSolReabImpl;
import com.touchcomp.basementorservice.service.impl.localticketatendtouch.ServiceLocalTicketAtendTouchImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.CoreUtilityFactory;

class UtilEnviarTicketsAberto {
    private static final TLogger logger = TLogger.get(UtilEnviarTicketsAberto.class);

    UtilEnviarTicketsAberto() {
    }

    public void enviarTicketsAberto(String servidor) throws ExceptionService {
        try {
            ServiceLocalTicketAtendTouchImpl service = (ServiceLocalTicketAtendTouchImpl)ConfApplicationContext.getBean(ServiceLocalTicketAtendTouchImpl.class);
            List ticketsAbertos = service.getTicketsAberto();
            if (ticketsAbertos.size() > 0) {
                CoreUtilityFactory.getUtilityAbrirTicketChamadoTouch().enviarChamados(ticketsAbertos, servidor);
                for (LocalTicketAtendTouch ticketsAberto : ticketsAbertos) {
                    CoreDAOFactory.getInstance().getDAOLocalTicketAtendTouch().saveOrUpdate(ticketsAberto);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getClass(), (Throwable)e);
            throw new ExceptionService("Erro ao atualizar Tickets.\n" + e.getMessage(), e);
        }
    }

    public void enviarNotasAtendimentoTickets(String servidor) throws ExceptionService {
        try {
            ServiceLocalTicketAtendTouchImpl service = (ServiceLocalTicketAtendTouchImpl)ConfApplicationContext.getBean(ServiceLocalTicketAtendTouchImpl.class);
            List tickets = service.getNotasTicketsToSend();
            if (tickets.size() > 0) {
                CoreUtilityFactory.getUtilityAbrirTicketChamadoTouch().enviarNotasAtendimento(tickets, servidor);
                for (LocalTicketAtendTouch ticketsAberto : tickets) {
                    CoreDAOFactory.getInstance().getDAOLocalTicketAtendTouch().saveOrUpdate(ticketsAberto);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getClass(), (Throwable)e);
            throw new ExceptionService("Erro ao atualizar Tickets.\n" + e.getMessage(), e);
        }
    }

    public void enviarSolicitacoesReabertura(String servidor) throws ExceptionService {
        try {
            ServiceLocalTicketAtSolReabImpl service = (ServiceLocalTicketAtSolReabImpl)ConfApplicationContext.getBean(ServiceLocalTicketAtSolReabImpl.class);
            List tickets = service.getReaberturasToSend();
            if (tickets.size() > 0) {
                CoreUtilityFactory.getUtilityAbrirTicketChamadoTouch().enviarSolicitacoesReabertura(tickets, servidor);
                for (LocalTicketAtSolReab ticketsAberto : tickets) {
                    CoreDAOFactory.getInstance().getDAOLocalTicketAtendTouch().saveOrUpdate(ticketsAberto);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getClass(), (Throwable)e);
            throw new ExceptionService("Erro ao atualizar Tickets.\n" + e.getMessage(), e);
        }
    }
}

